/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.linkage;

import org.eurocarbdb.application.glycanbuilder.linkage.AndOperator;
import org.eurocarbdb.application.glycanbuilder.linkage.ConditionFactory;
import org.eurocarbdb.application.glycanbuilder.linkage.LinkageMatcher;
import org.eurocarbdb.application.glycanbuilder.linkage.NegationOperator;
import org.eurocarbdb.application.glycanbuilder.linkage.OrOperator;
import org.eurocarbdb.application.glycanbuilder.linkage.TrueCondition;
import org.eurocarbdb.application.glycanbuilder.linkage.XOrOperator;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

class OperatorFactory {
    OperatorFactory() {
    }

    public static LinkageMatcher fromString(String init) throws Exception {
        init = TextUtils.trim(init);
        init = TextUtils.removeTrailingParentheses(init);
        if ((init = TextUtils.trim(init)).equals("")) {
            return new TrueCondition();
        }
        int ind = TextUtils.findFirstOfWithParentheses(init, "&|^");
        if (ind != -1) {
            String lop = init.substring(0, ind);
            char op = init.charAt(ind);
            String rop = init.substring(ind + 1);
            if (op == '&') {
                return new AndOperator(OperatorFactory.fromString(lop), OperatorFactory.fromString(rop));
            }
            if (op == '|') {
                return new OrOperator(OperatorFactory.fromString(lop), OperatorFactory.fromString(rop));
            }
            if (op == '^') {
                return new XOrOperator(OperatorFactory.fromString(lop), OperatorFactory.fromString(rop));
            }
            throw new Exception("Memory error");
        }
        if (init.startsWith("!")) {
            return new NegationOperator(OperatorFactory.fromString(init.substring(1)));
        }
        return ConditionFactory.fromString(init);
    }
}

