/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.dataset;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;
import org.glycoinfo.application.glycanbuilder.dataset.NonSymbolicResidueDictionary;
import org.glycoinfo.application.glycanbuilder.dataset.TextSymbolDescriptor;

public class ResidueDictionary {
    private static HashMap<String, ResidueType> dictionary = new HashMap();
    private static LinkedList<String> superclasses = new LinkedList();
    private static TreeMap<Integer, ResidueType> direct_residues = new TreeMap();
    private static LinkedList<ResidueType> other_residues = new LinkedList();
    private static LinkedList<ResidueType> all_residues = new LinkedList();
    private static HashMap<String, LinkedList<ResidueType>> all_residues_map = new HashMap();

    public static ResidueType getResidueType(String type_name) throws Exception {
        ResidueType ret = ResidueDictionary.findResidueType(type_name);
        if (ret == null) {
            throw new Exception("Invalid type: <" + type_name + ">");
        }
        return ret;
    }

    public static boolean hasResidueType(String type_name) {
        return ResidueDictionary.findResidueType(type_name) != null;
    }

    public static ResidueType findResidueType(String type_name) {
        ResidueType ret = dictionary.get(type_name.toLowerCase());
        if (ret != null) {
            return ret;
        }
        ret = ResidueDictionary.checkNoDefinedData(type_name);
        if (type_name.indexOf(61) != -1) {
            String[] tokens = type_name.split("=");
            String name = tokens[0];
            double mass = Double.valueOf(tokens[1].substring(0, tokens[1].length() - 1));
            return ResidueType.createOtherReducingEnd(name, mass);
        }
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public static Iterator<ResidueType> iterator() {
        return all_residues.iterator();
    }

    public static Collection<ResidueType> directResidues() {
        return direct_residues.values();
    }

    protected static Collection<ResidueType> otherResidues() {
        return other_residues;
    }

    public static Collection<ResidueType> allResidues() {
        return all_residues;
    }

    public static Collection<String> getSuperclasses() {
        return superclasses;
    }

    public static Collection<ResidueType> getResidues(String superclass) {
        return all_residues_map.get(superclass);
    }

    public static Collection<ResidueType> getReducingEnds() {
        LinkedList<ResidueType> ret = new LinkedList<ResidueType>();
        for (ResidueType rt : all_residues) {
            if (!rt.canBeReducingEnd()) continue;
            ret.add(rt);
        }
        return ret;
    }

    public static Collection<String> getReducingEndsString() {
        LinkedList<String> ret = new LinkedList<String>();
        for (ResidueType rt : all_residues) {
            if (!rt.canBeReducingEnd()) continue;
            ret.add(rt.getName());
        }
        return ret;
    }

    public static Residue newResidue(String type_name) throws Exception {
        return new Residue(ResidueDictionary.getResidueType(type_name));
    }

    public static Residue createReducingEnd(String a_sIndex) {
        String a_sKey = "";
        a_sKey = a_sIndex == null ? TextSymbolDescriptor.CER.toString() : TextSymbolDescriptor.forRedType(a_sIndex).toString();
        return new Residue(ResidueDictionary.findResidueType(a_sKey));
    }

    public static Residue createStartRepetition() {
        return new Residue(ResidueType.createStartRepetition());
    }

    public static Residue createEndRepetition() {
        return new Residue(ResidueType.createEndRepetition());
    }

    public static Residue createEndRepetition(String min, String max) {
        return new Residue(ResidueType.createEndRepetition(min, max));
    }

    public static Residue createStartCyclic() {
        return new Residue(ResidueType.createStartCyclic());
    }

    public static Residue createEndCyclic() {
        return new Residue(ResidueType.createEndCyclic());
    }

    public static Residue createAlternativeStart() {
        return new Residue(ResidueType.createAlternativeStart());
    }

    public static Residue createAlternativeEnd() {
        return new Residue(ResidueType.createAlternativeEnd());
    }

    public static Residue createBracket() {
        return new Residue(ResidueType.createBracket());
    }

    public static Residue createAttachPoint() {
        return new Residue(ResidueDictionary.findResidueType("#attach"));
    }

    public static Residue createBCleavage() {
        ResidueType res = ResidueType.createUnknown("#bcleavage", "");
        return new Residue(res);
    }

    public static Residue createCCleavage() {
        ResidueType res = ResidueType.createUnknown("#ccleavage", "H2O");
        return new Residue(res);
    }

    public static Residue createYCleavage() {
        ResidueType res = ResidueType.createUnknown("#ycleavage", "H2O");
        return new Residue(res);
    }

    public static Residue createZCleavage() {
        ResidueType res = ResidueType.createUnknown("#zcleavage", "");
        return new Residue(res);
    }

    public static Residue createLCleavage() {
        return new Residue(ResidueDictionary.findResidueType("#lcleavage"));
    }

    private ResidueDictionary() {
    }

    public static void loadDictionary(String filename) {
        ResidueDictionary.initDictionary();
        superclasses.clear();
        direct_residues.clear();
        other_residues.clear();
        all_residues.clear();
        all_residues_map.clear();
        try {
            String line;
            BufferedReader is;
            if (filename.startsWith("http")) {
                URLConnection conn = new URL(filename).openConnection();
                is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            } else {
                URL file_url = ResidueDictionary.class.getResource(filename);
                if (file_url == null) {
                    File file = new File(filename);
                    if (!file.exists()) {
                        throw new FileNotFoundException(filename);
                    }
                    is = new BufferedReader(new FileReader(file));
                } else {
                    is = new BufferedReader(new InputStreamReader(file_url.openStream()));
                }
            }
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim(line)).length() <= 0 || line.startsWith("%")) continue;
                ResidueDictionary.add(new ResidueType(line));
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report(e);
            dictionary.clear();
        }
    }

    private static void add(ResidueType type) {
        if (type.isMSDefault()) {
            dictionary.put(type.getName().toLowerCase(), type);
            for (String s : type.getSynonyms()) {
                dictionary.put(s.toLowerCase(), type);
            }
            String superclass = type.getSuperclass();
            if (all_residues_map.get(superclass) == null) {
                superclasses.add(superclass);
                all_residues_map.put(superclass, new LinkedList());
            }
            if (type.getToolbarOrder() != 0) {
                direct_residues.put(type.getToolbarOrder(), type);
            } else {
                other_residues.add(type);
            }
            all_residues.add(type);
            all_residues_map.get(superclass).add(type);
        }
    }

    private static void initDictionary() {
        dictionary.clear();
        ResidueDictionary.add(new ResidueType());
        ResidueDictionary.add(ResidueType.createAttachPoint());
        ResidueDictionary.add(ResidueType.createBracket());
        ResidueDictionary.add(ResidueType.createBCleavage());
        ResidueDictionary.add(ResidueType.createCCleavage());
        ResidueDictionary.add(ResidueType.createYCleavage());
        ResidueDictionary.add(ResidueType.createZCleavage());
        ResidueDictionary.add(ResidueType.createLCleavage());
        if (dictionary.get("Cer") == null) {
            ResidueDictionary.add(ResidueType.createCerReducingEnd());
        }
    }

    public static ResidueType checkNoDefinedData(String str_type) {
        if (str_type.equals("#startrep")) {
            return ResidueType.createStartRepetition();
        }
        if (str_type.contains("#endrep")) {
            return ResidueType.createEndRepetition();
        }
        try {
            return NonSymbolicResidueDictionary.getResidueType(str_type);
        }
        catch (Exception e) {
            e.getMessage();
            return null;
        }
    }

    static {
        ResidueDictionary.initDictionary();
    }
}

