/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.CanvasAction;
import org.eurocarbdb.application.glycanbuilder.CanvasCommand;
import org.eurocarbdb.application.glycanbuilder.Context;
import org.eurocarbdb.application.glycanbuilder.ContextAwareContainer;
import org.eurocarbdb.application.glycanbuilder.CoreType;
import org.eurocarbdb.application.glycanbuilder.DefaultPaintable;
import org.eurocarbdb.application.glycanbuilder.DropDownList;
import org.eurocarbdb.application.glycanbuilder.EurocarbResizableIcon;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.GlycanSelection;
import org.eurocarbdb.application.glycanbuilder.GlycanStructureAndChangeUser;
import org.eurocarbdb.application.glycanbuilder.GlytoucanIDList;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.ImageResizableIconReducedMem;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueHistory;
import org.eurocarbdb.application.glycanbuilder.ResiduePlacement;
import org.eurocarbdb.application.glycanbuilder.ResidueSelectorDialog;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TerminalType;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycanbuilder.converter.GlycanParserFactory;
import org.eurocarbdb.application.glycanbuilder.dataset.CoreDictionary;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.dataset.TerminalDictionary;
import org.eurocarbdb.application.glycanbuilder.fileutil.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.linkage.Bond;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.renderutil.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.renderutil.Geometry;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.renderutil.PositionManager;
import org.eurocarbdb.application.glycanbuilder.renderutil.ResAngle;
import org.eurocarbdb.application.glycanbuilder.renderutil.ResidueRenderer;
import org.eurocarbdb.application.glycanbuilder.renderutil.SVGUtils;
import org.eurocarbdb.application.glycanbuilder.util.ActionManager;
import org.eurocarbdb.application.glycanbuilder.util.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.util.CompositionDialog;
import org.eurocarbdb.application.glycanbuilder.util.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.util.GraphicOptionsDialog;
import org.eurocarbdb.application.glycanbuilder.util.ImportStructureDialog;
import org.eurocarbdb.application.glycanbuilder.util.JCommandToggleButtonAction;
import org.eurocarbdb.application.glycanbuilder.util.MassOptionsStructureDialog;
import org.eurocarbdb.application.glycanbuilder.util.MouseUtils;
import org.eurocarbdb.application.glycanbuilder.util.NotationChangeListener;
import org.eurocarbdb.application.glycanbuilder.util.OutputImageDialog;
import org.eurocarbdb.application.glycanbuilder.util.OutputStringDialog;
import org.eurocarbdb.application.glycanbuilder.util.RepetitionPropertiesDialog;
import org.eurocarbdb.application.glycanbuilder.util.ResiduePropertiesDialog;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;
import org.eurocarbdb.application.glycanbuilder.util.UIActionListener;
import org.glycoinfo.application.glycanbuilder.dataset.CrossLinkedSubstituentDictionary;
import org.glycoinfo.application.glycanbuilder.dataset.NonSymbolicResidueDictionary;
import org.glycoinfo.application.glycanbuilder.dataset.TextSymbolDescriptor;
import org.glycoinfo.application.glycanbuilder.dialog.ResidueDesignDialog;
import org.glycoinfo.application.glycanbuilder.util.GlycanUtils;
import org.glycoinfo.application.glycanbuilder.util.canvas.CanvasActionDescriptor;
import org.glycoinfo.application.glycanbuilder.util.canvas.CompositionUtility;
import org.glycoinfo.application.glycanbuilder.util.canvas.DebugUtility;
import org.json.simple.parser.ParseException;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.JFlowRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JFlowBandControlPanel;

public class GlycanCanvas
extends JComponent
implements ActionListener,
BaseDocument.DocumentChangeListener,
ResidueHistory.Listener,
Printable,
MouseListener,
MouseMotionListener,
HyperlinkListener {
    private static ICON_SIZE defaultMenuIconSize = ICON_SIZE.L3;
    private boolean allowRepeatingUnits = false;
    private boolean allowMultipleStructures = true;
    private boolean allowUncertainTerminals = false;
    private boolean allowCyclicUnits = false;
    private boolean allowAlternativeUnit = false;
    protected ImageIcon last;
    protected static final long serialVersionUID = 0L;
    protected GlycanCanvas this_object = null;
    protected JFrame theParent = null;
    protected BuilderWorkspace theWorkspace = null;
    protected GlycanDocument theDoc = null;
    protected GlycanStructureAndChangeUser theStructure = null;
    private ActionManager theActionManager;
    protected JScrollPane theScrollPane = null;
    protected JToolBar theToolBarDocument;
    protected JToolBar theToolBarStructure;
    protected JComboBox field_anomeric_state;
    protected JComboBox field_anomeric_carbon;
    protected DropDownList field_linkage_position;
    protected JComboBox field_chirality;
    protected JComboBox field_ring_size;
    protected JCheckBox field_second_bond;
    protected JComboBox field_second_child_position;
    protected DropDownList field_second_parent_position;
    protected JMenu theEditMenu = null;
    protected JMenu theStructureMenu = null;
    protected JMenu theViewMenu = null;
    protected JMenu theDebugMenu = null;
    protected JCheckBox show_redend_canvas_button = null;
    protected int recent_residues_index = -1;
    protected int no_recent_residues_buttons = 0;
    protected ButtonGroup display_button_group = null;
    protected HashMap<String, ButtonModel> display_models = null;
    protected Residue current_residue;
    protected Linkage current_linkage;
    protected HashSet<Residue> selected_residues;
    protected HashSet<Linkage> selected_linkages;
    private GlycanRendererAWT theGlycanRenderer;
    protected Rectangle all_structures_bbox;
    protected BBoxManager theBBoxManager;
    protected PositionManager thePosManager;
    protected boolean is_printing;
    protected JLabel sel_label = new JLabel();
    private boolean ignore_actions = false;
    protected Point mouse_start_point = null;
    protected Point mouse_end_point = null;
    protected boolean is_dragndrop = false;
    protected boolean was_dragged = false;
    protected Cursor dndcopy_cursor = null;
    protected Cursor dndmove_cursor = null;
    protected Cursor dndnocopy_cursor = null;
    protected Cursor dndnomove_cursor = null;
    protected LinkedList<SelectionChangeListener> listeners;
    protected ThemeManager themeManager;
    private RibbonTask theEditRibbon;
    private RibbonTask theStructureRibbon;
    private RibbonTask theViewRibbon;
    private RibbonTask theGlyTouCanRibbon;
    private JRibbonBand structureSelectionBand;
    private JRibbonBand structureRibbonBandSNFG;
    private String STRUCTURE_GALLERY_NAME = "Add structure";
    private String RESIDUE_GALLERY_NAME = "Add residue";
    private String TERMINAL_GAL_NAME = "Add terminal";
    private JRibbonBand insertResidueJRibbonBand;
    private JCommandButton orientationButton;
    private JRibbonBand terminalRibbonBand;
    private RibbonContextualTaskGroup theLinkageRibbon;
    protected Set<ContextAwareContainer> contextAwareContainers;
    protected Set<NotationChangeListener> notationChangeListeners;
    protected Map<String, String> themeNameToQualifiedName;
    private CanvasCommand a_oCommand;
    private HashMap<RESIDUE_INSERT_MODES, List<ResidueGalleryIndex>> residueGalleries;
    private JComboBox field_anomeric_state_r;
    private JComboBox field_anomeric_carbon_r;
    private DropDownList field_linkage_position_r;
    private JComboBox field_chirality_r;
    private JComboBox field_ring_size_r;
    private JCheckBox field_second_bond_r;
    private JComboBox field_second_child_position_r;
    private DropDownList field_second_parent_position_r;
    private HashMap<String, String> qualifiedNameToThemeName;
    private JMenu addResidueMenu;
    private JMenu addTerminalMenu;
    private JMenuItem insertResidueMenu;
    private JMenuItem changeResidueMenu;
    protected HashMap<String, JPopupMenu> cachedMenus = new HashMap();
    protected boolean respondToDocumentChange;
    protected Integer lastMouseButton;
    private List<UIActionListener> uiActionListenerList = new ArrayList<UIActionListener>();
    private JMenuItem bracketMenuItem;
    private JMenuItem repeatMenuItem;
    private JMenuItem antennaParentItem;
    private JMenuItem cyclicMenuItem;
    private JButton bracketButton;
    private JButton repeatButton;
    private JButton antennaParentButton;
    private JButton cyclicButton;
    private JButton altButton;

    public void nullAll() {
        this.listeners = null;
        this.themeManager = null;
        this.theEditRibbon = null;
        this.theStructureRibbon = null;
        this.theViewRibbon = null;
        this.theGlyTouCanRibbon = null;
        this.structureSelectionBand = null;
        this.structureRibbonBandSNFG = null;
        this.insertResidueJRibbonBand = null;
        this.orientationButton = null;
        this.terminalRibbonBand = null;
        this.theLinkageRibbon = null;
        this.contextAwareContainers = null;
        this.notationChangeListeners = null;
    }

    public RibbonTask getTheViewRibbon() {
        return this.theViewRibbon;
    }

    public RibbonTask getTheStructureRibbon() {
        return this.theStructureRibbon;
    }

    public GlycanCanvas(JFrame parent, BuilderWorkspace _workspace, ThemeManager _themeManager) {
        this.initCanvas(parent, _workspace, _themeManager, true);
    }

    public GlycanCanvas(JFrame parent, BuilderWorkspace _workspace, ThemeManager _themeManager, boolean enableRibbons) throws MalformedURLException {
        this.initCanvas(parent, _workspace, _themeManager, enableRibbons);
    }

    public void initCanvas(JFrame parent, BuilderWorkspace _workspace, ThemeManager _themeManager, boolean enableRibbons) {
        this.themeManager = _themeManager;
        FileUtils.themeManager = _themeManager;
        try {
            this.themeManager.addIconPath("/icons/glycan_builder", this.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.themeManager.addIconPath("/icons/crystal_project", this.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.a_oCommand = new CanvasCommand(this.themeManager, this.getTheActionManager());
        this.this_object = this;
        this.theParent = parent;
        this.theWorkspace = _workspace;
        this.theDoc = this.theWorkspace.getStructures();
        this.theDoc.addDocumentChangeListener(this);
        this.theStructure = new GlycanStructureAndChangeUser();
        this.setTheActionManager(new ActionManager());
        this.current_residue = null;
        this.current_linkage = null;
        this.selected_residues = new HashSet();
        this.selected_linkages = new HashSet();
        this.setTheGlycanRenderer((GlycanRendererAWT)this.theWorkspace.getGlycanRenderer());
        this.thePosManager = new PositionManager();
        this.theBBoxManager = new BBoxManager();
        this.all_structures_bbox = null;
        this.is_printing = false;
        this.residueGalleries = new HashMap();
        for (RESIDUE_INSERT_MODES mode : RESIDUE_INSERT_MODES.values()) {
            this.residueGalleries.put(mode, new ArrayList());
        }
        this.createActions();
        this.theToolBarDocument = this.createToolBarDocument();
        this.theToolBarStructure = this.createToolBarStructure();
        this.theEditMenu = this.createEditMenu();
        if (!enableRibbons) {
            this.theStructureMenu = this.createStructureMenu();
            this.theViewMenu = this.createViewMenu();
            this.theDebugMenu = this.createDebugMenu();
        }
        if (enableRibbons) {
            int restoreOrientation = this.theWorkspace.getGraphicOptions().ORIENTATION;
            if (this.theWorkspace.getGraphicOptions().ORIENTATION == 1 || this.theWorkspace.getGraphicOptions().ORIENTATION == 3) {
                this.theWorkspace.getGraphicOptions().ORIENTATION = 0;
            }
            this.theEditRibbon = this.createEditRibbonBand();
            this.theGlyTouCanRibbon = this.createGlyTouCanRibbonBand();
            this.theStructureRibbon = this.createStructureRibbonTask();
            this.theViewRibbon = this.createViewRibbonTask();
            this.theLinkageRibbon = this.createLinkageRibbon();
            this.theWorkspace.getGraphicOptions().ORIENTATION = restoreOrientation;
        }
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.dndcopy_cursor = FileUtils.createCursor("dnd-copy");
        this.dndnocopy_cursor = FileUtils.createCursor("dnd-nocopy");
        this.dndmove_cursor = FileUtils.createCursor("dnd-move");
        this.dndnomove_cursor = FileUtils.createCursor("dnd-nomove");
        this.theWorkspace.getResidueHistory().addHistoryChangedListener(this);
        this.theDoc.addDocumentChangeListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.listeners = new LinkedList();
        this.contextAwareContainers = new HashSet<ContextAwareContainer>();
        this.notationChangeListeners = new HashSet<NotationChangeListener>();
    }

    public void addContextAwareContainer(ContextAwareContainer container) {
        this.contextAwareContainers.add(container);
    }

    public void addNotationChangeListener(NotationChangeListener notationChangeListener) {
        this.notationChangeListeners.add(notationChangeListener);
    }

    public RibbonContextualTaskGroup getTheLinkageRibbon() {
        return this.theLinkageRibbon;
    }

    public RibbonTask getTheEditRibbon() {
        return this.theEditRibbon;
    }

    public RibbonTask getTheGlyTouCanRibbon() {
        return this.theGlyTouCanRibbon;
    }

    public void setDocument(GlycanDocument doc) {
        if (this.theDoc != null) {
            this.theDoc.removeDocumentChangeListener(this);
        }
        this.theDoc = doc;
        if (this.theDoc != null) {
            this.theDoc.addDocumentChangeListener(this);
        }
        this.resetSelection();
        this.respondToDocumentChange = true;
        this.repaint();
    }

    public GlycanDocument getDocument() {
        return this.theDoc;
    }

    public ActionManager getActionManager() {
        return this.getTheActionManager();
    }

    public GlycanRenderer getGlycanRenderer() {
        return this.getTheGlycanRenderer();
    }

    public void setGlycanRenderer(GlycanRendererAWT r) {
        this.setTheGlycanRenderer(r);
    }

    public void setScrollPane(JScrollPane sp) {
        this.theScrollPane = sp;
        this.theScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.theScrollPane.getVerticalScrollBar().setBlockIncrement(20);
        this.theScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.theScrollPane.getHorizontalScrollBar().setBlockIncrement(10);
    }

    public JToolBar getToolBarDocument() {
        return this.theToolBarDocument;
    }

    public JToolBar getToolBarStructure() {
        return this.theToolBarStructure;
    }

    public JMenu getEditMenu() {
        return this.theEditMenu;
    }

    public JMenu getStructureMenu() {
        return this.theStructureMenu;
    }

    public JMenu getViewMenu() {
        return this.theViewMenu;
    }

    public JMenu getDebugMenu() {
        return this.theDebugMenu;
    }

    private String getCurrentOrientation() {
        String iconId;
        int orientation = this.theWorkspace.getGraphicOptions().ORIENTATION;
        if (orientation == 2) {
            iconId = "lr";
        } else if (orientation == 0) {
            iconId = "rl";
        } else if (orientation == 3) {
            iconId = "tb";
        } else if (orientation == 1) {
            iconId = "bt";
        } else {
            return null;
        }
        return iconId;
    }

    private EurocarbResizableIcon getOrientationIcon() {
        return this.themeManager.getResizableIcon(this.getCurrentOrientation(), ICON_SIZE.L3);
    }

    private void createActions() {
        CanvasAction a_oAction = new CanvasAction();
        a_oAction.createAction(this.getTheActionManager(), this.themeManager, defaultMenuIconSize, this, this.getTheGlycanRenderer());
    }

    private void updateActions() {
        this.getTheActionManager().get("undo").setEnabled(this.theDoc.getUndoManager().canUndo());
        this.getTheActionManager().get("redo").setEnabled(this.theDoc.getUndoManager().canRedo());
        this.getTheActionManager().get("cut").setEnabled(this.hasSelectedResidues());
        this.getTheActionManager().get("copy").setEnabled(this.hasSelectedResidues());
        this.getTheActionManager().get("delete").setEnabled(this.hasSelectedResidues());
        if (!this.allowUncertainTerminals) {
            this.getTheActionManager().get("bracket").setEnabled(false);
            if (this.bracketButton != null) {
                this.bracketButton.setVisible(false);
            }
            if (this.bracketMenuItem != null) {
                this.bracketMenuItem.setVisible(false);
            }
        } else {
            this.getTheActionManager().get("bracket").setEnabled(this.hasCurrentResidue());
            if (this.bracketButton != null) {
                this.bracketButton.setVisible(true);
            }
            if (this.bracketMenuItem != null) {
                this.bracketMenuItem.setVisible(true);
            }
        }
        if (!this.allowRepeatingUnits) {
            this.getTheActionManager().get("repeat").setEnabled(false);
            if (this.repeatButton != null) {
                this.repeatButton.setVisible(false);
            }
            if (this.repeatMenuItem != null) {
                this.repeatMenuItem.setVisible(false);
            }
        } else {
            this.getTheActionManager().get("repeat").setEnabled(this.hasCurrentResidue());
            if (this.repeatButton != null) {
                this.repeatButton.setVisible(true);
            }
            if (this.repeatMenuItem != null) {
                this.repeatMenuItem.setVisible(true);
            }
        }
        if (!this.allowCyclicUnits) {
            this.getTheActionManager().get("cyclic").setEnabled(false);
            if (this.cyclicButton != null) {
                this.cyclicButton.setVisible(false);
            }
            if (this.cyclicMenuItem != null) {
                this.cyclicMenuItem.setVisible(false);
            }
        } else {
            this.getTheActionManager().get("cyclic").setEnabled(this.hasCurrentResidue());
            if (this.cyclicButton != null) {
                this.cyclicButton.setVisible(true);
            }
            if (this.cyclicMenuItem != null) {
                this.cyclicMenuItem.setVisible(true);
            }
        }
        if (!(this.getCurrentResidue() != null && this.getCurrentResidue().isSaccharide() && this.getCurrentResidue().hasParent() && this.getCurrentResidue().getParent().isBracket())) {
            this.getTheActionManager().get("antennaParent").setEnabled(false);
            if (this.antennaParentButton != null) {
                this.antennaParentButton.setVisible(false);
            }
            if (this.antennaParentItem != null) {
                this.antennaParentItem.setVisible(false);
            }
        } else {
            boolean isAntenna = this.getCurrentResidue().getParent().isBracket();
            this.getTheActionManager().get("antennaParent").setEnabled(isAntenna);
            if (this.antennaParentButton != null) {
                this.antennaParentButton.setVisible(isAntenna);
            }
            if (this.antennaParentItem != null) {
                this.antennaParentItem.setVisible(isAntenna);
            }
        }
        this.getTheActionManager().get("massoptstruct").setEnabled(this.hasSelection());
        this.getTheActionManager().get("moveccw").setEnabled(this.hasCurrentSelection());
        this.getTheActionManager().get("movecw").setEnabled(this.hasCurrentSelection());
        if (!this.allowMultipleStructures) {
            if (this.theDoc.getNoStructures() == 0) {
                this.setAddStructureStatus(true);
            } else if (this.getSelectedResidues().length == 0) {
                this.setAddStructureStatus(false);
            } else {
                this.setAddStructureStatus(true);
            }
        } else {
            this.setAddStructureStatus(true);
        }
    }

    protected void setAddStructureStatus(boolean enable) {
        ResidueRenderer rr = this.getTheGlycanRenderer().getResidueRenderer();
        for (ResidueType residueType : ResidueDictionary.allResidues()) {
            this.getTheActionManager().get("change=" + residueType.getName()).setEnabled(enable);
            if (residueType.canHaveParent()) {
                this.getTheActionManager().get("add=" + residueType.getName()).setEnabled(enable);
            }
            if (residueType.canHaveParent() && residueType.canHaveChildren()) {
                this.getTheActionManager().get("insert=" + residueType.getName()).setEnabled(enable);
            }
            if (!residueType.canBeReducingEnd()) continue;
            this.getTheActionManager().get("changeredend=" + residueType.getName()).setEnabled(enable);
        }
        for (CoreType coreType : CoreDictionary.getCores()) {
            this.getTheActionManager().get("addstructure=" + coreType.getName()).setEnabled(enable);
        }
        this.getTheActionManager().get("addstructurestr").setEnabled(enable);
        this.getTheActionManager().get("getstructurestr").setEnabled(enable);
        this.getTheActionManager().get("addcomposition").setEnabled(enable);
    }

    private void updateOrientation() {
        if (this.theWorkspace.getGraphicOptions().ORIENTATION == 2 || this.theWorkspace.getGraphicOptions().ORIENTATION == 0) {
            this.updateStructureRibbonGallery(this.STRUCTURE_GALLERY_NAME, this.structureSelectionBand);
            for (ResidueGalleryIndex gal : this.residueGalleries.get((Object)RESIDUE_INSERT_MODES.TERMINAL)) {
                if (gal.band.getControlPanel() == null || ((JBandControlPanel)gal.band.getControlPanel()).getRibbonGallery(gal.galleryName) != null) continue;
                this.updateTerminalRibbonGallery(gal.galleryName, gal.band);
            }
        }
    }

    private void updateResidueActions() {
        ResidueRenderer rr = this.getTheGlycanRenderer().getResidueRenderer();
        ICON_SIZE iconSize = ICON_SIZE.L4;
        for (ResidueType t : ResidueDictionary.allResidues()) {
            ImageResizableIconReducedMem icon = new ImageResizableIconReducedMem(rr.getImage(t, iconSize.getSize()), iconSize.getSize(), iconSize.getSize());
            EurocarbResizableIcon eu_icon = new EurocarbResizableIcon(this.themeManager, null, icon);
            eu_icon.setResizableIcon(icon);
            this.getTheActionManager().update("change=" + t.getName(), eu_icon, t.getDescription(), -1, "");
            if (t.canHaveParent()) {
                this.getTheActionManager().update("add=" + t.getName(), eu_icon, t.getDescription(), -1, t.getToolbarOrder() != 0 ? "ctrl " + t.getToolbarOrder() : "");
                this.getTheActionManager().get("add=" + t.getName()).putValue("SmallIcon", new ImageIcon(rr.getImage(t, ICON_SIZE.L3.getSize())));
            }
            if (t.canHaveParent() && t.canHaveChildren()) {
                this.getTheActionManager().update("insert=" + t.getName(), eu_icon, t.getDescription(), -1, "");
            }
            if (!t.canBeReducingEnd()) continue;
            this.getTheActionManager().update("redend=" + t.getName(), eu_icon, t.getDescription(), -1, "");
        }
        this.structureSelectionBand = this.createStructureRibbonBand();
        this.updateStructureRibbonGallery(this.STRUCTURE_GALLERY_NAME, this.structureSelectionBand);
        for (ResidueGalleryIndex gal : this.residueGalleries.get((Object)RESIDUE_INSERT_MODES.ADD)) {
            if (gal.band.getControlPanel() == null || ((JBandControlPanel)gal.band.getControlPanel()).getRibbonGallery(gal.galleryName) != null) continue;
            this.updateAddResidueRibbonGallery(gal.galleryName, gal.band);
        }
        for (ResidueGalleryIndex gal : this.residueGalleries.get((Object)RESIDUE_INSERT_MODES.REPLACE)) {
            if (gal.band.getControlPanel() == null || ((JBandControlPanel)gal.band.getControlPanel()).getRibbonGallery(gal.galleryName) != null) continue;
            this.updateChangeResidueRibbonGallery(gal.galleryName, gal.band);
        }
        for (ResidueGalleryIndex gal : this.residueGalleries.get((Object)RESIDUE_INSERT_MODES.INSERT)) {
            if (gal.band.getControlPanel() == null || ((JBandControlPanel)gal.band.getControlPanel()).getRibbonGallery(gal.galleryName) != null) continue;
            this.updateInsertResidueRibbonGallery(gal.galleryName, gal.band);
        }
        for (ResidueGalleryIndex gal : this.residueGalleries.get((Object)RESIDUE_INSERT_MODES.TERMINAL)) {
            if (gal.band.getControlPanel() == null || ((JBandControlPanel)gal.band.getControlPanel()).getRibbonGallery(gal.galleryName) != null) continue;
            this.updateTerminalRibbonGallery(gal.galleryName, gal.band);
        }
    }

    private String[] toStrings(char[] pos) {
        String[] ret = new String[pos.length];
        for (int i = 0; i < pos.length; ++i) {
            ret[i] = "" + pos[i];
        }
        return ret;
    }

    private ListModel createPositions(Residue parent) {
        DefaultListModel<String> ret = new DefaultListModel<String>();
        char[] par_pos = null;
        par_pos = parent == null || parent.getType().getLinkagePositions().length == 0 ? new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', 'N'} : parent.getType().getLinkagePositions();
        String par_pos_temp = String.valueOf(par_pos);
        for (Linkage donorLinkage : parent.getChildrenLinkages()) {
            if (this.current_residue == donorLinkage.getChildResidue()) continue;
            for (Bond donorBond : donorLinkage.getBonds()) {
                if (donorBond.getParentPositions().length > 1 || donorBond.getParentPositions()[0] == '?') continue;
                char donorPos = donorBond.getParentPositions()[0];
                par_pos_temp = par_pos_temp.replace(donorPos, ' ');
            }
        }
        if (parent.getRingSize() == 'o') {
            par_pos_temp = par_pos_temp + parent.getType().getAnomericCarbon();
        }
        if (parent.getRingSize() == 'p') {
            if (parent.getAnomericCarbon() == '1') {
                par_pos_temp = par_pos_temp.replace('5', ' ');
            }
            if (parent.getAnomericCarbon() == '2') {
                par_pos_temp = par_pos_temp.replace('6', ' ');
            }
        }
        if (parent.getRingSize() == 'f') {
            if (parent.getAnomericCarbon() == '1') {
                par_pos_temp = par_pos_temp.replace('4', ' ');
            }
            if (parent.getAnomericCarbon() == '2') {
                par_pos_temp = par_pos_temp.replace('5', ' ');
            }
        }
        if (!par_pos_temp.equals(String.valueOf(par_pos))) {
            par_pos_temp = par_pos_temp.replaceAll(" ", "");
            par_pos = par_pos_temp.toCharArray();
            Arrays.sort(par_pos);
        }
        ret.addElement("?");
        for (int i = 0; i < par_pos.length; ++i) {
            ret.addElement("" + par_pos[i]);
        }
        return ret;
    }

    private void fireContextChanged(Context context, boolean switchToDefault) {
        for (ContextAwareContainer container : this.contextAwareContainers) {
            container.fireContextChanged(context, switchToDefault);
        }
    }

    private void fireUndoContextChanged(Context context) {
        for (ContextAwareContainer container : this.contextAwareContainers) {
            container.fireUndoContextChanged(context);
        }
    }

    private JMenu createAddStructureMenu() {
        return this.a_oCommand.createAddStructureMenu(this.getTheActionManager());
    }

    private JMenu createAddResidueMenu() {
        return this.a_oCommand.createAddResidueMenu(this.getTheActionManager());
    }

    private JMenu createAddTerminalMenu() {
        return this.a_oCommand.createAddTerminalMenu(this);
    }

    private JMenu createInsertResidueMenu() {
        return this.a_oCommand.createInsertResidueMenu(this.getTheActionManager());
    }

    private JMenu createChangeResidueTypeMenu() {
        return this.a_oCommand.createChangeResidueTypeMenu(this.getTheActionManager());
    }

    private JMenu createInsertBridgeMenu() {
        return this.a_oCommand.createInsertBridgeMenu(this.getTheActionManager());
    }

    private void updateRecentResiduesToolbar(JToolBar tb) {
        for (int i = 0; i < this.no_recent_residues_buttons; ++i) {
            tb.remove(this.recent_residues_index);
        }
        this.no_recent_residues_buttons = 0;
        for (String typename : this.theWorkspace.getResidueHistory().getRecentResidues()) {
            JButton b = new JButton(this.getTheActionManager().get("add=" + typename));
            b.setText(null);
            tb.add((Component)b, this.recent_residues_index + this.no_recent_residues_buttons++);
        }
    }

    private JMenu createZoomMenu() {
        return this.a_oCommand.createZoomMenu(this.theWorkspace, this.getTheActionManager());
    }

    private JMenu createViewMenu() {
        GraphicOptions view_opt = this.theWorkspace.getGraphicOptions();
        JMenu view_menu = new JMenu("View");
        view_menu.setMnemonic(86);
        view_menu.add(this.createZoomMenu());
        view_menu.addSeparator();
        JRadioButtonMenuItem last = null;
        ButtonGroup groupn = new ButtonGroup();
        last = new JRadioButtonMenuItem(this.getTheActionManager().get("notation=cfg"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("cfg"));
        groupn.add(last);
        last = new JRadioButtonMenuItem(this.getTheActionManager().get("notation=cfgbw"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("cfgbw"));
        groupn.add(last);
        last = new JRadioButtonMenuItem(this.getTheActionManager().get("notation=cfglink"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("cfglink"));
        groupn.add(last);
        last = new JRadioButtonMenuItem(this.getTheActionManager().get("notation=uoxf"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("uoxf"));
        last = new JRadioButtonMenuItem(this.getTheActionManager().get("notation=uoxfcol"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("uoxfcol"));
        groupn.add(last);
        last = new JRadioButtonMenuItem(this.getTheActionManager().get("notation=text"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("text"));
        groupn.add(last);
        last = new JRadioButtonMenuItem(this.getTheActionManager().get("notation=snfg"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("snfg"));
        groupn.add(last);
        view_menu.addSeparator();
        this.display_button_group = new ButtonGroup();
        this.display_models = new HashMap();
        last = new JRadioButtonMenuItem(this.getTheActionManager().get("display=compact"));
        view_menu.add(last);
        last.setSelected(view_opt.DISPLAY.equals("compact"));
        this.display_models.put("compact", last.getModel());
        this.display_button_group.add(last);
        last = new JRadioButtonMenuItem(this.getTheActionManager().get("display=normal"));
        view_menu.add(last);
        last.setSelected(view_opt.DISPLAY.equals("normal"));
        this.display_models.put("normal", last.getModel());
        this.display_button_group.add(last);
        last = new JRadioButtonMenuItem(this.getTheActionManager().get("display=normalinfo"));
        view_menu.add(last);
        last.setSelected(view_opt.DISPLAY.equals("normalinfo"));
        this.display_models.put("normalinfo", last.getModel());
        this.display_button_group.add(last);
        last = new JRadioButtonMenuItem(this.getTheActionManager().get("display=custom"));
        view_menu.add(last);
        last.setSelected(view_opt.DISPLAY.equals("custom"));
        this.display_models.put("custom", last.getModel());
        this.display_button_group.add(last);
        view_menu.addSeparator();
        JCheckBox lastcb = new JCheckBox(this.getTheActionManager().get("collapsemultipleantennae"));
        view_menu.add(lastcb);
        lastcb.setSelected(view_opt.COLLAPSE_MULTIPLE_ANTENNAE);
        lastcb = new JCheckBox(this.getTheActionManager().get("showmassescanvas"));
        view_menu.add(lastcb);
        lastcb.setSelected(view_opt.SHOW_MASSES_CANVAS);
        lastcb = new JCheckBox(this.getTheActionManager().get("showmasses"));
        view_menu.add(lastcb);
        lastcb.setSelected(view_opt.SHOW_MASSES);
        lastcb = new JCheckBox(this.getTheActionManager().get("showredendcanvas"));
        view_menu.add(lastcb);
        this.show_redend_canvas_button = lastcb;
        lastcb.setSelected(view_opt.SHOW_REDEND_CANVAS);
        lastcb = new JCheckBox(this.getTheActionManager().get("showredend"));
        view_menu.add(lastcb);
        lastcb.setSelected(view_opt.SHOW_REDEND);
        view_menu.addSeparator();
        view_menu.add(this.getTheActionManager().get("orientation"));
        view_menu.addSeparator();
        view_menu.add(this.getTheActionManager().get("displaysettings"));
        return view_menu;
    }

    private RibbonTask createViewRibbonTask() {
        JFlowRibbonBand band1 = new JFlowRibbonBand("Notation format", new EmptyResizableIcon(10));
        ArrayList<RibbonBandResizePolicy> resizePolicies1 = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies1.add(new CoreRibbonResizePolicies.FlowTwoRows((JFlowBandControlPanel)band1.getControlPanel()));
        resizePolicies1.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)band1.getControlPanel()));
        band1.setResizePolicies(resizePolicies1);
        GraphicOptions view_opt = this.theWorkspace.getGraphicOptions();
        JCommandButtonPanel panel = new JCommandButtonPanel(CommandButtonDisplayState.TILE);
        panel.addButtonGroup("Active notation");
        panel.addButtonToLastGroup(this.getTheActionManager().get("notation=cfg").getJCommandToggleButton("", this, view_opt.NOTATION.equals("cfg"), ICON_SIZE.L6));
        panel.addButtonToLastGroup(this.getTheActionManager().get("notation=cfgbw").getJCommandToggleButton("", this, view_opt.NOTATION.equals("cfgbw"), ICON_SIZE.L6));
        panel.addButtonToLastGroup(this.getTheActionManager().get("notation=cfglink").getJCommandToggleButton("", this, view_opt.NOTATION.equals("cfglink"), ICON_SIZE.L6));
        panel.addButtonToLastGroup(this.getTheActionManager().get("notation=uoxf").getJCommandToggleButton("", this, view_opt.NOTATION.equals("uoxf"), ICON_SIZE.L6));
        panel.addButtonToLastGroup(this.getTheActionManager().get("notation=uoxfcol").getJCommandToggleButton("", this, view_opt.NOTATION.equals("uoxfcol"), ICON_SIZE.L6));
        panel.addButtonToLastGroup(this.getTheActionManager().get("notation=text").getJCommandToggleButton("", this, view_opt.NOTATION.equals("text"), ICON_SIZE.L6));
        panel.addButtonToLastGroup(this.getTheActionManager().get("notation=snfg").getJCommandToggleButton("", this, view_opt.NOTATION.equals("text"), ICON_SIZE.L6));
        panel.setToShowGroupLabels(false);
        panel.setSingleSelectionMode(true);
        panel.setMaxButtonColumns(7);
        panel.setMaxButtonRows(1);
        band1.addFlowComponent(panel);
        int zoom = (int)(this.theWorkspace.getGraphicOptions().SCALE_CANVAS * 100.0);
        if (zoom == 145) {
            zoom = 150;
        }
        final JCommandButton zoomButton = new JCommandButton(String.valueOf(zoom) + "%", this.themeManager.getResizableIcon("magglass", ICON_SIZE.L3).getResizableIcon());
        zoomButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
        zoomButton.setDisplayState(CommandButtonDisplayState.TILE);
        zoomButton.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        zoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GlycanCanvas.this.theWorkspace.getGraphicOptions().SCALE_CANVAS = 1.0;
                GlycanCanvas.this.respondToDocumentChange = true;
                zoomButton.setText("100%");
                GlycanCanvas.this.repaint();
            }
        });
        zoomButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton arg0) {
                int[] scaleArray;
                JCommandPopupMenu menu = new JCommandPopupMenu();
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JCommandMenuButton cb = (JCommandMenuButton)e.getSource();
                        String zoomLevel = cb.getText();
                        GlycanCanvas.this.theWorkspace.getGraphicOptions().SCALE_CANVAS = Double.parseDouble(zoomLevel.substring(0, zoomLevel.length() - 1)) / 100.0;
                        GlycanCanvas.this.respondToDocumentChange = true;
                        zoomButton.setText(zoomLevel);
                        GlycanCanvas.this.repaint();
                    }
                };
                for (int scale : scaleArray = new int[]{300, 400, 200, 150, 100, 67, 50, 33, 25}) {
                    JCommandMenuButton button = new JCommandMenuButton(GlycanCanvas.this.getTheActionManager().get("scale=" + scale).getName(), null);
                    button.addActionListener(actionListener);
                    menu.addMenuButton(button);
                }
                return menu;
            }
        });
        this.updateOrientationButton();
        JFlowRibbonBand band3 = new JFlowRibbonBand("Display settings", new EmptyResizableIcon(10));
        band3.addFlowComponent(this.getTheActionManager().get("displaysettings").getJCommandButton(ICON_SIZE.L4, " ", this, new RichTooltip("Change display settings", " "), true));
        band3.addFlowComponent(this.getTheActionManager().get("explode").getJCommandButton(ICON_SIZE.L4, " ", this, new RichTooltip("Explode panels", " "), true));
        band3.addFlowComponent(this.getTheActionManager().get("implode").getJCommandButton(ICON_SIZE.L4, " ", this, new RichTooltip("Implode panels", " "), true));
        band3.addFlowComponent(this.orientationButton);
        band3.addFlowComponent(zoomButton);
        ArrayList<RibbonBandResizePolicy> resizePolicies3 = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies3.add(new CoreRibbonResizePolicies.FlowTwoRows((JFlowBandControlPanel)band3.getControlPanel()));
        resizePolicies3.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)band3.getControlPanel()));
        band3.setResizePolicies(resizePolicies3);
        JFlowRibbonBand band2 = new JFlowRibbonBand("Notation style", new EmptyResizableIcon(10));
        ArrayList<RibbonBandResizePolicy> resizePolicies2 = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies2.add(new CoreRibbonResizePolicies.FlowTwoRows((JFlowBandControlPanel)band2.getControlPanel()));
        resizePolicies2.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)band2.getControlPanel()));
        band2.setResizePolicies(resizePolicies2);
        ButtonGroup group = new ButtonGroup();
        JCheckBox box = this.getTheActionManager().get("display=compact").getJCheckBox("Compact", view_opt.DISPLAY.equals("compact"), this);
        band2.addFlowComponent(box);
        group.add(box);
        box = this.getTheActionManager().get("display=normal").getJCheckBox("Normal", view_opt.DISPLAY.equals("normal"), this);
        band2.addFlowComponent(box);
        group.add(box);
        box = this.getTheActionManager().get("display=normalinfo").getJCheckBox("Extended", view_opt.DISPLAY.equals("normalinfo"), this);
        band2.addFlowComponent(box);
        group.add(box);
        box = this.getTheActionManager().get("display=custom").getJCheckBox("Custom", view_opt.DISPLAY.equals("custom"), this);
        band2.addFlowComponent(box);
        group.add(box);
        JFlowRibbonBand band4 = new JFlowRibbonBand("Show features", new EmptyResizableIcon(10));
        ArrayList<RibbonBandResizePolicy> resizePolicies4 = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies4.add(new CoreRibbonResizePolicies.FlowThreeRows((JFlowBandControlPanel)band4.getControlPanel()));
        resizePolicies4.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)band4.getControlPanel()));
        band4.setResizePolicies(resizePolicies4);
        band4.addFlowComponent(this.getTheActionManager().get("collapsemultipleantennae").getJCheckBox("Collapse multiple antennae", this));
        band4.addFlowComponent(this.getTheActionManager().get("showmassescanvas").getJCheckBox("Mass information", this));
        band4.addFlowComponent(this.getTheActionManager().get("showredendcanvas").getJCheckBox("Reducing end indicator", this));
        this.getTheActionManager().get("showmassescanvas").setSelected(this.getTheGlycanRenderer().getGraphicOptions().SHOW_MASSES_CANVAS);
        this.getTheActionManager().get("showredendcanvas").setSelected(this.getTheGlycanRenderer().getGraphicOptions().SHOW_REDEND_CANVAS);
        JFlowRibbonBand band5 = new JFlowRibbonBand("Switch themes", new EmptyResizableIcon(10));
        ArrayList<RibbonBandResizePolicy> resizePolicies5 = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies5.add(new CoreRibbonResizePolicies.FlowTwoRows((JFlowBandControlPanel)band5.getControlPanel()));
        resizePolicies5.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)band5.getControlPanel()));
        band5.setResizePolicies(resizePolicies5);
        this.themeNameToQualifiedName = new HashMap<String, String>();
        this.themeNameToQualifiedName.put("OfficeBlue2007Skin", "org.pushingpixels.substance.api.skin.OfficeBlue2007Skin");
        this.themeNameToQualifiedName.put("AutumnSkin", "org.pushingpixels.substance.api.skin.AutumnSkin");
        this.themeNameToQualifiedName.put("TwilightSkin", "org.pushingpixels.substance.api.skin.TwilightSkin");
        this.themeNameToQualifiedName.put("GraphiteGlassSkin", "org.pushingpixels.substance.api.skin.GraphiteGlassSkin");
        this.themeNameToQualifiedName.put("GraphiteAquaSkin", "org.pushingpixels.substance.api.skin.GraphiteAquaSkin");
        this.themeNameToQualifiedName.put("EmeraldDuskSkin", "org.pushingpixels.substance.api.skin.EmeraldDuskSkin");
        this.themeNameToQualifiedName.put("OfficeSilver2007Skin", "org.pushingpixels.substance.api.skin.OfficeSilver2007Skin");
        this.themeNameToQualifiedName.put("BasicWhiteSkin", "basic.white");
        this.qualifiedNameToThemeName = new HashMap();
        this.qualifiedNameToThemeName.put("org.pushingpixels.substance.api.skin.OfficeBlue2007Skin", "OfficeBlue2007Skin");
        this.qualifiedNameToThemeName.put("org.pushingpixels.substance.api.skin.AutumnSkin", "AutumnSkin");
        this.qualifiedNameToThemeName.put("org.pushingpixels.substance.api.skin.TwilightSkin", "TwilightSkin");
        this.qualifiedNameToThemeName.put("org.pushingpixels.substance.api.skin.GraphiteGlassSkin", "GraphiteGlassSkin");
        this.qualifiedNameToThemeName.put("org.pushingpixels.substance.api.skin.GraphiteAquaSkin", "GraphiteAquaSkin");
        this.qualifiedNameToThemeName.put("org.pushingpixels.substance.api.skin.EmeraldDuskSkin", "EmeraldDuskSkin");
        this.qualifiedNameToThemeName.put("org.pushingpixels.substance.api.skin.OfficeSilver2007Skin", "OfficeSilver2007Skin");
        this.qualifiedNameToThemeName.put("basic.white", "BasicWhiteSkin");
        JCommandButton themeButton = new JCommandButton(this.qualifiedNameToThemeName.get(this.theWorkspace.getGraphicOptions().THEME));
        themeButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        themeButton.setDisplayState(CommandButtonDisplayState.TILE);
        final String[] themes = new String[]{"OfficeBlue2007Skin", "AutumnSkin", "TwilightSkin", "GraphiteGlassSkin", "GraphiteAquaSkin", "EmeraldDuskSkin", "OfficeSilver2007Skin", "BasicWhiteSkin"};
        themeButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton arg0) {
                JCommandPopupMenu menu = new JCommandPopupMenu();
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JCommandMenuButton cb = (JCommandMenuButton)e.getSource();
                        String themeString = cb.getText();
                        if (GlycanCanvas.this.themeNameToQualifiedName.containsKey(themeString)) {
                            GlycanCanvas.this.theWorkspace.getGraphicOptions().THEME = themeString = GlycanCanvas.this.themeNameToQualifiedName.get(themeString);
                        }
                        JOptionPane.showMessageDialog(null, "GlycoWorkbench must be restarted for the new theme to be applied");
                    }
                };
                for (String theme : themes) {
                    JCommandMenuButton button = new JCommandMenuButton(theme, null);
                    button.addActionListener(actionListener);
                    menu.addMenuButton(button);
                }
                return menu;
            }
        });
        band5.addFlowComponent(themeButton);
        return new RibbonTask("View", band1, band2, band4, band3, band5);
    }

    private void updateOrientationButton() {
        EurocarbResizableIcon iconR;
        if (this.orientationButton == null) {
            this.orientationButton = this.getTheActionManager().get("orientation").getJCommandButton(ICON_SIZE.L4, (ActionListener)this, " ");
        }
        if ((iconR = this.getOrientationIcon()) == null) {
            System.err.println("Icon R is null1");
        } else if (iconR.getIconProperties() == null) {
            System.err.println("Icon R is null2");
        } else if (iconR.getIconProperties().id == null) {
            System.err.println("Icon R is null3");
        }
        this.orientationButton.setIcon(iconR.getThemeManager().getResizableIcon(iconR.getIconProperties().id, ICON_SIZE.L4).getResizableIcon());
        try {
            this.getTheActionManager().get("orientation").putValue("SmallIcon", iconR.getThemeManager().getImageIcon(iconR.getIconProperties().id, ICON_SIZE.L3));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private RibbonTask createEditRibbonBand() {
        return this.a_oCommand.createEditRibbonBand(this.getTheActionManager(), this);
    }

    private RibbonTask createGlyTouCanRibbonBand() {
        return this.a_oCommand.createGlyTouCanRibbonBand(this.getTheActionManager(), this);
    }

    private void updateStructureRibbonGallery(String galleryName, JRibbonBand band) {
        GlycanCanvas self = this;
        if (band != null && band.getControlPanel() != null) {
            if (((JBandControlPanel)band.getControlPanel()).getRibbonGallery(galleryName) != null) {
                ((JBandControlPanel)band.getControlPanel()).remove(((JBandControlPanel)band.getControlPanel()).getRibbonGallery(galleryName));
            }
            ICON_SIZE iconSize = ICON_SIZE.L6;
            ArrayList<StringValuePair<List<JCommandToggleButton>>> galleryButtons = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
            for (String superclass : CoreDictionary.getSuperclasses()) {
                Collection<CoreType> core_types = CoreDictionary.getCores(superclass);
                if (core_types.size() <= 0) continue;
                ArrayList<JCommandToggleButtonAction> galleryButtonsList = new ArrayList<JCommandToggleButtonAction>();
                JCommandToggleButtonAction temp = null;
                for (CoreType coreType : core_types) {
                    BufferedImage image = this.getTheGlycanRenderer().getImage(Glycan.fromString(coreType.getStructure()), false, false, false);
                    ImageResizableIconReducedMem imageIcon = new ImageResizableIconReducedMem(image, iconSize.getSize(), iconSize.getSize());
                    imageIcon.minScale(1);
                    String description = coreType.getDescription();
                    description = description.replaceAll("N-glycan", "");
                    description = description.replaceAll("O-glycan", "");
                    JCommandToggleButtonAction button = new JCommandToggleButtonAction(description, imageIcon);
                    button.addActionListener(self);
                    button.setDisplayState(CommandButtonDisplayState.BIG);
                    button.setActionCommand("addstructure=" + coreType.getName());
                    if (description.equals(" bisected fucosylated")) {
                        temp = button;
                        continue;
                    }
                    if (temp != null) {
                        galleryButtonsList.add(button);
                        galleryButtonsList.add(temp);
                        temp = null;
                        continue;
                    }
                    galleryButtonsList.add(button);
                }
                galleryButtons.add(new StringValuePair(superclass, galleryButtonsList));
            }
            HashMap<RibbonElementPriority, Integer> visibleButtonCounts = new HashMap<RibbonElementPriority, Integer>();
            visibleButtonCounts.put(RibbonElementPriority.LOW, 4);
            visibleButtonCounts.put(RibbonElementPriority.MEDIUM, 4);
            visibleButtonCounts.put(RibbonElementPriority.TOP, 4);
            band.addRibbonGallery(galleryName, galleryButtons, visibleButtonCounts, 4, 4, RibbonElementPriority.TOP);
        }
    }

    private void updateInsertResidueRibbonGallery(String galleryName, JRibbonBand band) {
        GlycanCanvas self = this;
        if (band != null && band.getControlPanel() != null) {
            if (((JBandControlPanel)band.getControlPanel()).getRibbonGallery(galleryName) != null) {
                ((JBandControlPanel)band.getControlPanel()).remove(((JBandControlPanel)band.getControlPanel()).getRibbonGallery(galleryName));
            } else {
                this.residueGalleries.get((Object)RESIDUE_INSERT_MODES.INSERT).add(new ResidueGalleryIndex(band, galleryName));
            }
            ICON_SIZE iconSize = ICON_SIZE.L6;
            ArrayList<StringValuePair<List<JCommandToggleButton>>> galleryButtons = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
            for (String superclass : ResidueDictionary.getSuperclasses()) {
                Collection<ResidueType> core_types = ResidueDictionary.getResidues(superclass);
                if (core_types.size() <= 0) continue;
                ArrayList<JCommandToggleButtonAction> galleryButtonsList = new ArrayList<JCommandToggleButtonAction>();
                for (ResidueType t : ResidueDictionary.getResidues(superclass)) {
                    if (!t.canHaveParent() || !t.canHaveChildren()) continue;
                    ImageResizableIconReducedMem icon = new ImageResizableIconReducedMem(this.getGlycanRenderer().getResidueRenderer().getImage(t, iconSize.getSize()), iconSize.getSize(), iconSize.getSize());
                    JCommandToggleButtonAction button = new JCommandToggleButtonAction(t.getName(), icon);
                    button.addActionListener(self);
                    button.setActionCommand("insert=" + t.getName());
                    galleryButtonsList.add(button);
                }
                if (galleryButtonsList.size() <= 0) continue;
                galleryButtons.add(new StringValuePair(superclass, galleryButtonsList));
            }
            HashMap<RibbonElementPriority, Integer> visibleButtonCounts = new HashMap<RibbonElementPriority, Integer>();
            visibleButtonCounts.put(RibbonElementPriority.LOW, 4);
            visibleButtonCounts.put(RibbonElementPriority.MEDIUM, 4);
            visibleButtonCounts.put(RibbonElementPriority.TOP, 4);
            band.addRibbonGallery(galleryName, galleryButtons, visibleButtonCounts, 5, 4, RibbonElementPriority.TOP);
        }
    }

    private void updateChangeResidueRibbonGallery(String galleryName, JRibbonBand band) {
        GlycanCanvas self = this;
        if (band != null && band.getControlPanel() != null) {
            if (((JBandControlPanel)band.getControlPanel()).getRibbonGallery(galleryName) != null) {
                ((JBandControlPanel)band.getControlPanel()).remove(((JBandControlPanel)band.getControlPanel()).getRibbonGallery(galleryName));
            } else {
                this.residueGalleries.get((Object)RESIDUE_INSERT_MODES.REPLACE).add(new ResidueGalleryIndex(band, galleryName));
            }
            ICON_SIZE iconSize = ICON_SIZE.L6;
            ArrayList<StringValuePair<List<JCommandToggleButton>>> galleryButtons = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
            for (String superclass : ResidueDictionary.getSuperclasses()) {
                Collection<ResidueType> core_types = ResidueDictionary.getResidues(superclass);
                if (core_types.size() <= 0) continue;
                ArrayList<JCommandToggleButtonAction> galleryButtonsList = new ArrayList<JCommandToggleButtonAction>();
                for (ResidueType t : ResidueDictionary.getResidues(superclass)) {
                    ImageResizableIconReducedMem icon = new ImageResizableIconReducedMem(this.getGlycanRenderer().getResidueRenderer().getImage(t, iconSize.getSize()), iconSize.getSize(), iconSize.getSize());
                    JCommandToggleButtonAction button = new JCommandToggleButtonAction(t.getName(), icon);
                    button.addActionListener(self);
                    button.setActionCommand("change=" + t.getName());
                    galleryButtonsList.add(button);
                }
                if (galleryButtonsList.size() <= 0) continue;
                galleryButtons.add(new StringValuePair(superclass, galleryButtonsList));
            }
            HashMap<RibbonElementPriority, Integer> visibleButtonCounts = new HashMap<RibbonElementPriority, Integer>();
            visibleButtonCounts.put(RibbonElementPriority.LOW, 4);
            visibleButtonCounts.put(RibbonElementPriority.MEDIUM, 4);
            visibleButtonCounts.put(RibbonElementPriority.TOP, 4);
            band.addRibbonGallery(galleryName, galleryButtons, visibleButtonCounts, 5, 4, RibbonElementPriority.TOP);
        }
    }

    private void updateAddResidueRibbonGallery(String galleryName, JRibbonBand band) {
        GlycanCanvas self = this;
        if (band != null && band.getControlPanel() != null) {
            if (((JBandControlPanel)band.getControlPanel()).getRibbonGallery(galleryName) != null) {
                ((JBandControlPanel)band.getControlPanel()).remove(((JBandControlPanel)band.getControlPanel()).getRibbonGallery(galleryName));
            } else {
                this.residueGalleries.get((Object)RESIDUE_INSERT_MODES.ADD).add(new ResidueGalleryIndex(band, galleryName));
            }
            ICON_SIZE iconSize = ICON_SIZE.L6;
            ArrayList<StringValuePair<List<JCommandToggleButton>>> galleryButtons = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
            for (String superclass : ResidueDictionary.getSuperclasses()) {
                Collection<ResidueType> core_types = ResidueDictionary.getResidues(superclass);
                if (core_types.size() <= 0) continue;
                ArrayList<JCommandToggleButtonAction> galleryButtonsList = new ArrayList<JCommandToggleButtonAction>();
                for (ResidueType t : ResidueDictionary.getResidues(superclass)) {
                    if (!t.canHaveParent()) continue;
                    ImageResizableIconReducedMem icon = new ImageResizableIconReducedMem(this.getGlycanRenderer().getResidueRenderer().getImage(t, iconSize.getSize()), iconSize.getSize(), iconSize.getSize());
                    JCommandToggleButtonAction button = new JCommandToggleButtonAction(t.getName(), icon);
                    button.addActionListener(self);
                    button.setActionCommand("add=" + t.getName());
                    galleryButtonsList.add(button);
                }
                if (galleryButtonsList.size() <= 0) continue;
                galleryButtons.add(new StringValuePair(superclass, galleryButtonsList));
            }
            HashMap<RibbonElementPriority, Integer> visibleButtonCounts = new HashMap<RibbonElementPriority, Integer>();
            visibleButtonCounts.put(RibbonElementPriority.LOW, 4);
            visibleButtonCounts.put(RibbonElementPriority.MEDIUM, 4);
            visibleButtonCounts.put(RibbonElementPriority.TOP, 4);
            band.addRibbonGallery(galleryName, galleryButtons, visibleButtonCounts, 5, 4, RibbonElementPriority.TOP);
        }
    }

    private HashMap<TerminalType, ImageResizableIconReducedMem> getCachedTerminalImages() {
        HashMap<TerminalType, ImageResizableIconReducedMem> map = new HashMap<TerminalType, ImageResizableIconReducedMem>();
        ICON_SIZE iconSize = ICON_SIZE.L6;
        for (String superclass : TerminalDictionary.getSuperclasses()) {
            Collection<TerminalType> terminal_types = TerminalDictionary.getTerminals(superclass);
            if (terminal_types.size() <= 0) continue;
            for (TerminalType terminalType : terminal_types) {
                ArrayList galleryButtonsList = new ArrayList();
                ImageResizableIconReducedMem imageIcon = new ImageResizableIconReducedMem(this.getGlycanRenderer().getImage(Glycan.fromString(terminalType.getStructure()), false, false, false), iconSize.getSize(), iconSize.getSize());
                imageIcon.minScale(1);
                map.put(terminalType, imageIcon);
            }
        }
        return map;
    }

    private void updateTerminalRibbonGallery(String galleryName, JRibbonBand band, HashMap<TerminalType, ImageResizableIconReducedMem> map) {
        GlycanCanvas self = this;
        if (band != null && band.getControlPanel() != null) {
            if (((JBandControlPanel)band.getControlPanel()).getRibbonGallery(galleryName) != null) {
                ((JBandControlPanel)band.getControlPanel()).remove(((JBandControlPanel)band.getControlPanel()).getRibbonGallery(galleryName));
            } else {
                this.residueGalleries.get((Object)RESIDUE_INSERT_MODES.TERMINAL).add(new ResidueGalleryIndex(band, galleryName));
            }
            ICON_SIZE iconSize = ICON_SIZE.L6;
            ArrayList<StringValuePair<List<JCommandToggleButton>>> galleryButtons = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
            for (String superclass : TerminalDictionary.getSuperclasses()) {
                Collection<TerminalType> terminal_types = TerminalDictionary.getTerminals(superclass);
                if (terminal_types.size() <= 0) continue;
                for (TerminalType terminalType : terminal_types) {
                    ArrayList<JCommandToggleButtonAction> galleryButtonsList = new ArrayList<JCommandToggleButtonAction>();
                    ImageResizableIconReducedMem imageIcon = map.get(terminalType);
                    JCommandToggleButtonAction button1 = new JCommandToggleButtonAction("x-linked", imageIcon);
                    button1.addActionListener(self);
                    button1.setActionCommand("addterminal=" + terminalType.getName());
                    galleryButtonsList.add(button1);
                    for (int l = 1; l < 9; ++l) {
                        JCommandToggleButtonAction button = new JCommandToggleButtonAction(l + "-linked", imageIcon);
                        button.addActionListener(self);
                        button.setActionCommand("addterminal=" + l + "-" + terminalType.getName());
                        galleryButtonsList.add(button);
                    }
                    galleryButtons.add(new StringValuePair(superclass + "[" + terminalType.getDescription() + "]", galleryButtonsList));
                }
            }
            HashMap<RibbonElementPriority, Integer> visibleButtonCounts = new HashMap<RibbonElementPriority, Integer>();
            visibleButtonCounts.put(RibbonElementPriority.LOW, 3);
            visibleButtonCounts.put(RibbonElementPriority.MEDIUM, 3);
            visibleButtonCounts.put(RibbonElementPriority.TOP, 3);
            band.addRibbonGallery(galleryName, galleryButtons, visibleButtonCounts, 3, 3, RibbonElementPriority.TOP);
        }
    }

    private void updateTerminalRibbonGallery(final String galleryName, final JRibbonBand band) {
        boolean updating = false;
        if (band != null && band.getControlPanel() != null && ((JBandControlPanel)band.getControlPanel()).getRibbonGallery(galleryName) != null) {
            updating = true;
        }
        if (updating) {
            SwingWorker worker = new SwingWorker(){
                protected HashMap<TerminalType, ImageResizableIconReducedMem> map;

                protected Object doInBackground() throws Exception {
                    this.map = GlycanCanvas.this.getCachedTerminalImages();
                    return null;
                }

                @Override
                protected void done() {
                    GlycanCanvas.this.updateTerminalRibbonGallery(galleryName, band, this.map);
                }
            };
            worker.execute();
        } else {
            this.updateTerminalRibbonGallery(galleryName, band, this.getCachedTerminalImages());
        }
    }

    private JMenu createDebugMenu() {
        return this.a_oCommand.createDebugMenu(this.getTheActionManager());
    }

    public JRibbonBand createStructureRibbonBand() {
        this.structureSelectionBand = new JRibbonBand(this.STRUCTURE_GALLERY_NAME, new EmptyResizableIcon(10));
        ArrayList<RibbonBandResizePolicy> resizePolicies = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)this.structureSelectionBand.getControlPanel()));
        resizePolicies.add(new CoreRibbonResizePolicies.Mid2Low((JBandControlPanel)this.structureSelectionBand.getControlPanel()));
        resizePolicies.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)this.structureSelectionBand.getControlPanel()));
        this.structureSelectionBand.setResizePolicies(resizePolicies);
        this.updateStructureRibbonGallery(this.STRUCTURE_GALLERY_NAME, this.structureSelectionBand);
        this.structureSelectionBand.addCommandButton(this.getTheActionManager().get("write").getJCommandButton(ICON_SIZE.L3, "Write", this, new RichTooltip(" ", "Import structure from string")), RibbonElementPriority.TOP);
        this.structureSelectionBand.addCommandButton(this.getTheActionManager().get("addcomposition").getJCommandButton(ICON_SIZE.L3, "Create composition", this, new RichTooltip("Open", " ")), RibbonElementPriority.TOP);
        return this.structureSelectionBand;
    }

    private RibbonTask createStructureRibbonTask() {
        this.structureRibbonBandSNFG = this.createStructureRibbonBand();
        JRibbonBand band1 = this.createAddResidueBand();
        RibbonTask task = new RibbonTask("Structure", this.structureRibbonBandSNFG, band1, this.createAddTerminalRibbon());
        return task;
    }

    private JRibbonBand createStructureRibbonControls() {
        JRibbonBand band = new JRibbonBand("Edit glycan", new EmptyResizableIcon(10));
        ThemeManager.setDefaultResizePolicy(band);
        band.addCommandButton(this.getTheActionManager().get("bracket").getJCommandButton(ICON_SIZE.L3, "Bracket", this, new RichTooltip("Add bracket ", "Insert bracket")), RibbonElementPriority.TOP);
        band.addCommandButton(this.getTheActionManager().get("repeat").getJCommandButton(ICON_SIZE.L3, "Repeat", this, new RichTooltip("Add repeat", "Add repeat unit")), RibbonElementPriority.TOP);
        band.addCommandButton(this.getTheActionManager().get("cyclic").getJCommandButton(ICON_SIZE.L3, "Cyclic", this, new RichTooltip("Add cyclic", "Add cyclic unit")), RibbonElementPriority.TOP);
        band.addCommandButton(this.getTheActionManager().get("moveccw").getJCommandButton(ICON_SIZE.L3, "Rotate CCW", this, new RichTooltip("Rotate residue", "Rotate residue counter-clockwise")), RibbonElementPriority.TOP);
        band.addCommandButton(this.getTheActionManager().get("movecw").getJCommandButton(ICON_SIZE.L3, "Rotate CW", this, new RichTooltip("Rotate residue", "Rotate residue clockwise")), RibbonElementPriority.TOP);
        band.addCommandButton(this.getTheActionManager().get("properties").getJCommandButton(ICON_SIZE.L3, "Properties", this, new RichTooltip("Residue Properties", "Get residue properties")), RibbonElementPriority.TOP);
        band.addCommandButton(this.getTheActionManager().get("massoptstruct").getJCommandButton(ICON_SIZE.L3, "Mass options", this, new RichTooltip("Mass options", "Mass options of selected structure")), RibbonElementPriority.TOP);
        return band;
    }

    private JRibbonBand createAddTerminalRibbon() {
        this.terminalRibbonBand = new JRibbonBand("Add Terminal", new EmptyResizableIcon(10));
        ArrayList<RibbonBandResizePolicy> resizePolicies = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)this.terminalRibbonBand.getControlPanel()));
        resizePolicies.add(new CoreRibbonResizePolicies.Mid2Low((JBandControlPanel)this.terminalRibbonBand.getControlPanel()));
        resizePolicies.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)this.terminalRibbonBand.getControlPanel()));
        this.terminalRibbonBand.setResizePolicies(resizePolicies);
        this.updateTerminalRibbonGallery(this.TERMINAL_GAL_NAME, this.terminalRibbonBand);
        return this.terminalRibbonBand;
    }

    private JRibbonBand createAddResidueBand() {
        GlycanCanvas self = this;
        this.insertResidueJRibbonBand = new JRibbonBand("Add residue", new EmptyResizableIcon(10));
        ArrayList<RibbonBandResizePolicy> resizePolicies = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)this.insertResidueJRibbonBand.getControlPanel()));
        resizePolicies.add(new CoreRibbonResizePolicies.Mid2Low((JBandControlPanel)this.insertResidueJRibbonBand.getControlPanel()));
        resizePolicies.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)this.insertResidueJRibbonBand.getControlPanel()));
        this.insertResidueJRibbonBand.setResizePolicies(resizePolicies);
        this.updateAddResidueRibbonGallery(this.RESIDUE_GALLERY_NAME, this.insertResidueJRibbonBand);
        return this.insertResidueJRibbonBand;
    }

    private JMenu createEditMenu() {
        return this.a_oCommand.createEditMenu(this.getTheActionManager());
    }

    private JMenu createStructureMenu() {
        JMenu structure_menu = new JMenu("Structure");
        structure_menu.setMnemonic(83);
        structure_menu.add(this.getTheActionManager().get("addcomposition"));
        structure_menu.add(this.getTheActionManager().get("addstructurestr"));
        structure_menu.add(this.getTheActionManager().get("getstructurestr"));
        structure_menu.add(this.createAddStructureMenu());
        structure_menu.addSeparator();
        structure_menu.add(this.createAddResidueMenu());
        structure_menu.add(this.createAddTerminalMenu());
        structure_menu.add(this.createInsertResidueMenu());
        structure_menu.add(this.createChangeResidueTypeMenu());
        structure_menu.add(this.createInsertBridgeMenu());
        this.bracketMenuItem = structure_menu.add(this.getTheActionManager().get("bracket"));
        this.repeatMenuItem = structure_menu.add(this.getTheActionManager().get("repeat"));
        this.antennaParentItem = structure_menu.add(this.getTheActionManager().get("antennaParent"));
        this.cyclicMenuItem = structure_menu.add(this.getTheActionManager().get("cyclic"));
        structure_menu.addSeparator();
        structure_menu.add(this.getTheActionManager().get("properties"));
        structure_menu.add(this.a_oCommand.createChangeReducingEndMenu(this.getTheActionManager()));
        structure_menu.add(this.getTheActionManager().get("massoptstruct"));
        structure_menu.addSeparator();
        structure_menu.add(this.getTheActionManager().get("moveccw"));
        structure_menu.add(this.getTheActionManager().get("movecw"));
        return structure_menu;
    }

    public JPopupMenu createPopupMenu() {
        return this.createPopupMenu(true);
    }

    public JPopupMenu createPopupMenu(boolean change_properties) {
        StringBuffer buf = new StringBuffer();
        if (!this.hasCurrentSelection()) {
            buf.append("0");
        } else {
            buf.append("1");
        }
        if (!this.hasCurrentLinkage()) {
            buf.append("0");
        } else {
            buf.append("1");
        }
        if (this.hasCurrentResidue()) {
            buf.append("1");
        } else {
            buf.append("0");
        }
        if (change_properties) {
            buf.append("1");
        } else {
            buf.append("0");
        }
        if (this.hasCurrentSelection()) {
            buf.append("1");
        } else {
            buf.append("0");
        }
        String key = buf.toString();
        if (this.cachedMenus.containsKey(key)) {
            return this.cachedMenus.get(key);
        }
        JPopupMenu menu = new JPopupMenu();
        menu.setDoubleBuffered(true);
        menu.add(this.getTheActionManager().get("cut"));
        menu.add(this.getTheActionManager().get("copy"));
        menu.add(this.getTheActionManager().get("paste"));
        menu.add(this.getTheActionManager().get("delete"));
        menu.addSeparator();
        if (!this.hasCurrentSelection()) {
            menu.add(this.getTheActionManager().get("addcomposition"));
            menu.add(this.createAddStructureMenu());
        }
        if (!this.hasCurrentLinkage()) {
            if (this.addResidueMenu == null) {
                this.addResidueMenu = this.createAddResidueMenu();
            }
            menu.add(this.addResidueMenu);
        }
        if (this.hasCurrentResidue()) {
            if (this.insertResidueMenu == null) {
                this.insertResidueMenu = this.createInsertResidueMenu();
            }
            menu.add(this.insertResidueMenu);
            if (this.changeResidueMenu == null) {
                this.changeResidueMenu = this.createChangeResidueTypeMenu();
            }
            menu.add(this.changeResidueMenu);
        }
        if (this.hasCurrentSelection()) {
            menu.addSeparator();
            menu.add(this.getTheActionManager().get("moveccw"));
            menu.add(this.getTheActionManager().get("movecw"));
        }
        this.cachedMenus.put(key, menu);
        return menu;
    }

    private JToolBar createToolBarDocument() {
        return this.a_oCommand.createToolBarDocument(this.getTheActionManager());
    }

    private JToolBar createToolBarStructure() {
        JToolBar toolbar = new JToolBar(){

            @Override
            public Dimension getPreferredSize() {
                int width = this.getParent().getWidth();
                int maxHeight = Integer.MIN_VALUE;
                int runningWidth = 0;
                for (Component component : this.getComponents()) {
                    if (component.getHeight() > maxHeight) {
                        maxHeight = component.getHeight();
                    }
                    runningWidth += component.getWidth() + 5;
                }
                if (width > 0) {
                    int rows = runningWidth / width;
                    if (runningWidth % width > 0) {
                        ++rows;
                    }
                    return new Dimension(width, rows * maxHeight + rows * 6);
                }
                return super.getPreferredSize();
            }
        };
        toolbar.setLayout(new FlowLayout(0));
        toolbar.setVisible(true);
        toolbar.setFloatable(false);
        for (ResidueType t : ResidueDictionary.directResidues()) {
            if (!t.canHaveParent()) continue;
            toolbar.add(this.getTheActionManager().get("add=" + t.getName()));
        }
        toolbar.addSeparator();
        this.recent_residues_index = toolbar.getComponentCount();
        this.no_recent_residues_buttons = 0;
        this.updateRecentResiduesToolbar(toolbar);
        toolbar.addSeparator();
        this.bracketButton = toolbar.add(this.getTheActionManager().get("bracket"));
        this.repeatButton = toolbar.add(this.getTheActionManager().get("repeat"));
        this.cyclicButton = toolbar.add(this.getTheActionManager().get("cyclic"));
        this.antennaParentButton = toolbar.add(this.getTheActionManager().get("antennaParent"));
        toolbar.addSeparator();
        toolbar.add(this.getTheActionManager().get("moveccw"));
        toolbar.add(this.getTheActionManager().get("movecw"));
        toolbar.addSeparator();
        toolbar.add(this.getTheActionManager().get("orientation"));
        return toolbar;
    }

    private JLabel createLabel(String text, int margin) {
        JLabel ret = new JLabel(text);
        ret.setBorder(new EmptyBorder(0, margin, 0, margin));
        return ret;
    }

    private JToolBar createToolBarProperties() {
        JToolBar toolbar = new JToolBar(){

            @Override
            public Dimension getPreferredSize() {
                int width = this.getParent().getWidth();
                int maxHeight = Integer.MIN_VALUE;
                int runningWidth = 0;
                for (Component component : this.getComponents()) {
                    if (component.getHeight() > maxHeight) {
                        maxHeight = component.getHeight();
                    }
                    runningWidth += component.getWidth() + 6;
                }
                if (width > 0) {
                    int rows = runningWidth / width;
                    if (runningWidth % width > 0) {
                        ++rows;
                    }
                    return new Dimension(width, rows * maxHeight + rows * 6);
                }
                return super.getPreferredSize();
            }
        };
        toolbar.setFloatable(false);
        toolbar.setLayout(new FlowLayout(0){});
        toolbar.add(this.createLabel("Linkage", 5));
        this.field_anomeric_state = new JComboBox<String>(new String[]{"?", "a", "b"});
        toolbar.add(this.field_anomeric_state);
        this.field_anomeric_carbon = new JComboBox<String>(new String[]{"?", "1", "2", "3"});
        toolbar.add(this.field_anomeric_carbon);
        toolbar.add(this.createLabel("->", 1));
        this.field_linkage_position = new DropDownList(new String[]{"?", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
        toolbar.add(this.field_linkage_position);
        toolbar.add(this.createLabel("Chirality", 5));
        this.field_chirality = new JComboBox<String>(new String[]{"?", "D", "L"});
        toolbar.add(this.field_chirality);
        toolbar.add(this.createLabel("Ring", 5));
        this.field_ring_size = new JComboBox<String>(new String[]{"?", "p", "f", "o"});
        toolbar.add(this.field_ring_size);
        toolbar.add(this.createLabel("2nd bond", 5));
        this.field_second_bond = new JCheckBox("");
        toolbar.add(this.field_second_bond);
        this.field_second_child_position = new JComboBox<String>(new String[]{"?", "1", "2", "3"});
        toolbar.add(this.field_second_child_position);
        toolbar.add(this.createLabel("->", 1));
        this.field_second_parent_position = new DropDownList(new String[]{"?", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
        toolbar.add(this.field_second_parent_position);
        this.field_anomeric_state.setActionCommand("setproperties");
        this.field_anomeric_carbon.setActionCommand("setproperties");
        this.field_linkage_position.setActionCommand("setproperties");
        this.field_chirality.setActionCommand("setproperties");
        this.field_ring_size.setActionCommand("setproperties");
        this.field_second_bond.setActionCommand("setproperties");
        this.field_second_child_position.setActionCommand("setproperties");
        this.field_second_parent_position.setActionCommand("setproperties");
        this.field_anomeric_state.addActionListener(this);
        this.field_anomeric_carbon.addActionListener(this);
        this.field_linkage_position.addActionListener(this);
        this.field_chirality.addActionListener(this);
        this.field_ring_size.addActionListener(this);
        this.field_second_bond.addActionListener(this);
        this.field_second_child_position.addActionListener(this);
        this.field_second_parent_position.addActionListener(this);
        return toolbar;
    }

    private RibbonContextualTaskGroup createLinkageRibbon() {
        JFlowRibbonBand band1 = new JFlowRibbonBand("Linkage specification", new EmptyResizableIcon(10));
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setLayout(new FlowLayout(0));
        toolbar.add(this.createLabel("Linkage", 5));
        this.field_anomeric_state_r = new JComboBox<String>(new String[]{"?", "a", "b", "o"});
        toolbar.add(this.field_anomeric_state_r);
        this.field_anomeric_carbon_r = new JComboBox<String>(new String[]{"?", "1", "2", "3"});
        toolbar.add(this.field_anomeric_carbon_r);
        toolbar.add(this.createLabel("->", 1));
        this.field_linkage_position_r = new DropDownList(new String[]{"?", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
        toolbar.add(this.field_linkage_position_r);
        toolbar.add(this.createLabel("Chirality", 5));
        this.field_chirality_r = new JComboBox<String>(new String[]{"?", "D", "L"});
        toolbar.add(this.field_chirality_r);
        toolbar.add(this.createLabel("Ring", 5));
        this.field_ring_size_r = new JComboBox<String>(new String[]{"?", "p", "f", "o"});
        toolbar.add(this.field_ring_size_r);
        toolbar.add(this.createLabel("2nd bond", 5));
        this.field_second_bond_r = new JCheckBox("");
        toolbar.add(this.field_second_bond_r);
        this.field_second_child_position_r = new JComboBox<String>(new String[]{"?", "1", "2", "3"});
        toolbar.add(this.field_second_child_position_r);
        toolbar.add(this.createLabel("->", 1));
        this.field_second_parent_position_r = new DropDownList(new String[]{"?", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
        toolbar.add(this.field_second_parent_position_r);
        this.field_anomeric_state_r.setActionCommand("setproperties_r");
        this.field_anomeric_carbon_r.setActionCommand("setproperties_r");
        this.field_linkage_position_r.setActionCommand("setproperties_r");
        this.field_chirality_r.setActionCommand("setproperties_r");
        this.field_ring_size_r.setActionCommand("setproperties_r");
        this.field_second_bond_r.setActionCommand("setproperties_r");
        this.field_second_child_position_r.setActionCommand("setproperties_r");
        this.field_second_parent_position_r.setActionCommand("setproperties_r");
        this.field_anomeric_state_r.addActionListener(this);
        this.field_anomeric_carbon_r.addActionListener(this);
        this.field_linkage_position_r.addActionListener(this);
        this.field_chirality_r.addActionListener(this);
        this.field_ring_size_r.addActionListener(this);
        this.field_second_bond_r.addActionListener(this);
        this.field_second_child_position_r.addActionListener(this);
        this.field_second_parent_position_r.addActionListener(this);
        band1.addFlowComponent(toolbar);
        JRibbonBand band2 = new JRibbonBand("Insert residue", new EmptyResizableIcon(10));
        this.updateInsertResidueRibbonGallery("Insert residue", band2);
        JRibbonBand band3 = new JRibbonBand("Add residue", new EmptyResizableIcon(10));
        this.updateAddResidueRibbonGallery("Add residue", band3);
        JRibbonBand band4 = new JRibbonBand("Change residue", new EmptyResizableIcon(10));
        this.updateChangeResidueRibbonGallery("Change residue", band4);
        RibbonTask task1 = new RibbonTask("Linkage specification", band1);
        return new RibbonContextualTaskGroup("Residue options", Color.GREEN, new RibbonTask("Residue input", band2, band3, band4), task1);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getTheGlycanRenderer().computeSize(this.all_structures_bbox);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public PositionManager getPositionManager() {
        return this.thePosManager;
    }

    public void getScreenshot() {
        ClipUtils.setContents(new GlycanSelection(this.getTheGlycanRenderer(), this.theDoc.getStructures()));
    }

    public LinkedList<Glycan> getGlycans() {
        return this.theDoc.getStructures();
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void copy() {
        LinkedList<Glycan> sel = this.theDoc.extractView(this.selected_residues);
        ClipUtils.setContents(new GlycanSelection(this.getTheGlycanRenderer(), sel));
    }

    public void copySelectedStructures() {
        ClipUtils.setContents(new GlycanSelection(this.getTheGlycanRenderer(), this.getSelectedStructures()));
    }

    public void copyAllStructures() {
        ClipUtils.setContents(new GlycanSelection(this.getTheGlycanRenderer(), this.theDoc.getStructures()));
    }

    public void paste() {
        try {
            Transferable t = ClipUtils.getContents();
            if (t != null && t.isDataFlavorSupported(GlycanSelection.glycoFlavor)) {
                String content = TextUtils.consume((InputStream)t.getTransferData(GlycanSelection.glycoFlavor));
                this.theDoc.addStructures(this.current_residue, this.theDoc.parseString(content));
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void delete() {
        Residue new_current = this.current_residue != null ? this.current_residue.getParent() : null;
        this.theDoc.removeResidues(this.selected_residues);
        if (this.theDoc.contains(new_current)) {
            this.setSelection(new_current, false);
        }
    }

    public void copyTo(Residue position) {
        this.theDoc.copyResidues(position, this.theBBoxManager.getLinkedResidues(position), this.selected_residues);
    }

    public void moveTo(Residue position) {
        this.theDoc.moveResidues(position, this.theBBoxManager.getLinkedResidues(position), this.selected_residues);
    }

    private void xorRectangle(Point start_point, Point end_point) {
        Graphics g = this.getGraphics();
        g.setXORMode(Color.white);
        g.setColor(Color.black);
        Rectangle rect = Geometry.makeRectangle(start_point, end_point);
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isOnBorder(Residue r) {
        return this.thePosManager.isOnBorder(r);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clipRect = new Rectangle();
        g.getClipBounds(clipRect);
        this.getTheGlycanRenderer().getGraphicOptions().setScale(this.getTheGlycanRenderer().getGraphicOptions().SCALE_CANVAS);
        boolean show_masses = this.is_printing ? this.getTheGlycanRenderer().getGraphicOptions().SHOW_MASSES : this.getTheGlycanRenderer().getGraphicOptions().SHOW_MASSES_CANVAS;
        boolean show_redend = this.is_printing ? this.getTheGlycanRenderer().getGraphicOptions().SHOW_REDEND : this.getTheGlycanRenderer().getGraphicOptions().SHOW_REDEND_CANVAS;
        this.all_structures_bbox = this.getTheGlycanRenderer().computeBoundingBoxes(this.theDoc.getStructures(), show_masses, show_redend, this.thePosManager, this.theBBoxManager);
        for (Glycan s : this.theDoc.getStructures()) {
            this.getTheGlycanRenderer().paint(new DefaultPaintable(g2d), s, this.selected_residues, this.selected_linkages, show_masses, show_redend, this.thePosManager, this.theBBoxManager);
        }
        if (!this.is_printing) {
            this.paintSelection(g2d, show_redend);
        }
        if (this.respondToDocumentChange) {
            this.respondToDocumentChange = false;
            this.revalidate();
        }
        g2d.dispose();
        this.getTheGlycanRenderer().getGraphicOptions().setScale(this.getTheGlycanRenderer().getGraphicOptions().SCALE);
    }

    private void paintSelection(Graphics2D g2d, boolean show_redend) {
        Rectangle cur_bbox;
        GraphicOptions theGraphicOptions = this.getTheGlycanRenderer().getGraphicOptions();
        Collection<Glycan> sel_structures = this.theDoc.findStructuresWith(this.selected_residues, this.selected_linkages);
        Glycan cur_structure = this.getCurrentStructure();
        Iterator i = this.theDoc.getStructures().iterator();
        while (i.hasNext()) {
            Glycan t;
            Glycan s = (Glycan)i.next();
            if (!sel_structures.contains(s)) continue;
            Rectangle bbox = this.theBBoxManager.getBBox(s, show_redend);
            while (i.hasNext() && sel_structures.contains(t = (Glycan)i.next())) {
                bbox = Geometry.union(bbox, this.theBBoxManager.getBBox(t, show_redend));
            }
            if (bbox == null) continue;
            g2d.setColor(UIManager.getColor("Table.selectionBackground"));
            g2d.fill(new Rectangle(theGraphicOptions.MARGIN_LEFT / 2 - 3, bbox.y, 5, bbox.height + theGraphicOptions.MASS_TEXT_SPACE + theGraphicOptions.MASS_TEXT_SIZE));
        }
        if (cur_structure != null && (cur_bbox = this.theBBoxManager.getBBox(cur_structure, show_redend)) != null) {
            UIManager.getBorder("Table.focusCellHighlightBorder").paintBorder(this.sel_label, g2d, theGraphicOptions.MARGIN_LEFT / 2 - 3, cur_bbox.y, 5, cur_bbox.height + theGraphicOptions.MASS_TEXT_SPACE + theGraphicOptions.MASS_TEXT_SIZE);
        }
    }

    public Residue getResidueAtPoint(Point p) {
        for (Glycan g : this.theDoc.getStructures()) {
            Residue ret = this.getResidueAtPoint(g.getRoot(), p);
            if (ret != null) {
                return ret;
            }
            ret = this.getResidueAtPoint(g.getBracket(), p);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public Residue getResidueAtPoint(Residue r, Point p) {
        if (r == null) {
            return null;
        }
        Rectangle cur_bbox = this.theBBoxManager.getCurrent(r);
        if (cur_bbox != null && cur_bbox.contains(p)) {
            return r;
        }
        for (Linkage l : r.getChildrenLinkages()) {
            Residue ret = this.getResidueAtPoint(l.getChildResidue(), p);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public Linkage getLinkageAtPoint(Point p) {
        for (Glycan g : this.theDoc.getStructures()) {
            Linkage ret = this.getLinkageAtPoint(g.getRoot(), p);
            if (ret != null) {
                return ret;
            }
            ret = this.getLinkageAtPoint(g.getBracket(), p);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public Linkage getLinkageAtPoint(Residue r, Point p) {
        if (r == null) {
            return null;
        }
        Rectangle cur_bbox = this.theBBoxManager.getCurrent(r);
        for (Linkage l : r.getChildrenLinkages()) {
            Rectangle child_bbox = this.theBBoxManager.getCurrent(l.getChildResidue());
            if (cur_bbox != null && child_bbox != null && Geometry.distance(p, Geometry.center(cur_bbox), Geometry.center(child_bbox)) < 4.0) {
                return l;
            }
            Linkage ret = this.getLinkageAtPoint(l.getChildResidue(), p);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean hasSelection() {
        return this.selected_residues.size() > 0 || this.selected_linkages.size() > 0;
    }

    public void resetSelection() {
        this.selected_residues.clear();
        this.selected_linkages.clear();
        this.current_residue = null;
        this.current_linkage = null;
        this.fireUpdatedSelection(true);
    }

    public boolean hasCurrentSelection() {
        return this.current_residue != null || this.current_linkage != null;
    }

    public Residue getCurrentSelection() {
        if (this.current_residue != null) {
            return this.current_residue;
        }
        if (this.current_linkage != null) {
            return this.current_linkage.getChildResidue();
        }
        return null;
    }

    public Glycan getCurrentStructure() {
        if (this.current_residue != null) {
            return this.theDoc.findStructureWith(this.current_residue);
        }
        if (this.current_linkage != null) {
            return this.theDoc.findStructureWith(this.current_linkage.getChildResidue());
        }
        return null;
    }

    public Collection<Glycan> getSelectedStructures() {
        return this.theDoc.findStructuresWith(this.selected_residues, this.selected_linkages);
    }

    public boolean hasCurrentResidue() {
        return this.current_residue != null;
    }

    public boolean isCurrentResidueCer() {
        return this.hasCurrentResidue() && this.current_residue.getResidueName().equalsIgnoreCase("Cer");
    }

    public Residue getCurrentResidue() {
        return this.current_residue;
    }

    public ArrayList<Residue> getLinkedResidues() {
        return this.theBBoxManager.getLinkedResidues(this.current_residue);
    }

    private void setCurrentResidue(Residue node) {
        if (node != null) {
            this.selected_residues.add(node);
        }
        this.selected_linkages.clear();
        this.current_residue = node;
        this.current_linkage = null;
        this.fireUpdatedSelection(false);
    }

    public boolean hasCurrentLinkage() {
        return this.current_linkage != null;
    }

    public Linkage getCurrentLinkage() {
        return this.current_linkage;
    }

    public boolean isSelected(Residue node) {
        if (node == null) {
            return false;
        }
        return this.selected_residues.contains(node);
    }

    public boolean isSelected(Linkage link) {
        if (link == null) {
            return false;
        }
        return this.selected_linkages.contains(link);
    }

    public boolean hasSelectedResidues() {
        return !this.selected_residues.isEmpty();
    }

    public boolean hasSelectedLinkages() {
        return !this.selected_linkages.isEmpty();
    }

    public Collection<Residue> getSelectedResiduesList() {
        return this.selected_residues;
    }

    public Residue[] getSelectedResidues() {
        return this.selected_residues.toArray(new Residue[0]);
    }

    public void setSelection(Collection<Residue> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            this.resetSelection();
        } else {
            this.selected_residues.clear();
            this.selected_linkages.clear();
            this.current_residue = null;
            this.current_linkage = null;
            for (Residue node : nodes) {
                this.selected_residues.add(node);
                this.selected_residues.addAll(this.theBBoxManager.getLinkedResidues(node));
            }
            this.fireUpdatedSelection(false);
        }
    }

    public void setSelection(Residue node) {
        this.setSelection(node, false);
    }

    public void setSelection(Residue node, boolean showResidueControls) {
        if (node == null) {
            this.resetSelection();
        } else {
            this.selected_residues.clear();
            this.selected_linkages.clear();
            this.selected_residues.add(node);
            this.selected_residues.addAll(this.theBBoxManager.getLinkedResidues(node));
            this.current_residue = node;
            this.current_linkage = null;
            this.fireUpdatedSelection(showResidueControls);
        }
    }

    public void setSelection(Linkage link) {
        this.setSelection(link, false);
    }

    public void setSelection(Linkage link, boolean showResidueControls) {
        if (link == null) {
            this.resetSelection();
        } else {
            this.selected_residues.clear();
            this.selected_linkages.clear();
            this.selected_linkages.add(link);
            this.current_residue = null;
            this.current_linkage = link;
            this.fireUpdatedSelection(showResidueControls);
        }
    }

    public void enforceSelection(Point p) {
        Residue r = this.getResidueAtPoint(p);
        if (r != null) {
            this.enforceSelection(r);
        } else {
            Linkage l = this.getLinkageAtPoint(p);
            if (l != null) {
                this.enforceSelection(l);
            } else {
                this.resetSelection();
            }
        }
    }

    public void enforceSelection(Residue node) {
        if (this.isSelected(node)) {
            this.current_residue = node;
            this.fireUpdatedSelection(false);
        } else {
            this.setSelection(node);
        }
    }

    public void enforceSelection(Linkage link) {
        if (this.isSelected(link)) {
            this.current_linkage = link;
            this.fireUpdatedSelection(false);
        } else {
            this.setSelection(link);
        }
    }

    public boolean enforceSelection() {
        if (!this.hasCurrentSelection()) {
            if (this.theDoc.getNoStructures() == 0) {
                return false;
            }
            if (this.theDoc.getFirstStructure().getRoot() == null) {
                return false;
            }
            this.setSelection(this.theDoc.getFirstStructure().getRoot());
        }
        return true;
    }

    public void addSelection(Collection<Residue> nodes) {
        if (nodes != null) {
            for (Residue node : nodes) {
                this.selected_residues.add(node);
                this.selected_residues.addAll(this.theBBoxManager.getLinkedResidues(node));
            }
            this.selected_linkages.clear();
            this.current_residue = null;
            this.current_linkage = null;
            this.fireUpdatedSelection(false);
        }
    }

    public void addSelection(Residue node) {
        if (node != null) {
            this.selected_residues.add(node);
            this.selected_residues.addAll(this.theBBoxManager.getLinkedResidues(node));
            this.selected_linkages.clear();
            this.current_residue = node;
            this.current_linkage = null;
            this.fireUpdatedSelection(false);
            this.respondToDocumentChange = true;
            this.repaint();
        }
    }

    public void addSelectionPathTo(Residue node) {
        if (node != null) {
            if (this.current_residue == null) {
                this.selected_residues.add(node);
                this.selected_residues.addAll(this.theBBoxManager.getLinkedResidues(node));
            } else {
                for (Residue r : Glycan.getPath(this.current_residue, node)) {
                    this.selected_residues.add(r);
                    this.selected_residues.addAll(this.theBBoxManager.getLinkedResidues(node));
                }
            }
            this.selected_linkages.clear();
            this.current_residue = node;
            this.current_linkage = null;
            this.fireUpdatedSelection(false);
        }
    }

    public void selectStructure() {
        this.selected_linkages.clear();
        this.selected_residues.clear();
        Glycan s = this.getCurrentStructure();
        if (s != null) {
            this.selectAll(s.getRoot());
            this.selectAll(s.getBracket());
        }
        this.current_linkage = null;
        this.fireUpdatedSelection(true);
    }

    public void selectAll() {
        Iterator<Glycan> i = this.theDoc.iterator();
        while (i.hasNext()) {
            Glycan structure = i.next();
            this.selectAll(structure.getRoot());
            this.selectAll(structure.getBracket());
        }
        this.selected_linkages.clear();
        this.current_residue = null;
        this.current_linkage = null;
        if (this.theDoc.getFirstStructure() != null) {
            this.current_residue = this.theDoc.getFirstStructure().getRoot();
        }
        this.fireUpdatedSelection(true);
    }

    private void selectAll(Residue node) {
        if (node == null) {
            return;
        }
        this.selected_residues.add(node);
        Iterator<Linkage> i = node.iterator();
        while (i.hasNext()) {
            this.selectAll(i.next().getChildResidue());
        }
    }

    private Residue findNearest(Point p, Collection<Residue> nodes) {
        if (p == null) {
            return null;
        }
        Residue best_node = null;
        double best_dist = 0.0;
        for (Residue cur_node : nodes) {
            Rectangle cur_rect = this.theBBoxManager.getCurrent(cur_node);
            if (cur_rect == null) continue;
            double cur_dist = Geometry.distance(p, cur_rect);
            if (best_node != null && !(best_dist > cur_dist)) continue;
            best_node = cur_node;
            best_dist = cur_dist;
        }
        return best_node;
    }

    private Residue getResidueAfter(Residue parent, Residue current, ResAngle cur_pos) {
        ArrayList<Residue> linked = this.theBBoxManager.getLinkedResidues(current);
        for (int i = parent.indexOf(current) + 1; i < parent.getNoChildren(); ++i) {
            Residue other = parent.getChildAt(i);
            if (!this.thePosManager.getRelativePosition(other).equals(cur_pos) || linked.contains(other)) continue;
            return other;
        }
        return null;
    }

    private Residue getResidueBefore(Residue parent, Residue current, ResAngle cur_pos) {
        ArrayList<Residue> linked = this.theBBoxManager.getLinkedResidues(current);
        for (int i = parent.indexOf(current) - 1; i >= 0; --i) {
            Residue other = parent.getChildAt(i);
            if (!this.thePosManager.getRelativePosition(other).equals(cur_pos) || linked.contains(other)) continue;
            return other;
        }
        return null;
    }

    private Residue getFirstResidue(Residue parent, Residue current, ResAngle cur_pos) {
        for (int i = 0; i < parent.getNoChildren(); ++i) {
            Residue other = parent.getChildAt(i);
            if (!this.thePosManager.getRelativePosition(other).equals(cur_pos) || other == current) continue;
            return other;
        }
        return null;
    }

    private Residue getLastResidue(Residue parent, Residue current, ResAngle cur_pos) {
        for (int i = parent.getNoChildren() - 1; i >= 0; --i) {
            Residue other = parent.getChildAt(i);
            if (!this.thePosManager.getRelativePosition(other).equals(cur_pos) || other == current) continue;
            return other;
        }
        return null;
    }

    private void updateAndMantainSelection() {
        if (this.current_residue != null) {
            Residue old_current = this.current_residue;
            this.theDoc.fireDocumentChanged();
            this.setSelection(old_current);
        } else if (this.current_linkage != null) {
            Linkage old_current = this.current_linkage;
            this.theDoc.fireDocumentChanged();
            this.setSelection(old_current);
        }
    }

    private void swapAndMantainSelection(Residue r1, Residue r2) {
        if (this.current_residue != null) {
            Residue old_current = this.current_residue;
            this.theDoc.swap(r1, r2);
            this.setSelection(old_current);
        } else if (this.current_linkage != null) {
            Linkage old_current = this.current_linkage;
            this.theDoc.swap(r1, r2);
            this.setSelection(old_current);
        }
    }

    private void setPlacement(Residue current, ResiduePlacement new_rp) {
        current.setPreferredPlacement(new_rp);
        for (Residue r : this.theBBoxManager.getLinkedResidues(current)) {
            r.setPreferredPlacement(new_rp);
        }
    }

    private void setWasSticky(Residue current, boolean f) {
        current.setWasSticky(f);
        for (Residue r : this.theBBoxManager.getLinkedResidues(current)) {
            r.setWasSticky(f);
        }
    }

    private void moveBefore(Residue parent, Residue current, Residue other) {
        parent.moveChildBefore(current, other);
        for (Residue r : this.theBBoxManager.getLinkedResidues(current)) {
            if (r.getParent() != parent) continue;
            parent.moveChildBefore(r, other);
        }
    }

    private void moveAfter(Residue parent, Residue current, Residue other) {
        parent.moveChildAfter(current, other);
        for (Residue r : this.theBBoxManager.getLinkedResidues(current)) {
            if (r.getParent() != parent) continue;
            parent.moveChildAfter(r, other);
        }
    }

    public void onMoveCCW() {
        ResAngle cur_pos;
        Residue current = this.getCurrentSelection();
        if (current == null || current.getParent() == null) {
            return;
        }
        Residue parent = current.getParent();
        Residue other = this.getResidueBefore(parent, current, cur_pos = this.thePosManager.getRelativePosition(current));
        if (other != null) {
            this.moveBefore(parent, current, other);
            this.updateAndMantainSelection();
            return;
        }
        if (!current.hasPreferredPlacement()) {
            this.setWasSticky(current, this.thePosManager.isSticky(current));
        }
        ResAngle new_pos = null;
        ResiduePlacement new_rp = null;
        if (this.thePosManager.isOnBorder(current)) {
            new_pos = cur_pos.getIntAngle() == -90 ? new ResAngle(90) : new ResAngle(-90);
            new_rp = new ResiduePlacement(new_pos, true, false);
        } else {
            new_pos = cur_pos.getIntAngle() == -90 ? new ResAngle(90) : cur_pos.combine(-45);
            new_rp = new_pos.getIntAngle() == -90 || new_pos.getIntAngle() == 90 ? new ResiduePlacement(new_pos, false, current.getWasSticky()) : new ResiduePlacement(new_pos, false, false);
        }
        this.setPlacement(current, new_rp);
        other = this.getLastResidue(parent, current, new_pos);
        this.moveAfter(parent, current, other);
        this.updateAndMantainSelection();
    }

    public void onMoveCW() {
        Residue current = this.getCurrentSelection();
        if (current == null || current.getParent() == null) {
            return;
        }
        ResAngle cur_pos = this.thePosManager.getRelativePosition(current);
        Residue parent = current.getParent();
        Residue other = this.getResidueAfter(parent, current, cur_pos);
        if (other != null) {
            this.moveAfter(parent, current, other);
            this.updateAndMantainSelection();
            return;
        }
        if (!current.hasPreferredPlacement()) {
            this.setWasSticky(current, this.thePosManager.isSticky(current));
        }
        ResAngle new_pos = null;
        ResiduePlacement new_rp = null;
        if (this.thePosManager.isOnBorder(current)) {
            new_pos = cur_pos.getIntAngle() == -90 ? new ResAngle(90) : new ResAngle(-90);
            new_rp = new ResiduePlacement(new_pos, true, false);
        } else {
            new_pos = cur_pos.getIntAngle() == 90 ? new ResAngle(-90) : cur_pos.combine(45);
            new_rp = new_pos.getIntAngle() == -90 || new_pos.getIntAngle() == 90 ? new ResiduePlacement(new_pos, false, current.getWasSticky()) : new ResiduePlacement(new_pos, false, false);
        }
        this.setPlacement(current, new_rp);
        other = this.getFirstResidue(parent, current, new_pos);
        this.moveBefore(parent, current, other);
        this.updateAndMantainSelection();
    }

    public void goToStart() {
        JViewport vp = this.theScrollPane.getViewport();
        vp.setViewPosition(new Point(0, 0));
        vp.setViewPosition(new Point(0, 0));
    }

    public void goToEnd() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JViewport vp = GlycanCanvas.this.theScrollPane.getViewport();
                Dimension all = GlycanCanvas.this.getPreferredSize();
                Dimension view = vp.getExtentSize();
                vp.setViewPosition(new Point(0, all.height - view.height));
            }
        });
    }

    public void onNavigateUp() {
        Residue current = this.getCurrentSelection();
        if (current == null) {
            Glycan s = this.theDoc.getLastStructure();
            if (s != null) {
                this.setSelection(s.getRoot());
            }
        } else {
            Residue best_node = this.theBBoxManager.getNearestUp(current);
            if (best_node != null) {
                this.setSelection(best_node);
            }
        }
    }

    public void onNavigateDown() {
        Residue current = this.getCurrentSelection();
        if (current == null) {
            Glycan s = this.theDoc.getFirstStructure();
            if (s != null) {
                this.setSelection(s.getRoot());
            }
        } else {
            Residue best_node = this.theBBoxManager.getNearestDown(current);
            if (best_node != null) {
                this.setSelection(best_node);
            }
        }
    }

    public void onNavigateLeft() {
        Residue current = this.getCurrentSelection();
        if (current == null) {
            Glycan s = this.theDoc.getLastStructure();
            if (s != null) {
                this.setSelection(s.getRoot());
            }
        } else {
            Residue best_node = this.theBBoxManager.getNearestLeft(current);
            if (best_node != null) {
                this.setSelection(best_node);
            }
        }
    }

    public void onNavigateRight() {
        Residue current = this.getCurrentSelection();
        if (current == null) {
            Glycan s = this.theDoc.getFirstStructure();
            if (s != null) {
                this.setSelection(s.getRoot());
            }
        } else {
            Residue best_node = this.theBBoxManager.getNearestRight(current);
            if (best_node != null) {
                this.setSelection(best_node);
            }
        }
    }

    public void print(PrinterJob job) throws PrinterException {
        this.is_printing = true;
        job.print();
        this.is_printing = false;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setBackground(Color.white);
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Dimension td = this.getPreferredSize();
        double sx = pageFormat.getImageableWidth() / (double)td.width;
        double sy = pageFormat.getImageableHeight() / (double)td.height;
        double s = Math.min(sx, sy);
        if (s < 1.0) {
            g2d.scale(s, s);
        }
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        this.respondToDocumentChange = true;
        this.paint(g2d);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
        return 0;
    }

    public void onAddStringNotation() {
        try {
            ResidueDesignDialog a_RDD = new ResidueDesignDialog(this.theParent);
            a_RDD.setVisible(true);
            Residue toadd = null;
            String a_strStatus = a_RDD.getReturnStatus();
            if (!a_strStatus.equals("Cancel") && !a_strStatus.equals("Accept")) {
                toadd = new Residue(NonSymbolicResidueDictionary.getResidueType(a_RDD.getReturnStatus()));
            }
            if (toadd == null && !a_strStatus.equals("Cancel")) {
                throw new Exception("This residue can not handle in GlycanBuilder");
            }
            if (this.theDoc.addResidue(this.getCurrentResidue(), this.getLinkedResidues(), toadd) != null) {
                this.setSelection(toadd);
                this.theWorkspace.getResidueHistory().add(toadd);
            }
            this.respondToDocumentChange = true;
            this.repaint();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.theParent, e.getMessage(), "Error while convert ResidueCode", 0);
        }
    }

    public void onAntennaParent() {
        try {
            LinkedList<Linkage> linkages = this.getSelectedStructures().iterator().next().getBracket().getChildrenLinkages();
            GlycanUtils glycanUtil = new GlycanUtils();
            glycanUtil.getCoreResidue(this.getSelectedStructures());
            Residue root = glycanUtil.getCoreResidues().getFirst();
            for (Linkage linkage : linkages) {
                if (!linkage.getChildResidue().equals(this.getSelectedResiduesList().iterator().next())) continue;
                int antennaIndex = linkages.indexOf(linkage);
                this.getCurrentResidue().setAntennaeID(antennaIndex + 1);
                break;
            }
            ResidueSelectorDialog rsd = new ResidueSelectorDialog(this.theParent, "Select parent node", "Select parent node of this antenna", new Glycan(root, true, null), glycanUtil.getCoreResidues(), true, this.getTheGlycanRenderer());
            rsd.setVisible(true);
            if (!rsd.isCanceled()) {
                if (rsd.getSelectedResidues().size() == 1) {
                    throw new Exception("Core node should be selected more than one monosaccharide.");
                }
                this.getCurrentResidue().getParentsOfFragment().clear();
                for (Residue residue : rsd.getSelectedResidues()) {
                    if (!residue.isSaccharide()) continue;
                    this.getCurrentResidue().addParentOfFragment(residue);
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String url = e.getURL().toString();
    }

    public void onUndo() {
        try {
            this.theDoc.getUndoManager().undo();
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void onRedo() {
        try {
            this.theDoc.getUndoManager().redo();
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public boolean onMassOptionsStructures(Collection<Glycan> structures) {
        MassOptionsStructureDialog mdlg = new MassOptionsStructureDialog((Frame)this.theParent, structures, this.theWorkspace.getDefaultMassOptions());
        mdlg.pack();
        mdlg.setVisible(true);
        if (mdlg.getReturnStatus().equals("OK")) {
            this.theDoc.setMassOptions(structures, mdlg.getMassOptions());
            this.theWorkspace.getDefaultMassOptions().setValues(mdlg.getMassOptions());
            this.respondToDocumentChange = true;
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean onMassOptionsAllStructures() {
        return this.onMassOptionsStructures(this.theDoc.getStructures());
    }

    public boolean onMassOptionsSelectedStructures() {
        return this.onMassOptionsStructures(this.getSelectedStructures());
    }

    public void onChangeOrientation() {
        this.theWorkspace.getGraphicOptions().ORIENTATION = (this.theWorkspace.getGraphicOptions().ORIENTATION + 1) % 4;
        this.respondToDocumentChange = true;
        this.repaint();
    }

    public void setNotation(String notation) {
        this.theWorkspace.setNotation(notation);
        this.respondToDocumentChange = true;
        this.onChangeReducingEnd();
        this.repaint();
        this.updateResidueActions();
        this.addResidueMenu = null;
        this.addTerminalMenu = null;
        this.insertResidueMenu = null;
        this.changeResidueMenu = null;
        this.cachedMenus.clear();
    }

    public void fireNotationChangedEvent(String notation) {
        for (NotationChangeListener notationChangeListener : this.notationChangeListeners) {
            notationChangeListener.notationChanged(notation);
        }
    }

    public void setDisplay(String display) {
        this.theWorkspace.setDisplay(display);
        this.respondToDocumentChange = true;
        this.repaint();
        this.updateResidueActions();
    }

    public void onChangeDisplaySettings() {
        GraphicOptions options = this.theWorkspace.getGraphicOptions();
        GraphicOptionsDialog dlg = new GraphicOptionsDialog((Frame)this.theParent, options);
        dlg.setVisible(true);
        if (dlg.getReturnStatus().equals("OK")) {
            this.theWorkspace.setDisplay(options.DISPLAY);
            this.display_button_group.setSelected(this.display_models.get(options.DISPLAY), true);
            this.respondToDocumentChange = true;
            this.repaint();
            this.updateResidueActions();
        }
    }

    public void onAddComposition() {
        try {
            CompositionDialog dlg = new CompositionDialog((Frame)this.theParent, this.theWorkspace.getCompositionOptions());
            dlg.setVisible(true);
            if (dlg.getReturnStatus().equals("OK")) {
                Glycan a_oComposition = this.theWorkspace.getCompositionOptions().getCompositionAsGlycan(this.theWorkspace.getDefaultMassOptions());
                this.theDoc.addStructure(a_oComposition);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void onAddStructure(String name) {
        try {
            Residue a_oNewStructure = CoreDictionary.newCore(name);
            this.theDoc.addStructure(a_oNewStructure);
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void onAddStructureFromString() {
        try {
            ImportStructureDialog dlg = new ImportStructureDialog((Frame)this.theParent, this.getTheActionManager());
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                for (String s : dlg.getStringEncoded()) {
                    this.theDoc.importFromString(s, dlg.getStringFormat());
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public boolean onSaveImage() {
        try {
            OutputImageDialog dig = new OutputImageDialog(this.theParent);
            dig.setVisible(true);
            if (!dig.isCanceled()) {
                if (this.theDoc.getStructures().size() > 1) {
                    int retValue;
                    if (!GlycanDocument.supportMultipleStructures(dig.getFormat()) && (retValue = JOptionPane.showOptionDialog(this, "The selected format does not support multiple structures.\nOnly the first structure will be exported. Continue?", "Cannot export all structures", 0, 2, null, null, null)) != 0) {
                        return false;
                    }
                }
                JFileChooser fileChooser = new JFileChooser();
                if (GlycanParserFactory.getExportFormats().containsKey(dig.getFormat())) {
                    fileChooser.addChoosableFileFilter(new ExtensionFileFilter("txt", "Glycan text"));
                } else {
                    fileChooser.addChoosableFileFilter(new ExtensionFileFilter(dig.getFormat(), "Graphic image"));
                }
                fileChooser.setCurrentDirectory(this.theWorkspace.getFileHistory().getRecentFolder());
                int returnVal = fileChooser.showSaveDialog(this);
                if (returnVal == 0) {
                    int retValue;
                    String filename = fileChooser.getSelectedFile().getAbsolutePath();
                    File file = new File(filename = FileUtils.enforceExtension(filename, dig.getFormat()));
                    if (file.exists() && (retValue = JOptionPane.showOptionDialog(this, "File exists. Overwrite file: " + filename + "?", "Salva documento", 1, 3, null, null, null)) != 0) {
                        return false;
                    }
                    if (GlycanDocument.isSequenceFormat(dig.getFormat()) ? this.theDoc.exportTo(filename, dig.getFormat()) : SVGUtils.export((GlycanRendererAWT)this.theWorkspace.getGlycanRenderer(), filename, this.theDoc.getStructures(), this.theWorkspace.getGraphicOptions().SHOW_MASSES, this.theWorkspace.getGraphicOptions().SHOW_REDEND, dig.getFormat())) {
                        return true;
                    }
                }
                return false;
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return true;
    }

    public void onGetStringFromStructure() {
        try {
            OutputStringDialog dig = new OutputStringDialog(this.theParent);
            dig.setVisible(true);
            if (!dig.isCanceled()) {
                if (this.getSelectedStructures().isEmpty()) {
                    this.theDoc.exportFromStructure(this.theDoc.getStructures(), dig.getFormat());
                } else {
                    this.theDoc.exportFromStructure(this.getSelectedStructures(), dig.getFormat());
                }
            }
            if (this.theDoc.getString().size() > 0) {
                JDialog dialog = new JDialog(this.theParent, "Encode string", true);
                dialog.setSize(300, 80);
                dialog.setResizable(true);
                dialog.setLocationRelativeTo(this);
                StringBuilder str = new StringBuilder();
                for (String s : this.theDoc.getString()) {
                    str.append(s + "\n");
                }
                dialog.add(new JScrollPane(new JTextArea(str.toString())));
                dialog.setVisible(true);
                this.theDoc.clearString();
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void onAddTerminal(String name) {
        try {
            Residue toadd = TerminalDictionary.newTerminal(name);
            Residue current = this.getCurrentResidue();
            if (this.theDoc.addResidue(current, this.getLinkedResidues(), toadd) != null) {
                this.setSelection(current);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void onAddBracket() {
        Residue bracket = this.theDoc.addBracket(this.getCurrentResidue());
        if (bracket != null) {
            this.setSelection(bracket);
        }
    }

    public void onAddRepeat() {
        try {
            Collection<Residue> nodes = this.getSelectedResiduesList();
            if (!this.theDoc.createRepetition(null, nodes)) {
                LinkedList<Residue> end_points = new LinkedList<Residue>();
                for (Residue r : nodes) {
                    if (!r.isSaccharide()) continue;
                    end_points.add(r);
                }
                Glycan structure = this.getSelectedStructures().iterator().next();
                ResidueSelectorDialog rsd = new ResidueSelectorDialog(this.theParent, "Select ending point", "Select ending point of the repetition", structure, end_points, false, this.getTheGlycanRenderer());
                rsd.setVisible(true);
                if (!rsd.isCanceled()) {
                    this.theDoc.createRepetition(rsd.getCurrentResidue(), this.getSelectedResiduesList());
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.theParent, e.getMessage(), "Error while creating the repeating unit", 0);
        }
    }

    private void onAddCyclic() {
        try {
            Collection<Residue> nodes = this.getSelectedResiduesList();
            if (nodes.size() < 2) {
                throw new Exception("Cyclic structure must be contain two or more monosaccharide");
            }
            LinkedList<Residue> end_points = new LinkedList<Residue>();
            Glycan a_oGlycan = this.getCurrentStructure();
            for (Residue r : nodes) {
                if (r.isReducingEnd()) {
                    throw new Exception("Add cyclic could not handle reducing end");
                }
                if (!r.isSaccharide()) continue;
                end_points.add(r);
            }
            Glycan structure = this.getSelectedStructures().iterator().next();
            ResidueSelectorDialog rsd = new ResidueSelectorDialog(this.theParent, "Select the last node", "Select the last node of the cyclic", structure, end_points, false, this.getTheGlycanRenderer());
            rsd.setVisible(true);
            if (!rsd.isCanceled()) {
                this.theDoc.createCyclic(rsd.getCurrentResidue(), this.getSelectedResiduesList());
                if (!a_oGlycan.getRoot().firstChild().isStartCyclic()) {
                    Residue a_oFirst = a_oGlycan.getRoot().firstChild();
                    a_oGlycan.getRoot().getChildrenLinkages().remove(a_oGlycan.getRoot().getLinkageAt(0));
                    a_oGlycan.getRoot().addChild(a_oFirst.getStartCyclicResidue());
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.theParent, e.getMessage(), "Error while creating the cyclic unit", 0);
        }
    }

    public void onAdd(String sacc_name) {
        try {
            Residue currentResidue = this.getCurrentResidue();
            if (currentResidue != null) {
                if (currentResidue.getType().getSuperclass().equals("Bridge")) {
                    throw new Exception(currentResidue.getTypeName() + " is bridge node");
                }
                if (currentResidue.isEndCyclic() || currentResidue.isStartCyclic()) {
                    throw new Exception(currentResidue.getTypeName() + " could not add any residue");
                }
            }
            Residue toadd = ResidueDictionary.newResidue(sacc_name);
            if (this.theDoc.addResidue(this.getCurrentResidue(), this.getLinkedResidues(), toadd) != null) {
                this.setSelection(toadd);
                this.theWorkspace.getResidueHistory().add(toadd);
            }
            if (currentResidue != null && currentResidue.isBracket()) {
                GlycanUtils glycanUtils = new GlycanUtils();
                glycanUtils.getCoreResidue(this.getSelectedStructures());
                LinkedList<Residue> core = glycanUtils.getCoreResidues();
                for (Residue coreResidue : core) {
                    this.getCurrentResidue().addParentOfFragment(coreResidue);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.theParent, e.getMessage(), "Error while add residue", 0);
        }
    }

    public void onInsertBefore(String sacc_name) {
        try {
            Residue toinsert = ResidueDictionary.newResidue(sacc_name);
            Residue current = this.getCurrentResidue();
            if (this.theDoc.insertResidueBefore(current, this.getLinkedResidues(), toinsert) != null) {
                this.setSelection(toinsert);
                this.theWorkspace.getResidueHistory().add(toinsert);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void onChangeResidueType(String sacc_name) {
        try {
            ResidueType new_type = ResidueDictionary.getResidueType(sacc_name);
            Residue current = this.getCurrentResidue();
            if (this.theDoc.changeResidueType(current, this.getLinkedResidues(), new_type)) {
                this.setSelection(current);
                this.theWorkspace.getResidueHistory().add(current);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void onChangeReducingEnd(String sacc_name) {
        try {
            if (this.getCurrentResidue() == null || !this.getCurrentResidue().isReducingEnd()) {
                throw new Exception("This utility need to select reducing end");
            }
            TextSymbolDescriptor a_enumRedType = TextSymbolDescriptor.forRedType(sacc_name);
            ResidueType new_type = ResidueDictionary.findResidueType(a_enumRedType.toString());
            Residue current = this.getCurrentResidue();
            this.theDoc.changeReducingEndType(current, new_type);
            if (a_enumRedType.equals((Object)TextSymbolDescriptor.REDEND)) {
                if (this.getTheGlycanRenderer().getGraphicOptions().NOTATION.equals("snfg")) {
                    current.firstChild().setAlditol(true);
                    current.firstChild().setRingSize('o');
                    current.firstChild().setAnomericState('?');
                }
            } else {
                current.firstChild().setAlditol(false);
                if (current.firstChild().getRingSize() == 'o') {
                    current.firstChild().setRingSize('?');
                    current.firstChild().setAnomericState('?');
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.theParent, e.getMessage(), "Error in Change reducing end type", 0);
        }
    }

    private void onChangeReducingEnd() {
        for (Glycan a_oGlycan : this.theDoc.getStructures()) {
            Residue a_oRoot = a_oGlycan.getRoot();
            if (!this.theGlycanRenderer.getGraphicOptions().NOTATION.equals("snfg") || !a_oRoot.getChildAt(0).isAlditol()) continue;
            a_oRoot.getChildAt(0).setAnomericState('o');
        }
    }

    public void onProperties() {
        Residue current = this.getCurrentResidue();
        if (current == null) {
            return;
        }
        if (current.getParent() != null && (!current.isSpecial() || current.isCleavage())) {
            new ResiduePropertiesDialog((Frame)this.theParent, current, this.getLinkedResidues(), this.theDoc).setVisible(true);
            this.setSelection(current);
            this.respondToDocumentChange = true;
            this.repaint();
        } else if (current.isStartRepetition()) {
            new ResiduePropertiesDialog((Frame)this.theParent, current, this.theDoc).setVisible(true);
            this.setSelection(current);
            this.respondToDocumentChange = true;
            this.repaint();
        } else if (current.isEndRepetition()) {
            new RepetitionPropertiesDialog((Frame)this.theParent, current, this.theDoc).setVisible(true);
            this.setSelection(current);
            this.respondToDocumentChange = true;
            this.repaint();
        } else if (current.isEndCyclic()) {
            new ResiduePropertiesDialog((Frame)this.theParent, current, this.getLinkedResidues(), this.theDoc).setVisible(true);
            current.getStartResidue().getParentLinkage().getBonds().get(0).setParentPosition(current.getParentLinkage().getParentPositionsSingle());
            this.setSelection(current);
            this.respondToDocumentChange = true;
        }
    }

    private char getSelectedValueChar(JComboBox field) {
        if (field.getSelectedItem() == null) {
            return '?';
        }
        return ((String)field.getSelectedItem()).charAt(0);
    }

    private char[] getSelectedPositions(DropDownList field) {
        Object[] sel = field.getSelectedValues();
        if (sel.length == 0) {
            return new char[]{'?'};
        }
        char[] ret = new char[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            ret[i] = ((String)sel[i]).charAt(0);
        }
        return ret;
    }

    public void onSetProperties() {
        Residue current = this.getCurrentResidue();
        if (current != null) {
            current.setAnomericState(this.getSelectedValueChar(this.field_anomeric_state));
            current.setAnomericCarbon(this.getSelectedValueChar(this.field_anomeric_carbon));
            current.setChirality(this.getSelectedValueChar(this.field_chirality));
            current.setRingSize(this.getSelectedValueChar(this.field_ring_size));
            Linkage parent_linkage = current.getParentLinkage();
            if (parent_linkage != null) {
                int a_iProbabilityHigh = parent_linkage.getBonds().get(0).getProbabilityHigh();
                int a_iProbabilityLow = parent_linkage.getBonds().get(0).getProbabilityLow();
                char[] sel_linkage_positions = this.getSelectedPositions(this.field_linkage_position);
                if (this.field_second_bond.isSelected()) {
                    char[] sel_second_parent_positions = this.getSelectedPositions(this.field_second_parent_position);
                    char sel_second_child_position = this.getSelectedValueChar(this.field_second_child_position);
                    parent_linkage.setLinkagePositions(sel_linkage_positions, sel_second_parent_positions, sel_second_child_position);
                } else {
                    parent_linkage.setLinkagePositions(sel_linkage_positions);
                }
                parent_linkage.getBonds().get(0).setProbabilityHigh(a_iProbabilityHigh);
                parent_linkage.getBonds().get(0).setProbabilityLow(a_iProbabilityLow);
            }
            if (current.isSaccharide() && !GlycanUtils.isFacingAnom(current)) {
                if (!current.isAlditol() && this.getSelectedValueChar(this.field_ring_size) == 'o') {
                    current.setAlditol(true);
                    this.field_anomeric_state.setSelectedItem("?");
                    current.setAnomericState('?');
                }
                if (current.isAlditol() && (this.getSelectedValueChar(this.field_anomeric_state) != '?' || this.getSelectedValueChar(this.field_ring_size) != 'o')) {
                    current.setAlditol(false);
                    current.setRingSize(current.getRingSize() == 'o' ? (char)'?' : (char)current.getRingSize());
                }
            }
            this.theDoc.fireDocumentChanged();
            this.setSelection(current);
            this.respondToDocumentChange = true;
            this.repaint();
        }
    }

    public void onSetProperties_r() {
        Residue current = this.getCurrentResidue();
        if (current != null) {
            current.setAnomericState(this.getSelectedValueChar(this.field_anomeric_state_r));
            current.setAnomericCarbon(this.getSelectedValueChar(this.field_anomeric_carbon_r));
            current.setChirality(this.getSelectedValueChar(this.field_chirality_r));
            current.setRingSize(this.getSelectedValueChar(this.field_ring_size_r));
            Linkage parent_linkage = current.getParentLinkage();
            if (parent_linkage != null) {
                int a_iProbabilityHigh = parent_linkage.getBonds().get(0).getProbabilityHigh();
                int a_iProbabilityLow = parent_linkage.getBonds().get(0).getProbabilityLow();
                char[] sel_linkage_positions = this.getSelectedPositions(this.field_linkage_position_r);
                if (this.field_second_bond_r.isSelected()) {
                    char[] sel_second_parent_positions = this.getSelectedPositions(this.field_second_parent_position_r);
                    char sel_second_child_position = this.getSelectedValueChar(this.field_second_child_position_r);
                    parent_linkage.setLinkagePositions(sel_linkage_positions, sel_second_parent_positions, sel_second_child_position);
                } else {
                    parent_linkage.setLinkagePositions(sel_linkage_positions);
                }
                parent_linkage.getBonds().get(0).setProbabilityHigh(a_iProbabilityHigh);
                parent_linkage.getBonds().get(0).setProbabilityLow(a_iProbabilityLow);
            }
            this.theDoc.fireDocumentChanged();
            this.setSelection(current);
            this.respondToDocumentChange = true;
            this.repaint();
        }
    }

    public void setShowRedendCanvas(boolean f) {
        this.theWorkspace.getGraphicOptions().SHOW_REDEND_CANVAS = f;
        this.getTheActionManager().get("showredendcanvas").setSelected(f);
        this.respondToDocumentChange = true;
        this.repaint();
    }

    public void insertCrossLinkedSubstituent(String a_sNodeName) {
        try {
            if (this.getSelectedResiduesList().size() > 2) {
                throw new Exception("This utility is need to select one or two monosaccharide");
            }
            if (this.getSelectedResiduesList().size() == 1) {
                Residue a_oParent = this.getSelectedResidues()[0];
                if (!a_oParent.isSaccharide()) {
                    throw new Exception(a_oParent.getType().getDescription() + " can not insert cross-linked substituent");
                }
                Residue a_oBridge = new Residue(ResidueDictionary.getResidueType(a_sNodeName));
                a_oBridge.setParentLinkage(new Linkage(a_oParent, a_oBridge, new char[]{'?'}, new char[]{'?'}, a_oBridge.getAnomericCarbon()));
                a_oParent.addChild(a_oBridge, a_oBridge.getParentLinkage().getBonds());
            }
            if (this.getSelectedResiduesList().size() == 2) {
                Residue[] a_aResidues = this.getSelectedResidues();
                Residue a_oStart = a_aResidues[0];
                Residue a_oEnd = a_aResidues[1];
                if (a_oStart.getParent().equals(a_oEnd)) {
                    a_oStart = a_aResidues[1];
                    a_oEnd = a_aResidues[0];
                }
                if (a_oStart.getType().getSuperclass().equals("Bridge")) {
                    throw new Exception(a_oStart.getTypeName() + " is cross-linked substituent");
                }
                if (a_oEnd.getType().getSuperclass().equals("Bridge")) {
                    throw new Exception(a_oEnd.getTypeName() + " is cross-linked substituent");
                }
                char a_cParentPos = a_oEnd.getParentLinkage().getParentPositionsSingle();
                Residue a_oBridge = new Residue(CrossLinkedSubstituentDictionary.getCrossLinkedSubstituent(a_sNodeName));
                a_oEnd.getParentLinkage().setSubstituent(a_oBridge);
                a_oStart.getChildrenLinkages().remove(a_oStart.getChildrenLinkages().indexOf(a_oEnd.getParentLinkage()));
                a_oBridge.setParentLinkage(new Linkage(a_oStart, a_oBridge, a_cParentPos));
                a_oEnd.setParentLinkage(new Linkage(a_oBridge, a_oEnd, '1'));
                a_oStart.addChild(a_oBridge, a_oBridge.getParentLinkage().getBonds());
                a_oBridge.addChild(a_oEnd, a_oEnd.getParentLinkage().getBonds());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.theParent, e.getMessage(), "Error while insert bridge", 0);
        }
    }

    private void onAddALternative() {
        if (this.getCurrentResidue().hasChildren()) {
            JOptionPane.showMessageDialog(this.theParent, "This utility need to select non-reducing end", "Error in \"Add alternatice unit\"", 0);
            return;
        }
        Residue a_oStartAlt = ResidueDictionary.createAlternativeStart();
        Residue a_oEndAlt = ResidueDictionary.createAlternativeEnd();
    }

    private void onSelectAPIDialog() {
        if (this.theDoc.getStructures().size() == 0) {
            JOptionPane.showMessageDialog(null, "Glycan Structure is empty", "Error in GlycanBuilder2", 0);
        } else {
            this.theStructure.onSelectAPIDialog(this.theParent, this.theDoc);
        }
    }

    private void changeUser() {
        try {
            this.theStructure.changeUser();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.ignore_actions) {
            return;
        }
        CanvasActionDescriptor a_enumAction = CanvasActionDescriptor.forActions(GlycanAction.getAction(e));
        String param = GlycanAction.getParam(e);
        if (a_enumAction.equals((Object)CanvasActionDescriptor.STRINGNOTATION)) {
            this.onAddStringNotation();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.ANTENNAPARENT)) {
            this.onAntennaParent();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.UNDO)) {
            this.onUndo();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.REDO)) {
            this.onRedo();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.CUT)) {
            this.cut();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.COPY)) {
            this.copy();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.PASTE)) {
            this.paste();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.DELETE)) {
            this.delete();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SELECTSTRUCTURE)) {
            this.selectStructure();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SELECTALL)) {
            this.selectAll();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SELECTNONE)) {
            this.resetSelection();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.GOTOSTART)) {
            this.resetSelection();
            this.goToStart();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.GOTOEND)) {
            this.resetSelection();
            this.goToEnd();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.ORDERSTRUCTURESASC)) {
            this.theDoc.orderStructures(false);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.ORDERSTRUCTURESDESC)) {
            this.theDoc.orderStructures(true);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.ADDTERMINAL)) {
            this.onAddTerminal(param);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.ADDCOMPOSITON)) {
            this.onAddComposition();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.ADDSTRUCTURE)) {
            this.onAddStructure(param);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.ADDSTRUCTURESTR)) {
            this.onAddStructureFromString();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.WRITE)) {
            this.onAddStructureFromString();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SAVEIMAGE)) {
            this.onSaveImage();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.GETSTRUCTURESTR)) {
            this.onGetStringFromStructure();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.ADD)) {
            this.onAdd(param);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.INSERT)) {
            this.onInsertBefore(param);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.CHANGE)) {
            this.onChangeResidueType(param);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.CHANGEREDEND)) {
            this.onChangeReducingEnd(param);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.BRACKET)) {
            this.onAddBracket();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.REPEAT)) {
            this.onAddRepeat();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.CYCLIC)) {
            this.onAddCyclic();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.ALTERNATIVE)) {
            this.onAddALternative();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.MASSOPTSTRUCT)) {
            this.onMassOptionsSelectedStructures();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.NOTATION)) {
            this.setNotation(param);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.DISPLAY)) {
            this.setDisplay(param);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.DISPLAYSETTINGS)) {
            this.onChangeDisplaySettings();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SHOWINFO)) {
            this.theWorkspace.getGraphicOptions().SHOW_INFO = ((JCheckBoxMenuItem)e.getSource()).getState();
            this.respondToDocumentChange = true;
            this.repaint();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SCALE)) {
            this.theWorkspace.getGraphicOptions().SCALE_CANVAS = Double.parseDouble(param) / 100.0;
            this.respondToDocumentChange = true;
            this.repaint();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.COLLLAPSE)) {
            this.theWorkspace.getGraphicOptions().COLLAPSE_MULTIPLE_ANTENNAE = ((JCheckBox)e.getSource()).isSelected();
            this.respondToDocumentChange = true;
            this.repaint();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SHOWMASSCANVAS)) {
            this.theWorkspace.getGraphicOptions().SHOW_MASSES_CANVAS = ((JCheckBox)e.getSource()).isSelected();
            this.respondToDocumentChange = true;
            this.repaint();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SHOWMASS)) {
            System.out.println(e.getSource());
            this.theWorkspace.getGraphicOptions().SHOW_MASSES = ((JCheckBox)e.getSource()).isSelected();
            this.respondToDocumentChange = true;
            this.repaint();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SHOWREDENDCANVAS)) {
            this.theWorkspace.getGraphicOptions().SHOW_REDEND_CANVAS = ((JCheckBox)e.getSource()).isSelected();
            this.respondToDocumentChange = true;
            this.repaint();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SHOWREDEND)) {
            this.theWorkspace.getGraphicOptions().SHOW_REDEND = ((JCheckBox)e.getSource()).isSelected();
            this.respondToDocumentChange = true;
            this.repaint();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SAVESPEC)) {
            System.err.println("Save spectra found");
            this.theWorkspace.getGraphicOptions().SAVE_SPECTRA_CUSTOM = ((JCheckBox)e.getSource()).isSelected();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.ORIENTATION)) {
            this.onChangeOrientation();
            this.updateOrientationButton();
            this.updateOrientation();
            this.repaint();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.PROPERTIES)) {
            this.onProperties();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SETPROPERTY)) {
            this.onSetProperties();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SETPROPERTYR)) {
            this.onSetProperties_r();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.MOVECCW)) {
            this.onMoveCCW();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.MOVECW)) {
            this.onMoveCW();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.NAVUP)) {
            this.onNavigateUp();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.NAVDOWN)) {
            this.onNavigateDown();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.NAVLEFT)) {
            this.onNavigateDown();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.NAVRIGHT)) {
            this.onNavigateRight();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.EXPLODE)) {
            this.explode();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.IMPLODE)) {
            this.implode();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.CHANGELV3)) {
            CompositionUtility.onChangeLV3(this.theDoc, this.getCurrentStructure());
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.CHANGELV4)) {
            CompositionUtility.onChangeLV4(this.theDoc, this.getCurrentStructure());
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SHOWID)) {
            DebugUtility.shoeIndex(this.getCurrentStructure());
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.REMOVEAANOTATION)) {
            DebugUtility.removeAnotation(this.getCurrentStructure());
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.INSERTBRIDGE)) {
            this.insertCrossLinkedSubstituent(param);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.SELECTAPIDIALOG)) {
            this.onSelectAPIDialog();
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.GLYCANIDLIST)) {
            GlytoucanIDList.showGlycanIdList(this.theParent);
        }
        if (a_enumAction.equals((Object)CanvasActionDescriptor.CHANGEUSER)) {
            this.changeUser();
        }
        this.updateActions();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlycanCanvas.this.revalidate();
                GlycanCanvas.this.repaint();
            }
        });
    }

    @Override
    public void residueHistoryChanged() {
        this.updateRecentResiduesToolbar(this.theToolBarStructure);
    }

    @Override
    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        this.updateActions();
        this.resetSelection();
        this.respondToDocumentChange = true;
        this.repaint();
    }

    @Override
    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        this.updateActions();
        this.resetSelection();
        this.respondToDocumentChange = true;
        this.respondToDocumentChange = true;
        this.repaint();
    }

    public void addSelectionChangeListener(SelectionChangeListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeSelectionChangeListener(SelectionChangeListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void fireUpdatedSelection(boolean completeStructure) {
        this.updateActions();
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((SelectionChangeListener)i.next()).selectionChanged(new SelectionChangeEvent(this));
        }
        this.respondToDocumentChange = true;
        this.repaint();
        this.showSelection();
    }

    public void showSelection() {
        boolean show_masses = this.is_printing ? this.getTheGlycanRenderer().getGraphicOptions().SHOW_MASSES : this.getTheGlycanRenderer().getGraphicOptions().SHOW_MASSES_CANVAS;
        boolean show_redend = this.is_printing ? this.getTheGlycanRenderer().getGraphicOptions().SHOW_REDEND : this.getTheGlycanRenderer().getGraphicOptions().SHOW_REDEND_CANVAS;
        this.getTheGlycanRenderer().computeBoundingBoxes(this.theDoc.getStructures(), show_masses, show_redend, this.thePosManager, this.theBBoxManager);
        Rectangle bbox = null;
        for (Residue r : this.selected_residues) {
            bbox = Geometry.union(bbox, this.theBBoxManager.getCurrent(r));
        }
        for (Linkage l : this.selected_linkages) {
            bbox = Geometry.union(bbox, this.theBBoxManager.getCurrent(l.getChildResidue()));
            bbox = Geometry.union(bbox, this.theBBoxManager.getCurrent(l.getParentResidue()));
        }
        if (bbox != null) {
            int max_move;
            int min_move;
            bbox = Geometry.expand(bbox, 5);
            Rectangle view = this.theScrollPane.getViewport().getViewRect();
            int new_x = Geometry.left(view);
            int new_y = Geometry.top(view);
            if (Geometry.left(view) > Geometry.left(bbox)) {
                new_x = Geometry.left(bbox);
            } else if (Geometry.right(view) < Geometry.right(bbox)) {
                min_move = Geometry.right(bbox) - Geometry.right(view);
                max_move = Geometry.left(bbox) - Geometry.left(view);
                new_x += Math.min(min_move, max_move);
            }
            if (Geometry.top(view) > Geometry.top(bbox)) {
                new_y = Geometry.top(bbox);
            } else if (Geometry.bottom(view) < Geometry.bottom(bbox)) {
                min_move = Geometry.bottom(bbox) - Geometry.bottom(view);
                max_move = Geometry.top(bbox) - Geometry.top(view);
                new_y += Math.min(min_move, max_move);
            }
            this.theScrollPane.getViewport().setViewPosition(new Point(new_x, new_y));
            this.theScrollPane.getViewport().setViewPosition(new Point(new_x, new_y));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastMouseButton = e.getButton();
        if (MouseUtils.isPushTrigger(e) || MouseUtils.isCtrlPushTrigger(e)) {
            Residue start_position = this.getResidueAtPoint(e.getPoint());
            if (start_position != null) {
                this.is_dragndrop = true;
                if (!this.isSelected(start_position)) {
                    if (MouseUtils.isCtrlPushTrigger(e)) {
                        this.addSelection(start_position);
                    } else {
                        this.setSelection(start_position);
                    }
                }
            } else {
                this.mouse_start_point = e.getPoint();
            }
        }
        this.was_dragged = false;
        this.lastMouseButton = null;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.was_dragged = true;
        this.lastMouseButton = e.getButton();
        if (this.is_dragndrop) {
            if (MouseUtils.isNothingPressed(e)) {
                this.setCursor(this.canDrop(e) ? this.dndmove_cursor : this.dndnomove_cursor);
            } else if (MouseUtils.isCtrlPressed(e)) {
                this.setCursor(this.canDrop(e) ? this.dndcopy_cursor : this.dndnocopy_cursor);
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (this.mouse_start_point != null) {
            if (this.mouse_end_point != null) {
                this.xorRectangle(this.mouse_start_point, this.mouse_end_point);
            }
            this.mouse_end_point = e.getPoint();
            this.xorRectangle(this.mouse_start_point, this.mouse_end_point);
        }
        this.dragAndScroll(e);
        this.lastMouseButton = null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.lastMouseButton = e.getButton();
        if (this.is_dragndrop && this.was_dragged) {
            Residue position = this.getResidueAtPoint(e.getPoint());
            if (this.canDrop(e)) {
                if (MouseUtils.isNothingPressed(e)) {
                    this.moveTo(position);
                } else if (MouseUtils.isCtrlPressed(e)) {
                    this.copyTo(position);
                }
            }
        } else if (this.mouse_end_point != null) {
            if (this.mouse_end_point != null) {
                this.xorRectangle(this.mouse_start_point, this.mouse_end_point);
            }
            Rectangle mouse_rect = Geometry.makeRectangle(this.mouse_start_point, this.mouse_end_point);
            if (MouseUtils.isNothingPressed(e)) {
                this.setSelection(this.theBBoxManager.getNodesInside(mouse_rect));
            } else if (MouseUtils.isCtrlPressed(e)) {
                this.addSelection(this.theBBoxManager.getNodesInside(mouse_rect));
            }
            this.setCurrentResidue(this.findNearest(e.getPoint(), this.selected_residues));
        }
        if (this.is_dragndrop) {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.is_dragndrop = false;
        this.was_dragged = false;
        this.mouse_start_point = null;
        this.mouse_end_point = null;
        this.repaint();
        this.lastMouseButton = null;
    }

    public Integer getLastMouseButton() {
        return this.lastMouseButton;
    }

    public void setLastMouseButton(Integer lastMouseButton) {
        this.lastMouseButton = lastMouseButton;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.lastMouseButton = e.getButton();
        Residue r = this.getResidueAtPoint(e.getPoint());
        if (r != null) {
            if (MouseUtils.isSelectTrigger(e)) {
                this.setSelection(r);
            } else if (MouseUtils.isAddSelectTrigger(e)) {
                this.addSelection(r);
            } else if (MouseUtils.isSelectAllTrigger(e)) {
                this.addSelectionPathTo(r);
            }
        } else {
            Linkage l = this.getLinkageAtPoint(e.getPoint());
            if (MouseUtils.isSelectTrigger(e) || MouseUtils.isAddSelectTrigger(e) || MouseUtils.isSelectAllTrigger(e)) {
                this.setSelection(l);
            }
        }
        this.lastMouseButton = null;
    }

    private void dragAndScroll(MouseEvent e) {
        Point point = e.getPoint();
        JViewport view = this.theScrollPane.getViewport();
        Rectangle inner = view.getViewRect();
        inner.grow(-10, -10);
        if (!inner.contains(point)) {
            Point orig = view.getViewPosition();
            if (point.x < inner.x) {
                orig.x -= 10;
            } else if (point.x > inner.x + inner.width) {
                orig.x += 10;
            }
            if (point.y < inner.y) {
                orig.y -= 10;
            } else if (point.y > inner.y + inner.height) {
                orig.y += 10;
            }
            int maxx = this.getBounds().width - view.getViewRect().width;
            int maxy = this.getBounds().height - view.getViewRect().height;
            if (orig.x < 0) {
                orig.x = 0;
            }
            if (orig.x > maxx) {
                orig.x = maxx;
            }
            if (orig.y < 0) {
                orig.y = 0;
            }
            if (orig.y > maxy) {
                orig.y = maxy;
            }
            view.setViewPosition(orig);
        }
    }

    private boolean canDrop(MouseEvent e) {
        Residue target = this.getResidueAtPoint(e.getPoint());
        if (target == null) {
            return true;
        }
        if (this.isSelected(target) && !e.isControlDown()) {
            return false;
        }
        return this.theDoc.canAddStructures(target, this.selected_residues);
    }

    public void clearResidueGalleries() {
        for (List<ResidueGalleryIndex> indexList : this.residueGalleries.values()) {
            for (ResidueGalleryIndex index : indexList) {
                if (index.band.getControlPanel() == null) continue;
                ((JBandControlPanel)index.band.getControlPanel()).remove(((JBandControlPanel)index.band.getControlPanel()).getRibbonGallery(index.galleryName));
            }
        }
        if (this.structureSelectionBand != null) {
            ((JBandControlPanel)this.structureSelectionBand.getControlPanel()).remove(this.structureSelectionBand);
        }
        if (this.terminalRibbonBand != null && this.terminalRibbonBand.getControlPanel() != null) {
            ((JBandControlPanel)this.terminalRibbonBand.getControlPanel()).remove(this.terminalRibbonBand);
        }
    }

    public void registerUIListener(UIActionListener uiActionListener) {
        this.uiActionListenerList.add(uiActionListener);
    }

    public void explode() {
        for (UIActionListener uiActionListener : this.uiActionListenerList) {
            uiActionListener.explode();
        }
    }

    public void implode() {
        for (UIActionListener uiActionListener : this.uiActionListenerList) {
            uiActionListener.implode();
        }
    }

    public void setTheActionManager(ActionManager theActionManager) {
        this.theActionManager = theActionManager;
    }

    public ActionManager getTheActionManager() {
        return this.theActionManager;
    }

    public void setTheGlycanRenderer(GlycanRendererAWT theGlycanRenderer) {
        this.theGlycanRenderer = theGlycanRenderer;
    }

    public GlycanRendererAWT getTheGlycanRenderer() {
        return this.theGlycanRenderer;
    }

    public JFrame getFrame() {
        return this.theParent;
    }

    public class ResidueGalleryIndex {
        public JRibbonBand band;
        public String galleryName;

        public ResidueGalleryIndex(JRibbonBand _band, String _galleryName) {
            this.band = _band;
            this.galleryName = _galleryName;
        }
    }

    public static enum RESIDUE_INSERT_MODES {
        INSERT,
        REPLACE,
        ADD,
        TERMINAL;

    }

    public static class SelectionChangeEvent {
        private final GlycanCanvas src;

        public SelectionChangeEvent(GlycanCanvas _src) {
            this.src = _src;
        }

        public GlycanCanvas getSource() {
            return this.src;
        }
    }

    public static interface SelectionChangeListener {
        public void selectionChanged(SelectionChangeEvent var1);
    }
}

