/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.eurocarbdb.application.glycanbuilder.EurocarbResizableIcon;
import org.eurocarbdb.application.glycanbuilder.HasActionProperty;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.ImageResizableIconReducedMem;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycanbuilder.util.JCommandButtonAction;
import org.eurocarbdb.application.glycanbuilder.util.JCommandMenuButtonAction;
import org.eurocarbdb.application.glycanbuilder.util.JCommandToggleButtonAction;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class GlycanAction
extends AbstractAction {
    private static final long serialVersionUID = 0L;
    private GlycanAction parent_action = null;
    private ActionListener main_listener = null;
    protected Vector<ActionListener> listeners = new Vector();
    protected EurocarbResizableIcon eurocarbIcon;
    protected JCommandButtonAction jCommandButton;
    protected ActionListener defaultListener;
    List<Object> enableAwareObjects = new ArrayList<Object>();
    List<Object> selectAwareObjects = new ArrayList<Object>();

    public EurocarbResizableIcon getEurocarbIcon() {
        return this.eurocarbIcon;
    }

    public void setEurocarbIcon(EurocarbResizableIcon eurocarbIcon) {
        this.eurocarbIcon = eurocarbIcon;
    }

    public GlycanAction() {
    }

    public GlycanAction(GlycanAction parent, String action, int mnemonic, String accelerator, ActionListener l) {
        this.init(action + "=" + parent.getActionCommand(), parent.getEurocarbIcon(), parent.getName(), mnemonic, accelerator, l);
        this.parent_action = parent;
    }

    public GlycanAction(String action, EurocarbResizableIcon i, String label, int mnemonic, String accelerator, ActionListener l) {
        this.init(action, i, label, mnemonic, accelerator, l);
    }

    public void init(String action, EurocarbResizableIcon i, String label, int mnemonic, String accelerator, ActionListener l) {
        this.setEnabled(true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelerator));
        this.putValue("ActionCommandKey", action);
        this.putValue("MnemonicKey", mnemonic);
        this.putValue("Name", label);
        if (this.getValue("AcceleratorKey") == null) {
            this.putValue("ShortDescription", label);
        } else {
            this.putValue("ShortDescription", label + "  [" + GlycanAction.getAcceleratorText((KeyStroke)this.getValue("AcceleratorKey")) + "]");
        }
        if (i != null) {
            this.putValue("SmallIcon", i.getResizableIcon());
        }
        if (l != null) {
            this.addActionListener(l);
            this.main_listener = l;
        }
        this.eurocarbIcon = i;
        this.enableAwareObjects = new ArrayList<Object>();
        if (l instanceof JComponent || l instanceof JFrame) {
            JComponent component = null;
            component = l instanceof JComponent ? (JComponent)((Object)l) : (JComponent)((JFrame)((Object)l)).getContentPane();
            KeyStroke keyStroke = (KeyStroke)this.getValue("AcceleratorKey");
            if (keyStroke != null && component.getActionForKeyStroke(keyStroke) == null) {
                component.registerKeyboardAction(this, (String)this.getValue("ActionCommandKey"), keyStroke, 2);
            }
        }
    }

    public String getActionCommand() {
        return (String)this.getValue("ActionCommandKey");
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public String getDescription() {
        return (String)this.getValue("ShortDescription");
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public ActionListener getMainListener() {
        return this.main_listener;
    }

    public GlycanAction getParentAction() {
        return this.parent_action;
    }

    private static String getAcceleratorText(KeyStroke accelerator) {
        String acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (acceleratorDelimiter == null) {
            acceleratorDelimiter = "+";
        }
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        return acceleratorText;
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(e);
        }
    }

    public static String getAction(ActionEvent e) {
        Object source = e.getSource();
        String str = source instanceof HasActionProperty ? ((HasActionProperty)source).getActionCommand() : e.getActionCommand();
        if (str == null) {
            return null;
        }
        int ind = str.indexOf(61);
        if (ind == -1) {
            return str;
        }
        return str.substring(0, ind);
    }

    public static String getParam(ActionEvent e) {
        Object source = e.getSource();
        String str = source instanceof HasActionProperty ? ((HasActionProperty)source).getActionCommand() : e.getActionCommand();
        if (str == null) {
            return null;
        }
        int ind = str.indexOf(61);
        if (ind == -1) {
            return null;
        }
        return str.substring(ind + 1);
    }

    public ActionListener getDefaultListener() {
        return this.defaultListener;
    }

    public void setDefaultListener(ActionListener defaultListener) {
        this.defaultListener = defaultListener;
    }

    public JCommandButton getJCommandButton() {
        return this.getJCommandButton(null, (String)this.getValue("Name"), null, new RichTooltip((String)this.getValue("Name"), null), true);
    }

    public JCommandButton getJCommandButton(ActionListener listener) {
        return this.getJCommandButton(null, (String)this.getValue("Name"), listener, new RichTooltip((String)this.getValue("Name"), null), true);
    }

    public JCommandButton getJCommandButton(ICON_SIZE iconSize, ActionListener listener, String label) {
        return this.getJCommandButton(iconSize, label, listener, new RichTooltip(label, " "), true);
    }

    public JCommandButton getJCommandButton(ICON_SIZE iconSize, ActionListener listener) {
        return this.getJCommandButton(iconSize, (String)this.getValue("Name"), listener, new RichTooltip((String)this.getValue("Name"), null), true);
    }

    public JCommandButton getJCommandButton(ICON_SIZE iconSize, ActionListener listener, RichTooltip alt) {
        return this.getJCommandButton(iconSize, null, listener, alt, true);
    }

    public JCommandButton getJCommandButton(String label) {
        return this.getJCommandButton(null, label, null, null, true);
    }

    public JCommandButton getJCommandButton(String label, ActionListener listener, RichTooltip alt) {
        return this.getJCommandButton(null, label, listener, alt, true);
    }

    public JCommandButton getJCommandButton(ActionListener listener, RichTooltip alt) {
        return this.getJCommandButton(null, null, listener, alt, true);
    }

    public JCommandButton getJCommandButton(ICON_SIZE iconSize, String label, ActionListener listener, RichTooltip alt) {
        return this.getJCommandButton(iconSize, label, listener, alt, true);
    }

    public JCommandButton getJCommandButton(ICON_SIZE iconSize, String label, ActionListener listener, RichTooltip alt, boolean showIcon) {
        KeyStroke keyStroke;
        JCommandButtonAction jCommandButton;
        if (iconSize == null) {
            jCommandButton = showIcon ? new JCommandButtonAction(label, this.getEurocarbIcon().getResizableIcon()) : new JCommandButtonAction(label);
            jCommandButton.setActionCommand(this.getActionCommand());
        } else {
            jCommandButton = showIcon ? new JCommandButtonAction(label, this.getResizableIcon(iconSize)) : new JCommandButtonAction(label);
            jCommandButton.setActionCommand(this.getActionCommand());
        }
        RichTooltip altNew = new RichTooltip();
        if (alt == null) {
            if (this.getValue("ShortDescription") != null) {
                Object name = (String)this.getValue("Name");
                if (name == null) {
                    name = " ";
                }
                altNew.setTitle((String)name);
            }
        } else {
            altNew.setTitle(alt.getTitle());
            for (String line : altNew.getDescriptionSections()) {
                if (line.matches("^\\\\s+$")) continue;
                altNew.addDescriptionSection(line);
            }
        }
        if ((keyStroke = (KeyStroke)this.getValue("AcceleratorKey")) != null) {
            String keyStrokeString = keyStroke.toString();
            keyStrokeString = keyStrokeString.replace("pressed", "+");
            altNew.addDescriptionSection(keyStrokeString);
        }
        jCommandButton.setActionRichTooltip(altNew);
        if (listener != null) {
            jCommandButton.addActionListener(listener);
        }
        this.enableAwareObjects.add(jCommandButton);
        jCommandButton.registerKeyboardAction(this, "lineup", (KeyStroke)this.getValue("AcceleratorKey"), 2);
        return jCommandButton;
    }

    public JCommandMenuButtonAction getJCommandMenuButton() {
        return this.getJCommandMenuButton(null, (String)this.getValue("Name"), this.getMainListener(), new RichTooltip((String)this.getValue("Name"), " "), true);
    }

    public JCommandMenuButtonAction getJCommandMenuButton(ICON_SIZE iconSize, String label, ActionListener listener, RichTooltip alt, boolean showIcon) {
        KeyStroke keyStroke;
        JCommandMenuButtonAction jCommandButton;
        if (iconSize == null) {
            jCommandButton = showIcon ? new JCommandMenuButtonAction(label, this.getEurocarbIcon().getResizableIcon()) : new JCommandMenuButtonAction(label);
            jCommandButton.setActionCommand(this.getActionCommand());
        } else {
            jCommandButton = showIcon ? new JCommandMenuButtonAction(label, this.getResizableIcon(iconSize)) : new JCommandMenuButtonAction(label);
            jCommandButton.setActionCommand(this.getActionCommand());
        }
        RichTooltip altNew = new RichTooltip();
        if (alt == null) {
            if (this.getValue("ShortDescription") != null) {
                Object name = (String)this.getValue("Name");
                if (name == null) {
                    name = " ";
                }
                altNew.setTitle((String)name);
            }
        } else {
            altNew.setTitle(alt.getTitle());
            for (String line : altNew.getDescriptionSections()) {
                if (line.matches("^\\\\s+$")) continue;
                altNew.addDescriptionSection(line);
            }
        }
        if ((keyStroke = (KeyStroke)this.getValue("AcceleratorKey")) != null) {
            String keyStrokeString = keyStroke.toString();
            keyStrokeString = keyStrokeString.replace("pressed", "+");
            altNew.addDescriptionSection(keyStrokeString);
        }
        jCommandButton.setActionRichTooltip(altNew);
        if (listener != null) {
            jCommandButton.addActionListener(listener);
        }
        this.enableAwareObjects.add(jCommandButton);
        jCommandButton.registerKeyboardAction(this, "lineup", (KeyStroke)this.getValue("AcceleratorKey"), 2);
        return jCommandButton;
    }

    public JCommandToggleButton getJCommandToggleButton(ActionListener listener, boolean selected) {
        return this.getJCommandToggleButton(this.getName(), 2, listener, selected, null);
    }

    public JCommandToggleButton getJCommandToggleButton(String label, ActionListener listener, boolean selected, ICON_SIZE iconSize) {
        return this.getJCommandToggleButton(label, 2, listener, selected, iconSize);
    }

    public JCommandToggleButton getJCommandToggleButton(String label, ActionListener listener, boolean selected) {
        return this.getJCommandToggleButton(label, 2, listener, selected, null);
    }

    public JCommandToggleButtonAction getJCommandToggleButton(String label, int aln, ActionListener listener, boolean selected, ICON_SIZE iconSize) {
        KeyStroke keyStroke;
        JCommandToggleButtonAction toggleButton = this.getEurocarbIcon() != null && this.getEurocarbIcon().getIconProperties() != null ? (iconSize == null ? new JCommandToggleButtonAction(label, this.getEurocarbIcon().getResizableIcon()) : new JCommandToggleButtonAction(label, this.getResizableIcon(iconSize))) : new JCommandToggleButtonAction(label);
        RichTooltip altNew = new RichTooltip();
        if (this.getValue("ShortDescription") != null) {
            String name = (String)this.getValue("Name");
            if (name == null) {
                name = " ";
            }
            altNew.setTitle(name);
        }
        if ((keyStroke = (KeyStroke)this.getValue("AcceleratorKey")) != null) {
            String keyStrokeString = keyStroke.toString();
            keyStrokeString = keyStrokeString.replace("pressed", "+");
            altNew.addDescriptionSection(keyStrokeString);
        }
        toggleButton.setActionRichTooltip(altNew);
        toggleButton.setHorizontalAlignment(0);
        toggleButton.setActionCommand(this.getActionCommand());
        toggleButton.addActionListener(listener);
        toggleButton.setDisplayState(CommandButtonDisplayState.TILE);
        if (selected) {
            toggleButton.doActionClick();
        }
        this.enableAwareObjects.add(toggleButton);
        toggleButton.registerKeyboardAction(this, "lineup", (KeyStroke)this.getValue("AcceleratorKey"), 2);
        return toggleButton;
    }

    public ResizableIcon getResizableIcon() {
        return this.eurocarbIcon.getResizableIcon();
    }

    public ResizableIcon getResizableIcon(ICON_SIZE iconSize) {
        if (this.eurocarbIcon.getIconProperties() == null) {
            return new ImageResizableIconReducedMem(ThemeManager.getEmptyIcon(iconSize).getImage(), iconSize.getSize(), iconSize.getSize());
        }
        return this.eurocarbIcon.getThemeManager().getResizableIcon(this.getEurocarbIcon().getIconProperties().id, iconSize).getResizableIcon();
    }

    public void setSelected(boolean enable) {
        super.setEnabled(enable);
        if (this.jCommandButton != null) {
            this.jCommandButton.setEnabled(enable);
        }
        for (Object component : this.selectAwareObjects) {
            try {
                Method method = component.getClass().getMethod("setSelected", Boolean.TYPE);
                method.invoke(component, enable);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void addComponent(Object component) {
        this.enableAwareObjects.add(component);
    }

    public Object addEnableAware(Object object) {
        this.enableAwareObjects.add(object);
        return object;
    }

    public JCheckBox getJCheckBox(String label, ActionListener listener) {
        return this.getJCheckBox(label, false, listener);
    }

    public JCheckBox getJCheckBox(String label, boolean setSelected, ActionListener listener) {
        JCheckBox checkBox = new JCheckBox(label);
        checkBox.setBorderPainted(false);
        checkBox.setSelected(setSelected);
        checkBox.addActionListener(listener);
        checkBox.setActionCommand(this.getActionCommand());
        this.enableAwareObjects.add(checkBox);
        this.selectAwareObjects.add(checkBox);
        return checkBox;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (this.jCommandButton != null) {
            this.jCommandButton.setEnabled(enable);
        }
        for (Object component : this.enableAwareObjects) {
            try {
                Method method = component.getClass().getMethod("setEnabled", Boolean.TYPE);
                method.invoke(component, enable);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

