/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.FragmentGroup;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.fileutil.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.massutil.MassOptions;
import org.eurocarbdb.application.glycanbuilder.util.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FragmentDocument
extends BaseDocument
implements SAXUtils.SAXWriter {
    protected LinkedList<Glycan> theStructures;
    protected LinkedList<FragmentCollection> theFragments;
    protected LinkedList<Double> theFragmentMZs;
    protected LinkedList<FragmentGroup> theFragmentGroups;
    protected LinkedList<StructuresChangeListener> sc_listeners = new LinkedList();

    @Override
    public int size() {
        return this.theFragments.size();
    }

    public int getNoStructures() {
        return this.theStructures.size();
    }

    public int getNoPeaks() {
        return this.theFragmentMZs.size();
    }

    @Override
    public String getName() {
        return "Fragments";
    }

    @Override
    public ImageIcon getIcon() {
        return FileUtils.themeManager.getImageIcon("fragmentdoc");
    }

    @Override
    public Collection<FileFilter> getFileFormats() {
        LinkedList<FileFilter> filters = new LinkedList<FileFilter>();
        filters.add(new ExtensionFileFilter("gwf", "GlycoWorkbench fragments file"));
        return filters;
    }

    @Override
    public FileFilter getAllFileFormats() {
        return new ExtensionFileFilter("gwf", "Fragments files");
    }

    public void copy(FragmentDocument src) {
        this.setData(src, true);
    }

    private void setData(FragmentDocument src, boolean fire) {
        if (src != null) {
            this.initData();
            for (int i = 0; i < src.getNoStructures(); ++i) {
                this.addFragments(src.getStructure(i), src.getFragments(i));
            }
            if (fire) {
                this.fireStructuresChanged();
                this.fireDocumentChanged();
            }
        }
    }

    public Collection<Glycan> getStructures() {
        return this.theStructures;
    }

    public Glycan getStructure(int s_ind) {
        return this.theStructures.get(s_ind);
    }

    public FragmentCollection getFragments(int s_ind) {
        return this.theFragments.get(s_ind);
    }

    public Double getFragmentMZ(int p_ind) {
        return this.theFragmentMZs.get(p_ind);
    }

    public FragmentGroup getFragmentGroup(int p_ind) {
        return this.theFragmentGroups.get(p_ind);
    }

    public LinkedList<Glycan> getFragments(int p_ind, int s_ind) {
        return this.theFragmentGroups.get(p_ind).getFragments(s_ind);
    }

    public boolean addFragments(Glycan _structure, FragmentCollection _fragments) {
        return this.addFragments(_structure, _fragments, true);
    }

    public boolean addFragments(Glycan _structure, FragmentCollection _fragments, boolean fire) {
        if (_structure == null) {
            return false;
        }
        if (_fragments == null) {
            _fragments = new FragmentCollection();
        }
        Glycan toadds = _structure.clone();
        FragmentCollection toaddf = _fragments.clone();
        this.theStructures.add(toadds);
        this.theFragments.add(toaddf);
        for (FragmentEntry fe : toaddf.getFragments()) {
            this.addFragment(this.theStructures.size() - 1, fe);
        }
        if (fire) {
            this.fireStructuresChanged();
            this.fireDocumentChanged();
        }
        return true;
    }

    public boolean addFragments(int s_ind, Collection<FragmentEntry> toadd) {
        if (s_ind < 0 || s_ind >= this.size()) {
            return false;
        }
        boolean added = false;
        for (FragmentEntry fe : toadd) {
            if (!(added |= this.theFragments.get(s_ind).addFragment(fe))) continue;
            this.addFragment(s_ind, fe);
        }
        if (added) {
            this.fireDocumentChanged();
        }
        return added;
    }

    private void addFragment(int s_ind, FragmentEntry fe) {
        int p_ind;
        for (p_ind = 0; p_ind < this.theFragmentMZs.size() && this.theFragmentMZs.get(p_ind) < fe.mz_ratio; ++p_ind) {
        }
        if (p_ind == this.theFragmentMZs.size() || this.theFragmentMZs.get(p_ind) > fe.mz_ratio + 1.0E-6) {
            this.theFragmentMZs.add(p_ind, fe.mz_ratio);
            this.theFragmentGroups.add(p_ind, new FragmentGroup());
        }
        for (FragmentGroup fg : this.theFragmentGroups) {
            fg.assertSize(s_ind);
        }
        this.theFragmentGroups.get(p_ind).addFragment(s_ind, fe);
    }

    public boolean removeFragments(int s_ind) {
        if (s_ind < 0 || s_ind >= this.size()) {
            return false;
        }
        this.theStructures.remove(s_ind);
        this.theFragments.remove(s_ind);
        for (int p_ind = 0; p_ind < this.theFragmentMZs.size(); ++p_ind) {
            this.theFragmentGroups.get(p_ind).removeFragments(s_ind);
            if (!this.theFragmentGroups.get(p_ind).isEmpty()) continue;
            this.theFragmentGroups.remove(p_ind);
            this.theFragmentMZs.remove(p_ind);
            --p_ind;
        }
        this.fireStructuresChanged();
        this.fireDocumentChanged();
        return true;
    }

    public boolean clearFragmentsFor(int[] p_inds) {
        LinkedList<Double> toremove_mzs = new LinkedList<Double>();
        for (int i = 0; i < p_inds.length; ++i) {
            toremove_mzs.add(this.theFragmentMZs.get(p_inds[i]));
        }
        LinkedList<FragmentGroup> toremove_groups = new LinkedList<FragmentGroup>();
        for (int i = 0; i < p_inds.length; ++i) {
            FragmentGroup fg = this.theFragmentGroups.get(p_inds[i]);
            for (int s_ind = 0; s_ind < this.theStructures.size(); ++s_ind) {
                this.theFragments.get(s_ind).removeFragments(fg.getFragmentEntries(s_ind));
            }
            toremove_groups.add(fg);
        }
        this.theFragmentMZs.removeAll(toremove_mzs);
        this.theFragmentGroups.removeAll(toremove_groups);
        this.fireDocumentChanged();
        return true;
    }

    public boolean removeFragments(int s_ind, Collection<FragmentEntry> toremove) {
        if (s_ind < 0 || s_ind >= this.size()) {
            return false;
        }
        boolean removed = false;
        for (FragmentEntry fe : toremove) {
            int p_ind;
            if (!(removed |= this.theFragments.get(s_ind).removeFragment(fe)) || (p_ind = this.removeFragment(s_ind, fe)) == -1) continue;
            this.theFragmentGroups.remove(p_ind);
            this.theFragmentMZs.remove(p_ind);
        }
        if (removed) {
            this.fireDocumentChanged();
        }
        return removed;
    }

    private int removeFragment(int s_ind, FragmentEntry fe) {
        int p_ind;
        for (p_ind = 0; p_ind < this.theFragmentMZs.size() && this.theFragmentMZs.get(p_ind) < fe.mz_ratio; ++p_ind) {
        }
        if (p_ind == this.theFragmentMZs.size() || this.theFragmentMZs.get(p_ind) > fe.mz_ratio + 1.0E-6) {
            return -1;
        }
        this.theFragmentGroups.get(p_ind).removeFragment(s_ind, fe);
        return p_ind;
    }

    @Override
    public void initData() {
        this.theStructures = new LinkedList();
        this.theFragments = new LinkedList();
        this.theFragmentMZs = new LinkedList();
        this.theFragmentGroups = new LinkedList();
    }

    public void addStructuresChangeListener(StructuresChangeListener l) {
        if (l != null) {
            this.sc_listeners.add(l);
        }
    }

    public void removeStructuresChangeListener(StructuresChangeListener l) {
        if (l != null) {
            this.sc_listeners.remove(l);
        }
    }

    public void fireStructuresChanged() {
        if (this.sc_listeners != null) {
            for (StructuresChangeListener scl : this.sc_listeners) {
                scl.structuresChanged(new StructuresChangeEvent(this));
            }
        }
    }

    @Override
    public void fireDocumentInit() {
        super.fireDocumentInit();
        this.fireStructuresChanged();
    }

    @Override
    public void fireDocumentInit(BaseDocument source) {
        super.fireDocumentInit(source);
        if (source == this) {
            this.fireStructuresChanged();
        }
    }

    @Override
    protected void read(InputStream is, boolean merge) throws Exception {
        SAXUtils.read(is, new SAXHandler(this, merge));
    }

    @Override
    public void fromString(String str, boolean merge) throws Exception {
        this.read(new ByteArrayInputStream(str.getBytes()), merge);
    }

    public String toString() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.write(bos);
            return bos.toString();
        }
        catch (Exception e) {
            LogUtils.report(e);
            return "";
        }
    }

    @Override
    public void write(OutputStream os) throws Exception {
        SAXUtils.write(os, this);
    }

    /*
     * WARNING - void declaration
     */
    public void fromXML(Node root_node, boolean merge) throws Exception {
        void var7_10;
        if (!merge) {
            this.resetStatus();
            this.initData();
        } else {
            this.setChanged(true);
        }
        LinkedList<Glycan> structures = new LinkedList<Glycan>();
        LinkedList<FragmentCollection> fragments = new LinkedList<FragmentCollection>();
        LinkedList<Node> s_nodes = XMLUtils.findAllChildren(root_node, "Glycan");
        for (Node node : s_nodes) {
            structures.add(Glycan.fromXML(node, new MassOptions()));
        }
        LinkedList<Node> fc_nodes = XMLUtils.findAllChildren(root_node, "FragmentCollection");
        for (Node fc_node : fc_nodes) {
            fragments.add(FragmentCollection.fromXML(fc_node));
        }
        if (structures.size() != fragments.size()) {
            throw new Exception("Invalid number of fragments");
        }
        boolean bl = false;
        while (var7_10 < structures.size()) {
            this.addFragments((Glycan)structures.get((int)var7_10), (FragmentCollection)fragments.get((int)var7_10), false);
            ++var7_10;
        }
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element root_node = document.createElement("Fragments");
        if (root_node == null) {
            return null;
        }
        for (Glycan s : this.theStructures) {
            root_node.appendChild(s.toXML(document));
        }
        for (FragmentCollection fc : this.theFragments) {
            root_node.appendChild(fc.toXML(document));
        }
        return root_node;
    }

    @Override
    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "Fragments", new AttributesImpl());
        for (Glycan s : this.theStructures) {
            s.write(th);
        }
        for (FragmentCollection fc : this.theFragments) {
            fc.write(th);
        }
        th.endElement("", "", "Fragments");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private FragmentDocument theDocument;
        private boolean merge;

        public SAXHandler(FragmentDocument _doc, boolean _merge) {
            this.theDocument = _doc;
            this.merge = _merge;
        }

        @Override
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Fragments";
        }

        @Override
        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(Glycan.SAXHandler.getNodeElementName())) {
                return new Glycan.SAXHandler(new MassOptions());
            }
            if (qName.equals(FragmentCollection.SAXHandler.getNodeElementName())) {
                return new FragmentCollection.SAXHandler();
            }
            return null;
        }

        @Override
        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            if (!this.merge) {
                this.theDocument.resetStatus();
                this.theDocument.initData();
            } else {
                this.theDocument.setChanged(true);
            }
            LinkedList<Object> structures = this.getSubObjects(Glycan.SAXHandler.getNodeElementName());
            LinkedList<Object> fragments = this.getSubObjects(FragmentCollection.SAXHandler.getNodeElementName());
            if (structures.size() != fragments.size()) {
                throw new SAXException(this.createMessage("Invalid number of fragments"));
            }
            for (int i = 0; i < structures.size(); ++i) {
                this.theDocument.addFragments((Glycan)structures.get(i), (FragmentCollection)fragments.get(i), false);
            }
            this.object = this.theDocument;
            return this.object;
        }
    }

    public static class StructuresChangeEvent {
        protected FragmentDocument source;

        public StructuresChangeEvent(FragmentDocument _source) {
            this.source = _source;
        }

        public FragmentDocument getSource() {
            return this.source;
        }
    }

    public static interface StructuresChangeListener {
        public void structuresChanged(StructuresChangeEvent var1);
    }
}

