/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResiduePlacement;
import org.eurocarbdb.application.glycanbuilder.renderutil.ResAngle;

public class BookingManager {
    private HashMap<Integer, LinkedList<Residue>> available_positions;
    private HashMap<Residue, ResAngle> assigned_positions;
    private HashMap<Residue, ResiduePlacement> residues = new HashMap();
    private LinkedList<Residue> single_position_residues = new LinkedList();
    private LinkedList<Residue> on_border_residues = new LinkedList();
    private LinkedList<Residue> other_residues = new LinkedList();

    public BookingManager(ResAngle[] avail_positions) {
        this.available_positions = new HashMap();
        this.assigned_positions = new HashMap();
        for (int i = 0; i < avail_positions.length; ++i) {
            this.available_positions.put(avail_positions[i].getIntAngle(), new LinkedList());
        }
    }

    public void add(Residue r, ResiduePlacement rp) throws Exception {
        if (r == null || rp == null) {
            return;
        }
        if (!this.isAvailable(rp)) {
            throw new Exception("Cannot place residue " + r.getTypeName() + " in position(s) " + rp.getStringPositions());
        }
        this.residues.put(r, rp);
        if (rp.getPositions().length == 1) {
            this.single_position_residues.add(r);
        } else if (rp.isOnBorder()) {
            this.on_border_residues.add(r);
        } else {
            this.other_residues.add(r);
        }
    }

    public void place() throws Exception {
        for (Residue r : this.single_position_residues) {
            this.assignPosition(r, this.getPossiblePositions(r)[0]);
        }
        for (Residue r : this.on_border_residues) {
            this.assignPosition(r, this.findOnBorderPosition(r));
        }
        for (Residue r : this.other_residues) {
            this.assignPosition(r, this.findPosition(r));
        }
    }

    public ResAngle getPosition(Residue r) {
        return this.assigned_positions.get(r);
    }

    public ResiduePlacement getPlacement(Residue r) {
        return this.residues.get(r);
    }

    public boolean isAvailable(ResiduePlacement rp) {
        ResAngle[] pos = rp.getPositions();
        for (int i = 0; i < pos.length; ++i) {
            if (!this.isAvailable(pos[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isAvailable(ResAngle p) {
        if (p == null) {
            return false;
        }
        return this.available_positions.get(p.getIntAngle()) != null;
    }

    private LinkedList<Residue> getAssignedResidues(ResAngle p) {
        return this.available_positions.get(p.getIntAngle());
    }

    private void assignPosition(Residue r, ResAngle ra) throws Exception {
        LinkedList<Residue> ar = this.getAssignedResidues(ra);
        if (ar == null) {
            throw new Exception("Cannot assign residue " + r.getTypeName() + " in position " + ra.getIntAngle() + ": position is not available");
        }
        ar.add(r);
        this.assigned_positions.put(r, ra);
    }

    private ResAngle[] getPossiblePositions(Residue r) {
        return this.residues.get(r).getPositions();
    }

    private boolean isOnBorder(Residue r) {
        return this.residues.get(r).isOnBorder();
    }

    private int countOnBorderResidues(ResAngle p) {
        int count = 0;
        Iterator l = this.getAssignedResidues(p).iterator();
        while (l.hasNext()) {
            if (!this.isOnBorder((Residue)l.next())) continue;
            ++count;
        }
        return count;
    }

    private boolean hasEmptyPositions(ResAngle[] pos) {
        for (int i = 0; i < pos.length; ++i) {
            if (this.available_positions.get(pos[i].getIntAngle()) != null && this.available_positions.get(pos[i].getIntAngle()).size() != 0) continue;
            return true;
        }
        return false;
    }

    private ResAngle findOnBorderPosition(Residue r) {
        ResAngle[] positions = this.getPossiblePositions(r);
        if (this.other_residues.size() > 0 || !this.hasEmptyPositions(positions)) {
            for (int i = 0; i < positions.length; ++i) {
                if (this.countOnBorderResidues(positions[i]) != 1) continue;
                return positions[i];
            }
        }
        return this.findPosition(r);
    }

    private ResAngle findPosition(Residue r) {
        ResAngle[] positions = this.getPossiblePositions(r);
        ResAngle best_pos = null;
        int best_occ = 0;
        for (int i = 0; i < positions.length; ++i) {
            ResAngle pos = positions[i];
            if (!this.isAvailable(pos)) continue;
            int occ = this.getAssignedResidues(pos).size();
            if (best_pos != null && occ >= best_occ) continue;
            best_pos = pos;
            best_occ = occ;
        }
        return best_pos;
    }
}

