/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.Linucs;

import java.util.ArrayList;
import java.util.HashMap;
import org.eurocarbdb.MolecularFramework.io.StructureSpecialInformation;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.io.SugarImporterText;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;

public class SugarImporterLinucs
extends SugarImporterText {
    private ArrayList<StructureSpecialInformation> m_aSpecialList = new ArrayList();
    private int m_iRepeatCount = -1;
    private boolean m_bSpezialStart;
    private HashMap<String, Integer> m_hashRepeatInformation = new HashMap();
    private ArrayList<String> m_aWarnings = new ArrayList();

    private void clear() {
        this.m_bSpezialStart = false;
        this.m_iRepeatCount = -1;
        this.m_aSpecialList.clear();
        this.m_hashRepeatInformation.clear();
        this.m_aWarnings.clear();
    }

    @Override
    protected void start() throws SugarImporterException {
        try {
            this.startparsing();
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("LINUCS021", this.m_iPosition);
        }
    }

    protected void startparsing() throws SugarImporterException, GlycoconjugateException {
        UnvalidatedGlycoNode t_objResiduum;
        StructureSpecialInformation t_objSpezialInfo2 = null;
        GlycoGraph t_objSubSugar = this.m_objSugar;
        this.clear();
        int t_iStartPosition = 0;
        String t_strName = "";
        if (this.m_cToken != '[') {
            throw new SugarImporterException("LINUCS001", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != ']') {
            throw new SugarImporterException("LINUCS001", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != '[') {
            throw new SugarImporterException("LINUCS002", this.m_iPosition);
        }
        this.nextToken();
        t_iStartPosition = this.m_iPosition;
        this.residuumname();
        t_strName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
        if (t_strName.equalsIgnoreCase("LINK")) {
            SugarUnitRepeat t_objRepeat;
            this.m_bSpezialStart = true;
            String t_strTemp = "";
            for (int t_iCounter = 0; t_iCounter < 9; ++t_iCounter) {
                t_strTemp = t_strTemp + this.m_cToken;
                this.nextToken();
            }
            if (!t_strTemp.equalsIgnoreCase("]{[(UNTIL")) {
                throw new SugarImporterException("LINUCS013", this.m_iPosition);
            }
            if (this.m_cToken != '+') {
                throw new SugarImporterException("LINUCS009", this.m_iPosition);
            }
            this.nextToken();
            Linkage t_objLinkage = new Linkage();
            t_objLinkage.setChildLinkageType(LinkageType.UNVALIDATED);
            t_objLinkage.setParentLinkageType(LinkageType.UNVALIDATED);
            int t_iResult = this.linkage(t_objLinkage);
            if (this.m_cToken != ')') {
                throw new SugarImporterException("LINUCS010", this.m_iPosition);
            }
            this.nextToken();
            if (this.m_cToken != ']') {
                throw new SugarImporterException("LINUCS010", this.m_iPosition);
            }
            this.nextToken();
            if (this.m_cToken != '[') {
                throw new SugarImporterException("LINUCS002", this.m_iPosition);
            }
            this.nextToken();
            t_iStartPosition = this.m_iPosition;
            this.residuumname();
            t_strName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
            t_objResiduum = new UnvalidatedGlycoNode();
            t_objResiduum.setName(t_strName);
            if (this.isCyclic()) {
                if (t_iResult == 3) {
                    t_objRepeat = new SugarUnitRepeat();
                    t_objSubSugar.addNode(t_objRepeat);
                    t_objSpezialInfo2 = new StructureSpecialInformation(t_objRepeat, t_objLinkage, null, t_objSubSugar);
                    this.m_aSpecialList.add(t_objSpezialInfo2);
                    Linkage t_objInternal = new Linkage();
                    t_objInternal.setChildLinkages(t_objLinkage.getChildLinkages());
                    t_objSpezialInfo2 = new StructureSpecialInformation(t_objResiduum, t_objInternal, this.m_iRepeatCount, t_objRepeat, t_objSpezialInfo2, t_objRepeat);
                    this.m_aSpecialList.add(t_objSpezialInfo2);
                    t_objSubSugar = t_objRepeat;
                    this.m_iRepeatCount = -1;
                    t_objSubSugar.addNode(t_objResiduum);
                } else {
                    t_objSpezialInfo2 = new StructureSpecialInformation(t_objResiduum, t_objLinkage, null, t_objSubSugar);
                    this.m_aSpecialList.add(t_objSpezialInfo2);
                    t_objSubSugar.addNode(t_objResiduum);
                }
            } else if (t_iResult == 3) {
                t_objRepeat = new SugarUnitRepeat();
                SugarUnitRepeat t_objRepeatInternal = new SugarUnitRepeat();
                t_objSpezialInfo2 = new StructureSpecialInformation(t_objRepeatInternal, t_objLinkage, -1, t_objRepeat, null, t_objSubSugar);
                this.m_aSpecialList.add(t_objSpezialInfo2);
                t_objSubSugar.addNode(t_objRepeat);
                t_objSubSugar = t_objRepeat;
                t_objSubSugar.addNode(t_objRepeatInternal);
                Linkage t_objInternal = new Linkage();
                t_objInternal.setChildLinkages(t_objLinkage.getChildLinkages());
                t_objRepeatInternal.setRepeatCount(this.m_iRepeatCount);
                t_objSpezialInfo2 = new StructureSpecialInformation(t_objResiduum, t_objInternal, this.m_iRepeatCount, t_objRepeatInternal, t_objSpezialInfo2, t_objSubSugar);
                this.m_aSpecialList.add(t_objSpezialInfo2);
                t_objSubSugar = t_objRepeatInternal;
                this.m_iRepeatCount = -1;
                t_objSubSugar.addNode(t_objResiduum);
            } else {
                t_objRepeat = new SugarUnitRepeat();
                t_objSpezialInfo2 = new StructureSpecialInformation(t_objResiduum, t_objLinkage, -1, t_objRepeat, null, t_objSubSugar);
                this.m_aSpecialList.add(t_objSpezialInfo2);
                t_objSubSugar.addNode(t_objRepeat);
                t_objSubSugar = t_objRepeat;
                t_objSubSugar.addNode(t_objResiduum);
            }
            if (this.m_cToken != ']') {
                throw new SugarImporterException("LINUCS003", this.m_iPosition);
            }
            this.nextToken();
            if (this.m_cToken != '{') {
                throw new SugarImporterException("LINUCS004", this.m_iPosition);
            }
            this.nextToken();
            while (this.m_cToken != '}') {
                this.subresiduum(t_objResiduum, t_objSpezialInfo2, t_objSubSugar);
            }
            this.nextToken();
            if (this.m_cToken != '}') {
                throw new SugarImporterException("LINUCS005", this.m_iPosition);
            }
            this.nextToken();
        } else {
            this.m_bSpezialStart = false;
            t_objResiduum = new UnvalidatedGlycoNode();
            t_objResiduum.setName(t_strName);
            t_objSubSugar.addNode(t_objResiduum);
            if (this.m_cToken != ']') {
                throw new SugarImporterException("LINUCS003", this.m_iPosition);
            }
            this.nextToken();
            if (this.m_cToken != '{') {
                throw new SugarImporterException("LINUCS004", this.m_iPosition);
            }
            this.nextToken();
            while (this.m_cToken != '}') {
                this.subresiduum(t_objResiduum, t_objSpezialInfo2, t_objSubSugar);
            }
            this.nextToken();
        }
        if (!this.finished()) {
            throw new SugarImporterException("LINUCS006", this.m_iPosition);
        }
        for (StructureSpecialInformation t_objSpezialInfo2 : this.m_aSpecialList) {
            if (t_objSpezialInfo2.isClosed()) continue;
            throw new SugarImporterException("LINUCS018", this.m_iPosition);
        }
    }

    private int linkage(Linkage a_objLinkage) throws SugarImporterException {
        if (this.m_cToken == '?') {
            this.nextToken();
            a_objLinkage.addChildLinkage(-1);
        } else {
            int t_iPos = this.number();
            if (t_iPos == 0) {
                a_objLinkage.addChildLinkage(1);
            } else {
                a_objLinkage.addChildLinkage(t_iPos);
            }
            while (this.m_cToken == '/') {
                this.nextToken();
                a_objLinkage.addChildLinkage(this.natural_number());
            }
        }
        if (this.m_cToken == '>') {
            this.nextToken();
            if (this.m_cToken != ')') {
                this.m_iRepeatCount = this.repeatcount();
            } else {
                this.m_aWarnings.add("No count given for repeat part.");
            }
            return 3;
        }
        return 0;
    }

    private void residuumname() throws SugarImporterException {
        this.symbol();
        while (this.m_cToken != ']') {
            this.symbol();
        }
    }

    private void symbol() throws SugarImporterException {
        char t_iDigit = this.m_cToken;
        if (t_iDigit > '/' && t_iDigit < ':') {
            this.nextToken();
            return;
        }
        if (this.m_cToken == '(' || this.m_cToken == ')' || this.m_cToken == '<' || this.m_cToken == '>') {
            this.nextToken();
            return;
        }
        if (this.m_cToken == ';' || this.m_cToken == ',' || this.m_cToken == ':' || this.m_cToken == ' ') {
            this.nextToken();
            return;
        }
        if (this.m_cToken == '\\' || this.m_cToken == '\'' || this.m_cToken == '-' || this.m_cToken == '?') {
            this.nextToken();
            return;
        }
        if (this.m_cToken == '_' || this.m_cToken == '+' || this.m_cToken == '.' || this.m_cToken == '=') {
            this.nextToken();
            return;
        }
        if (this.m_cToken == '/') {
            this.nextToken();
            return;
        }
        this.character();
    }

    private void subresiduum(GlycoNode a_objParentResiduum, StructureSpecialInformation a_objSpezialInfo, GlycoGraph a_objSugar) throws SugarImporterException, GlycoconjugateException {
        UnvalidatedGlycoNode t_objChild;
        GlycoEdge t_objEdge;
        StructureSpecialInformation t_objSpezialInfo = a_objSpezialInfo;
        GlycoNode t_objParent = a_objParentResiduum;
        int t_iResultR = -1;
        int t_iResultN = -1;
        int t_iStartPosition = 0;
        Linkage t_objLinkage = new Linkage();
        GlycoGraph t_objSugar = a_objSugar;
        if (this.m_cToken != '[') {
            throw new SugarImporterException("LINUCS008", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != '(') {
            throw new SugarImporterException("LINUCS008", this.m_iPosition);
        }
        this.nextToken();
        t_iResultR = this.link_r(t_objLinkage);
        if (t_iResultR == 1) {
            if (t_objSpezialInfo == null) {
                throw new SugarImporterException("LINUCS017", this.m_iPosition);
            }
            if (t_objSpezialInfo.getType() != 2) {
                throw new SugarImporterException("LINUCS017", this.m_iPosition);
            }
            if (t_objSpezialInfo.isClosed()) {
                throw new SugarImporterException("LINUCS019", this.m_iPosition);
            }
            t_objSpezialInfo.close();
            Linkage t_objInternalLinkage = t_objSpezialInfo.getIncomingLinkage();
            t_objInternalLinkage.setParentLinkages(t_objLinkage.getParentLinkages());
            GlycoNode t_objTarget = t_objSpezialInfo.getTarget();
            t_objEdge = new GlycoEdge();
            t_objEdge.addGlycosidicLinkage(t_objInternalLinkage);
            t_objSpezialInfo.getRepeatBlock().setRepeatLinkage(t_objEdge, t_objParent, t_objTarget);
            t_objParent = t_objSpezialInfo.getRepeatBlock();
            t_objSugar = t_objSpezialInfo.getParentUnit();
            t_objSpezialInfo = t_objSpezialInfo.getParentInfo();
        } else if (t_iResultR == 2 || t_iResultR == 3 || t_iResultR == 4) {
            t_objLinkage.addChildLinkage(-1);
            t_objLinkage.addParentLinkage(1);
            t_objChild = new UnvalidatedGlycoNode();
            if (t_iResultR == 2) {
                t_objChild.setName("N");
            } else if (t_iResultR == 3) {
                t_objChild.setName("S");
            } else {
                t_objChild.setName("P");
            }
            t_objSugar.addNode(t_objChild);
            t_objEdge = new GlycoEdge();
            t_objEdge.addGlycosidicLinkage(t_objLinkage);
            t_objSugar.addEdge(t_objParent, t_objChild, t_objEdge);
            t_objLinkage = new Linkage();
            t_objLinkage.addParentLinkage(1);
            t_objParent = t_objChild;
        }
        if (this.m_cToken != '+') {
            throw new SugarImporterException("LINUCS009", this.m_iPosition);
        }
        this.nextToken();
        t_iResultN = this.link_n(t_objLinkage);
        if (t_iResultN == 1 || t_iResultN == 2) {
            if (!this.m_bSpezialStart) {
                if (t_iResultN == 1) {
                    throw new SugarImporterException("LINUCS014", this.m_iPosition);
                }
                throw new SugarImporterException("LINUCS015", this.m_iPosition);
            }
            String t_strTemp = "";
            for (int t_iCounter = 0; t_iCounter < 10; ++t_iCounter) {
                t_strTemp = t_strTemp + this.m_cToken;
                this.nextToken();
            }
            if (!t_strTemp.equalsIgnoreCase(")][LINK]{}")) {
                throw new SugarImporterException("LINUCS016", this.m_iPosition);
            }
            if (t_iResultN == 1) {
                if (t_objSpezialInfo == null) {
                    throw new SugarImporterException("LINUCS014", this.m_iPosition);
                }
                if (t_objSpezialInfo.getType() != 2) {
                    throw new SugarImporterException("LINUCS014", this.m_iPosition);
                }
                if (t_objSpezialInfo.isClosed()) {
                    throw new SugarImporterException("LINUCS019", this.m_iPosition);
                }
                t_objSpezialInfo.close();
                Linkage t_objInternalLinkage = t_objSpezialInfo.getIncomingLinkage();
                t_objInternalLinkage.setParentLinkages(t_objLinkage.getParentLinkages());
                GlycoNode t_objTarget = t_objSpezialInfo.getTarget();
                t_objEdge = new GlycoEdge();
                t_objEdge.addGlycosidicLinkage(t_objInternalLinkage);
                t_objSpezialInfo.getRepeatBlock().setRepeatLinkage(t_objEdge, t_objParent, t_objTarget);
            } else {
                if (t_objSpezialInfo == null) {
                    throw new SugarImporterException("LINUCS015", this.m_iPosition);
                }
                if (t_objSpezialInfo.getType() != 1) {
                    throw new SugarImporterException("LINUCS015", this.m_iPosition);
                }
                if (t_objSpezialInfo.isClosed()) {
                    throw new SugarImporterException("LINUCS019", this.m_iPosition);
                }
                t_objSpezialInfo.close();
                Linkage t_objInternalLinkage = t_objSpezialInfo.getIncomingLinkage();
                t_objInternalLinkage.setParentLinkages(t_objLinkage.getParentLinkages());
                t_objEdge = new GlycoEdge();
                t_objEdge.addGlycosidicLinkage(t_objInternalLinkage);
                GlycoNode t_objTarget = t_objSpezialInfo.getTarget();
                t_objSugar.addEdge(t_objParent, t_objTarget, t_objEdge);
            }
            return;
        }
        if (t_iResultN == 4 || t_iResultN == 5 || t_iResultN == 6) {
            t_objLinkage.addChildLinkage(1);
            t_objChild = new UnvalidatedGlycoNode();
            if (t_iResultN == 4) {
                t_objChild.setName("N");
            } else if (t_iResultN == 5) {
                t_objChild.setName("S");
            } else {
                t_objChild.setName("P");
            }
            t_objSugar.addNode(t_objChild);
            t_objEdge = new GlycoEdge();
            t_objEdge.addGlycosidicLinkage(t_objLinkage);
            t_objSugar.addEdge(t_objParent, t_objChild, t_objEdge);
            t_objLinkage = new Linkage();
            t_objLinkage.addParentLinkage(1);
            t_objLinkage.addChildLinkage(-1);
            t_objParent = t_objChild;
        }
        if (this.m_cToken != ')') {
            throw new SugarImporterException("LINUCS010", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != ']') {
            throw new SugarImporterException("LINUCS010", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != '[') {
            throw new SugarImporterException("LINUCS002", this.m_iPosition);
        }
        this.nextToken();
        t_iStartPosition = this.m_iPosition;
        this.residuumname();
        UnvalidatedGlycoNode t_objResiduum = new UnvalidatedGlycoNode();
        t_objResiduum.setName(this.m_strText.substring(t_iStartPosition, this.m_iPosition));
        if (t_iResultN == 3) {
            Linkage t_objInternal = new Linkage();
            t_objInternal.setChildLinkages(t_objLinkage.getChildLinkages());
            SugarUnitRepeat t_objRepeat = new SugarUnitRepeat();
            t_objRepeat.setRepeatCount(this.m_iRepeatCount);
            t_objSugar.addNode(t_objRepeat);
            t_objEdge = new GlycoEdge();
            t_objEdge.addGlycosidicLinkage(t_objLinkage);
            t_objSugar.addEdge(t_objParent, t_objRepeat, t_objEdge);
            t_objSpezialInfo = new StructureSpecialInformation(t_objResiduum, t_objInternal, this.m_iRepeatCount, t_objRepeat, t_objSpezialInfo, t_objSugar);
            this.m_aSpecialList.add(t_objSpezialInfo);
            this.m_iRepeatCount = -1;
            t_objSugar = t_objRepeat;
            t_objSugar.addNode(t_objResiduum);
        } else {
            t_objSugar.addNode(t_objResiduum);
            t_objEdge = new GlycoEdge();
            t_objEdge.addGlycosidicLinkage(t_objLinkage);
            t_objSugar.addEdge(t_objParent, t_objResiduum, t_objEdge);
        }
        if (this.m_cToken != ']') {
            throw new SugarImporterException("LINUCS003", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != '{') {
            throw new SugarImporterException("LINUCS004", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken != '}') {
            this.subresiduum(t_objResiduum, t_objSpezialInfo, t_objSugar);
        }
        if (this.m_cToken != '}') {
            throw new SugarImporterException("LINUCS005", this.m_iPosition);
        }
        this.nextToken();
    }

    private int link_n(Linkage a_objLinkage) throws SugarImporterException {
        if (this.m_cToken == 'R' || this.m_cToken == 'r') {
            String t_strTemp = "";
            for (int t_iCounter = 0; t_iCounter < 6; ++t_iCounter) {
                t_strTemp = t_strTemp + this.m_cToken;
                this.nextToken();
            }
            if (!t_strTemp.equalsIgnoreCase("REPEAT")) {
                throw new SugarImporterException("LINUCS011", this.m_iPosition);
            }
            return 1;
        }
        if (this.m_cToken == '?') {
            this.nextToken();
            a_objLinkage.addChildLinkage(-1);
            if (this.m_cToken == '>') {
                this.nextToken();
                if (this.m_cToken != ')') {
                    this.m_iRepeatCount = this.repeatcount();
                } else {
                    this.m_aWarnings.add("No count given for repeat part.");
                }
                return 3;
            }
            return 0;
        }
        if (this.m_cToken == 'N') {
            a_objLinkage.addChildLinkage(1);
            this.nextToken();
            return 0;
        }
        if (this.m_cToken == 'S') {
            a_objLinkage.addChildLinkage(1);
            this.nextToken();
            return 0;
        }
        if (this.m_cToken == 'P') {
            this.nextToken();
            return 6;
        }
        if (this.m_cToken == 'c' || this.m_cToken == 'C') {
            String t_strTemp = "";
            for (int t_iCounter = 0; t_iCounter < 6; ++t_iCounter) {
                t_strTemp = t_strTemp + this.m_cToken;
                this.nextToken();
            }
            if (!t_strTemp.equalsIgnoreCase("CYCLIC")) {
                throw new SugarImporterException("LINUCS012", this.m_iPosition);
            }
            return 2;
        }
        int t_iPos = this.number();
        if (t_iPos == 0) {
            a_objLinkage.addChildLinkage(1);
        } else {
            a_objLinkage.addChildLinkage(t_iPos);
        }
        while (this.m_cToken == '/') {
            this.nextToken();
            a_objLinkage.addChildLinkage(this.natural_number());
        }
        if (this.m_cToken == '>') {
            this.nextToken();
            if (this.m_cToken != ')') {
                this.m_iRepeatCount = this.repeatcount();
            } else {
                this.m_aWarnings.add("No count given for repeat part.");
            }
            return 3;
        }
        return 0;
    }

    private int repeatcount() throws SugarImporterException {
        int t_iResult = -1;
        char t_iTemp = this.m_cToken;
        if (t_iTemp > '/' && t_iTemp < ':') {
            t_iResult = this.number();
            if (this.m_cToken == 'X') {
                this.nextToken();
            }
        } else {
            Integer t_iCount;
            String t_strWildcard = "";
            t_strWildcard = t_strWildcard + this.m_cToken;
            this.character();
            if (this.m_cToken == 'X') {
                this.nextToken();
            }
            if ((t_iCount = this.m_hashRepeatInformation.get(t_strWildcard)) == null) {
                this.m_aWarnings.add("Repeatcount not set for symbol : " + t_strWildcard);
                t_iResult = -1;
            } else {
                t_iResult = t_iCount;
            }
        }
        return t_iResult;
    }

    private int link_r(Linkage a_objLinkage) throws SugarImporterException {
        if (this.m_cToken == '?') {
            a_objLinkage.addParentLinkage(-1);
            this.nextToken();
            return 0;
        }
        if (this.m_cToken == 'N') {
            this.nextToken();
            a_objLinkage.addParentLinkage(1);
            return 0;
        }
        if (this.m_cToken == 'S') {
            this.nextToken();
            a_objLinkage.addParentLinkage(1);
            return 0;
        }
        if (this.m_cToken == 'P') {
            this.nextToken();
            return 4;
        }
        if (this.m_cToken == '<') {
            this.nextToken();
            if (this.m_cToken == '?') {
                a_objLinkage.addParentLinkage(-1);
                this.nextToken();
            } else {
                a_objLinkage.addParentLinkage(this.number());
                while (this.m_cToken == '/') {
                    this.nextToken();
                    a_objLinkage.addParentLinkage(this.natural_number());
                }
            }
            return 1;
        }
        int t_iPos = this.number();
        if (t_iPos == 0) {
            a_objLinkage.addParentLinkage(1);
        } else {
            a_objLinkage.addParentLinkage(t_iPos);
        }
        while (this.m_cToken == '/') {
            this.nextToken();
            a_objLinkage.addParentLinkage(this.natural_number());
        }
        return 0;
    }

    private boolean isCyclic() {
        String t_strTemp = this.m_strText.toUpperCase();
        return t_strTemp.indexOf("CYCLIC)][LINK]") != -1;
    }

    public void setRepeatCount(HashMap<String, Integer> a_hashInformation) {
        this.m_hashRepeatInformation = a_hashInformation;
    }

    public ArrayList<String> getWarnings() {
        return this.m_aWarnings;
    }
}

