/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.bitmap.BitmapRendererEventProducer;
import org.apache.fop.render.bitmap.MultiFileRenderingUtil;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;

public class PNGRenderer
extends Java2DRenderer {
    public static final String MIME_TYPE = "image/png";
    private static final String PNG_FILE_EXTENSION = "png";
    private OutputStream firstOutputStream;
    private MultiFileRenderingUtil multiFileUtil;

    public PNGRenderer(FOUserAgent userAgent) {
        super(userAgent);
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.info("rendering areas to PNG");
        this.multiFileUtil = new MultiFileRenderingUtil(PNG_FILE_EXTENSION, this.getUserAgent().getOutputFile());
        this.firstOutputStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRenderer() throws IOException {
        super.stopRenderer();
        for (int i = 0; i < this.pageViewportList.size(); ++i) {
            OutputStream os = this.getCurrentOutputStream(i);
            if (os == null) {
                BitmapRendererEventProducer eventProducer = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                eventProducer.stoppingAfterFirstPageNoFilename(this);
                break;
            }
            try {
                PageViewport pv = (PageViewport)this.pageViewportList.get(i);
                BufferedImage image = this.getPageImage(pv);
                if (log.isDebugEnabled()) {
                    log.debug("Encoding page " + (i + 1));
                }
                this.writeImage(os, image);
                continue;
            }
            finally {
                if (os != this.firstOutputStream) {
                    IOUtils.closeQuietly(os);
                }
            }
        }
    }

    private void writeImage(OutputStream os, RenderedImage image) throws IOException {
        ImageWriterParams params = new ImageWriterParams();
        params.setResolution(Math.round(this.userAgent.getTargetResolution()));
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor(this.getMimeType());
        if (writer == null) {
            BitmapRendererEventProducer eventProducer = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.noImageWriterFound(this, this.getMimeType());
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Writing image using " + writer.getClass().getName());
            }
            writer.writeImage(image, os, params);
        }
    }

    protected OutputStream getCurrentOutputStream(int pageNumber) throws IOException {
        if (pageNumber == 0) {
            return this.firstOutputStream;
        }
        return this.multiFileUtil.createOutputStream(pageNumber);
    }
}

