/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.XMLHandler;
import org.apache.xmlgraphics.util.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLHandlerRegistry {
    private static Log log = LogFactory.getLog(XMLHandlerRegistry.class);
    private Map<String, List<XMLHandler>> handlers = new HashMap<String, List<XMLHandler>>();

    public XMLHandlerRegistry() {
        this.discoverXMLHandlers();
    }

    private void setDefaultXMLHandler(XMLHandler handler) {
        this.addXMLHandler("*", handler);
    }

    public void addXMLHandler(String classname) {
        try {
            XMLHandler handlerInstance = (XMLHandler)Class.forName(classname).newInstance();
            this.addXMLHandler(handlerInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + classname);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + classname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(classname + " is not an " + XMLHandler.class.getName());
        }
    }

    public void addXMLHandler(XMLHandler handler) {
        String ns = handler.getNamespace();
        if (ns == null) {
            this.setDefaultXMLHandler(handler);
        } else {
            this.addXMLHandler(ns, handler);
        }
    }

    private void addXMLHandler(String ns, XMLHandler handler) {
        List<XMLHandler> lst = this.handlers.get(ns);
        if (lst == null) {
            lst = new ArrayList<XMLHandler>();
            this.handlers.put(ns, lst);
        }
        lst.add(handler);
    }

    public XMLHandler getXMLHandler(Renderer renderer, String ns) {
        List<XMLHandler> lst = this.handlers.get(ns);
        XMLHandler handler = this.getXMLHandler(renderer, lst);
        if (handler == null) {
            lst = this.handlers.get("*");
            handler = this.getXMLHandler(renderer, lst);
        }
        return handler;
    }

    private XMLHandler getXMLHandler(Renderer renderer, List<XMLHandler> lst) {
        if (lst != null) {
            int c = lst.size();
            for (int i = 0; i < c; ++i) {
                XMLHandler handler = lst.get(i);
                if (!handler.supportsRenderer(renderer)) continue;
                return handler;
            }
        }
        return null;
    }

    private void discoverXMLHandlers() {
        Iterator<Object> providers = Service.providers(XMLHandler.class);
        if (providers != null) {
            while (providers.hasNext()) {
                XMLHandler handler = (XMLHandler)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Dynamically adding XMLHandler: " + handler.getClass().getName());
                    }
                    this.addXMLHandler(handler);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while adding XMLHandler", e);
                }
            }
        }
    }
}

