/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.Filter;
import chrriis.common.UIUtils;
import chrriis.dj.nativeswing.NSSystemProperty;
import chrriis.dj.nativeswing.NativeComponentProxy;
import chrriis.dj.nativeswing.NativeComponentWrapper;
import chrriis.dj.nativeswing.NativeSwing;
import com.sun.jna.examples.WindowUtils;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

class NativeComponentProxyPanel
extends NativeComponentProxy {
    private static final boolean IS_DEBUGGING_SHAPE = Boolean.parseBoolean(NSSystemProperty.COMPONENTS_DEBUG_PRINTSHAPECOMPUTING.get());
    private boolean isProxiedFiliation;
    private AWTEventListener shapeAdjustmentEventListener;
    private boolean isDestructionOnFinalization;
    private boolean isVisibilityConstrained;
    private HierarchyBoundsListener hierarchyBoundsListener = new HierarchyBoundsListener(){

        public void ancestorMoved(HierarchyEvent e) {
            Component component = e.getChanged();
            if (component instanceof Window) {
                return;
            }
            NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
        }

        public void ancestorResized(HierarchyEvent e) {
            NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            this.adjustFocus();
        }

        protected void adjustFocus() {
            Container parent = NativeComponentProxyPanel.this;
            while (parent != null && !(parent instanceof Window)) {
                if (parent instanceof JInternalFrame) {
                    Window windowAncestor = SwingUtilities.getWindowAncestor(NativeComponentProxyPanel.this);
                    if (windowAncestor == null) break;
                    boolean focusableWindowState = windowAncestor.getFocusableWindowState();
                    windowAncestor.setFocusableWindowState(false);
                    try {
                        ((JInternalFrame)parent).setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    windowAncestor.setFocusableWindowState(focusableWindowState);
                    break;
                }
                parent = parent.getParent();
            }
        }
    };
    private volatile boolean isInvoking;
    private Rectangle[] lastArea = new Rectangle[]{new Rectangle(this.getSize())};
    private EmbeddedPanel embeddedPanel;
    private HierarchyListener hierarchyListener;

    NativeComponentProxyPanel(NativeComponentWrapper nativeComponentWrapper, boolean isVisibilityConstrained, boolean isDestructionOnFinalization, boolean isProxiedFiliation) {
        super(nativeComponentWrapper);
        this.isDestructionOnFinalization = isDestructionOnFinalization;
        this.isVisibilityConstrained = isVisibilityConstrained;
        this.hierarchyListener = new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                long changeFlags = e.getChangeFlags();
                if ((changeFlags & 4L) != 0L) {
                    if (NativeComponentProxyPanel.this.isVisibilityConstrained) {
                        NativeComponentProxyPanel.this.adjustEmbeddedPanelShape();
                    } else {
                        NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
                    }
                }
            }
        };
        if (isVisibilityConstrained) {
            this.shapeAdjustmentEventListener = new AWTEventListener(){

                public void eventDispatched(AWTEvent e) {
                    boolean isAdjustingShape = false;
                    switch (e.getID()) {
                        case 100: 
                        case 101: 
                        case 300: 
                        case 301: {
                            isAdjustingShape = true;
                            break;
                        }
                        case 102: 
                        case 103: {
                            if (!(e.getSource() instanceof Window)) break;
                            isAdjustingShape = true;
                        }
                    }
                    if (isAdjustingShape && NativeComponentProxyPanel.this.nativeComponentWrapper.getNativeComponentProxy() == NativeComponentProxyPanel.this) {
                        NativeComponentProxyPanel.this.adjustEmbeddedPanelShape();
                    }
                }
            };
        }
        this.isProxiedFiliation = isProxiedFiliation;
    }

    private void adjustEmbeddedPanelBounds() {
        boolean isShowing;
        if (this.embeddedPanel == null) {
            return;
        }
        if (!this.isVisibilityConstrained && (isShowing = this.isShowing()) != this.embeddedPanel.isVisible()) {
            this.embeddedPanel.setVisible(isShowing);
        }
        Point location = SwingUtilities.convertPoint(this, new Point(0, 0), this.embeddedPanel.getParent());
        Dimension size = this.getSize();
        Rectangle bounds = new Rectangle(location.x, location.y, size.width, size.height);
        if (!this.embeddedPanel.getBounds().equals(bounds)) {
            this.embeddedPanel.setBounds(bounds);
            this.embeddedPanel.invalidate();
            this.embeddedPanel.validate();
            this.embeddedPanel.repaint();
            if (this.isVisibilityConstrained) {
                this.adjustEmbeddedPanelShape();
            }
        }
    }

    private void adjustEmbeddedPanelShape() {
        if (this.isInvoking) {
            return;
        }
        this.isInvoking = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NativeComponentProxyPanel.this.isInvoking = false;
                NativeComponentProxyPanel.this.adjustEmbeddedPanelShape_();
            }
        });
    }

    private void adjustEmbeddedPanelShape_() {
        if (this.embeddedPanel == null) {
            return;
        }
        Object[] rectangles = this.computePeerShapeArea();
        if (Arrays.equals(this.lastArea, rectangles)) {
            return;
        }
        this.lastArea = rectangles;
        if (rectangles.length == 0) {
            this.embeddedPanel.setVisible(false);
        } else {
            if (!this.embeddedPanel.isVisible()) {
                this.embeddedPanel.setVisible(true);
            }
            WindowUtils.setComponentMask((Component)this.embeddedPanel, (Rectangle[])rectangles);
        }
    }

    private Rectangle[] computePeerShapeArea() {
        if (IS_DEBUGGING_SHAPE) {
            System.err.println("Computing shape: [" + this.getWidth() + "x" + this.getHeight() + "] " + this.nativeComponentWrapper.getComponentDescription());
        }
        Rectangle[] shape = UIUtils.getComponentVisibleArea(this, new Filter<Component>(){

            @Override
            public boolean accept(Component c) {
                Rectangle intersectionRectangle;
                boolean isAccepted;
                boolean bl = isAccepted = !(c instanceof EmbeddedPanel);
                if (IS_DEBUGGING_SHAPE && isAccepted && !(intersectionRectangle = SwingUtilities.convertRectangle(c, new Rectangle(c.getSize()), NativeComponentProxyPanel.this).intersection(new Rectangle(NativeComponentProxyPanel.this.getSize()))).isEmpty()) {
                    System.err.println("  -> Subtracting [" + intersectionRectangle.x + "," + intersectionRectangle.y + "," + intersectionRectangle.width + "x" + intersectionRectangle.height + "] " + c);
                }
                return isAccepted;
            }
        }, false);
        return shape;
    }

    public void paint(Graphics g) {
        super.paint(g);
        NativeComponentWrapper[] nativeComponentWrapperArray = NativeSwing.getNativeComponentWrappers();
        int n = nativeComponentWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            NativeComponentWrapper ncw = nativeComponentWrapperArray[n2];
            NativeComponentProxy nativeComponentProxy = ncw.getNativeComponentProxy();
            if (nativeComponentProxy instanceof NativeComponentProxyPanel && ((NativeComponentProxyPanel)nativeComponentProxy).isVisibilityConstrained) {
                ((NativeComponentProxyPanel)nativeComponentProxy).adjustEmbeddedPanelShape();
            }
            ++n2;
        }
    }

    public void reshape(int x, int y, int w, int h) {
        if (x == this.getX() && y == this.getY() && w == this.getWidth() && h == this.getHeight()) {
            return;
        }
        super.reshape(x, y, w, h);
        this.adjustEmbeddedPanelBounds();
    }

    public void addNotify() {
        boolean isEmbeddedPanelCreated;
        super.addNotify();
        if (this.hierarchyListener != null) {
            this.addHierarchyListener(this.hierarchyListener);
        }
        if (this.shapeAdjustmentEventListener != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.shapeAdjustmentEventListener, 3L);
        }
        boolean bl = isEmbeddedPanelCreated = this.embeddedPanel != null;
        if (!isEmbeddedPanelCreated) {
            this.embeddedPanel = new EmbeddedPanel();
            this.embeddedPanel.add(this.nativeComponentWrapper.getNativeComponent(), "Center");
        }
        this.adjustEmbeddedPanelBounds();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NativeComponentProxyPanel.this.addHierarchyBoundsListener(NativeComponentProxyPanel.this.hierarchyBoundsListener);
                NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
            }
        });
        this.nativeComponentWrapper.getNativeComponent().addMouseListener(this.mouseListener);
        if (!isEmbeddedPanelCreated) {
            Container parent = this;
            while ((parent = parent.getParent()) != null) {
                if (parent.isLightweight() || !(parent instanceof RootPaneContainer)) continue;
                if (this.isProxiedFiliation) {
                    JLayeredPane layeredPane = ((RootPaneContainer)((Object)parent)).getLayeredPane();
                    layeredPane.setLayer(this.embeddedPanel, Integer.MIN_VALUE);
                    layeredPane.add(this.embeddedPanel);
                } else {
                    this.add((Component)this.embeddedPanel, "Center");
                }
                return;
            }
            throw new IllegalStateException("The window ancestor must be a root pane container!");
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.hierarchyListener != null) {
            this.removeHierarchyListener(this.hierarchyListener);
        }
        if (this.shapeAdjustmentEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.shapeAdjustmentEventListener);
        }
        if (this.isDestructionOnFinalization) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NativeComponentProxyPanel.this.removeHierarchyBoundsListener(NativeComponentProxyPanel.this.hierarchyBoundsListener);
                    NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
                }
            });
            this.nativeComponentWrapper.getNativeComponent().removeMouseListener(this.mouseListener);
            if (this.isVisibilityConstrained) {
                this.adjustEmbeddedPanelShape();
            } else {
                this.adjustEmbeddedPanelBounds();
            }
            return;
        }
        this.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.embeddedPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NativeComponentProxyPanel.this.dispose();
                }
            });
        }
    }

    public void dispose() {
        if (this.embeddedPanel == null) {
            return;
        }
        EmbeddedPanel panel = this.embeddedPanel;
        this.embeddedPanel = null;
        Container parent = panel.getParent();
        if (parent != null) {
            parent.remove(panel);
            parent.invalidate();
            parent.validate();
            parent.repaint();
        }
    }

    public Dimension getPreferredSize() {
        if (this.embeddedPanel != null) {
            return this.embeddedPanel.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    private static class EmbeddedPanel
    extends Panel
    implements NativeComponentWrapper.NativeComponentHolder {
        public EmbeddedPanel() {
            super(new BorderLayout());
        }

        public boolean contains(int x, int y) {
            return false;
        }

        public boolean contains(Point p) {
            return false;
        }
    }
}

