package at.tugraz.genome.viewer3d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.StringTokenizer;
import java.util.Vector;

import org.jogamp.java3d.AmbientLight;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Billboard;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.DistanceLOD;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.IndexedTriangleStripArray;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.SpotLight;
import org.jogamp.java3d.Switch;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.border.Border;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;


import org.jogamp.java3d.utils.behaviors.mouse.MouseRotate;
import org.jogamp.java3d.utils.behaviors.mouse.MouseTranslate;
import org.jogamp.java3d.utils.behaviors.mouse.MouseZoom;
import org.jogamp.java3d.utils.behaviors.mouse.MouseWheelZoom;
import org.jogamp.java3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import org.jogamp.java3d.utils.geometry.Text2D;
import org.jogamp.java3d.utils.universe.SimpleUniverse;





public class MapViewer extends Panel implements ActionListener
{
  
  /**
   * 
   */
  private static final long serialVersionUID = -174204913154932068L;
  protected final static Color DEFAULT_COLOR1 = new Color(000,153,102);
  protected final static Color DEFAULT_COLOR2 = new Color(255,255,000);
  protected final static Color DEFAULT_COLOR3 = new Color(255,255,000);
  protected final static Color DEFAULT_COLOR4 = new Color(255,000,000);
  
  public final static String CMD_SHOW_TEXTURE = "showTexture";
  public final static String CMD_SHOW_LIGHT = "showLight";
  public final static String CMD_ADD_RES_LEVEL = "addResolutionLevel";
  public final static String CMD_UPDATE_RES_LEVEL = "updateResolutionLevel";
  public final static String CMD_REMOVE_RES_LEVEL = "removeResolutionLevel";
  
  protected final static Appearance appearanceWhite_ = createWhiteAppearance();
  
  protected Panel topMenuBar;
  protected Panel rightMenuBar;
  
  protected String stretchXString = "Stretch X:";
  protected String stretchYString = "Stretch Y:";
  protected String stretchZString = "Stretch Z:";
  
  protected JLabel stretchLabelX ;
  protected JLabel stretchLabelY; 
  protected JLabel stretchLabelZ;
  protected JTextField stretchXField;
  protected JTextField stretchYField;
  protected JTextField stretchZField;
  
  protected JCheckBox showLightCheckBox;
  protected JCheckBox showTextureCheckBox;
  
  protected Vector<JLabel> resolutionLabels;
  protected Vector<JLabel> resolutionXLabels;
  protected Vector<JLabel> resolutionZLabels;
  protected Vector<JLabel> resolutionDistLabels;
  protected Vector<JTextField> resolutionXText;
  protected Vector<JTextField> resolutionZText;
  protected Vector<JTextField> resolutionDistText;
  protected String resolutionLabelXString = "x: ";
  protected String resolutionLabelZString = "z: ";
  protected String resolutionLabelDistString = "d: ";
  
  protected JButton addResolutionLevel;
  protected JButton removeResolutionLevel;
  protected JButton updateResolutionLevel1;
  protected JButton updateResolutionLevel2;
  
  protected String xAxisString = "x";
  protected String yAxisString = "y";
  protected String zAxisString = "z";
  
  protected TransformGroup view_tg;
  
  protected SimpleUniverse universe;
  protected Canvas3D canvas3D;
  private final static GraphicsConfiguration config_ = SimpleUniverse.getPreferredConfiguration();
  protected float[][] data;
  
  private float maxIntensity;
  protected BufferedImage gradient_;
  
  private int defaultNrOfGradientPixels = 10000;
    
  protected IndexedTriangleStripArray[] stripArrays_;
  
  
  public MapViewer(float[][] data) 
  {    
    this.data = data;
    

  }
  
  
  public void init(){
    this.setLayout(new BorderLayout());
    this.createTopMenu();
    this.createRightMenu();
    canvas3D = new Canvas3D(config_);
    this.add("Center", canvas3D);
    this.initJ3D();
  }
  
  protected void initJ3D(){
    
    universe = new SimpleUniverse(canvas3D);
    Point3d basis = new Point3d(-0.5+this.getInitialXStretchValue()/2, -0.5+this.getInitialYStretchValue()/2, -0.5+this.getInitialZStretchValue()/2);

    this.view_tg = universe.getViewingPlatform().getViewPlatformTransform();
    setInitialViewPoint(view_tg, basis);
    BranchGroup scene = new BranchGroup();


    Vector<Node> objectsToDisplay = new Vector<Node>();
    Node[] nodes =  this.createGeometry();
    for (int i=0; i!=nodes.length;i++ ){
      objectsToDisplay.add(nodes[i]);
    }
    objectsToDisplay.addAll(this.generateAxes());
    Vector<Node> lights = this.createLights();
    for (int i=0; i!=lights.size();i++ ){
      objectsToDisplay.add(lights.get(i));
    }
    
    this.createInteractionObjects(scene, objectsToDisplay);
    universe.addBranchGraph(scene);    

  }

  
  protected void createTopMenu()
  {
    
    topMenuBar=new Panel();
    topMenuBar.setPreferredSize(new Dimension(100,30));
    topMenuBar.setBackground(new Color(50,50,50));
    //topMenuBar.setBorder(BorderFactory.createEmptyBorder());
    
    topMenuBar.setLayout(new GridBagLayout());
    
    this.add(topMenuBar, BorderLayout.NORTH);
    
    Font toolBarFont=new Font("Dialog",Font.PLAIN,11);

    this.stretchLabelX = new JLabel(this.getStretchXLabel());
    this.setStandardJLabelProperties(this.stretchLabelX);
    topMenuBar.add(this.stretchLabelX,new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 5, 0, 0), 0, 0));
    //this.topMenuBar.add(this.stretchLabelX);
    this.stretchXField = new JTextField(3);
    this.setStandardJTextProperties(this.stretchXField);
    this.stretchXField.setText(String.valueOf(this.getInitialXStretchValue()));
    this.stretchXField.setSize(10, 5);
    topMenuBar.add(this.stretchXField,new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 2), 0, 0));
    
    this.stretchLabelY = new JLabel(this.getStretchYLabel());
    this.setStandardJLabelProperties(this.stretchLabelY);
    topMenuBar.add(this.stretchLabelY,new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 5, 0, 0), 0, 0));
    this.stretchYField = new JTextField(3);
    this.setStandardJTextProperties(this.stretchYField);
    this.stretchYField.setText(String.valueOf(this.getInitialYStretchValue()));
    this.stretchYField.setSize(10, 5);
    topMenuBar.add(this.stretchYField,new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 2), 0, 0));
    
    this.stretchLabelZ = new JLabel(this.getStretchZLabel());
    this.setStandardJLabelProperties(this.stretchLabelZ);
    topMenuBar.add(this.stretchLabelZ,new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 5, 0, 0), 0, 0));
    this.stretchZField = new JTextField(3);
    this.setStandardJTextProperties(this.stretchZField);
    this.stretchZField.setText(String.valueOf(this.getInitialZStretchValue()));
    this.stretchZField.setSize(10, 5);
    topMenuBar.add(this.stretchZField,new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 2), 0, 0));
    
    showLightCheckBox = new JCheckBox("Show Light") {
      private static final long serialVersionUID = 5338842835820814758L;

      public Border getBorder() {
        return BorderFactory.createMatteBorder(0,0,0,2,new Color(50,50,50));
      }         
   };
   showLightCheckBox.setBorder(BorderFactory.createLineBorder(Color.white,1));
   showLightCheckBox.setBackground(new Color(50,50,50));
   showLightCheckBox.setOpaque(true);
   showLightCheckBox.setForeground(Color.white);
   showLightCheckBox.setIcon(new ImageIcon(MapViewer.class.getResource("/at/tugraz/genome/viewer3d/images/GenesisCheckBox-3.gif")));
   showLightCheckBox.setSelectedIcon(new ImageIcon(MapViewer.class.getResource("/at/tugraz/genome/viewer3d/images/GenesisCheckBox-Selected-3.gif")));
   showLightCheckBox.setFont(toolBarFont);
   showLightCheckBox.setFocusPainted(false);
   showLightCheckBox.setSelected(this.getInitialLightValue());
   showLightCheckBox.setActionCommand(MapViewer.CMD_SHOW_LIGHT);
   showLightCheckBox.addActionListener(this);

   topMenuBar.add(this.showLightCheckBox,new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0
       ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    
    showTextureCheckBox = new JCheckBox("Show Texture") {
      private static final long serialVersionUID = 6790245848445216456L;

      public Border getBorder() {
        return BorderFactory.createMatteBorder(0,0,0,2,new Color(50,50,50));
      }         
   };
   showTextureCheckBox.setBorder(BorderFactory.createLineBorder(Color.white,1));
   showTextureCheckBox.setBackground(new Color(50,50,50));
   showTextureCheckBox.setOpaque(true);
   showTextureCheckBox.setForeground(Color.white);
   showTextureCheckBox.setIcon(new ImageIcon(MapViewer.class.getResource("/at/tugraz/genome/viewer3d/images/GenesisCheckBox-3.gif")));
   showTextureCheckBox.setSelectedIcon(new ImageIcon(MapViewer.class.getResource("/at/tugraz/genome/viewer3d/images/GenesisCheckBox-Selected-3.gif")));
   showTextureCheckBox.setFont(toolBarFont);
   showTextureCheckBox.setFocusPainted(false);
   showTextureCheckBox.setSelected(this.getInitialTextureValue());
   showTextureCheckBox.setActionCommand(MapViewer.CMD_SHOW_TEXTURE);
   showTextureCheckBox.addActionListener(this);

   topMenuBar.add(this.showTextureCheckBox,new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0
       ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
   
   this.updateResolutionLevel1 = new JButton("Update");
   this.updateResolutionLevel1.setActionCommand(MapViewer.CMD_UPDATE_RES_LEVEL);
   this.updateResolutionLevel1.addActionListener(this);
   this.setStandardJButtonProperties(updateResolutionLevel1);
   updateResolutionLevel1.setMargin(new Insets(1,8,1,8));
   topMenuBar.add(this.updateResolutionLevel1,new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0
     ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
  }
  
  protected void createRightMenu()
  {
    rightMenuBar=new Panel();
    GridBagLayout layout = new GridBagLayout();
    rightMenuBar.setLayout(layout);
    rightMenuBar.setPreferredSize(new Dimension(95,50));
    rightMenuBar.setBackground(new Color(50,50,50));
//    rightMenuBar.setBorder(BorderFactory.createEmptyBorder());
    
    this.add(rightMenuBar, BorderLayout.EAST);
    
    this.initializeResolutionArrays();
    this.createResolutionFields();
    
    this.updateResolutionLevel2 = new JButton("Update");
    this.updateResolutionLevel2.setActionCommand(MapViewer.CMD_UPDATE_RES_LEVEL);
    this.updateResolutionLevel2.addActionListener(this);
    this.setStandardJButtonProperties(updateResolutionLevel2);
    updateResolutionLevel2.setMargin(new Insets(1,8,1,8));
    
    this.setResolutionMenuPositions();
    
  }


  protected Node[] createGeometry(){
    Shape3D landscape = null;
    Node[] nodes = new Node[2];
    
    Switch targetSwitch = new Switch();
    targetSwitch.setCapability(Switch.ALLOW_SWITCH_WRITE);
    float stretchX = Float.parseFloat(this.stretchXField.getText()); 
    float stretchY = Float.parseFloat(this.stretchYField.getText()); 
    float stretchZ = Float.parseFloat(this.stretchZField.getText());
    
    stripArrays_ = new IndexedTriangleStripArray[this.resolutionLabels.size()];
    
    for (int k=this.resolutionLabels.size()-1; k!=-1;k--){
      int resZ = this.getAmountForZResolution(k);
      int resX = this.getAmountForXResolution(k);
      int amountZPositions = data.length/resZ;
      if (data.length%resZ!=0)
        amountZPositions++; 
      int amountXPositions = data[0].length/resX;
      if (data[0].length%resX!=0)
        amountXPositions++; 

    float[][] displayData = null; 
    if (data.length>0)
      displayData = new float[amountZPositions][amountXPositions];
    int j = -1;
    int m = -1;
    for (int i = 0; i != data.length; i++) {
      if (i % resZ == 0) {
        j++;
      }
      m = -1;
      for (int l=0;l!=data[0].length;l++){
        if (l % resX == 0){
          m++;
        }
        if (data[i][l]!=Float.NaN)
          displayData[j][m] += data[i][l];
      }
    }
    
    this.maxIntensity = 0;
    int xValues = displayData[0].length;
    float xValueRange = this.getXValueRange();
    
    
    int zValues = displayData.length;
    float zValueRange = this.getZValueRange();
    
    int[] stripCounts = new int[displayData.length-1];
   for (int i=0 ; i!=displayData.length;i++){ 
      for (j=0;j!=displayData[i].length;j++){
        if (displayData[i][j]>maxIntensity) maxIntensity = displayData[i][j];
      }
   }
   
   
   
/****      float coords[] = new float[(displayData.length-1)*displayData[0].length*2*3];
    float colors[] = new float[(displayData.length-1)*displayData[0].length*2*3];
    for (int i=0; i!=(displayData.length-1); i++){
      stripCounts[i] = xValues*2;
      for (j=0;j!=displayData[i].length;j++){
        coords[(i*displayData[i].length+j)*2*3] = -0.5f+(1.0f*j)/xValues;
        coords[(i*displayData[i].length+j)*2*3+1] = -0.5f+(displayData[i][j])/maxIntensity;
        coords[(i*displayData[i].length+j)*2*3+2] = -0.5f+(1.0f*i)/zValues;

        coords[(i*displayData[i].length+j)*2*3+3] = -0.5f+(1.0f*j)/xValues;
        coords[(i*displayData[i].length+j)*2*3+4] = -0.5f+(displayData[i+1][j])/maxIntensity;
        coords[(i*displayData[i].length+j)*2*3+5] = -0.5f+(1.0f*(i+1))/zValues;
        
        
        int rgb1 = gradient.getRGB((int)(displayData[i][j]*scale), 0);
        int rgb2 = gradient.getRGB((int)(displayData[i+1][j]*scale), 0);
        
        colors[(i*displayData[i].length+j)*2*3] = (float)((rgb1 >> 16) & 0xFF)/255f;
        colors[(i*displayData[i].length+j)*2*3+1] = (float)((rgb1 >>  8) & 0xFF)/255f;
        colors[(i*displayData[i].length+j)*2*3+2] = (float)((rgb1 >>  0) & 0xFF)/255f;

        colors[(i*displayData[i].length+j)*2*3+3] = (float)((rgb2 >> 16) & 0xFF)/255f;
        colors[(i*displayData[i].length+j)*2*3+4] = (float)((rgb2 >>  8) & 0xFF)/255f;
        colors[(i*displayData[i].length+j)*2*3+5] = (float)((rgb2 >>  0) & 0xFF)/255f;
      }
    }*/
   
/****     float coords[] = new float[(displayData.length)*displayData[0].length*3];
   float colors[] = new float[(displayData.length)*displayData[0].length*3];
   for (int i=0; i!=(displayData.length); i++){
     if (i!=displayData.length-1)
       stripCounts[i] = xValues*2;
     for (j=0;j!=displayData[i].length;j++){
       coords[(i*displayData[i].length+j)*3] = -0.5f+(1.0f*j)/xValues;
       coords[(i*displayData[i].length+j)*3+1] = -0.5f+(displayData[i][j])/maxIntensity;
       coords[(i*displayData[i].length+j)*3+2] = -0.5f+(1.0f*i)/zValues;

       
       
       int rgb1 = gradient.getRGB((int)(displayData[i][j]*scale), 0);
       
       colors[(i*displayData[i].length+j)*3] = (float)((rgb1 >> 16) & 0xFF)/255f;
       colors[(i*displayData[i].length+j)*3+1] = (float)((rgb1 >>  8) & 0xFF)/255f;
       colors[(i*displayData[i].length+j)*3+2] = (float)((rgb1 >>  0) & 0xFF)/255f;

     }
   }
   */
   
   for (int i=0; i!=(displayData.length-1); i++){
     stripCounts[i] = xValues*2;
   }
    

////     TriangleStripArray stripArray = new TriangleStripArray(xValues*(zValues-1)*2,LineStripArray.COORDINATES | LineStripArray.COLOR_3,stripCounts);

    IndexedTriangleStripArray stripArray = this.createIndexedStripArray(xValues*zValues,xValues*(zValues-1)*2,stripCounts);
    stripArray.setCapability(IndexedTriangleStripArray.ALLOW_COLOR_WRITE);

    Vector3f v0 = new Vector3f();
    Vector3f south = new Vector3f();
    Vector3f east  = new Vector3f();
    Vector3f normal = new Vector3f();
    
    /** these dimensions are retrieved empirically*/
    int texturedimensionx=(int)Math.round(/*0.2f**/displayData[0].length/7/*/1.05*/);
    int texturedimensionz=(int)Math.round(/*0.2f**/displayData.length/7/*/1.05*/);
    float stepx = 1/(float)(texturedimensionx-1);
    float stepy = 1/(float)(texturedimensionz-1);
    float x = 0;
    float y = 1.0f;
    boolean forwardx=true;
    boolean forwardy=false;
    
    for (int i=0; i!=(displayData.length); i++){
      for (j=0;j!=displayData[i].length;j++){
        float[] coordinate = new float[3];
        coordinate[0] = -0.5f+(1.0f*(this.getXValueForPosition(j*resX)-this.getLowestXValue())*stretchX)/xValueRange;
        coordinate[1] = -0.5f+(displayData[i][j]*stretchY)/maxIntensity;
        coordinate[2] = -0.5f+(1.0f*(this.getZValueForPosition(i*resZ)-this.getLowestZValue())*stretchZ)/zValueRange/*zValues*/;
        stripArray.setCoordinate((i*displayData[i].length+j), coordinate);
        

        float[] color = this.getColorForCoordinate(this.getXValueForPosition(j*resX),displayData[i][j],this.getZValueForPosition(i*resZ));//new float[3];
        stripArray.setColor((i*displayData[i].length+j), (color));
        
        
        if (this.showLightCheckBox.isSelected()){
          if (i == displayData.length-1) { // last row
            south.set(0f, 0f, ((this.getZValueForPosition(i*resZ)-this.getZValueForPosition((i-1)*resZ))*stretchZ)/zValueRange);
          } else {
            south.set(0f, -0.5f+(displayData[i+1][j]*stretchY)/maxIntensity, /*step*/((this.getZValueForPosition((i+1)*resZ)-this.getZValueForPosition(i*resZ))*stretchZ)/zValueRange);
          }
          if (j == displayData[i].length-1) { // last column
            east.set(this.getXValueForPosition(j*resX)-this.getXValueForPosition((j-1)*resX), 0f, 0f);
          } else {
            east.set(((this.getXValueForPosition((j+1)*resX)-this.getXValueForPosition(j*resX))*stretchX)/xValueRange, -0.5f+(displayData[i][j+1]*stretchY)/maxIntensity, 0f);
          }
          v0.set(0, coordinate[1], 0);
          south.sub(v0);
          east.sub(v0);
          normal.cross(south, east);
          normal.normalize();
          float[] normalValues = new float[3];
          normalValues[0] = normal.x;
          normalValues[1] = normal.y;
          normalValues[2] = normal.z;
          stripArray.setNormal((i*displayData[i].length+j), normalValues);
        }
        
        if (this.showTextureCheckBox.isSelected()){
          stripArray.setTextureCoordinate(0,(i*displayData[i].length+j), new TexCoord2f(x,y));
          if (forwardx) {
            x += stepx;
           } else {
            x -= stepx;
           }
           if (x>1.0) {
            x = 1.0f-stepx;
            forwardx=false;
           }
           if (x<0) {
           x = stepx;
           forwardx=true;
           }  
        }  

        if (i!=0){
          stripArray.setCoordinateIndex(((i-1)*displayData[i].length+j)*2, (i-1)*displayData[i].length+j);
          stripArray.setCoordinateIndex(((i-1)*displayData[i].length+j)*2+1, (i)*displayData[i].length+j);
          
          stripArray.setColorIndex(((i-1)*displayData[i].length+j)*2, (i-1)*displayData[i].length+j);
          stripArray.setColorIndex(((i-1)*displayData[i].length+j)*2+1, (i)*displayData[i].length+j);
          
          if (this.showLightCheckBox.isSelected()){
            stripArray.setNormalIndex(((i-1)*displayData[i].length+j)*2, (i-1)*displayData[i].length+j);
            stripArray.setNormalIndex(((i-1)*displayData[i].length+j)*2+1, (i)*displayData[i].length+j);
          }  
          if (this.showTextureCheckBox.isSelected()){
            stripArray.setTextureCoordinateIndex(0,((i-1)*displayData[i].length+j)*2, (i-1)*displayData[i].length+j);
            stripArray.setTextureCoordinateIndex(0,((i-1)*displayData[i].length+j)*2+1, (i)*displayData[i].length+j);
          }  
          
        }
      }
      x=0;
      forwardx=true;
      if (forwardy) {
      y += stepy;
      } else {
         y -= stepy;
      }
      if (y>=1.0) {
        y = 1.0f;
        forwardy=false;
      }            
      if (y<=0) {
      y=0;
      forwardy=true;
      }
      
    }
    this.stripArrays_[k] = stripArray;
    landscape = new Shape3D(stripArray);
    
    Color3f ambientColor  = new Color3f(0.2f, 0.2f, 0.2f); // The default ambient  color is (0.2, 0.2, 0.2).
    Color3f emissiveColor = new Color3f(0.3f, 0.3f, 0.3f); // The default emissive color is (0.0, 0.0, 0.0).
    Color3f diffuseColor  = new Color3f(0.0f, 0.0f, 0.0f); // The default diffuse  color is (1.0, 1.0, 1.0).
    Color3f specularColor = new Color3f(0.0f, 0.0f, 0.0f); // The default specular color is (1.0, 1.0, 1.0).
    float shininess = 128.0f;
    Appearance appear = new Appearance();
    Material material = new Material(ambientColor, emissiveColor , diffuseColor, specularColor, shininess);
    //Material material = new Material();
    appear.setMaterial(material);
    material.setLightingEnable(true);
    ImageIcon textureIcon = new ImageIcon(MapViewer.class.getResource("/at/tugraz/genome/viewer3d/images/Texture.jpg"));
    org.jogamp.java3d.utils.image.TextureLoader myLoader = new org.jogamp.java3d.utils.image.TextureLoader(textureIcon.getImage(),"RGB",this);        
    Texture texture = myLoader.getTexture();
    appear.setTexture(texture);
  
    TextureAttributes texAttr = new TextureAttributes();
    texAttr.setPerspectiveCorrectionMode(TextureAttributes.FASTEST);
    texAttr.setTextureMode(TextureAttributes.MODULATE);
    appear.setTextureAttributes(texAttr);
    landscape.setAppearance(appear);
    landscape.setCapability(Shape3D.ALLOW_GEOMETRY_WRITE);
    
    targetSwitch.addChild(landscape);
    }
    float[] distances = new float[this.resolutionLabels.size()];
    for (int i=0;i!=this.resolutionLabels.size()-1;i++){
      float distance = Float.parseFloat(this.resolutionDistText.get(i).getText());
      distance = (distance/Float.parseFloat(String.valueOf(Math.sqrt(3))))*Float.parseFloat(String.valueOf(Math.sqrt(Math.pow(Double.parseDouble(String.valueOf(stretchX)),2d)+
          Math.pow(Double.parseDouble(String.valueOf(stretchY)),2d)+Math.pow(Double.parseDouble(String.valueOf(stretchZ)),2d))));
      distances[this.resolutionLabels.size()-i-2] = distance;
    }
    landscape=null;
    distances[this.resolutionLabels.size()-1] = 1000f;
    
    DistanceLOD dLOD = new DistanceLOD(distances, new Point3f(-0.5f+stretchX/2,-0.5f,-0.5f+stretchZ/2));
    dLOD.addSwitch(targetSwitch);
    dLOD.setSchedulingBounds(new BoundingSphere());
    nodes[0] = targetSwitch;
    nodes[1] = dLOD;
    return nodes;    
  }
  
  
  protected void createInteractionObjects(BranchGroup objRoot, Vector<Node> objectsToDisplay)
  {
      
      MouseRotate myMouseRotate = null;
      Transform3D transform = new Transform3D();
      

      TransformGroup objRotate = new TransformGroup(transform);
      objRotate.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

      objRoot.addChild(objRotate);
      for (Node objectToDisplay : objectsToDisplay){
        objRotate.addChild(objectToDisplay);
      }

      myMouseRotate = new MouseRotate();
      myMouseRotate.setTransformGroup(objRotate);
      myMouseRotate.setFactor(0.002);
      myMouseRotate.setSchedulingBounds(new BoundingSphere());
      objRoot.addChild(myMouseRotate);

      MouseTranslate myMouseTranslate = new MouseTranslate();
      myMouseTranslate.setTransformGroup(objRotate);
      myMouseTranslate.setFactor(0.001);
      myMouseTranslate.setSchedulingBounds(new BoundingSphere());
      objRoot.addChild(myMouseTranslate);

      MouseZoom myMouseZoom = new MouseZoom();
      myMouseZoom.setTransformGroup(objRotate);
      myMouseZoom.setFactor(0.005);
      myMouseZoom.setSchedulingBounds(new BoundingSphere());
      objRoot.addChild(myMouseZoom);
      
      MouseWheelZoom myWheelZoom = new MouseWheelZoom();
      myWheelZoom.setTransformGroup(objRotate);
      myWheelZoom.setFactor(0.01);
      myWheelZoom.setSchedulingBounds(new BoundingSphere());
      objRoot.addChild(myWheelZoom);
      
      KeyNavigatorBehavior keyNavBeh = new KeyNavigatorBehavior(objRotate);
      keyNavBeh.setSchedulingBounds(new BoundingSphere(new Point3d(),1));
      objRoot.addChild(keyNavBeh);
      
/****    Background backg = new Background(1f,1f,1f);
    backg.setApplicationBounds(new BoundingSphere());
    objRoot.addChild(backg);*/
  }

  protected static BufferedImage createDefaultGradientImage(int sizeX) {
    BufferedImage gradient = new BufferedImage(sizeX, 1, BufferedImage.TYPE_3BYTE_BGR);
    Graphics2D graphics = gradient.createGraphics();
    GradientPaint gp1 = new GradientPaint(0, 0, MapViewer.DEFAULT_COLOR1, (sizeX-1)/15, 0, MapViewer.DEFAULT_COLOR2);
    GradientPaint gp2 = new GradientPaint((sizeX-1)/15, 0, MapViewer.DEFAULT_COLOR3,  sizeX-1, 0, MapViewer.DEFAULT_COLOR4);
    graphics.setPaint(gp1);
    graphics.drawRect(0, 0, (sizeX-1)/2, 1);
    graphics.setPaint(gp2);
    graphics.drawRect((sizeX-1)/2, 0, sizeX-1, 1);
    graphics.dispose();    
    return gradient;
  }

  protected void setInitialViewPoint(TransformGroup tg, Point3d basis) {
    Transform3D t3d = new Transform3D();
    float factor = (1f/Float.parseFloat(String.valueOf(Math.sqrt(3))))*Float.parseFloat(String.valueOf(Math.sqrt(Math.pow(Double.parseDouble(String.valueOf(this.getInitialXStretchValue())),2d)+
        Math.pow(Double.parseDouble(String.valueOf(this.getInitialYStretchValue())),2d)+Math.pow(Double.parseDouble(String.valueOf(this.getInitialZStretchValue())),2d))));
    t3d.lookAt(new Point3d(-0.5+factor*0.9, -0.5+this.getInitialYStretchValue()*0.5, -0.5+factor*2.5f), basis, new Vector3d(0, 1, 0));
    t3d.invert();
    tg.setTransform(t3d);
  }  
  
  protected Vector<Node> generateAxes(){   
    
    Vector<Node> axesAndLabel = new Vector<Node>();
    float stretchX = Float.parseFloat(this.stretchXField.getText()); 
    float stretchY = Float.parseFloat(this.stretchYField.getText()); 
    float stretchZ = Float.parseFloat(this.stretchZField.getText()); 
    
    LineArray axisZLines = new LineArray(6, LineArray.COORDINATES);
    axisZLines.setCoordinate(0, new Point3f(-0.5f,-0.5f,-0.5f));
    axisZLines.setCoordinate(1, new Point3f(-0.5f,-0.5f,-0.5f+stretchZ+0.05f));
    axisZLines.setCoordinate(2, new Point3f(-0.49f,-0.5f,-0.5f+stretchZ+0.04f));
    axisZLines.setCoordinate(3, new Point3f(-0.5f,-0.5f,-0.5f+stretchZ+0.05f));
    axisZLines.setCoordinate(4, new Point3f(-0.51f,-0.5f,-0.5f+stretchZ+0.04f));
    axisZLines.setCoordinate(5, new Point3f(-0.5f,-0.5f,-0.5f+stretchZ+0.05f));
    Shape3D zAxis = new Shape3D(axisZLines,appearanceWhite_);
  
    
    Text2D text2D = new Text2D(this.getZAxisLabel(),  new Color3f(1f,1f,1f), "Helvetica", 10, Font.PLAIN);
    
    Transform3D transform = new Transform3D();
    transform.setTranslation(new Vector3d(-0.55f,-0.5f,-0.5f+stretchZ));
    Transform3D transform2 = new Transform3D();

    TransformGroup transformText = new TransformGroup(transform);
    TransformGroup transformBillboard = new TransformGroup();
    transformBillboard.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
    Billboard billboard = new Billboard(transformBillboard);
    billboard.setSchedulingBounds(new BoundingSphere());
    transformText.addChild(transformBillboard);    
    transformBillboard.addChild(text2D);    
    
    axesAndLabel.add(zAxis);
    axesAndLabel.add(transformText);
    axesAndLabel.add(billboard);
    
    this.generateZAxisScale(axesAndLabel);

    LineArray axisXLines = new LineArray(6, LineArray.COORDINATES);
    axisXLines.setCoordinate(0, new Point3f(-0.5f,-0.5f,-0.5f));
    axisXLines.setCoordinate(1, new Point3f(-0.5f+(stretchX+0.05f),-0.5f,-0.5f));
    axisXLines.setCoordinate(2, new Point3f(-0.5f+(stretchX+0.04f),-0.5f,-0.49f));
    axisXLines.setCoordinate(3, new Point3f(-0.5f+(stretchX+0.05f),-0.5f,-0.5f));
    axisXLines.setCoordinate(4, new Point3f(-0.5f+(stretchX+0.04f),-0.5f,-0.51f));
    axisXLines.setCoordinate(5, new Point3f(-0.5f+(stretchX+0.05f),-0.5f,-0.5f));
    Shape3D xAxis = new Shape3D(axisXLines,appearanceWhite_);
    
    text2D = new Text2D(this.getXAxisLabel(),  new Color3f(1f,1f,1f), "Helvetica", 10, Font.PLAIN);
    
    transform = new Transform3D();
    transform.setTranslation(new Vector3d(-0.5f+(stretchX+0.03f),-0.5f,-0.53f));
    transformText = new TransformGroup(transform);
    transformBillboard = new TransformGroup();
    transformBillboard.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
    billboard = new Billboard(transformBillboard);
    billboard.setSchedulingBounds(new BoundingSphere());
    transformText.addChild(transformBillboard);    
    transformBillboard.addChild(text2D);    
        
    axesAndLabel.add(xAxis);
    axesAndLabel.add(transformText);
    axesAndLabel.add(billboard);
    
    this.generateXAxisScale(axesAndLabel);
    
    LineArray axisYLines = new LineArray(6, LineArray.COORDINATES);
    axisYLines.setCoordinate(0, new Point3f(-0.5f,-0.5f,-0.5f));
    axisYLines.setCoordinate(1, new Point3f(-0.5f,-0.5f+stretchY+0.05f,-0.5f));
    axisYLines.setCoordinate(2, new Point3f(-0.49f,-0.5f+stretchY+0.04f,-0.5f));
    axisYLines.setCoordinate(3, new Point3f(-0.5f,-0.5f+stretchY+0.05f,-0.5f));
    axisYLines.setCoordinate(4, new Point3f(-0.51f,-0.5f+stretchY+0.04f,-0.5f));
    axisYLines.setCoordinate(5, new Point3f(-0.5f,-0.5f+stretchY+0.05f,-0.5f));
    Shape3D yAxis = new Shape3D(axisYLines,appearanceWhite_);

    text2D = new Text2D(this.getYAxisLabel(),  new Color3f(1f,1f,1f), "Helvetica", 10, Font.PLAIN);
    
    transform = new Transform3D();
    transform.setTranslation(new Vector3d(-0.52f,-0.5f+stretchY-0.05f,-0.5f));
    transform2 = new Transform3D();
    transform2.rotZ(Math.PI/2);
    transform.mul(transform2);
    transform2 = new Transform3D();
    transform2.rotX(Math.PI/4);
    transform.mul(transform2);
    transformText = new TransformGroup(transform);
    transformBillboard = new TransformGroup();
    transformBillboard.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
    billboard = new Billboard(transformBillboard);
    billboard.setSchedulingBounds(new BoundingSphere());
    
    
    transformText.addChild(transformBillboard);    
    transformBillboard.addChild(text2D);

    axesAndLabel.add(yAxis);
    axesAndLabel.add(transformText);
    axesAndLabel.add(billboard);
    
    this.generateYAxisScale(axesAndLabel);
    
    return axesAndLabel;
  }
  
  protected Vector<Node> createLights(){
    Vector<Node> lights = new Vector<Node>();
    BoundingLeaf boundingLeaf = new BoundingLeaf(new BoundingSphere(new Point3d(), 10000d));
    

    AmbientLight light = new AmbientLight();
    light.setInfluencingBoundingLeaf(boundingLeaf);
    lights.add(light);
    
    
    //lights.add(this.newSpotLight(new BoundingSphere(), new Point3f(0.4f, 0.3f, 2f), 3f, 5f));    
    lights.add(this.newSpotLight(new BoundingSphere(), new Point3f(-0.5f+this.getInitialXStretchValue()/2+0.4f, -0.5f+this.getInitialYStretchValue()/2+0.3f, -0.5f+this.getInitialZStretchValue()/2+2f), 3f, 5f));    
    return lights;
  }
  
  
  SpotLight newSpotLight(Bounds bounds, Point3f pos,
      float spread, float concentration) {
    SpotLight sl = new SpotLight();
    sl.setInfluencingBounds(bounds);
    sl.setPosition(pos);
    sl.setSpreadAngle(spread);
    sl.setConcentration(concentration);
    sl.setCapability(SpotLight.ALLOW_POSITION_WRITE);
    sl.setCapability(SpotLight.ALLOW_DIRECTION_WRITE);
    return sl;
  }
  

  public void actionPerformed(ActionEvent event)
  {
    this.executeCommand(event.getActionCommand());
  }
  
  public void executeCommand(String command){
    if (command.equalsIgnoreCase(MapViewer.CMD_SHOW_LIGHT)){
      this.repaintGeometry();
    }
    if (command.equalsIgnoreCase(MapViewer.CMD_SHOW_TEXTURE)){
      this.repaintGeometry();
    }
    if (command.equalsIgnoreCase(MapViewer.CMD_ADD_RES_LEVEL)){
      this.addResolutionLevel();
    }
    if (command.equalsIgnoreCase(MapViewer.CMD_REMOVE_RES_LEVEL)){
      this.removeResolutionLevel();
    }    
    if (command.equalsIgnoreCase(MapViewer.CMD_UPDATE_RES_LEVEL)){
      if (this.checkResolutionInput()){
        this.repaintGeometry();
      }  
    }     
  }
  
  protected void repaintGeometry(){
    long time = System.currentTimeMillis();
    this.universe.cleanup();
    this.universe.getViewer().getView().removeCanvas3D(this.canvas3D);
    this.universe.removeAllLocales();
    this.universe = null;
    this.initJ3D();
    System.out.println("GeometryTime: "+(System.currentTimeMillis()-time)/1000+"secs");
  }
  
  protected IndexedTriangleStripArray createIndexedStripArray(int nrVertices, int nrIndices, int[] stripCounts){
    IndexedTriangleStripArray stripArray = null;
    if ((!this.showLightCheckBox.isSelected())&&(!this.showTextureCheckBox.isSelected())){
      stripArray = new IndexedTriangleStripArray(nrVertices,
          IndexedTriangleStripArray.COORDINATES | IndexedTriangleStripArray.COLOR_3,
          nrIndices,stripCounts);      
    }
    if ((!this.showLightCheckBox.isSelected())&&this.showTextureCheckBox.isSelected()){
      stripArray = new IndexedTriangleStripArray(nrVertices,
          IndexedTriangleStripArray.COORDINATES | IndexedTriangleStripArray.COLOR_3 | 
          GeometryArray.TEXTURE_COORDINATE_2,
          nrIndices,stripCounts);      
    }
    if (this.showLightCheckBox.isSelected()&&(!this.showTextureCheckBox.isSelected())){
      stripArray = new IndexedTriangleStripArray(nrVertices,
          IndexedTriangleStripArray.COORDINATES | IndexedTriangleStripArray.COLOR_3 | 
          IndexedTriangleStripArray.NORMALS,
          nrIndices,stripCounts);      
    }
    if (this.showLightCheckBox.isSelected()&&this.showTextureCheckBox.isSelected()){
      stripArray = new IndexedTriangleStripArray(nrVertices,
        IndexedTriangleStripArray.COORDINATES | IndexedTriangleStripArray.COLOR_3 | 
        IndexedTriangleStripArray.NORMALS | GeometryArray.TEXTURE_COORDINATE_2,
        nrIndices,stripCounts);
    }
    return stripArray;
  }
  
  protected float getZValueRange(){
    return this.getHighestZValue()-this.getLowestZValue();
  }
  
  protected float getZValueForPosition(int position){
    return position;
  }
  
  
  protected float getXValueRange(){
    return this.getHighestXValue() - this.getLowestXValue();
  }
  
  protected float getXValueForPosition(int position){
    return position;
  }
  
  protected float getLowestXValue(){
    return 0;
  }
  
  protected float getHighestXValue(){
    return this.data[0].length;
  }
  
  protected float getLowestZValue(){
    return 0;
  }
  
  protected float getHighestZValue(){
    return this.data.length;
  }
  
  protected void initializeResolutionArrays(){
    this.resolutionLabels = new Vector<JLabel>();
    this.resolutionXLabels = new Vector<JLabel>();
    this.resolutionZLabels = new Vector<JLabel>();
    this.resolutionDistLabels = new Vector<JLabel>();
    this.resolutionXText = new Vector<JTextField>();
    this.resolutionZText = new Vector<JTextField>();
    this.resolutionDistText = new Vector<JTextField>();
  }
  
  
  protected void createResolutionFields(){    
    JLabel label;
    JTextField text;
    
    boolean onlyOne = false;
    int size = 1;
    
    if (size==1)
      onlyOne = true;
    for (int i=0; i!=size;i++){
      String resolutionString = "Res. "+(i+1);
      if (i==0&&!onlyOne)
        resolutionString+=" (far)";
      if (i==(size-1)&&!onlyOne)
        resolutionString+=" (close)";
      label = new JLabel(resolutionString);
      this.setStandardJLabelProperties(label);
      this.resolutionLabels.add(label); 
      
      label = new JLabel(this.getResolutionLabelXString());
      this.setStandardJLabelProperties(label);
      this.resolutionXLabels.add(label);
      

      label = new JLabel(this.getResolutionLabelZString());
      this.setStandardJLabelProperties(label);
      this.resolutionZLabels.add(label);
      
      if (i!=(size-1)){
        label = new JLabel(this.getResolutionLabelDistString());
        this.setStandardJLabelProperties(label);
        this.resolutionDistLabels.add(label);
      }
      
      text = new JTextField(5);
      if (i==0)
        text.setText("20");
      this.setStandardJTextProperties(text);
      this.resolutionXText.add(text);
      
      text = new JTextField(5);
      this.setStandardJTextProperties(text);
      this.resolutionZText.add(text);
      if (i==0)
        text.setText("50");
      
      if (i!=(size-1)){
        text = new JTextField(5);
        this.setStandardJTextProperties(text);
        this.resolutionDistText.add(text); 
      }  

    }
  }
  
  private void addResolutionLevel(){
    JLabel label;
    JTextField text;
    this.rightMenuBar.setPreferredSize(new Dimension(95,50));
    
    
    label = this.resolutionLabels.get(this.resolutionLabels.size()-1);
    if (label.getText().endsWith(" (close)"))
      label.setText(label.getText().substring(0,label.getText().length()-8));
    
    if (this.resolutionLabels.size()==1){
      label = this.resolutionLabels.get(0);
      label.setText(label.getText()+" (far)");
    }
      
    String resolutionString = "Res. "+(this.resolutionLabels.size()+1)+" (close)";
    
    label = new JLabel(resolutionString);
    this.setStandardJLabelProperties(label);
    this.resolutionLabels.add(label); 
    
    label = new JLabel(this.getResolutionLabelXString());
    this.setStandardJLabelProperties(label);
    this.resolutionXLabels.add(label);
    

    label = new JLabel(this.getResolutionLabelZString());
    this.setStandardJLabelProperties(label);
    this.resolutionZLabels.add(label);

    label = new JLabel("d: ");
    this.setStandardJLabelProperties(label);
    this.resolutionDistLabels.add(label);
    
    
    text = new JTextField(5);
    this.setStandardJTextProperties(text);
    this.resolutionXText.add(text);
    
    text = new JTextField(5);
    this.setStandardJTextProperties(text);
    this.resolutionZText.add(text);

    text = new JTextField(5);
    this.setStandardJTextProperties(text);
    this.resolutionDistText.add(text);
    
    this.rightMenuBar.removeAll();

    this.setResolutionMenuPositions();
    this.validate();
    this.rightMenuBar.repaint();

  }
  
  protected void removeResolutionLevel(){
    JLabel label;
    this.rightMenuBar.setPreferredSize(new Dimension(95,50));
    
    if (this.resolutionLabels.size()>2){
      label = this.resolutionLabels.get(this.resolutionLabels.size()-2);
      label.setText(label.getText().concat(" (close)"));
    }   
    label = this.resolutionLabels.get(0);
    if (this.resolutionLabels.size()==2&&label.getText().endsWith(" (far)"))
      label.setText(label.getText().substring(0,label.getText().length()-6));
    
    if (this.resolutionLabels.size()>1){
      this.resolutionXLabels.remove(this.resolutionLabels.size()-1);
      this.resolutionZLabels.remove(this.resolutionLabels.size()-1);
      this.resolutionDistLabels.remove(this.resolutionLabels.size()-2);
      this.resolutionXText.remove(this.resolutionLabels.size()-1);
      this.resolutionZText.remove(this.resolutionLabels.size()-1);
      this.resolutionDistText.remove(this.resolutionLabels.size()-2);
      this.resolutionLabels.remove(this.resolutionLabels.size()-1);
    
      this.rightMenuBar.removeAll();

      this.setResolutionMenuPositions();
      this.validate();
      this.rightMenuBar.repaint();
    }
  }
  
  protected void setStandardJButtonProperties(JButton button){
    this.setStandardComponentProperties(button);
    button.setMargin(new Insets(1,4,1,4));
  }
  
  protected void setStandardJLabelProperties(JLabel label){
    this.setStandardComponentProperties(label);
  }
  
  protected void setStandardJTextProperties(JTextField text){
    this.setStandardComponentProperties(text);
    text.setCaretColor(Color.white);
    text.setHorizontalAlignment(JTextField.RIGHT);
  }
  
  protected void setStandardComponentProperties(JComponent comp){
    Font toolBarFont=new Font("Dialog",Font.PLAIN,11);
    comp.setBackground(new Color(50,50,50));
    comp.setOpaque(true);
    comp.setForeground(Color.white);
    comp.setFont(toolBarFont);
  }
  
  protected void setResolutionMenuPositions(){
    
    for (int i=0;i!=this.resolutionLabels.size();i++){
      rightMenuBar.add(resolutionLabels.get(i),new GridBagConstraints(0, i*4+getRightMenubarYOffset(), 2, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      rightMenuBar.add(resolutionXLabels.get(i),new GridBagConstraints(0, i*4+1+getRightMenubarYOffset(), 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      rightMenuBar.add(resolutionXText.get(i),new GridBagConstraints(1, i*4+1+getRightMenubarYOffset(), 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      rightMenuBar.add(resolutionZLabels.get(i),new GridBagConstraints(0, i*4+2+getRightMenubarYOffset(), 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      rightMenuBar.add(resolutionZText.get(i),new GridBagConstraints(1, i*4+2+getRightMenubarYOffset(), 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      if (i!=this.resolutionLabels.size()-1){
        rightMenuBar.add(resolutionDistLabels.get(i),new GridBagConstraints(0, i*4+3+getRightMenubarYOffset(), 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 1, 0, 1), 0, 0));
        rightMenuBar.add(resolutionDistText.get(i),new GridBagConstraints(1, i*4+3+getRightMenubarYOffset(), 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 1, 0, 1), 0, 0));
      }
    }
    this.removeResolutionLevel = new JButton("Rem res.");
    this.removeResolutionLevel.setActionCommand(MapViewer.CMD_REMOVE_RES_LEVEL);
    this.removeResolutionLevel.addActionListener(this);
    this.setStandardJButtonProperties(removeResolutionLevel);
    rightMenuBar.add(this.removeResolutionLevel,new GridBagConstraints(0, this.resolutionLabels.size()*4-1+getRightMenubarYOffset(), 2, 1, 0.0, 0.0
      ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    
    this.addResolutionLevel = new JButton("Add res.");
    this.addResolutionLevel.setActionCommand(MapViewer.CMD_ADD_RES_LEVEL);
    this.addResolutionLevel.addActionListener(this);
    this.setStandardJButtonProperties(addResolutionLevel);
    rightMenuBar.add(this.addResolutionLevel,new GridBagConstraints(0, this.resolutionLabels.size()*4+getRightMenubarYOffset(), 2, 1, 0.0, 0.0
      ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    

    rightMenuBar.add(this.updateResolutionLevel2,new GridBagConstraints(0, this.resolutionLabels.size()*4+1+getRightMenubarYOffset(), 2, 1, 0.0, 0.0
      ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }
  
  protected boolean checkResolutionInput(){
    boolean allCorrect = true;
    JTextField field;
    int lastXValue = 0;
    int thisXValue;
    int lastZValue = 0;
    int thisZValue;
    float lastDistValue = 0;
    float thisDistValue;

    topMenuBar.setPreferredSize(new Dimension(100,30));
    Component[] comp = topMenuBar.getComponents();
    for (int i=0;i!=comp.length;i++){
      if (comp[i] instanceof JLabel){
        String message = ((JLabel)comp[i]).getText();
        if (message.equalsIgnoreCase(">0!")||message.equalsIgnoreCase("Float!")||message.equalsIgnoreCase("Input!"))
          topMenuBar.remove(comp[i]);
      }
    }
    
    boolean checkValue = this.checkTopMenuInput(this.stretchXField, 1);
    if (!checkValue) allCorrect = false;
    checkValue = this.checkTopMenuInput(this.stretchYField, 3);
    if (!checkValue) allCorrect = false;
    checkValue = this.checkTopMenuInput(this.stretchZField, 5);
    if (!checkValue) allCorrect = false;
    
    this.rightMenuBar.removeAll();
    this.rightMenuBar.setPreferredSize(new Dimension(95,50));
    this.setResolutionMenuPositions();

    
    for (int i=0; i!=this.resolutionLabels.size();i++){
      field = this.resolutionXText.get(i);
      if (field.getText()!=null&&field.getText().length()>0){
        try{
          thisXValue = Integer.parseInt(field.getText());
          if (i!=0&&thisXValue>lastXValue){
            allCorrect = false;
            this.createResolutionErrorMessage("closer -> smaller!", i*4+1);
          }
          lastXValue=thisXValue;  
        }catch(NumberFormatException nfx){
          allCorrect = false;
          this.createResolutionErrorMessage("Enter integer!", i*4+1);
        }
      }else{
        allCorrect = false;
        this.createResolutionErrorMessage("Enter input!", i*4+1);
      }
      field = this.resolutionZText.get(i);
      if (field.getText()!=null&&field.getText().length()>0){
        try{
          thisZValue = Integer.parseInt(field.getText());
          if (i!=0&&thisZValue>lastZValue){
            allCorrect = false;
            this.createResolutionErrorMessage("closer -> smaller!", i*4+2);
          }
          lastZValue=thisZValue;  
        }catch(NumberFormatException nfx){
          allCorrect = false;
          this.createResolutionErrorMessage("Enter integer!", i*4+2);
        }
      }else{
        allCorrect = false;
        this.createResolutionErrorMessage("Enter input!", i*4+2);
      }
      if (i!=this.resolutionLabels.size()-1){
        field = this.resolutionDistText.get(i);
        if (field.getText()!=null&&field.getText().length()>0){
          try{
            thisDistValue = Float.parseFloat(field.getText());
            if (i!=0&&thisDistValue>=lastDistValue){
              allCorrect = false;
              this.createResolutionErrorMessage("closer -> smaller!", i*4+3);
            }
            lastDistValue=thisDistValue;  
          }catch(NumberFormatException nfx){
            allCorrect = false;
            this.createResolutionErrorMessage("Enter float!", i*4+3);
          }
        }else{
          allCorrect = false;
          this.createResolutionErrorMessage("Enter input!", i*4+3);
        }
      }
    }
      
    
    this.validate();
    this.rightMenuBar.repaint();
    this.topMenuBar.repaint();
    return allCorrect;
  }
  
  protected boolean checkTopMenuInput(JTextField field, int position){
    boolean allCorrect = true;
    float value;
    if (field.getText()!=null&&field.getText().length()>0){
      try{
        value = Float.parseFloat(field.getText());
        if (value<=0){
          allCorrect = false;
          this.createTopMenuErrorMessage(">0!", position);
        }
      }catch(NumberFormatException nfx){
        allCorrect = false;
        this.createTopMenuErrorMessage("Float!", position);
      }
    }else{
      allCorrect = false;
      this.createTopMenuErrorMessage("Input!", position);
    }
    return allCorrect;
  }
  
  protected void createTopMenuErrorMessage(String message, int position){
    topMenuBar.setPreferredSize(new Dimension(100,50));
    JLabel label = new JLabel(message);
    this.setStandardJLabelProperties(label);
    label.setForeground(Color.red);
    this.topMenuBar.add(label,new GridBagConstraints(position, 0, 0, 1, 0.0, 0.0
      ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));    
  }
  
  
  protected void createResolutionErrorMessage(String text, int position){
    this.rightMenuBar.setPreferredSize(new Dimension(150,50));
    JLabel label = new JLabel(text);
    this.setStandardJLabelProperties(label);
    label.setForeground(Color.red);
    rightMenuBar.add(label,new GridBagConstraints(2, position, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));    
  }
  
  
  protected String getXAxisLabel(){
    return this.xAxisString;
  }
  
  protected String getZAxisLabel(){
    return this.zAxisString;
  }
  
  protected String getYAxisLabel(){
    return this.yAxisString;
  }
  
  protected String getStretchXLabel(){
    return this.stretchXString;
  }
  
  protected String getStretchYLabel(){
    return this.stretchYString;
  }
  
  protected String getStretchZLabel(){
    return this.stretchZString;
  }


  protected String getResolutionLabelDistString()
  {
    return this.resolutionLabelDistString;
  }


  protected String getResolutionLabelXString()
  {
    return this.resolutionLabelXString;
  }


  protected String getResolutionLabelZString()
  {
    return this.resolutionLabelZString;
  }
  
  protected void generateZAxisScale(Vector<Node> axesAndLabel){

    float stretchZ = Float.parseFloat(this.stretchZField.getText());
    LineArray axisZMarkLines;
    Shape3D zMark;
    String markLabel;
    Text2D text2D;
    Transform3D transform;
    TransformGroup transformBillboard;
    TransformGroup transformText;
    Billboard billboard;
    
    int exponentDivFactor = this.detectAxesDivider(this.getZValueRange(), 0);
    float divFactor = Float.valueOf(String.valueOf(Math.pow(10, exponentDivFactor)));
    int nrOfZAxisMarks = Integer.parseInt((new StringTokenizer(String.valueOf(this.getZValueRange()/divFactor),".")).nextToken());
    for (int i=1; i!=nrOfZAxisMarks+1;i++){
      axisZMarkLines = new LineArray(2, LineArray.COORDINATES);
      int valueInWholeInts = Integer.parseInt((new StringTokenizer(String.valueOf((this.getLowestZValue()+i*divFactor)/divFactor),".")).nextToken());
      float zValue = valueInWholeInts*divFactor;
      if (exponentDivFactor<0){
        zValue = MapViewer.roundFloat(zValue, exponentDivFactor*(-1), BigDecimal.ROUND_HALF_UP);
        markLabel = String.valueOf(zValue);    
      }else{
        markLabel = (new StringTokenizer(String.valueOf(zValue),".")).nextToken();
      }
      float zPosition = -0.5f+(1.0f*((zValue-this.getLowestZValue())*stretchZ)/this.getZValueRange());
      if (zPosition<(-0.5f+stretchZ-0.02)){
        axisZMarkLines.setCoordinate(0, new Point3f(-0.5f,-0.5f,zPosition));
        axisZMarkLines.setCoordinate(1, new Point3f(-0.52f,-0.5f,zPosition));
        zMark = new Shape3D(axisZMarkLines,appearanceWhite_);
    
        text2D = new Text2D(markLabel,  new Color3f(1f,1f,1f), "Arial", 9, Font.PLAIN);
        transform = new Transform3D();
        transform.setTranslation(new Vector3d(-0.55f,-0.5f,zPosition));

        transformText = new TransformGroup(transform);
        transformBillboard = new TransformGroup();
        transformBillboard.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        billboard = new Billboard(transformBillboard);
        billboard.setSchedulingBounds(new BoundingSphere());
        transformText.addChild(transformBillboard);    
        transformBillboard.addChild(text2D);    

        axesAndLabel.add(zMark);
        axesAndLabel.add(transformText);
        axesAndLabel.add(billboard);
      }
    }
  }
  
  protected void generateXAxisScale(Vector<Node> axesAndLabel){

    float stretchX = Float.parseFloat(this.stretchXField.getText());
    LineArray axisXMarkLines;
    Shape3D xMark;
    String markLabel;
    Text2D text2D;
    Transform3D transform;
    TransformGroup transformBillboard;
    TransformGroup transformText;
    Billboard billboard;
    
    int exponentDivFactor  = this.detectAxesDivider(this.getXValueRange()/getXLabelCorrectionFactor(), 0);
    float divFactor = Float.valueOf(String.valueOf(Math.pow(10, exponentDivFactor)));
    int nrOfXAxisMarks = Integer.parseInt((new StringTokenizer(String.valueOf(MapViewer.roundFloat((this.getXValueRange()/getXLabelCorrectionFactor())/divFactor, 0, BigDecimal.ROUND_HALF_UP)),".")).nextToken());
    for (int i=1; i!=nrOfXAxisMarks+1;i++){
      axisXMarkLines = new LineArray(2, LineArray.COORDINATES);
      int valueInWholeInts = Integer.parseInt((new StringTokenizer(String.valueOf((this.getLowestXValue()/getXLabelCorrectionFactor()+i*divFactor)/divFactor),".")).nextToken());
      float xValue = valueInWholeInts*divFactor;
      if (exponentDivFactor<0){
        xValue = MapViewer.roundFloat(xValue, exponentDivFactor*(-1), BigDecimal.ROUND_HALF_UP);
        markLabel = String.valueOf(xValue);    
      }else{
        markLabel = (new StringTokenizer(String.valueOf(xValue),".")).nextToken();
      }
      float xPosition = -0.5f+(1.0f*((xValue-this.getLowestXValue()/getXLabelCorrectionFactor())*stretchX)/(this.getXValueRange()/getXLabelCorrectionFactor()));
      if (xPosition<(-0.5f+stretchX-0.02)){
        axisXMarkLines.setCoordinate(0, new Point3f(xPosition,-0.5f,-0.5f));
        axisXMarkLines.setCoordinate(1, new Point3f(xPosition,-0.5f,-0.52f));
        xMark = new Shape3D(axisXMarkLines,appearanceWhite_);
    
        text2D = new Text2D(markLabel,  new Color3f(1f,1f,1f), "Arial", 9, Font.PLAIN);
        transform = new Transform3D();
        transform.setTranslation(new Vector3d(xPosition,-0.5f,-0.55f));

        transformText = new TransformGroup(transform);
        transformBillboard = new TransformGroup();
        transformBillboard.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        billboard = new Billboard(transformBillboard);
        billboard.setSchedulingBounds(new BoundingSphere());
        transformText.addChild(transformBillboard);    
        transformBillboard.addChild(text2D);    

        axesAndLabel.add(xMark);
        axesAndLabel.add(transformText);
        axesAndLabel.add(billboard);
      }
    }
  }
  
  protected void generateYAxisScale(Vector<Node> axesAndLabel){

    float stretchY = Float.parseFloat(this.stretchYField.getText());
    LineArray axisYMarkLines;
    Shape3D yMark;
    String markLabel;
    Text2D text2D;
    Transform3D transform;
    TransformGroup transformBillboard;
    TransformGroup transformText;
    Billboard billboard;
    int exponentDivFactor = this.detectAxesDivider(this.maxIntensity, 0);
    float divFactor = Float.valueOf(String.valueOf(Math.pow(10, exponentDivFactor)));
    int nrOfYAxisMarks = Integer.parseInt((new StringTokenizer(String.valueOf(this.maxIntensity/divFactor),".")).nextToken());
    for (int i=1; i!=nrOfYAxisMarks+1;i++){
      axisYMarkLines = new LineArray(2, LineArray.COORDINATES);
      int valueInWholeInts = Integer.parseInt((new StringTokenizer(String.valueOf((0+i*divFactor)/divFactor),".")).nextToken());
      float yValue = valueInWholeInts*divFactor;
      if (exponentDivFactor<0){
        yValue = MapViewer.roundFloat(yValue, exponentDivFactor*(-1), BigDecimal.ROUND_HALF_UP);
        markLabel = String.valueOf(yValue);    
      }else{
        markLabel = (new StringTokenizer(String.valueOf(yValue),".")).nextToken();
      }
      
      float yPosition = -0.5f+(1.0f*((yValue-0)*stretchY)/this.maxIntensity);
      if (yPosition<(-0.5f+stretchY-0.02)){
        axisYMarkLines.setCoordinate(0, new Point3f(-0.5f,yPosition,-0.5f));
        axisYMarkLines.setCoordinate(1, new Point3f(-0.51f,yPosition,-0.49f));
        yMark = new Shape3D(axisYMarkLines,appearanceWhite_);
    
        text2D = new Text2D(markLabel,  new Color3f(1f,1f,1f), "Arial", 9, Font.PLAIN);
        transform = new Transform3D();
        transform.setTranslation(new Vector3d(-0.53f,yPosition,-0.53f));

        transformText = new TransformGroup(transform);
        transformBillboard = new TransformGroup();
        transformBillboard.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        billboard = new Billboard(transformBillboard);
        billboard.setSchedulingBounds(new BoundingSphere());
        transformText.addChild(transformBillboard);    
        transformBillboard.addChild(text2D);    

        axesAndLabel.add(yMark);
        axesAndLabel.add(transformText);
        axesAndLabel.add(billboard);
      }
    }
  }
  
  protected int detectAxesDivider(float range, int exponentDivFactor){
    if (range==0) return 1;
    if (range/10>1) return this.detectAxesDivider(range/10, ++exponentDivFactor);
    if (range/1>1){
      if (range/2>1)
        return exponentDivFactor;
      else
        return --exponentDivFactor;
    }else
      return this.detectAxesDivider(range*10, --exponentDivFactor);
  }
  
  protected int getAmountForXResolution(int fieldIndex){
    return Integer.parseInt(this.resolutionXText.get(fieldIndex).getText());
  }
  
  protected int getAmountForZResolution(int fieldIndex){
    return Integer.parseInt(this.resolutionZText.get(fieldIndex).getText());
  }
  
  protected float getInitialXStretchValue(){
    return 1f;
  }
  
  protected float getInitialYStretchValue(){
    return 1f;
  }
  
  protected float getInitialZStretchValue(){
    return 1f;
  }
  
  protected boolean getInitialLightValue(){
    return true;
  }
  
  protected boolean getInitialTextureValue(){
    return true;
  }
  
  public static float roundFloat(float targetFloat,int decimalPlace, int roundingMode){
    BigDecimal bd = new BigDecimal(targetFloat);
    bd = bd.setScale(decimalPlace,roundingMode);
    return (bd.floatValue());
  }
  
  protected float[] getColorForCoordinate(float xValue, float yValue, float zValue){
    BufferedImage gradient = this.getColorGradient(xValue, yValue, zValue);
    float scale = this.getColorScale();     
    int rgb1 = gradient.getRGB((int)(yValue*scale), 0);
    return this.mapColorToScale(rgb1);
  }
  
  protected float[] mapColorToScale(int rgb1){
    float[] color = new float[3];
    color[0] = (float)((rgb1 >> 16) & 0xFF)/255f;
    color[1] = (float)((rgb1 >>  8) & 0xFF)/255f;
    color[2] = (float)((rgb1 >>  0) & 0xFF)/255f;
    return color;    
  }
  
  protected BufferedImage getColorGradient(float xValue, float yValue, float zValue){
    if (this.gradient_==null)
      this.gradient_ = MapViewer.createDefaultGradientImage(this.getDefaultNrOfGradientPixels());
    return this.gradient_;
  }
  
  protected float getColorScale(){
    return (float)(10000-1)/maxIntensity;
  }
  
  protected int getDefaultNrOfGradientPixels(){
    return this.defaultNrOfGradientPixels;
  }
  
  public void destroyViewer(){
    this.setVisible(false);
    
    if (this.stripArrays_!=null){
      for (int i=0;i!=this.stripArrays_.length;i++){
        stripArrays_[i] = null;
      }
    }
    this.stripArrays_ = null;
    
    this.universe.cleanup();
    this.universe.getViewer().getView().removeAllCanvas3Ds();
    this.universe.removeAllLocales(); // This should do a proper cleanup.
    this.universe.cleanup();
    this.universe = null;
    if (this.getGraphics()!=null){
      this.getGraphics().dispose();
    }
    this.addResolutionLevel.removeAll();
    if (this.addResolutionLevel.getGraphics()!=null)
      this.addResolutionLevel.getGraphics().dispose();
    this.addResolutionLevel = null;
    this.canvas3D.setVisible(false);
    if (this.canvas3D.getGraphics()!=null)
      this.canvas3D.getGraphics().dispose();
    this.canvas3D = null;
    
    this.data = null;
    if (this.gradient_.getGraphics()!=null){
      this.gradient_.flush();
      this.gradient_.getGraphics().dispose();
    }  
    this.gradient_ = null;
    if (this.removeResolutionLevel.getGraphics()!=null)
      this.removeResolutionLevel.getGraphics().dispose();
    this.removeResolutionLevel = null;
    for (int i=0; i!=this.resolutionLabels.size();i++){
      if (this.resolutionLabels.get(i).getGraphics()!=null)
        this.resolutionLabels.get(i).getGraphics().dispose();
      this.resolutionLabels.set(i,null);
      if (this.resolutionXLabels.get(i).getGraphics()!=null)
        this.resolutionXLabels.get(i).getGraphics().dispose();
      this.resolutionXLabels.set(i,null);
      if (this.resolutionZLabels.get(i).getGraphics()!=null)
        this.resolutionZLabels.get(i).getGraphics().dispose();
      this.resolutionZLabels.set(i,null);
      if (this.resolutionXText.get(i).getGraphics()!=null)
        this.resolutionXText.get(i).getGraphics().dispose();
      this.resolutionXText.set(i,null);
      if (this.resolutionZText.get(i).getGraphics()!=null)
        this.resolutionZText.get(i).getGraphics().dispose();
      this.resolutionZText.set(i,null);

      if (i!=this.resolutionLabels.size()-1){
        if (this.resolutionDistLabels.get(i).getGraphics()!=null)
          this.resolutionDistLabels.get(i).getGraphics().dispose();
        this.resolutionDistLabels.set(i,null);
        if (this.resolutionDistText.get(i).getGraphics()!=null)
          this.resolutionDistText.get(i).getGraphics().dispose();
        this.resolutionDistText.set(i,null);
      }
    }
    this.resolutionLabelDistString = null;
    this.resolutionLabelXString = null;
    this.resolutionLabelZString=null;
    if (this.rightMenuBar.getGraphics()!=null)
      this.rightMenuBar.getGraphics().dispose();
    this.rightMenuBar = null;
    if (this.showLightCheckBox.getGraphics()!=null)
      this.showLightCheckBox.getGraphics().dispose();
    this.showLightCheckBox = null;
    if (this.showTextureCheckBox.getGraphics()!=null)
      this.showTextureCheckBox.getGraphics().dispose();
    this.showTextureCheckBox = null;
    if (this.stretchLabelX.getGraphics()!=null)
      this.stretchLabelX.getGraphics().dispose();
    this.stretchLabelX = null;
    if (this.stretchLabelY.getGraphics()!=null)
      this.stretchLabelY.getGraphics().dispose();
    this.stretchLabelY = null;
    if (this.stretchLabelZ.getGraphics()!=null)
      this.stretchLabelZ = null;
    this.stretchLabelZ = null;
    if (this.stretchXField.getGraphics()!=null)
      this.stretchXField.getGraphics().dispose();
    this.stretchXField = null;
    this.stretchXString = null;
    if (this.stretchYField.getGraphics()!=null)
      this.stretchYField.getGraphics().dispose();
    this.stretchYField = null;
    this.stretchYString = null;
    if (this.stretchZField.getGraphics()!=null)
      this.stretchZField.getGraphics().dispose();
    this.stretchZField = null;
    this.stretchZString = null;
    if (this.topMenuBar.getGraphics()!=null)
      this.topMenuBar.getGraphics().dispose();
    this.topMenuBar = null;
    if (this.updateResolutionLevel1.getGraphics()!=null)
      this.updateResolutionLevel1.getGraphics().dispose();
    this.updateResolutionLevel1 = null;
    if (this.updateResolutionLevel2.getGraphics()!=null)
      this.updateResolutionLevel2.getGraphics().dispose();
    this.updateResolutionLevel2 = null;
    this.view_tg = null;
    this.xAxisString = null;
    this.yAxisString = null;
    this.zAxisString = null;
    this.finalizeThisObject();
  }
  
  protected void finalizeThisObject(){
    try {finalize();} catch (Throwable e){}    
  }
  
  protected float getXLabelCorrectionFactor(){
    return 1f;
  }
  
  protected int getRightMenubarYOffset(){
    return 0;
  }
  
  private static Appearance createWhiteAppearance(){
    Appearance appearanceWhite = new Appearance();
    ColoringAttributes coloringAttributesWhite = new ColoringAttributes();
    coloringAttributesWhite.setColor(new Color3f(Color.white.getRGBColorComponents(null)));
    appearanceWhite.setColoringAttributes(coloringAttributesWhite);
    return appearanceWhite;
  }
}
