package at.tugraz.genome.maspectrasService;

import javax.naming.*;
import java.sql.*;
import javax.sql.*;
import at.tugraz.genome.dbutilities.Databases;
import org.apache.log4j.Logger;

/**
 * <p>Title: MARS Service Extension</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: Bioinformatics Group - Graz University of Technology</p>
 * @author Robert Molidor
 * @version 1.0
 */


public class ServerSettings implements ServerSettingsMBean {

  private String JNDIName_ = "not set";
  private static String DATABASEJNDIName = "java:/jdbc/MaspectrasDS";
  private int status_ = STOPPED;
  private java.util.Hashtable/*<String,String>*/ properties_ = new java.util.Hashtable/*<String,String>*/();
  private transient Connection con_ = null;
  private String DATABASE = null;
  private static transient Logger log_ = Logger.getLogger(at.tugraz.genome.maspectrasService.ServerSettings.class);


  public void setProperty(String key, String value) {
    setPropertyDB(key.trim(),value.trim());
    properties_.put(key.trim(), value.trim());
  }

  
  public String getProperty(String key) {
    String retValue = (String)properties_.get(key.trim());
    return retValue;
  }
  
  public void removeProperty(String key) {
    removePropertyDB(key.trim());
    properties_.remove(key.trim());
  }
  
  public String[] getKeys() {
    String[] returnValue = new String[properties_.size()];
    java.util.Enumeration enumer = properties_.keys();
    int i=0;
    while (enumer.hasMoreElements()) {
      returnValue[i] = (String)enumer.nextElement();
      i++;
    }
    return returnValue;
  }
  
  public String listProperties() {
    String returnValue = "Count\tKey\t\tValue\n";
    if (DATABASE.equalsIgnoreCase(Databases.MYSQL)){
      returnValue = "Count\tProperty\t\tValue\n";
    }
    int i=1;
    java.util.Enumeration enumer = properties_.keys();
    while (enumer.hasMoreElements()) {
      String key = (String)enumer.nextElement();
      returnValue = returnValue+i+"\t"+key+"\t\t"+properties_.get(key)+"\n";
      i++;
    }
    return returnValue;
  }

  public String getJNDIName() {
    return JNDIName_;
  }

  public void setJNDIName(String JNDIName) {
    try {
      Context ctx = new InitialContext();
      unbind(ctx, JNDIName_);
      bind(ctx, JNDIName);
      JNDIName_ = JNDIName;
    }
    catch (NamingException ex) {
      log_.error("NamingException: "+ex);
    }
  }

  public String getStatusString() {
    switch (status_) {
      case STOPPED: return "STOPPED";
      case STARTED: return "STARTED";
    }
    return "STOPPED";
  }

  public int getStatus() {
    return status_;
  }

  public void start() {
    if (status_ == STARTED) {
      stop();
    }
    log_.info("start ServerSettingsMBean");
    try {
      Context ctx = new InitialContext();
      con_ = getConnection();
      if (!checkDBExists()) {
        createTable();
      }
      readPropertiesDB();
    }
    catch (NamingException ex) {
      ex.printStackTrace();
    }
    status_ = STARTED;
  }
  
  public void stop() {
    log_.info("stop ServerSettingsMBean");
    try {
      con_.close();
      con_ = null;
      log_.info("Connection closed");
    }
    catch (SQLException ex) {
      ex.printStackTrace();
    }
    status_ = STOPPED;
  }

  private void unbind(Context ctx, String name) throws javax.naming.NamingException {
    if (!name.equals("not set")) {
      ctx.unbind(name);
    }
  }

  private void bind(Context ctx, String name) throws javax.naming.NamingException {
    ctx.bind(name, this);
  } 

  private boolean checkDBExists() {
    try {
      String databasename = con_.getMetaData().getDatabaseProductName();
      log_.info(databasename);
      if (databasename.length()>5){
        if (databasename.substring(0,6).equalsIgnoreCase("Oracle")){
          DATABASE = Databases.ORACLE;
        }else{
          DATABASE = Databases.THESERVERSIDEGUID;
        }
      }else{
        DATABASE = Databases.THESERVERSIDEGUID;
      }
      if (databasename.startsWith("MySQL")){
        DATABASE = Databases.MYSQL;
      }
      if (databasename.startsWith("PostgreSQL")){
        DATABASE = Databases.POSTGRESQL;
      }
    }    catch (SQLException ex) {
      ex.printStackTrace();
    }
    log_.info(DATABASE);
    String sqlStatement = "SELECT * FROM "+TABLENAME;
    PreparedStatement pStmt = null;
    ResultSet rs = null;
    try {
      pStmt = con_.prepareStatement(sqlStatement);
      rs = pStmt.executeQuery();
      rs.close();
      pStmt.close();
      return true;
    } catch (SQLException ex) {
      try {
        pStmt.close();
      }
      catch (SQLException ex1) {
      }
      return false;
    }
  }  

  private void addRequiredProperties() {
    setProperty(PROPERTY_DATABASE, DATABASE);
    setProperty(PROPERTY_DATAROOTDIRECTORY, "/home/maspectrasdata/");
    setProperty(PROPERTY_GUESTUSERALLOWED, "FALSE");
  }

  private boolean createTable() {
    String sqlStatement = null;
    if (DATABASE.equalsIgnoreCase(Databases.MYSQL)){
      sqlStatement = "CREATE TABLE "+TABLENAME+" (\n PROPERTY VARCHAR(150),\n VALUE VARCHAR(255)\n)";
    }
    if (DATABASE.equalsIgnoreCase(Databases.ORACLE)){
      sqlStatement = "CREATE TABLE "+TABLENAME+" (KEY VARCHAR2(150), VALUE VARCHAR2(1000))";
    }
    if (DATABASE.equalsIgnoreCase(Databases.POSTGRESQL)){
      sqlStatement = "CREATE TABLE "+TABLENAME+" (KEY VARCHAR(150), VALUE VARCHAR(1000))";
    }
    if (DATABASE.equalsIgnoreCase(Databases.THESERVERSIDEGUID)){
      sqlStatement = "CREATE TABLE "+TABLENAME+" (KEY VARCHAR(150), VALUE VARCHAR(1000))";
    }
    PreparedStatement pStmt = null;
    ResultSet rs = null;
    try {
      pStmt = con_.prepareStatement(sqlStatement);
      pStmt.executeUpdate();
      pStmt.close();
      addRequiredProperties();
      return true;
    }
    catch (SQLException ex) {
      ex.printStackTrace();
      try {
        pStmt.close();
      }
      catch (SQLException ex1) {
      }
      return false;
    }
  }

  private String getPropertyDB(String key) {
    String sqlStatement = "SELECT VALUE FROM "+TABLENAME+" WHERE (key = ?)";
    if (DATABASE.equalsIgnoreCase(Databases.MYSQL)){
      sqlStatement = "SELECT VALUE FROM "+TABLENAME+" WHERE (property = ?)";
    }
    PreparedStatement pStmt = null;
    ResultSet rs = null;
    try {
      pStmt = con_.prepareStatement(sqlStatement);
      pStmt.setString(1, key);
      rs = pStmt.executeQuery();
      if (rs.next()) {
        return rs.getString(1);
      }
      rs.close();
      pStmt.close();
      return null;
    }
    catch (SQLException ex) {
      ex.printStackTrace();
      try {
        rs.close();
        pStmt.close();
        return null;
      }
      catch (SQLException ex1) {
        return null;
      }
    }
  }
  
  private boolean setPropertyDB(String key, String value) {
    String sqlFindStatement = "SELECT VALUE FROM "+TABLENAME+" WHERE (key = ?)";
    String sqlStatement = "INSERT INTO "+TABLENAME+" VALUES (?,?)";
    String sqlUpdateStatement = "UPDATE "+TABLENAME+" SET value = ? WHERE (key = ?)";
    if (DATABASE.equalsIgnoreCase(Databases.MYSQL)){
      sqlFindStatement = "SELECT VALUE FROM "+TABLENAME+" WHERE (property = ?)";
      sqlUpdateStatement = "UPDATE "+TABLENAME+" SET value = ? WHERE (property = ?)";    
    }  
    PreparedStatement pStmt = null;
    ResultSet rs = null;
    try {
      pStmt = con_.prepareStatement(sqlFindStatement);
      pStmt.setString(1, key);
      rs = pStmt.executeQuery();
      boolean updateable = false;
      if (rs.next()) {
        updateable = true;
      } else {
        updateable = false;
      }
      rs.close();
      pStmt.close();
      if (updateable) {
        pStmt = con_.prepareStatement(sqlUpdateStatement);
        pStmt.setString(1, value);
        pStmt.setString(2, key);
        pStmt.executeUpdate();
        pStmt.close();
      } else {
        pStmt = con_.prepareStatement(sqlStatement);
        pStmt.setString(1, key);
        pStmt.setString(2, value);
        pStmt.executeUpdate();
        pStmt.close();
      }
      return true;
    }
    catch (SQLException ex) {
      ex.printStackTrace();
      try {
        pStmt.close();
      }
      catch (SQLException ex1) {
        return false;
      }
      return false;
    }
  }
  
  private void removePropertyDB(String key) {
    String sqlStatement = "DELETE FROM "+TABLENAME+" WHERE (key = ?)";
    if (DATABASE.equalsIgnoreCase(Databases.MYSQL)){
      sqlStatement = "DELETE FROM "+TABLENAME+" WHERE (property = ?)";
    }
    PreparedStatement pStmt = null;
    ResultSet rs = null;
    try {
      pStmt = con_.prepareStatement(sqlStatement);
      pStmt.setString(1, key);
      pStmt.executeUpdate();
      pStmt.close();
    }
    catch (SQLException ex) {
      ex.printStackTrace();
      try {
        pStmt.close();
      }
      catch (SQLException ex1) {

      }
    }
  }


  private void readPropertiesDB() {
    String sqlStatement = "SELECT * FROM "+TABLENAME;
    PreparedStatement pStmt = null;
    ResultSet rs = null;
    try {
      pStmt = con_.prepareStatement(sqlStatement);
      rs = pStmt.executeQuery();
      while (rs.next()) {
        String key = rs.getString(1);
        String value = rs.getString(2);
        properties_.put(key, value);
      }
      rs.close();
      pStmt.close();
    }
    catch (SQLException ex) {
      ex.printStackTrace();
      try {
        rs.close();
        pStmt.close();
      }
      catch (SQLException ex1) {
      }
    }
  }

  private Connection getConnection() {
    if (con_ == null) {
      try {
        Context ctx = new InitialContext();
        DataSource ds = (DataSource) ctx.lookup(DATABASEJNDIName);
        con_ = ds.getConnection();
      }
      catch (SQLException ex) {
        ex.printStackTrace();
      }
      catch (NamingException ex) {
        ex.printStackTrace();
      }
    }
    return con_;
  }


  public String getDATABASE()
  {
    return DATABASE;
  }


  public static String getDATABASEJNDIName()
  {
    return DATABASEJNDIName;
  }
  
}