package at.tugraz.genome.maspectras.quantification.vos;

import java.io.Serializable;
import java.util.Vector;

/**
 * One chromatogram
 * @author Juergen Hartler
 *
 */
public class CgChromatogramVO implements Serializable
{
  /** lower m/z threshold */
  private float          lowerMzBand;            // Lower m/z area
  /** upper m/z threshold */
  private float          upperMzBand;            // Upper m/z area
  /** number of scans*/
  private int            scanCount;              // Number of scans
  /** main m/z value */
  private float          mz;        
  /** background value */
  private float          background;             // The background
  /** the chromatogram encoded in chromatogram point VOs */
  private Vector         chromatogramPointVOs;

  
  /**
   * @param mz main m/z value
   * @param background background value
   * @param scanCount number of scans
   * @param lowerMzBand lower m/z threshold
   * @param upperMzBand upper m/z threshold
   * @param chromatogramPointVOs chromatogram encoded in chromatogram point VOs
   */  
  public CgChromatogramVO(float mz, float background, int scanCount, float lowerMzBand, float upperMzBand, Vector chromatogramPointVOs)
  {
    super();
    this.background = background;
    this.chromatogramPointVOs = chromatogramPointVOs;
    this.lowerMzBand = lowerMzBand;
    this.mz = mz;
    this.scanCount = scanCount;
    this.upperMzBand = upperMzBand;
  }
  /**
   * @return background value
   */
  public float getBackground()
  {
    return background;
  }
  /**
   * @param background background value
   */
  public void setBackground(float background)
  {
    this.background = background;
  }
  /**
   * @return chromatogram encoded in chromatogram point VOs
   */
  public Vector getChromatogramPointVOs()
  {
    return chromatogramPointVOs;
  }
  /**
   * @param chromatogramPointVOs chromatogram encoded in chromatogram point VOs
   */
  public void setChromatogramPointVOs(Vector chromatogramPointVOs)
  {
    this.chromatogramPointVOs = chromatogramPointVOs;
  }
  /**
   * @return lower m/z threshold
   */
  public float getLowerMzBand()
  {
    return lowerMzBand;
  }
  /**
   * @param lowerMzBand lower m/z threshold
   */
  public void setLowerMzBand(float lowerMzBand)
  {
    this.lowerMzBand = lowerMzBand;
  }
  /**
   * @return main m/z value
   */
  public float getMz()
  {
    return mz;
  }
  /**
   * @param mz main m/z value
   */
  public void setMz(float mz)
  {
    this.mz = mz;
  }
  /**
   * @return number of scans
   */
  public int getScanCount()
  {
    return scanCount;
  }
  /**
   * @param scanCount number of scans
   */
  public void setScanCount(int scanCount)
  {
    this.scanCount = scanCount;
  }
  /**
   * @return upper m/z threshold
   */
  public float getUpperMzBand()
  {
    return upperMzBand;
  }
  /**
   * @param upperMzBand upper m/z threshold
   */
  public void setUpperMzBand(float upperMzBand)
  {
    this.upperMzBand = upperMzBand;
  }      
  

}
