package at.tugraz.genome.maspectras.quantification.vos;

import java.io.Serializable;
import java.util.Vector;

import at.tugraz.genome.maspectras.msResultsAnalysis.vos.ViewersettingVO;

/**
 * Holds the chromatograms of a peptide at different charge states
 * @author Juergen Hartler
 *
 */
public class CgAllChromatogramSets implements Serializable
{
  /** chromatogram with parent charge 1*/
  private CgChromatogramSet charge1;
  /** chromatogram with parent charge 2*/
  private CgChromatogramSet charge2;
  /** chromatogram with parent charge 3*/
  private CgChromatogramSet charge3;
  /** chromatogram with parent charge 4*/
  private CgChromatogramSet charge4;
  /** chromatogram with parent charge 5*/
  private CgChromatogramSet charge5;
  /** chromatogram with parent charge 6*/
  private CgChromatogramSet charge6;
  /** chromatogram with parent charge 7*/
  private CgChromatogramSet charge7;
  /** chromatogram with parent charge 8*/
  private CgChromatogramSet charge8;
  /** chromatogram with parent charge 9*/
  private CgChromatogramSet charge9;
  /** chromatogram with parent charge 10*/
  private CgChromatogramSet charge10;
  /** chromatogram with parent charge 11*/
  private CgChromatogramSet charge11;
  /** chromatogram with parent charge 12*/
  private CgChromatogramSet charge12;
  /** chromatogram with parent charge 13*/
  private CgChromatogramSet charge13;
  /** chromatogram with parent charge 14*/
  private CgChromatogramSet charge14;
  /** chromatogram with parent charge 15*/
  private CgChromatogramSet charge15;
  /** chromatogram with parent charge 16*/
  private CgChromatogramSet charge16;
  /** chromatogram with parent charge 17*/
  private CgChromatogramSet charge17;
  /** chromatogram with parent charge 18*/
  private CgChromatogramSet charge18;
  /** chromatogram with parent charge 19*/
  private CgChromatogramSet charge19;
  /** chromatogram with parent charge 20*/
  private CgChromatogramSet charge20;
  /** chromatogram with parent charge 21*/
  private CgChromatogramSet charge21;
  /** chromatogram with parent charge 22*/
  private CgChromatogramSet charge22;

  /** identifier for the quantification parameters*/
  private Long quantparametersId;
  
  private ViewersettingVO settings;
  
  private Vector<Double> idealIntensityDistribution;
  
  /**
   * @param quantparametersId identifier for the quantification parameters
   */
  public CgAllChromatogramSets(Long quantparametersId)
  {
    this.quantparametersId = quantparametersId;
  }
  
  /**
   * @return chromatogram with parent charge 1
   */
  public CgChromatogramSet getCharge1()
  {
    return charge1;
  }
  /**
   * @param charge1 chromatogram with parent charge 1
   */
  public void setCharge1(CgChromatogramSet charge1)
  {
    this.charge1 = charge1;
  }
  /**
   * @return chromatogram with parent charge 2
   */
  public CgChromatogramSet getCharge2()
  {
    return charge2;
  }
  /**
   * @param charge2 chromatogram with parent charge 2
   */
  public void setCharge2(CgChromatogramSet charge2)
  {
    this.charge2 = charge2;
  }
  /**
   * @return chromatogram with parent charge 3
   */
  public CgChromatogramSet getCharge3()
  {
    return charge3;
  }
  /**
   * @param charge3 chromatogram with parent charge 3
   */
  public void setCharge3(CgChromatogramSet charge3)
  {
    this.charge3 = charge3;
  }
  /**
   * @return chromatogram with parent charge 4
   */
  public CgChromatogramSet getCharge4()
  {
    return charge4;
  }
  /**
   * @param charge4 chromatogram with parent charge 4
   */
  public void setCharge4(CgChromatogramSet charge4)
  {
    this.charge4 = charge4;
  }
  /**
   * @return identifier for the quantification parameters
   */
  public Long getQuantparametersId()
  {
    return quantparametersId;
  }
  /**
   * @return chromatogram with parent charge 5
   */
  public CgChromatogramSet getCharge5()
  {
    return charge5;
  }

  /**
   * @param charge5 chromatogram with parent charge 5
   */
  public void setCharge5(CgChromatogramSet charge5)
  {
    this.charge5 = charge5;
  }

  /**
   * @return chromatogram with parent charge 6
   */
  public CgChromatogramSet getCharge6()
  {
    return charge6;
  }

  /**
   * @param charge6 chromatogram with parent charge 6
   */
  public void setCharge6(CgChromatogramSet charge6)
  {
    this.charge6 = charge6;
  }
  
  /**
   * @return chromatogram with parent charge 7
   */
  public CgChromatogramSet getCharge7()
  {
    return charge7;
  }
  
  /**
   * @param charge7 chromatogram with parent charge 7
   */
  public void setCharge7(CgChromatogramSet charge7)
  {
    this.charge7 = charge7;
  }
  
  /**
   * @return chromatogram with parent charge 8
   */
  public CgChromatogramSet getCharge8()
  {
    return charge8;
  }
  
  /**
   * @param charge8 chromatogram with parent charge 8
   */
  public void setCharge8(CgChromatogramSet charge8)
  {
    this.charge8 = charge8;
  }
  
  /**
   * @return chromatogram with parent charge 9
   */
  public CgChromatogramSet getCharge9()
  {
    return charge9;
  }
  
  /**
   * @param charge9 chromatogram with parent charge 9
   */
  public void setCharge9(CgChromatogramSet charge9)
  {
    this.charge9 = charge9;
  }
  
  
  /**
   * @return chromatogram with parent charge 10
   */
  public CgChromatogramSet getCharge10()
  {
    return charge10;
  }

  /**
   * @param charge10 chromatogram with parent charge 10
   */
  public void setCharge10(CgChromatogramSet charge10)
  {
    this.charge10 = charge10;
  }

  /**
   * @return chromatogram with parent charge 11
   */
  public CgChromatogramSet getCharge11()
  {
    return charge11;
  }

  /**
   * @param charge11 chromatogram with parent charge 11
   */
  public void setCharge11(CgChromatogramSet charge11)
  {
    this.charge11 = charge11;
  }

  /**
   * @return chromatogram with parent charge 12
   */
  public CgChromatogramSet getCharge12()
  {
    return charge12;
  }

  /**
   * @param charge12 chromatogram with parent charge 12
   */
  public void setCharge12(CgChromatogramSet charge12)
  {
    this.charge12 = charge12;
  }

  /**
   * @return chromatogram with parent charge 13
   */
  public CgChromatogramSet getCharge13()
  {
    return charge13;
  }

  /**
   * @param charge13 chromatogram with parent charge 13
   */
  public void setCharge13(CgChromatogramSet charge13)
  {
    this.charge13 = charge13;
  }

  /**
   * @return chromatogram with parent charge 14
   */
  public CgChromatogramSet getCharge14()
  {
    return charge14;
  }

  /**
   * @param charge14 chromatogram with parent charge 14
   */
  public void setCharge14(CgChromatogramSet charge14)
  {
    this.charge14 = charge14;
  }

  /**
   * @return chromatogram with parent charge 15
   */
  public CgChromatogramSet getCharge15()
  {
    return charge15;
  }

  /**
   * @param charge15 chromatogram with parent charge 15
   */
  public void setCharge15(CgChromatogramSet charge15)
  {
    this.charge15 = charge15;
  }

  /**
   * @return chromatogram with parent charge 16
   */
  public CgChromatogramSet getCharge16()
  {
    return charge16;
  }

  /**
   * @param charge16 chromatogram with parent charge 16
   */
  public void setCharge16(CgChromatogramSet charge16)
  {
    this.charge16 = charge16;
  }

  /**
   * @return chromatogram with parent charge 17
   */
  public CgChromatogramSet getCharge17()
  {
    return charge17;
  }

  /**
   * @param charge17 chromatogram with parent charge 17
   */
  public void setCharge17(CgChromatogramSet charge17)
  {
    this.charge17 = charge17;
  }

  /**
   * @return chromatogram with parent charge 18
   */
  public CgChromatogramSet getCharge18()
  {
    return charge18;
  }

  /**
   * @param charge18 chromatogram with parent charge 18
   */
  public void setCharge18(CgChromatogramSet charge18)
  {
    this.charge18 = charge18;
  }

  /**
   * @return chromatogram with parent charge 19
   */
  public CgChromatogramSet getCharge19()
  {
    return charge19;
  }

  /**
   * @param charge19 chromatogram with parent charge 19
   */
  public void setCharge19(CgChromatogramSet charge19)
  {
    this.charge19 = charge19;
  }

  /**
   * @return chromatogram with parent charge 20
   */
  public CgChromatogramSet getCharge20()
  {
    return charge20;
  }

  /**
   * @param charge20 chromatogram with parent charge 20
   */
  public void setCharge20(CgChromatogramSet charge20)
  {
    this.charge20 = charge20;
  }

  /**
   * @return chromatogram with parent charge 21
   */
  public CgChromatogramSet getCharge21()
  {
    return charge21;
  }

  /**
   * @param charge21 chromatogram with parent charge 21
   */
  public void setCharge21(CgChromatogramSet charge21)
  {
    this.charge21 = charge21;
  }

  /**
   * @return chromatogram with parent charge 22
   */
  public CgChromatogramSet getCharge22()
  {
    return charge22;
  }

  /**
   * @param charge22 chromatogram with parent charge 22
   */
  public void setCharge22(CgChromatogramSet charge22)
  {
    this.charge22 = charge22;
  }

  /**
   * @param quantparametersId identifier for the quantification parameters
   */
  public void setQuantparametersId(Long quantparametersId)
  {
    this.quantparametersId = quantparametersId;
  }

  public Vector<Double> getIdealIntensityDistribution()
  {
    return idealIntensityDistribution;
  }

  public void setIdealIntensityDistribution(
      Vector<Double> idealIntensityDistribution)
  {
    this.idealIntensityDistribution = idealIntensityDistribution;
  }

  public ViewersettingVO getSettings()
  {
    return settings;
  }

  public void setSettings(ViewersettingVO settings)
  {
    this.settings = settings;
  }

  
  
  
}
