/*
 * Created on 24.06.2005
 * Erik Koerner, FH Joanneum
 * erik.koerner@fh-joanneum.at
 */
package at.tugraz.genome.maspectras.quantification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;

/**
 * Parameters and Results for an Analysis. Fill in the parameters required and
 * pass this object to the analysis process. During this analysis process the
 * result fields are determined.
 * 
 * @author Erik Koerner
 * @version 25.06.2005
 */
public class CgParameterSet
{
    public float			Mz[];					// Masses
    public String			 Peptide;				// The peptide string
    public float            Area;                   // Result
    public float			LowerMzBand;			// Lower m/z area
    public float			UpperMzBand;			// Upper m/z area
    public int				ValleyMethod;			// What algorithm to use
    
    protected ArrayList<CgProbe>		m_probes;
    
    protected Vector<Vector<CgProbe>> isotopicProbes_;
    
    /**
     * Constructor for a new analysis parameter set.
     * 
     * @param mz
     *      Charge +1 m/z value
     * @param peptide
     *      String representing the peptide. Used for printout.
     */
    public CgParameterSet(float mz, String peptide)
    {
        m_probes = new ArrayList<CgProbe>();
        Mz = new float[CgDefines.MaxCharge];
        DetermineMasses(mz);
        Peptide = peptide;
        Area = 0;
        LowerMzBand = 1;
        UpperMzBand = 1;
        ValleyMethod = CgDefines.StandardValleyMethod;//.EnhancedValleyMethod;
        isotopicProbes_ = new Vector<Vector<CgProbe>>();
    }
    
    public CgParameterSet (float mz, String peptide,float plus1Mass,float plus2Mass,float plus3Mass, float plus4Mass,
        float plus5Mass, float plus6Mass, float plus7Mass, float plus8Mass, float plus9Mass, float plus10Mass, float plus11Mass, 
        float plus12Mass, float plus13Mass, float plus14Mass, float plus15Mass, float plus16Mass, float plus17Mass, float plus18Mass, 
        float plus19Mass, float plus20Mass, float plus21Mass, float plus22Mass){
      this (mz,peptide);
      if (plus1Mass>0){
        determineMass(1,plus1Mass);
      }
      if (plus2Mass>0){
        determineMass(2,plus2Mass);
      }
      if (plus3Mass>0){
        determineMass(3,plus3Mass);
      }
      if (plus4Mass>0){
        determineMass(4,plus4Mass);
      }
      if (plus5Mass>0){
        determineMass(5,plus5Mass);
      }
      if (plus6Mass>0){
        determineMass(6,plus6Mass);
      }
      if (plus7Mass>0){
        determineMass(7,plus7Mass);
      }
      if (plus8Mass>0){
        determineMass(8,plus8Mass);
      }
      if (plus9Mass>0){
        determineMass(9,plus9Mass);
      }
      if (plus10Mass>0){
        determineMass(10,plus10Mass);
      }
      if (plus11Mass>0){
        determineMass(11,plus11Mass);
      }
      if (plus12Mass>0){
        determineMass(12,plus12Mass);
      }
      if (plus13Mass>0){
        determineMass(13,plus13Mass);
      }
      if (plus14Mass>0){
        determineMass(14,plus14Mass);
      }
      if (plus15Mass>0){
        determineMass(15,plus15Mass);
      }
      if (plus16Mass>0){
        determineMass(16,plus16Mass);
      }
      if (plus17Mass>0){
        determineMass(17,plus17Mass);
      }
      if (plus18Mass>0){
        determineMass(18,plus18Mass);
      }
      if (plus19Mass>0){
        determineMass(19,plus19Mass);
      }
      if (plus20Mass>0){
        determineMass(20,plus20Mass);
      }
      if (plus21Mass>0){
        determineMass(21,plus21Mass);
      }
      if (plus22Mass>0){
        determineMass(22,plus22Mass);
      }
    }
    
    /**
     * Constructor for a new analysis parameter set.
     * 
     * @param mz
     *      Charge +1 m/z value
     * @param peptide
     *      String representing the peptide. Used for printout.
     */
    public CgParameterSet(double mz, String peptide)
    {
        this((float)mz, peptide);
    }
    
    /**
     * Adds a probe object to the parameter set. Each probe is analyzed separately.
     * @param px
     *      The CgProbe to be analyzed 
     * @throws CgException
     */
    public void AddProbe(CgProbe px) throws CgException
    {
        if (m_probes.contains(px)) throw new CgException("Duplicate Parameter in Parameter List.");
        m_probes.add(px);
        this.generateIsotopicHash();
    }
    
    /**
     * Informs about the number of probes stored
     * @return
     *      Number of probe objects aggregated
     */
    public int ProbeCount()
    {
        return m_probes.size();
    }
    
    /**
     * Returns a probe object specified by a given index
     * 
     * @param index
     *      Index of probe object
     * @return
     *      Probe object, if index in valid range, null otherwise
     */
    public CgProbe Probe(int index)
    {
        if (index>=ProbeCount()) return null;
        return m_probes.get(index);
    }
    
    /**
     * Determine the masses for a given Base Mass (+1 Charge state)
     *  
     * @param mz
     *      Base Mass (+1 Charge state)
     */
    private void DetermineMasses(float mz)
    {
        for (int i=0; i<CgDefines.MaxCharge; i++)
        {
            Mz[i] = -1;//(mz + i) / (i + 1);
        }
    }
    
    public void determineMass(int charge, float mz){
      Mz[charge-1]= (mz + (charge-1)) / (charge);
    }
    
    public void setProbes(Collection<CgProbe> probes){
      this.m_probes = new ArrayList<CgProbe>(probes);
      this.generateIsotopicHash();
    }
    
    private void generateIsotopicHash(){
      Hashtable<Integer,Vector<CgProbe>> isotopeHash = new Hashtable<Integer,Vector<CgProbe>>();
      int lowestIsotope = 0;
      int highestIsotope = 0;
      for (CgProbe probe : this.m_probes){
        Vector<CgProbe> isoProbes = new  Vector<CgProbe>();
        if (isotopeHash.containsKey(probe.isotopeNumber))
          isoProbes = isotopeHash.get(probe.isotopeNumber);
        isoProbes.add(probe);
        isotopeHash.put(probe.isotopeNumber, isoProbes);
        if (probe.isotopeNumber<lowestIsotope) lowestIsotope=probe.isotopeNumber;
        if (probe.isotopeNumber>highestIsotope) highestIsotope=probe.isotopeNumber;
      }
      for (int i=lowestIsotope;i!=(highestIsotope+1);i++){
        if (!isotopeHash.containsKey(i))isotopeHash.put(i,new  Vector<CgProbe>());
      }
      this.isotopicProbes_ = new Vector<Vector<CgProbe>>();
      for (int i=0;i!=isotopeHash.size();i++){
        if (lowestIsotope<0)
          this.isotopicProbes_.add(isotopeHash.get((i*-1)));        
        else
          this.isotopicProbes_.add(isotopeHash.get(i));
      }
    }
    
    public void setIsotopicProbes(Vector<Vector<CgProbe>> probes){
      this.isotopicProbes_ = probes;
    }
    
    public Vector<Vector<CgProbe>> getIsotopicProbes(){
      return this.isotopicProbes_;
    }
    
    public int getMaxIsotope(){
      int isotope = 0;
      for (int i=0; i!=ProbeCount();i++){
        int isoNumber = this.m_probes.get(i).isotopeNumber;
        if (isoNumber>isotope)
          isotope = isoNumber;
      }
      return isotope;
    }
}
