package at.tugraz.genome.maspectras.parser.spectrummill.vos;

import java.util.Hashtable;
import java.util.Vector;

public class ChemicalFormulaVO
{
  private Hashtable<String,SmChemicalElementVO> elementLookup_;
  private Hashtable<String,Integer> amountOfElements_;
  
  public ChemicalFormulaVO(){
    elementLookup_ = new Hashtable<String,SmChemicalElementVO>();
    amountOfElements_ = new Hashtable<String,Integer>();
  }
  
  public ChemicalFormulaVO(ChemicalFormulaVO otherFormulaVO){
    this.elementLookup_ = new Hashtable<String,SmChemicalElementVO>(otherFormulaVO.elementLookup_);
    this.amountOfElements_ = new Hashtable<String,Integer>(otherFormulaVO.amountOfElements_);
  }
  
  public void addElement(SmChemicalElementVO elementVO){
    elementLookup_.put(elementVO.getChemicalSymbol(), elementVO);
    int amountOfElement = 0;
    if (amountOfElements_.containsKey(elementVO.getChemicalSymbol())){
      amountOfElement = amountOfElements_.get(elementVO.getChemicalSymbol());
    }
    amountOfElement++;
    this.amountOfElements_.put(elementVO.getChemicalSymbol(), amountOfElement);
  }
  
  public void removeElement(SmChemicalElementVO elementVO){
    if (amountOfElements_.containsKey(elementVO.getChemicalSymbol())){
      int amountOfElement = amountOfElements_.get(elementVO.getChemicalSymbol());
      amountOfElement--;
      if (amountOfElement<1){
        amountOfElements_.remove(elementVO.getChemicalSymbol());
        elementLookup_.remove(elementVO.getChemicalSymbol());
      }else{
        amountOfElements_.put(elementVO.getChemicalSymbol(), amountOfElement);
      }
    }else{
      elementLookup_.remove(elementVO.getChemicalSymbol());
    }
  }
  
  public void removeElement(SmChemicalElementVO elementVO, int nrOfElements){
    if (amountOfElements_.containsKey(elementVO.getChemicalSymbol())){
      int amountOfElement = amountOfElements_.get(elementVO.getChemicalSymbol());
      amountOfElement = amountOfElement-nrOfElements;
      if (amountOfElement<1){
        amountOfElements_.remove(elementVO.getChemicalSymbol());
        elementLookup_.remove(elementVO.getChemicalSymbol());
      }else{
        amountOfElements_.put(elementVO.getChemicalSymbol(), amountOfElement);
      }
    }else{
      elementLookup_.remove(elementVO.getChemicalSymbol());
    }
  }
  
  public int getNumberOfItemsOfOneElement(SmChemicalElementVO elementVO){
    int nrOfItems = 0;
    if (amountOfElements_.containsKey(elementVO.getChemicalSymbol())){
      nrOfItems = amountOfElements_.get(elementVO.getChemicalSymbol());
    }
    return nrOfItems;
  }
  
  public float getMassOfAddedElements(){
    float mass = 0;
    for (String chemSymbol : amountOfElements_.keySet()){
      mass += amountOfElements_.get(chemSymbol)*(elementLookup_.get(chemSymbol).getMonoMass());
    }
    return mass;
  }
  
  public Vector<SmChemicalElementVO> getElements(){
    Vector<SmChemicalElementVO> elements = new Vector<SmChemicalElementVO>();
    for (String chemSymbol: amountOfElements_.keySet()){
      for (int i=0; i!=amountOfElements_.get(chemSymbol);i++){
        elements.add(elementLookup_.get(chemSymbol));
      }
    }
    return elements;
  }
  
  public String getChemicalFormula(){
    String formula = "";
    for (String chemFormula : amountOfElements_.keySet()){
      if (formula.length()>0){
        formula+=" ";
      }
      formula+=chemFormula+amountOfElements_.get(chemFormula);
    }
    return formula;
  }
  
  public void removeAllOfOneElement(SmChemicalElementVO element){
    elementLookup_.remove(element.getChemicalSymbol());
    amountOfElements_.remove(element.getChemicalSymbol());
  }
  
  public boolean isProbable(){
    boolean isProbable = true;
    if (this.elementLookup_.size()==1)
      isProbable = false;
    if (this.elementLookup_.size()==2){
      int count = 0;
      int amount1 = 0;
      int amount2 = 0;
      for (String chemSymbol : amountOfElements_.keySet()){
        if (count==0)
          amount1 = amountOfElements_.get(chemSymbol);
        if (count==1)
          amount2 = amountOfElements_.get(chemSymbol);
        count++;
      }
      if (amount1/amount2>8||amount2/amount1<8){
        isProbable = false;
      }
    }
    return isProbable;
  }
  
}
