package at.tugraz.genome.maspectras.parser.spectrummill.vos;

import java.util.Hashtable;
import java.util.Vector;

public class AaFormulaVO
{
  private Hashtable<String,SmAaVO> aaLookup_;
  private Hashtable<String,Integer> amountOfAas_;
  private long timesFound_;
  
  public AaFormulaVO(){
    aaLookup_ = new Hashtable<String,SmAaVO>();
    amountOfAas_ = new Hashtable<String,Integer>();
    timesFound_ = 1;
  }
  
  public AaFormulaVO(AaFormulaVO otherFormulaVO){
    this.aaLookup_ = new Hashtable<String,SmAaVO>(otherFormulaVO.aaLookup_);
    this.amountOfAas_ = new Hashtable<String,Integer>(otherFormulaVO.amountOfAas_);
  }
  
  public void addAa(SmAaVO aaVO){
    aaLookup_.put(aaVO.getKeyName(), aaVO);
    int amountOfElement = 0;
    if (amountOfAas_.containsKey(aaVO.getKeyName())){
      amountOfElement = amountOfAas_.get(aaVO.getKeyName());
    }
    amountOfElement++;
    this.amountOfAas_.put(aaVO.getKeyName(), amountOfElement);
  }
  
  public void addAa(SmAaVO aaVO,int amount){
    aaLookup_.put(aaVO.getKeyName(), aaVO);
    int amountOfElement = 0;
    if (amountOfAas_.containsKey(aaVO.getKeyName())){
      amountOfElement = amountOfAas_.get(aaVO.getKeyName());
    }
    amountOfElement += amount;
    this.amountOfAas_.put(aaVO.getKeyName(), amountOfElement);
  }
  
  public void removeAa(SmAaVO aaVO){
    if (amountOfAas_.containsKey(aaVO.getKeyName())){
      int amountOfElement = amountOfAas_.get(aaVO.getKeyName());
      amountOfElement--;
      if (amountOfElement<1){
        amountOfAas_.remove(aaVO.getKeyName());
        aaLookup_.remove(aaVO.getKeyName());
      }else{
        amountOfAas_.put(aaVO.getKeyName(), amountOfElement);
      }
    }else{
      aaLookup_.remove(aaVO.getKeyName());
    }
  }
  
  public void removeAa(SmAaVO aaVO, int nrOfElements){
    if (amountOfAas_.containsKey(aaVO.getKeyName())){
      int amountOfElement = amountOfAas_.get(aaVO.getKeyName());
      amountOfElement = amountOfElement-nrOfElements;
      if (amountOfElement<1){
        amountOfAas_.remove(aaVO.getKeyName());
        aaLookup_.remove(aaVO.getKeyName());
      }else{
        amountOfAas_.put(aaVO.getKeyName(), amountOfElement);
      }
    }else{
      aaLookup_.remove(aaVO.getKeyName());
    }
  }
  
  public int getNumberOfItemsOfOneElement(SmAaVO aaVO){
    int nrOfItems = 0;
    if (amountOfAas_.containsKey(aaVO.getKeyName())){
      nrOfItems = amountOfAas_.get(aaVO.getKeyName());
    }
    return nrOfItems;
  }
  
  public float getMassOfAddedAas(){
    float mass = 0;
    for (String aaSymbol : amountOfAas_.keySet()){
      mass += amountOfAas_.get(aaSymbol)*(aaLookup_.get(aaSymbol).getMassValue());
    }
    return mass;
  }
  
//  public Vector<SmChemicalElementVO> getElements(){
//    Vector<SmChemicalElementVO> elements = new Vector<SmChemicalElementVO>();
//    for (String chemSymbol: amountOfElements_.keySet()){
//      for (int i=0; i!=amountOfElements_.get(chemSymbol);i++){
//        elements.add(elementLookup_.get(chemSymbol));
//      }
//    }
//    return elements;
//  }
  
  public String getChemicalFormula(){
    Hashtable<String,Integer> amountOfElements = new Hashtable<String,Integer>();
    for (String aaKey : amountOfAas_.keySet()){
      SmAaVO aaVO = aaLookup_.get(aaKey);
      int nrAas = amountOfAas_.get(aaKey);
      for (SmChemicalElementVO elem : aaVO.getElementsOfAA()){
        int amountOfElement = 0;
        if (amountOfElements.containsKey(elem.getChemicalSymbol())){
          amountOfElement = amountOfElements.get(elem.getChemicalSymbol());
        }
        amountOfElement += nrAas;
        amountOfElements.put(elem.getChemicalSymbol(), amountOfElement);
      }
      
    }
    String formula = "";
    for (String chemFormula : amountOfElements.keySet()){
      if (formula.length()>0){
        formula+=" ";
      }
      formula+=chemFormula+amountOfElements.get(chemFormula);
    }
    return formula;
  }
  
  public String getAaFormula(){
    String formula = "";
    for (String aaFormula : amountOfAas_.keySet()){
      if (formula.length()>0){
        formula+=" ";
      }
      formula+=aaFormula+amountOfAas_.get(aaFormula);
    }
    return formula;
  }
  
  public void removeAllOfOneAa(SmAaVO aaVO){
    aaLookup_.remove(aaVO.getKeyName());
    amountOfAas_.remove(aaVO.getKeyName());
  }
  
//  public boolean isProbable(){
//    boolean isProbable = true;
//    if (this.elementLookup_.size()==1)
//      isProbable = false;
//    if (this.elementLookup_.size()==2){
//      int count = 0;
//      int amount1 = 0;
//      int amount2 = 0;
//      for (String chemSymbol : amountOfElements_.keySet()){
//        if (count==0)
//          amount1 = amountOfElements_.get(chemSymbol);
//        if (count==1)
//          amount2 = amountOfElements_.get(chemSymbol);
//        count++;
//      }
//      if (amount1/amount2>8||amount2/amount1<8){
//        isProbable = false;
//      }
//    }
//    return isProbable;
//  }
  public void addOneTimesFound(){
    this.timesFound_++;
  }

  public long getTimesFound()
  {
    return timesFound_;
  }
  
  
}
