package at.tugraz.genome.maspectras.chromaviewer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;


import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import at.tugraz.genome.maspectras.quantification.CgProbe;

import java.util.Vector;

import at.tugraz.genome.maspectras.utils.exception.ProtocolException;

/**
 * Stores the selected peak areas back to the MASPECTRAS database
 * @author hartler
 */
public class CgThreadedDataStorer extends Thread
{

  /**
   * chromatograms at different charge states
   */
  private CgChromaSetInfo m_info[] = null;
  
  /** URL to the server */
  private String          m_base_url = "";
  
  /** the applet class */
  private CgChromaViewer  m_viewer;
  
  /** true when the first time data is retrieved */
  private boolean         m_firstCall;
  
  /** 
   * 
   * @param myViewer the quantification applet
   */
  public CgThreadedDataStorer(CgChromaViewer myViewer)
    {
        super();
        m_viewer = myViewer;
    }
  
  
  /** 
   * 
   * @param sets the URL to the server
   */  
    public void setBaseUrl(String newValue)
    {
        m_base_url = newValue;
    }
    
    /**
     * 
     * @return if the thread is currently working
     */
    public boolean getBusy()
    {
        return this.isAlive();
    }
    
    /**
     * 
     * @return if the storage procedure is finished
     */
    public boolean getJustReady()
    {
        if (m_firstCall==true)
        {
            m_firstCall = false;
            return true;
        }
        return false;
    }
    
//    public CgChromaSetInfo[] getInfo()
//    {
//        return m_info;
//    }
    
    
    /**
     * starts the thread
     */
    public void run()
    {
        URLConnection servletConnection = null;
        
//        String url = m_base_url;
        try
        {
                  // this is only necessary for testing purposes, with applet loaded from the server not necessary
            if (m_base_url.startsWith("https"))
            {
                TrustManager[] trustAllCerts = new TrustManager[]
                { 
                    new X509TrustManager()
                    {
                        public boolean checkClientTrusted(java.security.cert.X509Certificate[] chain)               { return true; }
                        public java.security.cert.X509Certificate[] getAcceptedIssuers()                            { return null; }
                        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) { }
                        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) { } 
                    } 
                };
                try 
                {
                    SSLContext ctx;
                    ctx = SSLContext.getInstance("SSL");
                    ctx.init(null, trustAllCerts, null);
////                    HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
            } // this is only necessary for testing purposes, with applet loaded from the server not necessary
            String storeQuantparameterUrl = this.getStoreparametersURL();
            checkUrl(storeQuantparameterUrl);
            servletConnection = getServletConnection(storeQuantparameterUrl);
//            servletConnection.connect();
            servletConnection.getInputStream();
//            inputParams.readObject();
            m_info = m_viewer.m_info;
            for (int i=0;i!=CgChromaViewer.maxCharge_;i++){
              if (m_info[i]!=null){
                CgChromaSetInfo setInfo = m_info[i];
                int numberOfChromas = setInfo.getChromaCount();
                int lowerSpan = (new Double(m_viewer.m_lowerSpan)).intValue();
                Vector addableProbes = setInfo.getAddableProbes();
                Vector returnedProbes = new Vector();
                for (int j=0; j!=addableProbes.size();j++){
                  CgProbe anAddableProbe = (CgProbe)addableProbes.get(j);
                  String addProbeUrl = getAddQuantpeakURL(anAddableProbe,setInfo.getSpanNumber(anAddableProbe,(new Double(m_viewer.m_lowerSpanText.getText())).intValue()));
                  checkUrl(addProbeUrl);
                  servletConnection = getServletConnection(addProbeUrl);
                  ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
                  Long id = (Long)input.readObject();
                  anAddableProbe.setPeakId(id);
                  returnedProbes.add(anAddableProbe);
                  
                }
                Vector deletableProbes = setInfo.getDeletableProbes();
                for (int j=0; j!=deletableProbes.size();j++){
                  CgProbe anDeleteableProbe = (CgProbe)deletableProbes.get(j);
                  String deleteProbeUrl = getDeleteQuantpeakURL(anDeleteableProbe,setInfo.getSpanNumber(anDeleteableProbe,(new Double(m_viewer.m_lowerSpanText.getText())).intValue()));
                  checkUrl(deleteProbeUrl);
                  servletConnection = getServletConnection(deleteProbeUrl);
//                  servletConnection.connect();
                  servletConnection.getInputStream();
//                  Long id = (Long)input.readObject();
                }
                returnedProbes = this.deleteDeletedIds(returnedProbes,deletableProbes);
                setInfo.updateSystemProbes(returnedProbes);
              }
            }
            String refreshUrl = this.getRefreshQuantpeakURL();
            checkUrl(refreshUrl);
            servletConnection = getServletConnection(refreshUrl);
//            servletConnection.connect();
            servletConnection.getInputStream();
            m_viewer.setChromaSetInfoArray(m_info);
/*            servletConnection = getServletConnection(url); 
            ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
            CgAllChromatogramSets sets = (CgAllChromatogramSets)input.readObject();
*/            
        }
        catch(Exception ex)
        {
            System.out.println(ex.toString());
        }
        m_firstCall = true;
    }
    
    /**
     * 
     * @param returnedProbes peak areas storead at the server
     * @param deletableProbes peak areas which have to be removed
     * @return the remaining peak areas
     */
    private Vector deleteDeletedIds(Vector returnedProbes, Vector deletableProbes){
      Vector notDeletedIds = new Vector();
      for (int i=0; i!=returnedProbes.size(); i++){
        CgProbe returnedProbe = (CgProbe)returnedProbes.get(i);
        boolean isDeleted = false;
        for (int j=0; j!=deletableProbes.size();j++){
          CgProbe deletedProbe = (CgProbe)deletableProbes.get(j);
          if (returnedProbe.getPeakId()!=null&&deletedProbe.getPeakId()!=null&&returnedProbe.getPeakId().longValue()==deletedProbe.getPeakId().longValue())
            isDeleted = true;
        }
        if (!isDeleted)notDeletedIds.add(returnedProbe);
      }
      return notDeletedIds;
    }
    
    /**
     * Checks if the URL to the server is OK
     * @param url address to the server
     * @return returns if the URL is correct
     * @throws ProtocolException
     */
    private static boolean checkUrl(String url) throws Exception
    {
        if (url.length()>1024) throw new Exception("http request to long >1024!");
        return true;
    }

    /**
     * Returns the connection to the server
     * @param serverName URL adress to the server
     * @return the connection to the server
     */
    private static URLConnection getServletConnection(String serverName)
    {
        URL url = null;
        URLConnection servletConnection = null;
        try
        {
            url = new URL(serverName);
            servletConnection = url.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setRequestProperty("Content-type","application/octet-stream");
        }
        catch (IOException ioe)
        {
            System.out.println(ioe.getMessage());
            System.out.println("IOException " + ioe);
        } 
        catch (Exception e) 
        {
            System.out.println("Error in getServletConnection: " + e.getMessage());
        }
        return servletConnection;
    }
    
    /**
     * Assembles the URL for the HTTP connection
     * @return the URL
     */
    private String getStoreparametersURL(){
      String url=this.m_base_url;
      url += "/StoreQuantparameters";
      url += "?";
      url += "quantparametersId="+m_viewer.quantId;
      url += "&";
      url += "step="+m_viewer.m_stepMzText.getText();
      url += "&";
      url += "lowerSpan="+m_viewer.m_lowerSpanText.getText();
      url += "&";
      url += "upperSpan="+m_viewer.m_upperSpanText.getText();
      return url;
    }
    
    /**
     * Assembles the URL to store a peak area
     * @param cp peak area VO containing the parameters
     * @param spanNumber identifier for the chromatogram used
     * @return the URL
     */
    private String getAddQuantpeakURL(CgProbe cp,int spanNumber){
      String url=this.m_base_url;
      url += "/AddQuantpeak";
      url += "?";
      if (cp.getPeakId()!=null){
        url += "quantpeakId="+cp.getPeakId();
        url += "&";        
      }
      url += "quantId="+m_viewer.quantId;
      url += "&";
      url += "charge="+Integer.toString(cp.Charge);
      url += "&";
      url += "lowVal="+Double.toString(cp.LowerValley);
      url += "&";
      url += "upVal="+Double.toString(cp.UpperValley);
      url += "&";
      url += "area="+Double.toString(cp.Area);
      url += "&";
      url += "spNr="+Integer.toString(spanNumber);
      url += "&";
      url += "peak="+Double.toString(cp.Peak);
      url += "&";
      url += "bkgrnd="+Double.toString(cp.Background);
      url += "&";
      url += "arEr="+Double.toString(cp.AreaError);
      url += "&";
      url += "mz="+Float.toString(cp.Mz-Float.parseFloat(m_viewer.m_stepMzText.getText())*spanNumber);
      return url;
    }
    
    /**
     * Assembles the URL to delete a peak area
     * @param cp cp peak area VO containing the parameters
     * @param spanNumber identifier for the chromatogram used
     * @return the URL
     */
    private String getDeleteQuantpeakURL(CgProbe cp,int spanNumber){
      String url=this.m_base_url;
      url += "/DeleteQuantpeak";
      url += "?";
      if (cp.getPeakId()!=null){
        url += "quantpeakId="+cp.getPeakId();
        url += "&";        
      }
      url += "quantId="+m_viewer.quantId;
      url += "&";
      url += "charge="+Integer.toString(cp.Charge);
      url += "&";
      url += "lowVal="+Double.toString(cp.LowerValley);
      url += "&";
      url += "upVal="+Double.toString(cp.UpperValley);
      url += "&";
      url += "area="+Double.toString(cp.Area);
      url += "&";
      url += "spNr="+Integer.toString(spanNumber);
      url += "&";
      url += "peak="+Double.toString(cp.Peak);
      url += "&";
      url += "bkgrnd="+Double.toString(cp.Background);
      url += "&";
      url += "arEr="+Double.toString(cp.AreaError);
      return url;
    }
    
    /**
     * Assembles an URL to refresh the peak area in the peptide hit table
     * @return the URL
     */
    private String getRefreshQuantpeakURL(){
      String url=this.m_base_url;
      url += "/RefreshTotalArea";
      url += "?";
      url += "quantparametersId="+m_viewer.quantId;
      return url;
    }
    
    public void destroyDataStorer(){
      this.m_base_url = null;
      if (this.m_info!=null){
        for (int i=0;i!=this.m_info.length;i++){
          if (m_info[i]!=null){
            this.m_info[i].destroyInfoObject();
          }
          this.m_info[i] = null;
        }
      }
      this.m_info = null;
      if (this.m_viewer!=null)
        this.m_viewer.getGraphics().dispose();
      this.m_viewer = null;
//      try {
//        this.finalize();
//      }
//      catch (Throwable e) {
        // TODO Auto-generated catch block
//        e.printStackTrace();
//      }
//      super.destroy();
    }
}
