package at.tugraz.genome.maspectras;

import at.tugraz.genome.dbutilities.DatabaseTableField;
import at.tugraz.genome.dbutilities.GenericDAOFactory;
import at.tugraz.genome.utils.UtilsConstants;

import java.util.Collection;
import java.util.Iterator;

/**
 *  Global constants used by the application.
 *
*/
public class GlobalConstantsGenerated
{
   /**
    * Serves for the Report Beans to select a distinct database table field by the display name
    * @param fields the searchable fields provided by the report beans
    * @param dbField the display name of the database field to look for
    * @return the corresponding searchable field
    */
  public static DatabaseTableField getDatabaseTableField(Collection fields, String dbField) {
    Iterator it = fields.iterator();
    while (it.hasNext()) {
      DatabaseTableField dbtf = (DatabaseTableField) it.next();
      if (dbtf.getDBFieldDisplayName().equals(dbField)) {
        return dbtf;
      }
    }
    return null;
  }

  /**
   * @return a string as identifier for the database type
   */
  public static String getDatabase(){
    return UtilsConstants.getDatabase();
  }
  
  /** the datasource JNDI name used */
  public static final String DATASOURCE_JNDI = UtilsConstants.DATASOURCE_JNDI;
  
  /**
   * @return the factory for the JDBC connection
   */
  public static GenericDAOFactory getDAOFactory() {
    return UtilsConstants.getDAOFactory();
  }   
    
  /**
   * @return the globally used search operators (=,>,<,<>,LIKE,...)
   */  
  public static java.util.Collection getSearchOperators() {
    return UtilsConstants.getSearchOperators();
  }

  /** the pk constant of the database table EXPERIMENT */
  public static final String EXPERIMENT_ID = "experimentId";
  /** the constant for the column ID of the database table EXPERIMENT */
  public static final String EXPERIMENT_FIELD_ID = "Id";
  /** the constant for the column HYPOTHESIS of the database table EXPERIMENT */
  public static final String EXPERIMENT_FIELD_HYPOTHESIS = "Hypothesis";
  /** the constant for the column METHOD_CITATIONS of the database table EXPERIMENT */
  public static final String EXPERIMENT_FIELD_METHOD_CITATIONS = "MethodCitations";
  /** the constant for the column RESULT_CITATIONS of the database table EXPERIMENT */
  public static final String EXPERIMENT_FIELD_RESULT_CITATIONS = "ResultCitations";
  /** the constant for the column TITLE of the database table EXPERIMENT */
  public static final String EXPERIMENT_FIELD_TITLE = "Title";
  /** the constant for the column DESCRIPTION of the database table EXPERIMENT */
  public static final String EXPERIMENT_FIELD_DESCRIPTION = "Description";
  /** the constant for the column SHOW_IN_MENU_TREE of the database table EXPERIMENT */
  public static final String EXPERIMENT_FIELD_SHOW_IN_MENU_TREE = "ShowInMenuTree";
  /** the constant for the column USERID of the database table EXPERIMENT */
  public static final String EXPERIMENT_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table EXPERIMENT */
  public static final String EXPERIMENT_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table EXPERIMENT */
  public static final String EXPERIMENT_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table SAMPLE */
  public static final String SAMPLE_ID = "sampleId";
  /** the constant for the column ID of the database table SAMPLE */
  public static final String SAMPLE_FIELD_ID = "Id";
  /** the constant for the column SAMPLE_ID of the database table SAMPLE */
  public static final String SAMPLE_FIELD_SAMPLE_ID = "SampleId";
  /** the constant for the column USERID of the database table SAMPLE */
  public static final String SAMPLE_FIELD_USERID = "Userid";
  /** the constant for the column SAMPLE_DATE of the database table SAMPLE */
  public static final String SAMPLE_FIELD_SAMPLE_DATE = "SampleDate";
  /** the constant for the column TITLE of the database table SAMPLE */
  public static final String SAMPLE_FIELD_TITLE = "Title";
  /** the constant for the column DESCRIPTION of the database table SAMPLE */
  public static final String SAMPLE_FIELD_DESCRIPTION = "Description";
  /** the constant for the column PROTEIN_AMOUNT of the database table SAMPLE */
  public static final String SAMPLE_FIELD_PROTEIN_AMOUNT = "ProteinAmount";
  /** the constant for the column SUBMITTERID of the database table SAMPLE */
  public static final String SAMPLE_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table SAMPLE */
  public static final String SAMPLE_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table GEL1D */
  public static final String GEL1D_ID = "gel1dId";
  /** the constant for the column ID of the database table GEL1D */
  public static final String GEL1D_FIELD_ID = "Id";
  /** the constant for the column GEL1D_ID of the database table GEL1D */
  public static final String GEL1D_FIELD_GEL1D_ID = "Gel1dId";
  /** the constant for the column IMAGE_PROCESSING of the database table GEL1D */
  public static final String GEL1D_FIELD_IMAGE_PROCESSING = "ImageProcessing";
  /** the constant for the column PROTEIN_ASSAY of the database table GEL1D */
  public static final String GEL1D_FIELD_PROTEIN_ASSAY = "ProteinAssay";
  /** the constant for the column IN_GEL_DIGESTION of the database table GEL1D */
  public static final String GEL1D_FIELD_IN_GEL_DIGESTION = "InGelDigestion";
  /** the constant for the column BACKGROUND of the database table GEL1D */
  public static final String GEL1D_FIELD_BACKGROUND = "Background";
  /** the constant for the column PIXEL_SIZE_X of the database table GEL1D */
  public static final String GEL1D_FIELD_PIXEL_SIZE_X = "PixelSizeX";
  /** the constant for the column PIXEL_SIZE_Y of the database table GEL1D */
  public static final String GEL1D_FIELD_PIXEL_SIZE_Y = "PixelSizeY";
  /** the constant for the column IMAGE_RESOLUTION of the database table GEL1D */
  public static final String GEL1D_FIELD_IMAGE_RESOLUTION = "ImageResolution";
  /** the constant for the column DENATURING_AGENT of the database table GEL1D */
  public static final String GEL1D_FIELD_DENATURING_AGENT = "DenaturingAgent";
  /** the constant for the column RAW_IMAGE_DESCRIPTION of the database table GEL1D */
  public static final String GEL1D_FIELD_RAW_IMAGE_DESCRIPTION = "RawImageDescription";
  /** the constant for the column GEL_MANUFACTURER of the database table GEL1D */
  public static final String GEL1D_FIELD_GEL_MANUFACTURER = "GelManufacturer";
  /** the constant for the column GEL_MODEL_NAME of the database table GEL1D */
  public static final String GEL1D_FIELD_GEL_MODEL_NAME = "GelModelName";
  /** the constant for the column GEL_MODEL_NUMBER of the database table GEL1D */
  public static final String GEL1D_FIELD_GEL_MODEL_NUMBER = "GelModelNumber";
  /** the constant for the column PUBLISHED_PROTOCOL of the database table GEL1D */
  public static final String GEL1D_FIELD_PUBLISHED_PROTOCOL = "PublishedProtocol";
  /** the constant for the column GEL_RECIPE of the database table GEL1D */
  public static final String GEL1D_FIELD_GEL_RECIPE = "GelRecipe";
  /** the constant for the column GEL_LANES of the database table GEL1D */
  public static final String GEL1D_FIELD_GEL_LANES = "GelLanes";
  /** the constant for the column BUFFER_PROTOCOL of the database table GEL1D */
  public static final String GEL1D_FIELD_BUFFER_PROTOCOL = "BufferProtocol";
  /** the constant for the column EQUIPMENT_CALIBRATION of the database table GEL1D */
  public static final String GEL1D_FIELD_EQUIPMENT_CALIBRATION = "EquipmentCalibration";
  /** the constant for the column EQUIPMENT_SPECIFIC_PARAMS of the database table GEL1D */
  public static final String GEL1D_FIELD_EQUIPMENT_SPECIFIC_PARAMS = "EquipmentSpecificParams";
  /** the constant for the column IMAGE_ACQUISITION_PROCESS of the database table GEL1D */
  public static final String GEL1D_FIELD_IMAGE_ACQUISITION_PROCESS = "ImageAcquisitionProcess";
  /** the constant for the column BIT_DEPTH of the database table GEL1D */
  public static final String GEL1D_FIELD_BIT_DEPTH = "BitDepth";
  /** the constant for the column DESCRIPTION of the database table GEL1D */
  public static final String GEL1D_FIELD_DESCRIPTION = "Description";
  /** the pk constant of the database table GEL2D */
  public static final String GEL2D_ID = "gel2dId";
  /** the constant for the column ID of the database table GEL2D */
  public static final String GEL2D_FIELD_ID = "Id";
  /** the constant for the column GEL2D_ID of the database table GEL2D */
  public static final String GEL2D_FIELD_GEL2D_ID = "Gel2dId";
  /** the constant for the column IMAGE_PROCESSING of the database table GEL2D */
  public static final String GEL2D_FIELD_IMAGE_PROCESSING = "ImageProcessing";
  /** the constant for the column PROTEIN_ASSAY of the database table GEL2D */
  public static final String GEL2D_FIELD_PROTEIN_ASSAY = "ProteinAssay";
  /** the constant for the column IN_GEL_DIGESTION of the database table GEL2D */
  public static final String GEL2D_FIELD_IN_GEL_DIGESTION = "InGelDigestion";
  /** the constant for the column BACKGROUND of the database table GEL2D */
  public static final String GEL2D_FIELD_BACKGROUND = "Background";
  /** the constant for the column PIXEL_SIZE_X of the database table GEL2D */
  public static final String GEL2D_FIELD_PIXEL_SIZE_X = "PixelSizeX";
  /** the constant for the column PIXEL_SIZE_Y of the database table GEL2D */
  public static final String GEL2D_FIELD_PIXEL_SIZE_Y = "PixelSizeY";
  /** the constant for the column IMAGE_RESOLUTION of the database table GEL2D */
  public static final String GEL2D_FIELD_IMAGE_RESOLUTION = "ImageResolution";
  /** the constant for the column DENATURATING_AGENT of the database table GEL2D */
  public static final String GEL2D_FIELD_DENATURATING_AGENT = "DenaturatingAgent";
  /** the constant for the column RAW_IMAGE_DESCRIPTION of the database table GEL2D */
  public static final String GEL2D_FIELD_RAW_IMAGE_DESCRIPTION = "RawImageDescription";
  /** the constant for the column GEL_MANUFACTURER of the database table GEL2D */
  public static final String GEL2D_FIELD_GEL_MANUFACTURER = "GelManufacturer";
  /** the constant for the column GEL_MODEL_NAME of the database table GEL2D */
  public static final String GEL2D_FIELD_GEL_MODEL_NAME = "GelModelName";
  /** the constant for the column GEL_MODEL_NUMBER of the database table GEL2D */
  public static final String GEL2D_FIELD_GEL_MODEL_NUMBER = "GelModelNumber";
  /** the constant for the column PUBLISHED_PROTOCOL of the database table GEL2D */
  public static final String GEL2D_FIELD_PUBLISHED_PROTOCOL = "PublishedProtocol";
  /** the constant for the column GEL_RECIPE of the database table GEL2D */
  public static final String GEL2D_FIELD_GEL_RECIPE = "GelRecipe";
  /** the constant for the column BUFFER_PROTOCOL_X of the database table GEL2D */
  public static final String GEL2D_FIELD_BUFFER_PROTOCOL_X = "BufferProtocolX";
  /** the constant for the column BUFFER_PROTOCOL_Y of the database table GEL2D */
  public static final String GEL2D_FIELD_BUFFER_PROTOCOL_Y = "BufferProtocolY";
  /** the constant for the column EQUIPMENT_CALIBRATION of the database table GEL2D */
  public static final String GEL2D_FIELD_EQUIPMENT_CALIBRATION = "EquipmentCalibration";
  /** the constant for the column EQUIPMENT_SPECIFIC_PARAMS of the database table GEL2D */
  public static final String GEL2D_FIELD_EQUIPMENT_SPECIFIC_PARAMS = "EquipmentSpecificParams";
  /** the constant for the column IMAGE_ACQUISITION_PROCESS of the database table GEL2D */
  public static final String GEL2D_FIELD_IMAGE_ACQUISITION_PROCESS = "ImageAcquisitionProcess";
  /** the constant for the column BIT_DEPTH of the database table GEL2D */
  public static final String GEL2D_FIELD_BIT_DEPTH = "BitDepth";
  /** the constant for the column DESCRIPTION of the database table GEL2D */
  public static final String GEL2D_FIELD_DESCRIPTION = "Description";
  /** the pk constant of the database table GEL_SUBSTANCE */
  public static final String GEL_SUBSTANCE_ID = "gelSubstanceId";
  /** the constant for the column ID of the database table GEL_SUBSTANCE */
  public static final String GEL_SUBSTANCE_FIELD_ID = "Id";
  /** the constant for the column GELSUBSTANCE_ID of the database table GEL_SUBSTANCE */
  public static final String GEL_SUBSTANCE_FIELD_GELSUBSTANCE_ID = "GelsubstanceId";
  /** the constant for the column INSTITUTEID of the database table GEL_SUBSTANCE */
  public static final String GEL_SUBSTANCE_FIELD_INSTITUTEID = "Instituteid";
  /** the constant for the column SUBMITTERID of the database table GEL_SUBSTANCE */
  public static final String GEL_SUBSTANCE_FIELD_SUBMITTERID = "Submitterid";
  /** the pk constant of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_ID = "peptidehitId";
  /** the constant for the column ID of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_ID = "Id";
  /** the constant for the column SCORE of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_SCORE = "Score";
  /** the constant for the column SEQUENCE of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_SEQUENCE = "Sequence";
  /** the constant for the column INFORMATION of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_INFORMATION = "Information";
  /** the constant for the column SCORE_TYPE of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_SCORE_TYPE = "ScoreType";
  /** the constant for the column MASS of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_MASS = "Mass";
  /** the constant for the column DELTA of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_DELTA = "Delta";
  /** the constant for the column NUM_IONS of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_NUM_IONS = "NumIons";
  /** the constant for the column MODIFICATION of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_MODIFICATION = "Modification";
  /** the constant for the column PARENT_CHARGE of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_PARENT_CHARGE = "ParentCharge";
  /** the constant for the column SECOND_SCORE of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_SECOND_SCORE = "SecondScore";
  /** the constant for the column SECOND_SCORE_TYPE of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_SECOND_SCORE_TYPE = "SecondScoreType";
  /** the constant for the column MISSED_CLEAVAGES of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_MISSED_CLEAVAGES = "MissedCleavages";
  /** the constant for the column HIT_NUMBER of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_HIT_NUMBER = "HitNumber";
  /** the constant for the column PEAK_AREA of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_PEAK_AREA = "PeakArea";
  /** the constant for the column PROPHET_SCORE of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_PROPHET_SCORE = "ProphetScore";
  /** the constant for the column DELTA_SCORE of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_DELTA_SCORE = "DeltaScore";
  /** the constant for the column THIRD_SCORE of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_THIRD_SCORE = "ThirdScore";
  /** the constant for the column THIRD_SCORE_TYPE of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_THIRD_SCORE_TYPE = "ThirdScoreType";
  /** the constant for the column DECOY of the database table PEPTIDEHIT */
  public static final String PEPTIDEHIT_FIELD_DECOY = "Decoy";
  /** the pk constant of the database table MASPECTRAS_DICTIONARY */
  public static final String MASPECTRAS_DICTIONARY_ID = "maspectrasDictionaryId";
  /** the constant for the column ID of the database table MASPECTRAS_DICTIONARY */
  public static final String MASPECTRAS_DICTIONARY_FIELD_ID = "Id";
  /** the constant for the column DOMAIN of the database table MASPECTRAS_DICTIONARY */
  public static final String MASPECTRAS_DICTIONARY_FIELD_DOMAIN = "Domain";
  /** the constant for the column VALUE of the database table MASPECTRAS_DICTIONARY */
  public static final String MASPECTRAS_DICTIONARY_FIELD_VALUE = "Value";
  /** the constant for the column DESCRIPTION of the database table MASPECTRAS_DICTIONARY */
  public static final String MASPECTRAS_DICTIONARY_FIELD_DESCRIPTION = "Description";
  /** the pk constant of the database table PROTEIN */
  public static final String PROTEIN_ID = "proteinId";
  /** the constant for the column ID of the database table PROTEIN */
  public static final String PROTEIN_FIELD_ID = "Id";
  /** the constant for the column ACCESSION_NUM of the database table PROTEIN */
  public static final String PROTEIN_FIELD_ACCESSION_NUM = "AccessionNum";
  /** the constant for the column GENE_NAME of the database table PROTEIN */
  public static final String PROTEIN_FIELD_GENE_NAME = "GeneName";
  /** the constant for the column SYNONYMS of the database table PROTEIN */
  public static final String PROTEIN_FIELD_SYNONYMS = "Synonyms";
  /** the constant for the column ORGANISM of the database table PROTEIN */
  public static final String PROTEIN_FIELD_ORGANISM = "Organism";
  /** the constant for the column ORF_NUMBER of the database table PROTEIN */
  public static final String PROTEIN_FIELD_ORF_NUMBER = "OrfNumber";
  /** the constant for the column DESCRIPTION of the database table PROTEIN */
  public static final String PROTEIN_FIELD_DESCRIPTION = "Description";
  /** the constant for the column MODIFICATIONS of the database table PROTEIN */
  public static final String PROTEIN_FIELD_MODIFICATIONS = "Modifications";
  /** the constant for the column PREDICTED_MASS of the database table PROTEIN */
  public static final String PROTEIN_FIELD_PREDICTED_MASS = "PredictedMass";
  /** the constant for the column PREDICTED_PI of the database table PROTEIN */
  public static final String PROTEIN_FIELD_PREDICTED_PI = "PredictedPi";
  /** the constant for the column GENE_SYMBOL of the database table PROTEIN */
  public static final String PROTEIN_FIELD_GENE_SYMBOL = "GeneSymbol";
  /** the pk constant of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_ID = "dbsearchparametersId";
  /** the constant for the column ID of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_ID = "Id";
  /** the constant for the column DATABASE_NAME of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_DATABASE_NAME = "DatabaseName";
  /** the constant for the column DATABASE_VERSION of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_DATABASE_VERSION = "DatabaseVersion";
  /** the constant for the column PARAMETERS_FILE of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_PARAMETERS_FILE = "ParametersFile";
  /** the constant for the column TAXONOMICAL_FILTER of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_TAXONOMICAL_FILTER = "TaxonomicalFilter";
  /** the constant for the column FIXED_MODIFICATIONS of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_FIXED_MODIFICATIONS = "FixedModifications";
  /** the constant for the column VARIABLE_MODIFICATIONS of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_VARIABLE_MODIFICATIONS = "VariableModifications";
  /** the constant for the column MAX_MISSED_CLEAVAGES of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_MAX_MISSED_CLEAVAGES = "MaxMissedCleavages";
  /** the constant for the column MASS_VALUE_TYPE of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_MASS_VALUE_TYPE = "MassValueType";
  /** the constant for the column FRAGMENT_ION_TOLERANCE of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_FRAGMENT_ION_TOLERANCE = "FragmentIonTolerance";
  /** the constant for the column PEPTIDE_MASS_TOLERANCE of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_PEPTIDE_MASS_TOLERANCE = "PeptideMassTolerance";
  /** the constant for the column ACCURATE_MASS_MODE of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_ACCURATE_MASS_MODE = "AccurateMassMode";
  /** the constant for the column MASS_ERROR_TYPE of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_MASS_ERROR_TYPE = "MassErrorType";
  /** the constant for the column MASS_ERROR of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_MASS_ERROR = "MassError";
  /** the constant for the column PROTONATED of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_PROTONATED = "Protonated";
  /** the constant for the column ICAT_OPTION of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_ICAT_OPTION = "IcatOption";
  /** the constant for the column AUTO_QUANT_METHOD of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_AUTO_QUANT_METHOD = "AutoQuantMethod";
  /** the constant for the column AUTO_QUANT_TOLERANCE of the database table DBSEARCHPARAMETERS */
  public static final String DBSEARCHPARAMETERS_FIELD_AUTO_QUANT_TOLERANCE = "AutoQuantTolerance";
  /** the pk constant of the database table LCCOLUMN */
  public static final String LCCOLUMN_ID = "lccolumnId";
  /** the constant for the column ID of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_ID = "Id";
  /** the constant for the column TITLE of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_TITLE = "Title";
  /** the constant for the column COLUMN_TYPE of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_COLUMN_TYPE = "ColumnType";
  /** the constant for the column ELUTION_MODE of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_ELUTION_MODE = "ElutionMode";
  /** the constant for the column BATCH_NUMBER of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_BATCH_NUMBER = "BatchNumber";
  /** the constant for the column INTERNAL_LENGTH of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_INTERNAL_LENGTH = "InternalLength";
  /** the constant for the column INTERNAL_DIAMETER of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_INTERNAL_DIAMETER = "InternalDiameter";
  /** the constant for the column STATIONARY_PHASE of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_STATIONARY_PHASE = "StationaryPhase";
  /** the constant for the column BEAD_SIZE of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_BEAD_SIZE = "BeadSize";
  /** the constant for the column PORE_SIZE of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_PORE_SIZE = "PoreSize";
  /** the constant for the column TEMPERATURE of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_TEMPERATURE = "Temperature";
  /** the constant for the column FLOW_RATE of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_FLOW_RATE = "FlowRate";
  /** the constant for the column INJECTION_VOLUME of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_INJECTION_VOLUME = "InjectionVolume";
  /** the constant for the column DETECTION_TYPE of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_DETECTION_TYPE = "DetectionType";
  /** the constant for the column DETECTOR_PROPERTIES of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_DETECTOR_PROPERTIES = "DetectorProperties";
  /** the constant for the column DATA_COLLECTION_TIME of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_DATA_COLLECTION_TIME = "DataCollectionTime";
  /** the constant for the column TRACE_LOCATION of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_TRACE_LOCATION = "TraceLocation";
  /** the constant for the column TRACE_FORMAT of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_TRACE_FORMAT = "TraceFormat";
  /** the constant for the column DESCRIPTION of the database table LCCOLUMN */
  public static final String LCCOLUMN_FIELD_DESCRIPTION = "Description";
  /** the pk constant of the database table BUFFER */
  public static final String BUFFER_ID = "bufferId";
  /** the constant for the column ID of the database table BUFFER */
  public static final String BUFFER_FIELD_ID = "Id";
  /** the constant for the column BUFFER_ID of the database table BUFFER */
  public static final String BUFFER_FIELD_BUFFER_ID = "BufferId";
  /** the constant for the column BUFFER_TYPE of the database table BUFFER */
  public static final String BUFFER_FIELD_BUFFER_TYPE = "BufferType";
  /** the constant for the column INSTITUTEID of the database table BUFFER */
  public static final String BUFFER_FIELD_INSTITUTEID = "Instituteid";
  /** the constant for the column SUBMITTERID of the database table BUFFER */
  public static final String BUFFER_FIELD_SUBMITTERID = "Submitterid";
  /** the pk constant of the database table BAND */
  public static final String BAND_ID = "bandId";
  /** the constant for the column ID of the database table BAND */
  public static final String BAND_FIELD_ID = "Id";
  /** the constant for the column TITLE of the database table BAND */
  public static final String BAND_FIELD_TITLE = "Title";
  /** the constant for the column AREA of the database table BAND */
  public static final String BAND_FIELD_AREA = "Area";
  /** the constant for the column INTENSITY of the database table BAND */
  public static final String BAND_FIELD_INTENSITY = "Intensity";
  /** the constant for the column LOCAL_BACKGROUND of the database table BAND */
  public static final String BAND_FIELD_LOCAL_BACKGROUND = "LocalBackground";
  /** the constant for the column ANNOTATION of the database table BAND */
  public static final String BAND_FIELD_ANNOTATION = "Annotation";
  /** the constant for the column ANNOTATION_SOURCE of the database table BAND */
  public static final String BAND_FIELD_ANNOTATION_SOURCE = "AnnotationSource";
  /** the constant for the column VOLUME of the database table BAND */
  public static final String BAND_FIELD_VOLUME = "Volume";
  /** the constant for the column NORMALISATION of the database table BAND */
  public static final String BAND_FIELD_NORMALISATION = "Normalisation";
  /** the constant for the column NORMALISED_VOLUME of the database table BAND */
  public static final String BAND_FIELD_NORMALISED_VOLUME = "NormalisedVolume";
  /** the constant for the column LANE_NUMBER of the database table BAND */
  public static final String BAND_FIELD_LANE_NUMBER = "LaneNumber";
  /** the constant for the column APPARENT_MASS of the database table BAND */
  public static final String BAND_FIELD_APPARENT_MASS = "ApparentMass";
  /** the constant for the column LOCALISATION_ITEM_TYPE of the database table BAND */
  public static final String BAND_FIELD_LOCALISATION_ITEM_TYPE = "LocalisationItemType";
  /** the constant for the column DESCRIPTION of the database table BAND */
  public static final String BAND_FIELD_DESCRIPTION = "Description";
  /** the pk constant of the database table OTHERANALYTE */
  public static final String OTHERANALYTE_ID = "otheranalyteId";
  /** the constant for the column ID of the database table OTHERANALYTE */
  public static final String OTHERANALYTE_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table OTHERANALYTE */
  public static final String OTHERANALYTE_FIELD_NAME = "Name";
  /** the pk constant of the database table MOBILEPHASECOMPONENT */
  public static final String MOBILEPHASECOMPONENT_ID = "mobilephasecomponentId";
  /** the constant for the column ID of the database table MOBILEPHASECOMPONENT */
  public static final String MOBILEPHASECOMPONENT_FIELD_ID = "Id";
  /** the constant for the column DESCRIPTION of the database table MOBILEPHASECOMPONENT */
  public static final String MOBILEPHASECOMPONENT_FIELD_DESCRIPTION = "Description";
  /** the constant for the column CONCENTRATION of the database table MOBILEPHASECOMPONENT */
  public static final String MOBILEPHASECOMPONENT_FIELD_CONCENTRATION = "Concentration";
  /** the pk constant of the database table PERCENTX */
  public static final String PERCENTX_ID = "percentxId";
  /** the constant for the column ID of the database table PERCENTX */
  public static final String PERCENTX_FIELD_ID = "Id";
  /** the constant for the column PERCENT_TYPE of the database table PERCENTX */
  public static final String PERCENTX_FIELD_PERCENT_TYPE = "PercentType";
  /** the constant for the column PERCENTAGE of the database table PERCENTX */
  public static final String PERCENTX_FIELD_PERCENTAGE = "Percentage";
  /** the pk constant of the database table OTHERANALYTEPS */
  public static final String OTHERANALYTEPS_ID = "otheranalytepsId";
  /** the constant for the column ID of the database table OTHERANALYTEPS */
  public static final String OTHERANALYTEPS_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table OTHERANALYTEPS */
  public static final String OTHERANALYTEPS_FIELD_NAME = "Name";
  /** the pk constant of the database table FRACTION */
  public static final String FRACTION_ID = "fractionId";
  /** the constant for the column ID of the database table FRACTION */
  public static final String FRACTION_FIELD_ID = "Id";
  /** the constant for the column FRACTION_ID of the database table FRACTION */
  public static final String FRACTION_FIELD_FRACTION_ID = "FractionId";
  /** the constant for the column START_POINT of the database table FRACTION */
  public static final String FRACTION_FIELD_START_POINT = "StartPoint";
  /** the constant for the column END_POINT of the database table FRACTION */
  public static final String FRACTION_FIELD_END_POINT = "EndPoint";
  /** the constant for the column PROTEIN_ASSAY of the database table FRACTION */
  public static final String FRACTION_FIELD_PROTEIN_ASSAY = "ProteinAssay";
  /** the pk constant of the database table RELATEDGELITEM */
  public static final String RELATEDGELITEM_ID = "relatedgelitemId";
  /** the constant for the column ID of the database table RELATEDGELITEM */
  public static final String RELATEDGELITEM_FIELD_ID = "Id";
  /** the constant for the column DESCRIPTION of the database table RELATEDGELITEM */
  public static final String RELATEDGELITEM_FIELD_DESCRIPTION = "Description";
  /** the constant for the column GEL_REFERENCE of the database table RELATEDGELITEM */
  public static final String RELATEDGELITEM_FIELD_GEL_REFERENCE = "GelReference";
  /** the constant for the column ITEM_REFERENCE of the database table RELATEDGELITEM */
  public static final String RELATEDGELITEM_FIELD_ITEM_REFERENCE = "ItemReference";
  /** the constant for the column BAND_GEL1_D of the database table RELATEDGELITEM */
  public static final String RELATEDGELITEM_FIELD_BAND_GEL1_D = "BandGel1D";
  /** the constant for the column SPOT_GEL2_D of the database table RELATEDGELITEM */
  public static final String RELATEDGELITEM_FIELD_SPOT_GEL2_D = "SpotGel2D";
  /** the pk constant of the database table GEL_SEPARATION_METHOD */
  public static final String GEL_SEPARATION_METHOD_ID = "gelSeparationMethodId";
  /** the constant for the column ID of the database table GEL_SEPARATION_METHOD */
  public static final String GEL_SEPARATION_METHOD_FIELD_ID = "Id";
  /** the constant for the column DIMENSION_NUMBER of the database table GEL_SEPARATION_METHOD */
  public static final String GEL_SEPARATION_METHOD_FIELD_DIMENSION_NUMBER = "DimensionNumber";
  /** the constant for the column SEPARATION_METHOD of the database table GEL_SEPARATION_METHOD */
  public static final String GEL_SEPARATION_METHOD_FIELD_SEPARATION_METHOD = "SeparationMethod";
  /** the constant for the column PHYSICAL_DIMENSION of the database table GEL_SEPARATION_METHOD */
  public static final String GEL_SEPARATION_METHOD_FIELD_PHYSICAL_DIMENSION = "PhysicalDimension";
  /** the constant for the column PROPERTY_RANGE_START of the database table GEL_SEPARATION_METHOD */
  public static final String GEL_SEPARATION_METHOD_FIELD_PROPERTY_RANGE_START = "PropertyRangeStart";
  /** the constant for the column PROPERTY_RANGE_STOP of the database table GEL_SEPARATION_METHOD */
  public static final String GEL_SEPARATION_METHOD_FIELD_PROPERTY_RANGE_STOP = "PropertyRangeStop";
  /** the constant for the column DISTRIBUTION of the database table GEL_SEPARATION_METHOD */
  public static final String GEL_SEPARATION_METHOD_FIELD_DISTRIBUTION = "Distribution";
  /** the pk constant of the database table DIGEGEL */
  public static final String DIGEGEL_ID = "digegelId";
  /** the constant for the column ID of the database table DIGEGEL */
  public static final String DIGEGEL_FIELD_ID = "Id";
  /** the constant for the column DYE_TYPE of the database table DIGEGEL */
  public static final String DIGEGEL_FIELD_DYE_TYPE = "DyeType";
  /** the constant for the column EXCITATION_WAVELENGTH of the database table DIGEGEL */
  public static final String DIGEGEL_FIELD_EXCITATION_WAVELENGTH = "ExcitationWavelength";
  /** the constant for the column EXPOSURE_TIME of the database table DIGEGEL */
  public static final String DIGEGEL_FIELD_EXPOSURE_TIME = "ExposureTime";
  /** the constant for the column TIFF_IMAGE of the database table DIGEGEL */
  public static final String DIGEGEL_FIELD_TIFF_IMAGE = "TiffImage";
  /** the constant for the column EMISSION of the database table DIGEGEL */
  public static final String DIGEGEL_FIELD_EMISSION = "Emission";
  /** the constant for the column PMT_VOLTAGE of the database table DIGEGEL */
  public static final String DIGEGEL_FIELD_PMT_VOLTAGE = "PmtVoltage";
  /** the pk constant of the database table CHEMICALTREATMENT */
  public static final String CHEMICALTREATMENT_ID = "chemicaltreatmentId";
  /** the constant for the column ID of the database table CHEMICALTREATMENT */
  public static final String CHEMICALTREATMENT_FIELD_ID = "Id";
  /** the constant for the column DIGESTION of the database table CHEMICALTREATMENT */
  public static final String CHEMICALTREATMENT_FIELD_DIGESTION = "Digestion";
  /** the constant for the column DERIVATISATIONS of the database table CHEMICALTREATMENT */
  public static final String CHEMICALTREATMENT_FIELD_DERIVATISATIONS = "Derivatisations";
  /** the pk constant of the database table TREATEDANALYTE */
  public static final String TREATEDANALYTE_ID = "treatedanalyteId";
  /** the constant for the column ID of the database table TREATEDANALYTE */
  public static final String TREATEDANALYTE_FIELD_ID = "Id";
  /** the constant for the column DESCRIPTION of the database table TREATEDANALYTE */
  public static final String TREATEDANALYTE_FIELD_DESCRIPTION = "Description";
  /** the pk constant of the database table INTER_DIMENSION_ACTION */
  public static final String INTER_DIMENSION_ACTION_ID = "interDimensionActionId";
  /** the constant for the column ID of the database table INTER_DIMENSION_ACTION */
  public static final String INTER_DIMENSION_ACTION_FIELD_ID = "Id";
  /** the constant for the column DESCRIPTIVE_NAME_OF_STEPS of the database table INTER_DIMENSION_ACTION */
  public static final String INTER_DIMENSION_ACTION_FIELD_DESCRIPTIVE_NAME_OF_STEPS = "DescriptiveNameOfSteps";
  /** the constant for the column PRE_DIMENSION of the database table INTER_DIMENSION_ACTION */
  public static final String INTER_DIMENSION_ACTION_FIELD_PRE_DIMENSION = "PreDimension";
  /** the constant for the column PUBLISHED_PROTOCOL of the database table INTER_DIMENSION_ACTION */
  public static final String INTER_DIMENSION_ACTION_FIELD_PUBLISHED_PROTOCOL = "PublishedProtocol";
  /** the pk constant of the database table DIGEGELITEM */
  public static final String DIGEGELITEM_ID = "digegelitemId";
  /** the constant for the column ID of the database table DIGEGELITEM */
  public static final String DIGEGELITEM_FIELD_ID = "Id";
  /** the constant for the column DYE_TYPE of the database table DIGEGELITEM */
  public static final String DIGEGELITEM_FIELD_DYE_TYPE = "DyeType";
  /** the constant for the column BAND_GEL1_D of the database table DIGEGELITEM */
  public static final String DIGEGELITEM_FIELD_BAND_GEL1_D = "BandGel1D";
  /** the constant for the column SPOT_GEL2_D of the database table DIGEGELITEM */
  public static final String DIGEGELITEM_FIELD_SPOT_GEL2_D = "SpotGel2D";
  /** the pk constant of the database table SPOT */
  public static final String SPOT_ID = "spotId";
  /** the constant for the column ID of the database table SPOT */
  public static final String SPOT_FIELD_ID = "Id";
  /** the constant for the column TITLE of the database table SPOT */
  public static final String SPOT_FIELD_TITLE = "Title";
  /** the constant for the column APPARENT_PI of the database table SPOT */
  public static final String SPOT_FIELD_APPARENT_PI = "ApparentPi";
  /** the constant for the column APPARENT_MASS of the database table SPOT */
  public static final String SPOT_FIELD_APPARENT_MASS = "ApparentMass";
  /** the constant for the column INTENSITY of the database table SPOT */
  public static final String SPOT_FIELD_INTENSITY = "Intensity";
  /** the constant for the column AREA of the database table SPOT */
  public static final String SPOT_FIELD_AREA = "Area";
  /** the constant for the column LOCAL_BACKGROUND of the database table SPOT */
  public static final String SPOT_FIELD_LOCAL_BACKGROUND = "LocalBackground";
  /** the constant for the column ANNOTATION of the database table SPOT */
  public static final String SPOT_FIELD_ANNOTATION = "Annotation";
  /** the constant for the column ANNOTATION_SOURCE of the database table SPOT */
  public static final String SPOT_FIELD_ANNOTATION_SOURCE = "AnnotationSource";
  /** the constant for the column VOLUME of the database table SPOT */
  public static final String SPOT_FIELD_VOLUME = "Volume";
  /** the constant for the column NORMALISATION of the database table SPOT */
  public static final String SPOT_FIELD_NORMALISATION = "Normalisation";
  /** the constant for the column NORMALISED_VOLUME of the database table SPOT */
  public static final String SPOT_FIELD_NORMALISED_VOLUME = "NormalisedVolume";
  /** the constant for the column LOCALISATION_ITEM_TYPE of the database table SPOT */
  public static final String SPOT_FIELD_LOCALISATION_ITEM_TYPE = "LocalisationItemType";
  /** the constant for the column DESCRIPTION of the database table SPOT */
  public static final String SPOT_FIELD_DESCRIPTION = "Description";
  /** the pk constant of the database table BOUNDARYPOINT */
  public static final String BOUNDARYPOINT_ID = "boundarypointId";
  /** the constant for the column ID of the database table BOUNDARYPOINT */
  public static final String BOUNDARYPOINT_FIELD_ID = "Id";
  /** the constant for the column POINT_NUMBER of the database table BOUNDARYPOINT */
  public static final String BOUNDARYPOINT_FIELD_POINT_NUMBER = "PointNumber";
  /** the constant for the column PIXEL_X_COORD of the database table BOUNDARYPOINT */
  public static final String BOUNDARYPOINT_FIELD_PIXEL_X_COORD = "PixelXCoord";
  /** the constant for the column PIXEL_Y_COORD of the database table BOUNDARYPOINT */
  public static final String BOUNDARYPOINT_FIELD_PIXEL_Y_COORD = "PixelYCoord";
  /** the pk constant of the database table BOUNDARYCHAIN */
  public static final String BOUNDARYCHAIN_ID = "boundarychainId";
  /** the constant for the column ID of the database table BOUNDARYCHAIN */
  public static final String BOUNDARYCHAIN_FIELD_ID = "Id";
  /** the constant for the column START_X_COORDINATE of the database table BOUNDARYCHAIN */
  public static final String BOUNDARYCHAIN_FIELD_START_X_COORDINATE = "StartXCoordinate";
  /** the constant for the column START_Y_COORDINATE of the database table BOUNDARYCHAIN */
  public static final String BOUNDARYCHAIN_FIELD_START_Y_COORDINATE = "StartYCoordinate";
  /** the pk constant of the database table CIRCLE */
  public static final String CIRCLE_ID = "circleId";
  /** the constant for the column ID of the database table CIRCLE */
  public static final String CIRCLE_FIELD_ID = "Id";
  /** the constant for the column X_COORDINATE of the database table CIRCLE */
  public static final String CIRCLE_FIELD_X_COORDINATE = "XCoordinate";
  /** the constant for the column Y_COORDINATE of the database table CIRCLE */
  public static final String CIRCLE_FIELD_Y_COORDINATE = "YCoordinate";
  /** the constant for the column PIXEL_RADIUS of the database table CIRCLE */
  public static final String CIRCLE_FIELD_PIXEL_RADIUS = "PixelRadius";
  /** the pk constant of the database table RECTANGLE */
  public static final String RECTANGLE_ID = "rectangleId";
  /** the constant for the column ID of the database table RECTANGLE */
  public static final String RECTANGLE_FIELD_ID = "Id";
  /** the constant for the column X_COORDINATE of the database table RECTANGLE */
  public static final String RECTANGLE_FIELD_X_COORDINATE = "XCoordinate";
  /** the constant for the column Y_COORDINATE of the database table RECTANGLE */
  public static final String RECTANGLE_FIELD_Y_COORDINATE = "YCoordinate";
  /** the constant for the column PIXEL_X_SIZE of the database table RECTANGLE */
  public static final String RECTANGLE_FIELD_PIXEL_X_SIZE = "PixelXSize";
  /** the constant for the column PIXEL_Y_SIZE of the database table RECTANGLE */
  public static final String RECTANGLE_FIELD_PIXEL_Y_SIZE = "PixelYSize";
  /** the pk constant of the database table MASSSPECEXPERIMENT */
  public static final String MASSSPECEXPERIMENT_ID = "massspecexperimentId";
  /** the constant for the column ID of the database table MASSSPECEXPERIMENT */
  public static final String MASSSPECEXPERIMENT_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table MASSSPECEXPERIMENT */
  public static final String MASSSPECEXPERIMENT_FIELD_NAME = "Name";
  /** the constant for the column GENERATION_DATE of the database table MASSSPECEXPERIMENT */
  public static final String MASSSPECEXPERIMENT_FIELD_GENERATION_DATE = "GenerationDate";
  /** the constant for the column USERID of the database table MASSSPECEXPERIMENT */
  public static final String MASSSPECEXPERIMENT_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table MASSSPECEXPERIMENT */
  public static final String MASSSPECEXPERIMENT_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column DESCRIPTION of the database table MASSSPECEXPERIMENT */
  public static final String MASSSPECEXPERIMENT_FIELD_DESCRIPTION = "Description";
  /** the constant for the column INSTITUTEID of the database table MASSSPECEXPERIMENT */
  public static final String MASSSPECEXPERIMENT_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table SOFTWARE */
  public static final String SOFTWARE_ID = "softwareId";
  /** the constant for the column ID of the database table SOFTWARE */
  public static final String SOFTWARE_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table SOFTWARE */
  public static final String SOFTWARE_FIELD_NAME = "Name";
  /** the constant for the column VERSION of the database table SOFTWARE */
  public static final String SOFTWARE_FIELD_VERSION = "Version";
  /** the constant for the column DATE_OF_RELEASE of the database table SOFTWARE */
  public static final String SOFTWARE_FIELD_DATE_OF_RELEASE = "DateOfRelease";
  /** the constant for the column ROLE of the database table SOFTWARE */
  public static final String SOFTWARE_FIELD_ROLE = "Role";
  /** the constant for the column USERID of the database table SOFTWARE */
  public static final String SOFTWARE_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table SOFTWARE */
  public static final String SOFTWARE_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table SOFTWARE */
  public static final String SOFTWARE_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table CONTROLSOFTWARE */
  public static final String CONTROLSOFTWARE_ID = "controlsoftwareId";
  /** the constant for the column ID of the database table CONTROLSOFTWARE */
  public static final String CONTROLSOFTWARE_FIELD_ID = "Id";
  /** the constant for the column PACKAGE_NAME of the database table CONTROLSOFTWARE */
  public static final String CONTROLSOFTWARE_FIELD_PACKAGE_NAME = "PackageName";
  /** the constant for the column ISOLATION_WIDTH of the database table CONTROLSOFTWARE */
  public static final String CONTROLSOFTWARE_FIELD_ISOLATION_WIDTH = "IsolationWidth";
  /** the constant for the column USERID of the database table CONTROLSOFTWARE */
  public static final String CONTROLSOFTWARE_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table CONTROLSOFTWARE */
  public static final String CONTROLSOFTWARE_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table CONTROLSOFTWARE */
  public static final String CONTROLSOFTWARE_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table IONSOURCE */
  public static final String IONSOURCE_ID = "ionsourceId";
  /** the constant for the column ID of the database table IONSOURCE */
  public static final String IONSOURCE_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table IONSOURCE */
  public static final String IONSOURCE_FIELD_NAME = "Name";
  /** the constant for the column TYPE of the database table IONSOURCE */
  public static final String IONSOURCE_FIELD_TYPE = "Type";
  /** the constant for the column USERID of the database table IONSOURCE */
  public static final String IONSOURCE_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table IONSOURCE */
  public static final String IONSOURCE_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table IONSOURCE */
  public static final String IONSOURCE_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table MZANALYSIS */
  public static final String MZANALYSIS_ID = "mzanalysisId";
  /** the constant for the column ID of the database table MZANALYSIS */
  public static final String MZANALYSIS_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table MZANALYSIS */
  public static final String MZANALYSIS_FIELD_NAME = "Name";
  /** the constant for the column TYPE of the database table MZANALYSIS */
  public static final String MZANALYSIS_FIELD_TYPE = "Type";
  /** the constant for the column USERID of the database table MZANALYSIS */
  public static final String MZANALYSIS_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table MZANALYSIS */
  public static final String MZANALYSIS_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table MZANALYSIS */
  public static final String MZANALYSIS_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table DETECTION */
  public static final String DETECTION_ID = "detectionId";
  /** the constant for the column ID of the database table DETECTION */
  public static final String DETECTION_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table DETECTION */
  public static final String DETECTION_FIELD_NAME = "Name";
  /** the constant for the column TYPE of the database table DETECTION */
  public static final String DETECTION_FIELD_TYPE = "Type";
  /** the constant for the column DETECTOR_SENSITIVITY of the database table DETECTION */
  public static final String DETECTION_FIELD_DETECTOR_SENSITIVITY = "DetectorSensitivity";
  /** the constant for the column RATE_OF_DATA_ACQUISITION of the database table DETECTION */
  public static final String DETECTION_FIELD_RATE_OF_DATA_ACQUISITION = "RateOfDataAcquisition";
  /** the constant for the column USERID of the database table DETECTION */
  public static final String DETECTION_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table DETECTION */
  public static final String DETECTION_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table DETECTION */
  public static final String DETECTION_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_ID = "massspecmachineId";
  /** the constant for the column ID of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_FIELD_NAME = "Name";
  /** the constant for the column MANUFACTURER of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_FIELD_MANUFACTURER = "Manufacturer";
  /** the constant for the column MODEL_NAME of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_FIELD_MODEL_NAME = "ModelName";
  /** the constant for the column MANUFACTURE_DATE of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_FIELD_MANUFACTURE_DATE = "ManufactureDate";
  /** the constant for the column TUNE_FILE of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_FIELD_TUNE_FILE = "TuneFile";
  /** the constant for the column METHOD_FILE of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_FIELD_METHOD_FILE = "MethodFile";
  /** the constant for the column SIGNIFICANT_CUSTOMIZATIONS of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_FIELD_SIGNIFICANT_CUSTOMIZATIONS = "SignificantCustomizations";
  /** the constant for the column USERID of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table MASSSPECMACHINE */
  public static final String MASSSPECMACHINE_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table ORGANISM */
  public static final String ORGANISM_ID = "organismId";
  /** the constant for the column ID of the database table ORGANISM */
  public static final String ORGANISM_FIELD_ID = "Id";
  /** the constant for the column SPECIES_NAME of the database table ORGANISM */
  public static final String ORGANISM_FIELD_SPECIES_NAME = "SpeciesName";
  /** the constant for the column STRAIN_IDENTIFIER of the database table ORGANISM */
  public static final String ORGANISM_FIELD_STRAIN_IDENTIFIER = "StrainIdentifier";
  /** the constant for the column RELEVANT_GENOTYPE of the database table ORGANISM */
  public static final String ORGANISM_FIELD_RELEVANT_GENOTYPE = "RelevantGenotype";
  /** the constant for the column TAXONOMY_ID of the database table ORGANISM */
  public static final String ORGANISM_FIELD_TAXONOMY_ID = "TaxonomyId";
  /** the constant for the column USERID of the database table ORGANISM */
  public static final String ORGANISM_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table ORGANISM */
  public static final String ORGANISM_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table ORGANISM */
  public static final String ORGANISM_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_ID = "taggingprocessId";
  /** the constant for the column ID of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_NAME = "Name";
  /** the constant for the column LYSIS_BUFFER of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_LYSIS_BUFFER = "LysisBuffer";
  /** the constant for the column TAG_TYPE of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_TAG_TYPE = "TagType";
  /** the constant for the column TAG_PURITY of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_TAG_PURITY = "TagPurity";
  /** the constant for the column PROTEIN_CONCENTRATION of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_PROTEIN_CONCENTRATION = "ProteinConcentration";
  /** the constant for the column TAG_CONCENTRATION of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_TAG_CONCENTRATION = "TagConcentration";
  /** the constant for the column FINAL_VOLUME of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_FINAL_VOLUME = "FinalVolume";
  /** the constant for the column INCUBATION_TIME of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_INCUBATION_TIME = "IncubationTime";
  /** the constant for the column USERID of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table TAGGINGPROCESS */
  public static final String TAGGINGPROCESS_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_ID = "sampleoriginId";
  /** the constant for the column ID of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_NAME = "Name";
  /** the constant for the column SAMPLECONDITION of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_SAMPLECONDITION = "Samplecondition";
  /** the constant for the column CONDITION_DEGREE of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_CONDITION_DEGREE = "ConditionDegree";
  /** the constant for the column ENVIRONMENT of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_ENVIRONMENT = "Environment";
  /** the constant for the column TISSUE_TYPE of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_TISSUE_TYPE = "TissueType";
  /** the constant for the column CELL_TYPE of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_CELL_TYPE = "CellType";
  /** the constant for the column CELL_CYCLE_PHASE of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_CELL_CYCLE_PHASE = "CellCyclePhase";
  /** the constant for the column CELL_COMPONENT of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_CELL_COMPONENT = "CellComponent";
  /** the constant for the column TECHNIQUE of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_TECHNIQUE = "Technique";
  /** the constant for the column METABOLIC_LABEL of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_METABOLIC_LABEL = "MetabolicLabel";
  /** the constant for the column DESCRIPTION of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_DESCRIPTION = "Description";
  /** the constant for the column USERID of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table SAMPLEORIGIN */
  public static final String SAMPLEORIGIN_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table GELMATRIX */
  public static final String GELMATRIX_ID = "gelmatrixId";
  /** the constant for the column ID of the database table GELMATRIX */
  public static final String GELMATRIX_FIELD_ID = "Id";
  /** the constant for the column GELMATRIX_ID of the database table GELMATRIX */
  public static final String GELMATRIX_FIELD_GELMATRIX_ID = "GelmatrixId";
  /** the constant for the column DESCRIPTIVE_NAME of the database table GELMATRIX */
  public static final String GELMATRIX_FIELD_DESCRIPTIVE_NAME = "DescriptiveName";
  /** the constant for the column MATRIX_TYPE of the database table GELMATRIX */
  public static final String GELMATRIX_FIELD_MATRIX_TYPE = "MatrixType";
  /** the constant for the column INSTITUTEID of the database table GELMATRIX */
  public static final String GELMATRIX_FIELD_INSTITUTEID = "Instituteid";
  /** the constant for the column SUBMITTERID of the database table GELMATRIX */
  public static final String GELMATRIX_FIELD_SUBMITTERID = "Submitterid";
  /** the pk constant of the database table EQUIPMENT */
  public static final String EQUIPMENT_ID = "equipmentId";
  /** the constant for the column ID of the database table EQUIPMENT */
  public static final String EQUIPMENT_FIELD_ID = "Id";
  /** the constant for the column MODEL_NAME of the database table EQUIPMENT */
  public static final String EQUIPMENT_FIELD_MODEL_NAME = "ModelName";
  /** the constant for the column EQUIPMENT_TYPE of the database table EQUIPMENT */
  public static final String EQUIPMENT_FIELD_EQUIPMENT_TYPE = "EquipmentType";
  /** the constant for the column MODEL_MANUFACTURER of the database table EQUIPMENT */
  public static final String EQUIPMENT_FIELD_MODEL_MANUFACTURER = "ModelManufacturer";
  /** the constant for the column MODEL_NUMBER of the database table EQUIPMENT */
  public static final String EQUIPMENT_FIELD_MODEL_NUMBER = "ModelNumber";
  /** the constant for the column INSTITUTEID of the database table EQUIPMENT */
  public static final String EQUIPMENT_FIELD_INSTITUTEID = "Instituteid";
  /** the constant for the column SUBMITTERID of the database table EQUIPMENT */
  public static final String EQUIPMENT_FIELD_SUBMITTERID = "Submitterid";
  /** the pk constant of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_ID = "gelitemdetectionId";
  /** the constant for the column ID of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_ID = "Id";
  /** the constant for the column DETECTION_TYPE of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_DETECTION_TYPE = "DetectionType";
  /** the constant for the column DETECTION_PROCESS of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_DETECTION_PROCESS = "DetectionProcess";
  /** the constant for the column TRANSFER_MEDIUM_NAME of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_NAME = "TransferMediumName";
  /** the constant for the column TRANSFER_MEDIUM_TYPE of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_TYPE = "TransferMediumType";
  /** the constant for the column TRANSFER_MEDIUM_MANUFACTURER of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_MANUFACTURER = "TransferMediumManufacturer";
  /** the constant for the column TRANSFER_MEDIUM_MODEL of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_MODEL = "TransferMediumModel";
  /** the constant for the column DETECTION_MEDIUM_NAME of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_DETECTION_MEDIUM_NAME = "DetectionMediumName";
  /** the constant for the column DETECTION_MEDIUM_MANUFACTRURER of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_DETECTION_MEDIUM_MANUFACTRURER = "DetectionMediumManufactrurer";
  /** the constant for the column DETECTION_MEDIUM_MODEL of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_DETECTION_MEDIUM_MODEL = "DetectionMediumModel";
  /** the constant for the column DETECTION_PROTOCOL of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_DETECTION_PROTOCOL = "DetectionProtocol";
  /** the constant for the column DETECTION_AGENTS_DESCRIPTION of the database table GELITEMDETECTION */
  public static final String GELITEMDETECTION_FIELD_DETECTION_AGENTS_DESCRIPTION = "DetectionAgentsDescription";
  /** the pk constant of the database table DETECTIONAGENT */
  public static final String DETECTIONAGENT_ID = "detectionagentId";
  /** the constant for the column ID of the database table DETECTIONAGENT */
  public static final String DETECTIONAGENT_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table DETECTIONAGENT */
  public static final String DETECTIONAGENT_FIELD_NAME = "Name";
  /** the constant for the column PURPOSE_DESCRIPTION of the database table DETECTIONAGENT */
  public static final String DETECTIONAGENT_FIELD_PURPOSE_DESCRIPTION = "PurposeDescription";
  /** the constant for the column AGENT_MANUFACTURER of the database table DETECTIONAGENT */
  public static final String DETECTIONAGENT_FIELD_AGENT_MANUFACTURER = "AgentManufacturer";
  /** the constant for the column AGENT_MODEL of the database table DETECTIONAGENT */
  public static final String DETECTIONAGENT_FIELD_AGENT_MODEL = "AgentModel";
  /** the constant for the column ORIGIN_DESCRIPTION of the database table DETECTIONAGENT */
  public static final String DETECTIONAGENT_FIELD_ORIGIN_DESCRIPTION = "OriginDescription";
  /** the constant for the column VOLUME of the database table DETECTIONAGENT */
  public static final String DETECTIONAGENT_FIELD_VOLUME = "Volume";
  /** the constant for the column CONCENTRATION of the database table DETECTIONAGENT */
  public static final String DETECTIONAGENT_FIELD_CONCENTRATION = "Concentration";
  /** the constant for the column SUBMITTERID of the database table DETECTIONAGENT */
  public static final String DETECTIONAGENT_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table DETECTIONAGENT */
  public static final String DETECTIONAGENT_FIELD_INSTITUTEID = "Instituteid";
  /** the pk constant of the database table REAGENT */
  public static final String REAGENT_ID = "reagentId";
  /** the constant for the column ID of the database table REAGENT */
  public static final String REAGENT_FIELD_ID = "Id";
  /** the constant for the column REAGENT_ID of the database table REAGENT */
  public static final String REAGENT_FIELD_REAGENT_ID = "ReagentId";
  /** the constant for the column INSITITUTEID of the database table REAGENT */
  public static final String REAGENT_FIELD_INSITITUTEID = "Insitituteid";
  /** the constant for the column SUBMITTERID of the database table REAGENT */
  public static final String REAGENT_FIELD_SUBMITTERID = "Submitterid";
  /** the pk constant of the database table TEMPLATEPARSING */
  public static final String TEMPLATEPARSING_ID = "templateparsingId";
  /** the constant for the column ID of the database table TEMPLATEPARSING */
  public static final String TEMPLATEPARSING_FIELD_ID = "Id";
  /** the constant for the column TEMPLATE_TYPE of the database table TEMPLATEPARSING */
  public static final String TEMPLATEPARSING_FIELD_TEMPLATE_TYPE = "TemplateType";
  /** the constant for the column REFERENCE_ID of the database table TEMPLATEPARSING */
  public static final String TEMPLATEPARSING_FIELD_REFERENCE_ID = "ReferenceId";
  /** the constant for the column PARSING_RULE of the database table TEMPLATEPARSING */
  public static final String TEMPLATEPARSING_FIELD_PARSING_RULE = "ParsingRule";
  /** the pk constant of the database table TEMPLATESETTING */
  public static final String TEMPLATESETTING_ID = "templatesettingId";
  /** the constant for the column ID of the database table TEMPLATESETTING */
  public static final String TEMPLATESETTING_FIELD_ID = "Id";
  /** the constant for the column NAME of the database table TEMPLATESETTING */
  public static final String TEMPLATESETTING_FIELD_NAME = "Name";
  /** the pk constant of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_ID = "fileDownloadId";
  /** the constant for the column ID of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_FIELD_ID = "Id";
  /** the constant for the column USERID of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_FIELD_USERID = "Userid";
  /** the constant for the column NAME of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_FIELD_NAME = "Name";
  /** the constant for the column FILESIZE of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_FIELD_FILESIZE = "Filesize";
  /** the constant for the column DESCR of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_FIELD_DESCR = "Descr";
  /** the constant for the column ADDEDDATE of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_FIELD_ADDEDDATE = "Addeddate";
  /** the constant for the column MIMETYPE of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_FIELD_MIMETYPE = "Mimetype";
  /** the constant for the column HIDDEN of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_FIELD_HIDDEN = "Hidden";
  /** the constant for the column FILEPATHNAME of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_FIELD_FILEPATHNAME = "Filepathname";
  /** the constant for the column CATEGORY of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_FIELD_CATEGORY = "Category";
  /** the constant for the column SUBMITTERID of the database table FILE_DOWNLOAD */
  public static final String FILE_DOWNLOAD_FIELD_SUBMITTERID = "Submitterid";
  /** the pk constant of the database table STORED_QUERY_SET */
  public static final String STORED_QUERY_SET_ID = "storedQuerySetId";
  /** the constant for the column ID of the database table STORED_QUERY_SET */
  public static final String STORED_QUERY_SET_FIELD_ID = "Id";
  /** the constant for the column QUERY_NAME of the database table STORED_QUERY_SET */
  public static final String STORED_QUERY_SET_FIELD_QUERY_NAME = "QueryName";
  /** the constant for the column TABLENAME of the database table STORED_QUERY_SET */
  public static final String STORED_QUERY_SET_FIELD_TABLENAME = "Tablename";
  /** the constant for the column USERID of the database table STORED_QUERY_SET */
  public static final String STORED_QUERY_SET_FIELD_USERID = "Userid";
  /** the constant for the column SUBMITTERID of the database table STORED_QUERY_SET */
  public static final String STORED_QUERY_SET_FIELD_SUBMITTERID = "Submitterid";
  /** the constant for the column INSTITUTEID of the database table STORED_QUERY_SET */
  public static final String STORED_QUERY_SET_FIELD_INSTITUTEID = "Instituteid";

}
