package at.tugraz.genome.dbutilities;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

/**
 * Returns MySQL conform PK generator and Strings for the JDBC statements
 * 
 * @author Juergen Hartler
 *
 */
public class MySQLGenericDAOImpl extends GenericDAOImpl
{
  /** distuingishes if MySQL is used case sensitive or not */
  private boolean mySQLLowerCase = false;
  /** the logger*/
  private static Logger log_ = Logger.getLogger(at.tugraz.genome.dbutilities.GenericDAOImpl.class);
  
  /**
   * 
   * @param factory holds the parameters for the database connection
   */
  public MySQLGenericDAOImpl(GenericDAOFactory factory) {
    log_.debug("MySQLGenericDAOImpl");
    factory_ = factory;
    try {
      Connection con = factory_.createConnection();
      DatabaseMetaData metadata = con.getMetaData();
      ResultSet columnRs = metadata.getImportedKeys(null, null, "PROTEINSEQUENCE");
      while (columnRs.next()) {
        String fkTable = columnRs.getString("PKTABLE_NAME");
        log_.info("FK-Table: "+fkTable);
        if (Character.isLowerCase(fkTable.toCharArray()[0])) this.mySQLLowerCase = true;
      }
      con.close();
    }catch(SQLException sqx){
      sqx.printStackTrace();
    }
    
  }
  
  /**
   * @return returns the primary key generator for the MySQL database
   */
  public PKGenerator getPKGenerator()
  {
    return MYSQLPKGenerator.getInstance(factory_);
  }

  /**
   * 
   * @param input column name extracted from VO
   * @return database conform column name
   */
  protected String getDatabaseConformString(String input)
  {
    return input.toLowerCase();
  }

  /**
   * 
   * @param input table name extracted from VO
   * @return database conform table name
   */
  protected String getDatabaseConformTablename(String input)
  {
    if (this.mySQLLowerCase) return input.toLowerCase();
    return input.toUpperCase();
  }

}
