package at.tugraz.genome.dbutilities;

/**
 * <p>Title: MARS EJB</p>
 * <p>Description: Microarray Analysis and Retrieval System</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: genome.tugraz.at</p>
 * @author Robert Molidor
 * @version 1.0
 *
 *
 */

import at.tugraz.genome.dbutilities.OraclePKGenerator;


public class DummyPKGeneratorFactory {
  /**
   * Factory to get the right Primary Key Generator.
   * @param database A string which represents the database.
   * @return The primary key generator. NULL if the generator for the
   * given database is not available.
   */
  public static PKGenerator getPKGenerator(String database, GenericDAOFactory daoFactory) {
    if (database.equals(Databases.ORACLE)) {
      return OraclePKGenerator.getInstance(daoFactory);
    }
    if  (database.equals(Databases.POSTGRESQL)) {
      return PostgreSQLPKGenerator.getInstance(daoFactory);
    }
    if  (database.equals(Databases.MYSQL)) {
      return MYSQLPKGenerator.getInstance(daoFactory);
    }
    if (database.equals(Databases.THESERVERSIDEGUID)) {
      return TSSGUIDPKGenerator.getInstance();
    }
    return DummyPKGeneratorFactory.getPKGenerator(daoFactory);
  }


  /**
   * Factory to get the right Primary Key Generator; It uses the default
   * database (ORACLE).
   * @return The primary key generator. NULL if the generator for the
   * given database is not available.
   */
  private static PKGenerator getPKGenerator(GenericDAOFactory daoFactory) {
    return getPKGenerator(Databases.ORACLE, daoFactory);
  }
}