/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorConvertOp;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.icon.FilteredResizableIcon;
import test.common.TestCommandToggleButtons;
import test.svg.transcoded.edit_paste;

public class TestCommandToggleButtonsNoText
extends TestCommandToggleButtons {
    @Override
    protected JCommandToggleButton createToggleButton(CommandButtonDisplayState state, String title) {
        JCommandToggleButton mainButton = new JCommandToggleButton(new edit_paste());
        mainButton.setDisabledIcon(new FilteredResizableIcon(new edit_paste(), new ColorConvertOp(ColorSpace.getInstance(1003), null)));
        mainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(TestCommandToggleButtons.stamp() + ": Main selection");
            }
        });
        mainButton.setDisplayState(state);
        mainButton.setFlat(false);
        return mainButton;
    }

    @Override
    protected void configureControlPanel(JPanel controlPanel) {
        super.configureControlPanel(controlPanel);
        final JCheckBox noText = new JCheckBox("no text");
        noText.setSelected(true);
        noText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestCommandToggleButtonsNoText.apply(TestCommandToggleButtonsNoText.this, new Command(){

                            @Override
                            public void apply(JCommandToggleButton button) {
                                button.setText(noText.isSelected() ? null : "New caption");
                                button.setExtraText(noText.isSelected() ? null : "New extra text");
                            }
                        });
                        TestCommandToggleButtonsNoText.this.getContentPane().invalidate();
                        TestCommandToggleButtonsNoText.this.getContentPane().validate();
                    }
                });
            }
        });
        controlPanel.add(noText);
    }

    private static void apply(Container cont, Command cmd) {
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            Component comp = cont.getComponent(i);
            if (comp instanceof JCommandToggleButton) {
                JCommandToggleButton cb = (JCommandToggleButton)comp;
                cmd.apply(cb);
            }
            if (!(comp instanceof Container)) continue;
            TestCommandToggleButtonsNoText.apply((Container)comp, cmd);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
                catch (Exception e) {
                    // empty catch block
                }
                TestCommandToggleButtonsNoText frame = new TestCommandToggleButtonsNoText();
                frame.setSize(800, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
            }
        });
    }

    private static interface Command {
        public void apply(JCommandToggleButton var1);
    }
}

