/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import test.common.LocaleSwitcher;
import test.common.QuickStylesPanel;

public class TestCommandButtonPanel
extends JFrame {
    protected ResourceBundle resourceBundle;
    protected Locale currLocale = Locale.getDefault();
    private JScrollPane scroller;
    private QuickStylesPanel buttonPanel;

    public TestCommandButtonPanel() {
        this.resourceBundle = ResourceBundle.getBundle("test.resource.Resources", this.currLocale);
        this.buttonPanel = new QuickStylesPanel(this.resourceBundle, this.currLocale);
        this.scroller = new JScrollPane(this.buttonPanel);
        this.add((Component)this.scroller, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(2));
        final JCheckBox toShowGroupLabels = new JCheckBox("show group labels");
        toShowGroupLabels.setSelected(this.buttonPanel.isToShowGroupLabels());
        toShowGroupLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestCommandButtonPanel.this.buttonPanel.setToShowGroupLabels(toShowGroupLabels.isSelected());
                TestCommandButtonPanel.this.scroller.revalidate();
            }
        });
        controlPanel.add(toShowGroupLabels);
        final JCheckBox isRowFillLayout = new JCheckBox("use row fill layout");
        isRowFillLayout.setSelected(this.buttonPanel.getLayoutKind() == JCommandButtonPanel.LayoutKind.ROW_FILL);
        isRowFillLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestCommandButtonPanel.this.buttonPanel.setLayoutKind(isRowFillLayout.isSelected() ? JCommandButtonPanel.LayoutKind.ROW_FILL : JCommandButtonPanel.LayoutKind.COLUMN_FILL);
            }
        });
        controlPanel.add(isRowFillLayout);
        JComboBox localeSwitcher = LocaleSwitcher.getLocaleSwitcher(new LocaleSwitcher.LocaleCallback(){

            @Override
            public void onLocaleSelected(Locale selected) {
                TestCommandButtonPanel.this.currLocale = selected;
                TestCommandButtonPanel.this.resourceBundle = ResourceBundle.getBundle("test.resource.Resources", TestCommandButtonPanel.this.currLocale);
                TestCommandButtonPanel.this.remove(TestCommandButtonPanel.this.scroller);
                TestCommandButtonPanel.this.buttonPanel = new QuickStylesPanel(TestCommandButtonPanel.this.resourceBundle, TestCommandButtonPanel.this.currLocale);
                TestCommandButtonPanel.this.scroller = new JScrollPane(TestCommandButtonPanel.this.buttonPanel);
                TestCommandButtonPanel.this.add((Component)TestCommandButtonPanel.this.scroller, "Center");
                Window window = SwingUtilities.getWindowAncestor(TestCommandButtonPanel.this.buttonPanel);
                window.applyComponentOrientation(ComponentOrientation.getOrientation(TestCommandButtonPanel.this.currLocale));
                SwingUtilities.updateComponentTreeUI(window);
            }
        });
        controlPanel.add(localeSwitcher);
        this.add((Component)controlPanel, "South");
        this.setSize(500, 300);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new TestCommandButtonPanel().setVisible(true);
            }
        });
    }
}

