/*
 * Decompiled with CFR 0.152.
 */
package test.bcb;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbTreeAdapterSelector;
import org.pushingpixels.flamingo.api.common.StringValuePair;

public class TreeAdapterBreadCrumbTest
extends JFrame {
    private JList fileList;
    private BreadcrumbTreeAdapterSelector bar;

    public TreeAdapterBreadCrumbTest() {
        super("BreadCrumb test");
        File[] roots = File.listRoots();
        FileTreeNode rootTreeNode = new FileTreeNode(roots);
        this.bar = new BreadcrumbTreeAdapterSelector(new DefaultTreeModel(rootTreeNode), new BreadcrumbTreeAdapterSelector.TreeAdapter(){

            @Override
            public String toString(Object node) {
                FileTreeNode n = (FileTreeNode)node;
                if (n.file == null) {
                    return "Computer";
                }
                String result = FileSystemView.getFileSystemView().getSystemDisplayName(n.file);
                if (result.length() == 0) {
                    result = n.file.getAbsolutePath();
                }
                return result;
            }

            @Override
            public Icon getIcon(Object node) {
                FileTreeNode n = (FileTreeNode)node;
                if (n.file == null) {
                    return null;
                }
                Icon result = FileSystemView.getFileSystemView().getSystemIcon(n.file);
                return result;
            }
        }, false);
        this.bar.getModel().addPathListener(new BreadcrumbPathListener(){

            @Override
            public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final List newPath = TreeAdapterBreadCrumbTest.this.bar.getModel().getItems();
                        System.out.println("New path is ");
                        for (BreadcrumbItem item : newPath) {
                            FileTreeNode node = (FileTreeNode)item.getData();
                            if (node.file == null) continue;
                            System.out.println("\t" + node.file.getName());
                        }
                        if (newPath.size() > 0) {
                            SwingWorker<List<StringValuePair<Object>>, Void> worker = new SwingWorker<List<StringValuePair<Object>>, Void>(){

                                @Override
                                protected List<StringValuePair<Object>> doInBackground() throws Exception {
                                    return TreeAdapterBreadCrumbTest.this.bar.getCallback().getLeafs(newPath);
                                }

                                @Override
                                protected void done() {
                                    try {
                                        FileListModel model = new FileListModel();
                                        List leafs = (List)this.get();
                                        for (StringValuePair leaf : leafs) {
                                            FileTreeNode node = (FileTreeNode)leaf.getValue();
                                            model.add(node.file);
                                        }
                                        model.sort();
                                        TreeAdapterBreadCrumbTest.this.fileList.setModel(model);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            worker.execute();
                        }
                    }
                });
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        this.fileList = new JList();
        this.fileList.setCellRenderer(new FileListRenderer());
        JScrollPane fileListScrollPane = new JScrollPane(this.fileList);
        fileListScrollPane.setBorder(new TitledBorder("File list"));
        this.add((Component)fileListScrollPane, "Center");
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeAdapterBreadCrumbTest test = new TreeAdapterBreadCrumbTest();
                test.setSize(700, 400);
                test.setLocation(300, 100);
                test.setVisible(true);
                test.setDefaultCloseOperation(3);
            }
        });
    }

    public class MemoryListRenderer
    extends JLabel
    implements ListCellRenderer {
        public MemoryListRenderer() {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.setFont(new Font("Tahoma", 0, 11));
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            BreadcrumbItem[] path = (BreadcrumbItem[])value;
            if (path.length > 0) {
                this.setText(((File)path[path.length - 1].getData()).getName());
            } else {
                this.setIcon(null);
                this.setText("Root");
            }
            Color back = index % 2 == 0 ? new Color(250, 250, 250) : new Color(240, 240, 240);
            this.setBackground(back);
            return this;
        }
    }

    public static class FileListModel
    extends AbstractListModel {
        private ArrayList<File> files = new ArrayList();

        public void add(File file) {
            this.files.add(file);
        }

        public void sort() {
            Collections.sort(this.files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    if (o1.isDirectory() && !o2.isDirectory()) {
                        return -1;
                    }
                    if (o2.isDirectory() && !o1.isDirectory()) {
                        return 1;
                    }
                    return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                }
            });
        }

        @Override
        public Object getElementAt(int index) {
            return this.files.get(index);
        }

        @Override
        public int getSize() {
            return this.files.size();
        }
    }

    public class FileListRenderer
    extends JLabel
    implements ListCellRenderer {
        public FileListRenderer() {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.setFont(new Font("Tahoma", 0, 11));
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color back;
            File file = (File)value;
            this.setIcon(FileSystemView.getFileSystemView().getSystemIcon(file));
            this.setText(FileSystemView.getFileSystemView().getSystemDisplayName(file));
            Color color = back = index % 2 == 0 ? new Color(250, 250, 250) : new Color(240, 240, 240);
            if (isSelected) {
                back = new Color(220, 220, 240);
            }
            this.setBackground(back);
            return this;
        }
    }

    private static class FileTreeNode
    implements TreeNode {
        private File file;
        private File[] children;
        private TreeNode parent;

        public FileTreeNode(File file, TreeNode parent) {
            this.file = file;
            this.parent = parent;
            this.children = this.file.listFiles();
            if (this.children == null) {
                this.children = new File[0];
            }
        }

        public FileTreeNode(File[] children) {
            this.file = null;
            this.parent = null;
            this.children = children;
        }

        public Enumeration<?> children() {
            final int elementCount = this.children.length;
            return new Enumeration<File>(){
                int count = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.count < elementCount;
                }

                @Override
                public File nextElement() {
                    if (this.count < elementCount) {
                        return FileTreeNode.this.children[this.count++];
                    }
                    throw new NoSuchElementException("Vector Enumeration");
                }
            };
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return new FileTreeNode(this.children[childIndex], this);
        }

        @Override
        public int getChildCount() {
            return this.children.length;
        }

        @Override
        public int getIndex(TreeNode node) {
            FileTreeNode ftn = (FileTreeNode)node;
            for (int i = 0; i < this.children.length; ++i) {
                if (!ftn.file.equals(this.children[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            boolean isNotFolder = this.file != null && this.file.isFile();
            return this.getChildCount() == 0 && isNotFolder;
        }
    }
}

