/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.application.glycanbuilder.util.exchange.importer.glycontainer2glycan;

import java.util.HashMap;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.ModifiedMonosaccharideDescriptor;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameDictionary;

public class NodeAnalyzer {
    private final HashMap<String, Edge> subList = new HashMap();
    private final HashMap<String, GlyCoModification> modList = new HashMap();

    public Node start(Node _node, Residue _residue) throws GlycanException {
        this.extractSubstituents(_node);
        this.extractModifications(_node);
        this.removeCoreSubstituent(_node, _residue);
        return _node;
    }

    private void extractSubstituents(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        for (Edge edge : mono.getChildEdges()) {
            if (edge.getSubstituent() == null) continue;
            Substituent sub = (Substituent)edge.getSubstituent();
            if (edge.getSubstituent() instanceof GlycanRepeatModification || sub.getSubstituent() instanceof BaseCrossLinkedTemplate || edge.getGlycosidicLinkages().get(0).getParentLinkages().size() != 1) continue;
            this.subList.put(edge.getGlycosidicLinkages().get(0).getParentLinkages().get(0) + sub.getSubstituent().getIUPACnotation(), edge);
        }
    }

    private void extractModifications(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        for (GlyCoModification gMod : mono.getModifications()) {
            this.modList.put(gMod.getPositionOne() + String.valueOf(gMod.getModificationTemplate().getCarbon()), gMod);
        }
    }

    private Node removeCoreSubstituent(Node _node, Residue _residue) throws GlycanException {
        ModifiedMonosaccharideDescriptor modMonoDesc;
        String[] items;
        String trivialName = _residue.getTypeName();
        TrivialNameDictionary trivialNameDictionary = TrivialNameDictionary.forThreeLetterCode(trivialName);
        if (trivialNameDictionary != null) {
            String modNotations;
            String subNotations = trivialNameDictionary.getSubstituents();
            if (!subNotations.equals("")) {
                for (String item : subNotations.split("_")) {
                    String[] items2 = item.split("\\*");
                    this.removeModifications(_node, items2[0] + items2[1]);
                }
            }
            if (!(modNotations = trivialNameDictionary.getModifications()).equals("")) {
                for (String item : modNotations.split("_")) {
                    items = item.split("\\*");
                    this.removeModifications(_node, items[0] + items[1]);
                }
            }
        }
        if ((modMonoDesc = ModifiedMonosaccharideDescriptor.forTrivialName(trivialName)) != null) {
            String modNotations;
            String subNotations = modMonoDesc.getSubstituents();
            if (!subNotations.equals("")) {
                for (String item : subNotations.split("_")) {
                    items = item.split("\\*");
                    if (item.equals("5*NAc") || item.equals("5*NGc")) {
                        this.removeModifications(_node, items[0] + items[1].replaceFirst("N", ""));
                        continue;
                    }
                    this.removeModifications(_node, items[0] + items[1]);
                }
            }
            if (!(modNotations = modMonoDesc.getModifications()).equals("")) {
                for (String item : modMonoDesc.getModifications().split("_")) {
                    String[] items3 = item.split("\\*");
                    this.removeModifications(_node, items3[0] + items3[1]);
                }
            }
        }
        return _node;
    }

    private void removeModifications(Node _acceptor, String _key) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_acceptor;
        for (String key : this.subList.keySet()) {
            if (!key.equals(_key)) continue;
            mono.removeChildEdge(this.subList.get(key));
        }
        for (String key : this.modList.keySet()) {
            if (!key.equals(_key)) continue;
            mono.removeModification(this.modList.get(_key));
        }
    }
}

