/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.application.glycanbuilder.converterWURCS2;

import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.converter.GlycanParser;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.massutil.MassOptions;
import org.eurocarbdb.application.glycanbuilder.renderutil.BBoxManager;
import org.glycoinfo.WURCSFramework.util.WURCSFactory;
import org.glycoinfo.application.glycanbuilder.converterWURCS2.LinkageTypeOptimizer;
import org.glycoinfo.application.glycanbuilder.util.exchange.exporter.GlycanToWURCSGraph;
import org.glycoinfo.application.glycanbuilder.util.exchange.importer.WURCSSequence2ToGlycan;

public class WURCS2Parser
implements GlycanParser {
    @Override
    public void setTolerateUnknown(boolean f) {
    }

    @Override
    public String writeGlycan(Glycan structure) {
        if (structure.isFragment()) {
            return "";
        }
        if (structure.isComposition()) {
            return "";
        }
        try {
            LinkageTypeOptimizer linkOpt = new LinkageTypeOptimizer();
            linkOpt.start(structure);
            GlycanToWURCSGraph glycan2graph = new GlycanToWURCSGraph();
            glycan2graph.start(structure);
            WURCSFactory wf = new WURCSFactory(glycan2graph.getGraph());
            return wf.getWURCS();
        }
        catch (Exception e) {
            LogUtils.report(e);
            return "";
        }
    }

    @Override
    public Glycan readGlycan(String str, MassOptions mass_opt) throws Exception {
        if (str.equals("") || !str.contains("WURCS")) {
            throw new Exception(str + " is wrong format");
        }
        mass_opt.setDerivatization("Und");
        mass_opt.ION_CLOUD.set("Na", 0);
        str = str.trim();
        if (str.contains("\t")) {
            str = str.substring(str.indexOf("\t") + 1);
        }
        WURCSFactory wf = new WURCSFactory(str);
        WURCSSequence2ToGlycan seq22glycan = new WURCSSequence2ToGlycan();
        seq22glycan.start(wf, mass_opt);
        return seq22glycan.getGlycan();
    }

    @Override
    public String writeGlycan(Glycan structure, BBoxManager bboxManager) {
        throw new UnsupportedOperationException();
    }
}

