/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.map.analysis.cip;

import java.util.Comparator;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.map.analysis.cip.HierarchicalDigraphNode;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPConnection;

public class HierarchicalDigraphComparator
implements Comparator<HierarchicalDigraphNode> {
    private static final double EPS = 1.0E-9;

    @Override
    public int compare(HierarchicalDigraphNode a_oNode1, HierarchicalDigraphNode a_oNode2) {
        LinkedList<HierarchicalDigraphNode> t_aGraph1Width = new LinkedList<HierarchicalDigraphNode>();
        LinkedList<HierarchicalDigraphNode> t_aGraph2Width = new LinkedList<HierarchicalDigraphNode>();
        t_aGraph1Width.addLast(a_oNode1);
        t_aGraph2Width.addLast(a_oNode2);
        while (t_aGraph1Width.size() != 0 && t_aGraph2Width.size() != 0) {
            HierarchicalDigraphNode t_oNode1 = (HierarchicalDigraphNode)t_aGraph1Width.removeFirst();
            HierarchicalDigraphNode t_oNode2 = (HierarchicalDigraphNode)t_aGraph2Width.removeFirst();
            MAPConnection t_oConn1 = t_oNode1.getConnection();
            MAPConnection t_oConn2 = t_oNode2.getConnection();
            if (t_oConn1 != null && t_oConn2 == null) {
                return -1;
            }
            if (t_oConn1 == null && t_oConn2 != null) {
                return 1;
            }
            if (t_oConn1 != null && t_oConn2 != null && t_oConn1.equals(t_oConn2)) continue;
            int t_iComp = this.compareNodes(t_oNode1, t_oNode2);
            if (t_iComp != 0) {
                return t_iComp;
            }
            LinkedList<HierarchicalDigraphNode> t_aChildren1 = t_oNode1.getChildren();
            LinkedList<HierarchicalDigraphNode> t_aChildren2 = t_oNode2.getChildren();
            for (HierarchicalDigraphNode t_oChild1 : t_aChildren1) {
                t_aGraph1Width.addLast(t_oChild1);
            }
            for (HierarchicalDigraphNode t_oChild2 : t_aChildren2) {
                t_aGraph2Width.addLast(t_oChild2);
            }
            int t_iDiff = t_aChildren1.size() - t_aChildren2.size();
            if (t_iDiff == 0) continue;
            HierarchicalDigraphNode t_oPseudoNode = new HierarchicalDigraphNode(null, 0.0);
            LinkedList<HierarchicalDigraphNode> t_aWidth = t_iDiff < 0 ? t_aGraph1Width : t_aGraph2Width;
            for (int i = 0; i < Math.abs(t_iDiff); ++i) {
                t_aWidth.addLast(t_oPseudoNode);
            }
        }
        return 0;
    }

    protected int compareNodes(HierarchicalDigraphNode a_oNode1, HierarchicalDigraphNode a_oNode2) {
        if (Math.abs(a_oNode1.getAverageAtomicNumber() - a_oNode2.getAverageAtomicNumber()) > 1.0E-9) {
            return a_oNode1.getAverageAtomicNumber() > a_oNode2.getAverageAtomicNumber() ? -1 : 1;
        }
        return 0;
    }
}

