/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.visitor;

import java.util.HashMap;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.array.WURCSExporter;
import org.glycoinfo.WURCSFramework.util.exchange.WURCSGraphToArray;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSEdgeComparator;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverser;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverserTreeStoppable;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitor;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WURCSVisitorExpandRepeatingUnit
implements WURCSVisitor {
    private static final Logger logger = LoggerFactory.getLogger(WURCSVisitorExpandRepeatingUnit.class);
    private WURCSGraph m_oGraph;
    private LinkedList<ModificationRepeat> m_aModificationsOfRepeat = new LinkedList();
    private LinkedList<Backbone> m_aRepeatBackbones = new LinkedList();
    private LinkedList<Modification> m_aRepeatModifications = new LinkedList();
    private WURCSEdge m_oUnitStartEdge = null;
    private WURCSEdge m_oUnitEndEdge = null;
    private WURCSEdge m_oRepeatEdgeStartSide = null;
    private WURCSEdge m_oRepeatEdgeEndSide = null;
    private boolean m_bExpanded = false;
    private WURCSGraphTraverserTreeStoppable m_oTraverser;

    public boolean hasDone() {
        return this.m_bExpanded;
    }

    @Override
    public void visit(Backbone a_objBackbone) throws WURCSVisitorException {
        this.m_aRepeatBackbones.addLast(a_objBackbone);
    }

    @Override
    public void visit(Modification a_objModification) throws WURCSVisitorException {
        if (!this.m_aRepeatModifications.contains(a_objModification)) {
            this.m_aRepeatModifications.addLast(a_objModification);
        }
        if (!(a_objModification instanceof ModificationRepeat)) {
            return;
        }
        if (this.m_aModificationsOfRepeat.contains(a_objModification)) {
            return;
        }
        this.m_aModificationsOfRepeat.addLast((ModificationRepeat)a_objModification);
    }

    @Override
    public void visit(WURCSEdge a_objWURCSEdge) throws WURCSVisitorException {
        logger.debug(this.m_aRepeatBackbones.indexOf(a_objWURCSEdge.getBackbone()) + ":" + a_objWURCSEdge.printEdge());
        if (!(a_objWURCSEdge.equals(this.m_oUnitEndEdge) || a_objWURCSEdge.equals(this.m_oUnitStartEdge) || a_objWURCSEdge.equals(this.m_oRepeatEdgeEndSide) || a_objWURCSEdge.equals(this.m_oRepeatEdgeStartSide))) {
            return;
        }
        logger.debug("stop");
        this.m_oTraverser.stop();
    }

    @Override
    public void start(WURCSGraph a_objGraph) throws WURCSVisitorException {
        this.m_oGraph = a_objGraph;
        LinkedList<ModificationRepeat> t_aIgnoreModReps = new LinkedList<ModificationRepeat>();
        LinkedList<Object> t_aModReps = new LinkedList<Object>();
        for (Modification t_oMod : this.m_oGraph.getModifications()) {
            if (!(t_oMod instanceof ModificationRepeat)) continue;
            ModificationRepeat modificationRepeat = (ModificationRepeat)t_oMod;
            if (modificationRepeat.getMinRepeatCount() == -1 || modificationRepeat.getMaxRepeatCount() == -1) {
                logger.debug("Can't expand repeating unit with unknown repeat count");
                t_aIgnoreModReps.add(modificationRepeat);
                continue;
            }
            if (modificationRepeat.getMinRepeatCount() != modificationRepeat.getMaxRepeatCount()) {
                logger.debug("Can't expand repeating unit with ranged repeat count");
                t_aIgnoreModReps.add(modificationRepeat);
                continue;
            }
            t_aModReps.addLast(modificationRepeat);
        }
        if (t_aModReps.isEmpty()) {
            return;
        }
        logger.debug("Repeating unit expansion>>>");
        LinkedList<Object> t_aSortedModReps = new LinkedList<Object>();
        while (true) {
            this.clear();
            if (t_aModReps.isEmpty()) break;
            ModificationRepeat t_oModRep = (ModificationRepeat)t_aModReps.removeFirst();
            this.traverseRepeat(t_oModRep);
            if (this.m_aModificationsOfRepeat.contains(t_oModRep)) {
                throw new WURCSVisitorException("Illegal composition of repeating unit is found.");
            }
            boolean bl = false;
            for (ModificationRepeat t_oNestedModRep : this.m_aModificationsOfRepeat) {
                if (t_aIgnoreModReps.contains(t_oNestedModRep) || this.checkExternalLinkage(t_oNestedModRep) || t_aSortedModReps.contains(t_oNestedModRep)) continue;
                bl = true;
            }
            if (!bl) {
                t_aSortedModReps.addLast(t_oModRep);
                continue;
            }
            t_aModReps.addLast(t_oModRep);
        }
        try {
            for (ModificationRepeat modificationRepeat : t_aSortedModReps) {
                this.expandRepeatingUnits(modificationRepeat);
            }
        }
        catch (WURCSException e) {
            throw new WURCSVisitorException(e.getErrorMessage());
        }
        this.m_bExpanded = true;
    }

    @Override
    public WURCSGraphTraverser getTraverser(WURCSVisitor a_objVisitor) throws WURCSVisitorException {
        return new WURCSGraphTraverserTreeStoppable(a_objVisitor);
    }

    @Override
    public void clear() {
        this.m_aModificationsOfRepeat = new LinkedList();
        this.m_aRepeatBackbones = new LinkedList();
        this.m_oUnitStartEdge = null;
        this.m_oUnitEndEdge = null;
        this.m_oRepeatEdgeStartSide = null;
        this.m_oRepeatEdgeEndSide = null;
    }

    private void expandRepeatingUnits(ModificationRepeat a_oModRep) throws WURCSException {
        Backbone t_oEndRepBOrig;
        this.clear();
        this.traverseRepeat(a_oModRep);
        Backbone t_oStartRepBOrig = this.m_oRepeatEdgeStartSide.getBackbone();
        Backbone t_oEndRepB = t_oEndRepBOrig = this.m_oRepeatEdgeEndSide.getBackbone();
        WURCSEdge t_oUnitEndEdge = this.m_oUnitEndEdge;
        while (a_oModRep.getMinRepeatCount() > 1) {
            HashMap<Backbone, Backbone> t_mapOrig2CopyB = new HashMap<Backbone, Backbone>();
            HashMap<Modification, Modification> t_mapOrig2CopyM = new HashMap<Modification, Modification>();
            for (Backbone t_oBackOrig : this.m_aRepeatBackbones) {
                Backbone t_oBackCopy = t_oBackOrig.copy();
                t_mapOrig2CopyB.put(t_oBackOrig, t_oBackCopy);
                for (WURCSEdge t_oEdgeOrig : t_oBackOrig.getEdges()) {
                    Modification t_oModifOrig = t_oEdgeOrig.getModification();
                    if (t_oModifOrig.equals(a_oModRep) || !this.m_aRepeatModifications.contains(t_oModifOrig) || t_oModifOrig instanceof ModificationRepeat && this.checkExternalLinkage((ModificationRepeat)t_oModifOrig)) continue;
                    if (!t_mapOrig2CopyM.containsKey(t_oModifOrig)) {
                        t_mapOrig2CopyM.put(t_oModifOrig, t_oModifOrig.copy());
                    }
                    Modification t_copyModif = (Modification)t_mapOrig2CopyM.get(t_oModifOrig);
                    this.m_oGraph.addResidues(t_oBackCopy, t_oEdgeOrig.copy(), t_copyModif);
                }
            }
            Backbone t_oEndRepBOld = t_oEndRepB;
            t_oEndRepB = (Backbone)t_mapOrig2CopyB.get(t_oEndRepBOrig);
            if (t_oUnitEndEdge != null) {
                t_oEndRepBOld.removeEdge(t_oUnitEndEdge);
                t_oUnitEndEdge.setBackbone(t_oEndRepB);
                t_oEndRepB.addEdge(t_oUnitEndEdge);
            }
            Backbone t_oStartRepB = (Backbone)t_mapOrig2CopyB.get(t_oStartRepBOrig);
            WURCSEdge t_oStartEdge = this.m_oRepeatEdgeStartSide.copy();
            t_oStartEdge.reverse();
            WURCSEdge t_oEndEdge = this.m_oRepeatEdgeEndSide.copy();
            Modification t_oNewMod = new Modification(a_oModRep.getMAPCode());
            this.m_oGraph.addResidues(t_oEndRepBOld, t_oEndEdge, t_oNewMod);
            this.m_oGraph.addResidues(t_oStartRepB, t_oStartEdge, t_oNewMod);
            int t_iMinRepCount = a_oModRep.getMinRepeatCount();
            int t_iMaxRepCount = a_oModRep.getMaxRepeatCount();
            a_oModRep.setMinRepeatCount(--t_iMinRepCount);
            a_oModRep.setMaxRepeatCount(--t_iMaxRepCount);
            WURCSGraphToArray t_oG2A = new WURCSGraphToArray();
            t_oG2A.start(this.m_oGraph);
            WURCSArray t_oArray = t_oG2A.getWURCSArray();
            String t_strWURCS = new WURCSExporter().getWURCSString(t_oArray);
            logger.debug("expanded WURCS: {}", (Object)t_strWURCS);
        }
        this.m_oGraph.removeModification(a_oModRep);
    }

    private void traverseRepeat(ModificationRepeat a_objRepeat) throws WURCSVisitorException {
        if (a_objRepeat.getEdges().size() != 2) {
            throw new WURCSVisitorException("Repeat linkage must have two edges.");
        }
        boolean t_bFirstIsStart = this.isStartEdge(a_objRepeat.getEdges().getFirst());
        boolean t_bLastIsStart = this.isStartEdge(a_objRepeat.getEdges().getLast());
        if (t_bFirstIsStart && t_bLastIsStart || !t_bFirstIsStart && !t_bLastIsStart) {
            throw new WURCSVisitorException("Can't be specified start edge for repeating unit.");
        }
        this.m_oRepeatEdgeStartSide = t_bFirstIsStart ? a_objRepeat.getEdges().getFirst() : a_objRepeat.getEdges().getLast();
        this.m_oRepeatEdgeEndSide = t_bFirstIsStart ? a_objRepeat.getEdges().getLast() : a_objRepeat.getEdges().getFirst();
        WURCSEdgeComparator t_oEdgeComp = new WURCSEdgeComparator();
        for (WURCSEdge t_oEdge : this.m_oRepeatEdgeStartSide.getBackbone().getEdges()) {
            if (!t_oEdge.getModification().isGlycosidic() || t_oEdge.getModification() instanceof ModificationRepeat || this.m_oRepeatEdgeStartSide.equals(t_oEdge) || t_oEdgeComp.compareLinkagePositions(this.m_oRepeatEdgeStartSide.getLinkages(), t_oEdge.getLinkages()) != 0) continue;
            this.m_oUnitStartEdge = t_oEdge;
        }
        for (WURCSEdge t_oEdge : this.m_oRepeatEdgeEndSide.getBackbone().getEdges()) {
            if (!t_oEdge.getModification().isGlycosidic() || t_oEdge.getModification() instanceof ModificationRepeat || this.m_oRepeatEdgeEndSide.equals(t_oEdge) || t_oEdgeComp.compareLinkagePositions(this.m_oRepeatEdgeEndSide.getLinkages(), t_oEdge.getLinkages()) != 0) continue;
            this.m_oUnitEndEdge = t_oEdge;
        }
        this.m_oTraverser = (WURCSGraphTraverserTreeStoppable)this.getTraverser(this);
        logger.debug(this.m_oRepeatEdgeStartSide.printEdge() + " : " + this.m_oRepeatEdgeEndSide.printEdge());
        if (this.m_oUnitStartEdge != null && this.m_oUnitEndEdge != null) {
            logger.debug(this.m_oUnitStartEdge.printEdge() + " : " + this.m_oUnitEndEdge.printEdge());
        }
        this.m_oTraverser.traverse(this.m_oRepeatEdgeStartSide.getBackbone());
    }

    private boolean isStartEdge(WURCSEdge a_oEdge) {
        if (a_oEdge.getLinkages().size() > 1) {
            return false;
        }
        int t_iAnomPos = a_oEdge.getBackbone().getAnomericPosition();
        if (t_iAnomPos == 0 || t_iAnomPos == -1) {
            return true;
        }
        return a_oEdge.getLinkages().getFirst().getBackbonePosition() == t_iAnomPos;
    }

    private boolean checkExternalLinkage(ModificationRepeat a_oModRep) {
        for (WURCSEdge t_oEdge : a_oModRep.getEdges()) {
            if (this.m_aRepeatBackbones.contains(t_oEdge.getBackbone())) continue;
            return true;
        }
        return false;
    }
}

