/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.comparator;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.graph.comparator.BackboneComparator;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSEdgeComparator;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSVisitorCollectSequenceComparator;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorCollectSequence;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.Monosaccharide;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class MonosaccharideComparatorForInvertBackbone
implements Comparator<Monosaccharide> {
    private static WURCSEdgeComparator compEdge = new WURCSEdgeComparator();

    @Override
    public int compare(Monosaccharide MS1, Monosaccharide MS2) {
        int t_nChildCount2;
        int t_nParentCount2;
        Backbone b2;
        BackboneComparator t_oBComp = new BackboneComparator();
        Backbone b1 = MS1.getBackbone();
        int t_iComp = t_oBComp.compare(b1, b2 = MS2.getBackbone());
        if (t_iComp != 0) {
            return t_iComp;
        }
        WURCSEdgeComparator t_oCompEdge = new WURCSEdgeComparator();
        int score1 = 0;
        int score2 = 0;
        t_iComp = this.compareEdges(MS1.getRingEdges(), MS2.getRingEdges());
        if (t_iComp != 0) {
            return t_iComp;
        }
        t_iComp = this.compareEdges(MS1.getSubstituentEdges(), MS2.getSubstituentEdges());
        if (t_iComp != 0) {
            return t_iComp;
        }
        int t_nParentCount1 = b1.getParentEdges().size();
        t_iComp = t_nParentCount1 - (t_nParentCount2 = b2.getParentEdges().size());
        if (t_iComp != 0) {
            return t_iComp;
        }
        for (WURCSEdge edge : b1.getParentEdges()) {
            int pos1 = edge.getLinkages().getFirst().getBackbonePosition();
            score1 += pos1;
        }
        for (WURCSEdge edge : b2.getParentEdges()) {
            int pos2 = edge.getLinkages().getFirst().getBackbonePosition();
            score2 += pos2;
        }
        t_iComp = score1 - score2;
        if (t_iComp != 0) {
            return t_iComp;
        }
        LinkedList<WURCSEdge> t_aGlycoLinkages1 = MS1.getChildGlycosidicEdges();
        LinkedList<WURCSEdge> t_aGlycoLinkages2 = MS2.getChildGlycosidicEdges();
        int t_nChildCount1 = t_aGlycoLinkages1.size();
        t_iComp = t_nChildCount1 - (t_nChildCount2 = t_aGlycoLinkages2.size());
        if (t_iComp != 0) {
            return t_iComp;
        }
        Collections.sort(t_aGlycoLinkages1, t_oCompEdge);
        Collections.sort(t_aGlycoLinkages2, t_oCompEdge);
        score1 = 0;
        score2 = 0;
        for (WURCSEdge edge : t_aGlycoLinkages1) {
            int pos1 = edge.getLinkages().getFirst().getBackbonePosition();
            score1 += pos1;
        }
        for (WURCSEdge edge : t_aGlycoLinkages2) {
            int pos2 = edge.getLinkages().getFirst().getBackbonePosition();
            score2 += pos2;
        }
        t_iComp = score2 - score1;
        if (t_iComp != 0) {
            return t_iComp;
        }
        WURCSVisitorCollectSequenceComparator t_oCompSeq = new WURCSVisitorCollectSequenceComparator();
        int n = t_aGlycoLinkages1.size();
        for (int i = 0; i < n; ++i) {
            WURCSEdge t_oEdge1 = t_aGlycoLinkages1.get(i);
            WURCSEdge t_oEdge2 = t_aGlycoLinkages2.get(i);
            try {
                WURCSVisitorCollectSequence t_oSeq1 = new WURCSVisitorCollectSequence();
                t_oSeq1.start(t_oEdge1);
                WURCSVisitorCollectSequence t_oSeq2 = new WURCSVisitorCollectSequence();
                t_oSeq2.start(t_oEdge2);
                t_iComp = t_oCompSeq.compare(t_oSeq1, t_oSeq2);
            }
            catch (WURCSVisitorException e) {
                e.printStackTrace();
            }
            if (t_iComp == 0) continue;
            return t_iComp;
        }
        return 0;
    }

    private int compareEdges(LinkedList<WURCSEdge> a_edges1, LinkedList<WURCSEdge> a_edges2) {
        int t_nEdgeCount1 = a_edges1.size();
        int t_nEdgeCount2 = a_edges2.size();
        int t_iComp = t_nEdgeCount2 - t_nEdgeCount1;
        if (t_iComp != 0) {
            return t_iComp;
        }
        Collections.sort(a_edges1, compEdge);
        Collections.sort(a_edges2, compEdge);
        int score1 = 0;
        int score2 = 0;
        for (WURCSEdge edge : a_edges1) {
            score1 += edge.getLinkages().getFirst().getBackbonePosition();
        }
        for (WURCSEdge edge : a_edges2) {
            score2 += edge.getLinkages().getFirst().getBackbonePosition();
        }
        t_iComp = score1 - score2;
        if (t_iComp != 0) {
            return t_iComp;
        }
        for (int i = 0; i < a_edges1.size(); ++i) {
            t_iComp = compEdge.compare(a_edges1.get(i), a_edges2.get(i));
            if (t_iComp == 0) continue;
            return t_iComp;
        }
        return 0;
    }
}

