/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.analysis;

import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptor;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class WURCSGraphStateDeterminer {
    public static boolean hasMultipleReducingEnd(WURCSGraph a_graph) throws WURCSException {
        return a_graph.getRootBackbones().size() > 1;
    }

    public static boolean isNonReducingSugar(WURCSGraph a_graph) throws WURCSException {
        Modification modOnAnom = WURCSGraphStateDeterminer.getAnomericModificationOnReducingEnd(a_graph);
        if (modOnAnom == null) {
            return false;
        }
        return modOnAnom.isGlycosidic();
    }

    public static boolean isGlycoside(WURCSGraph a_graph) throws WURCSException {
        Modification modOnAnom = WURCSGraphStateDeterminer.getAnomericModificationOnReducingEnd(a_graph);
        if (modOnAnom == null) {
            return false;
        }
        return !modOnAnom.isGlycosidic();
    }

    public static Modification getAnomericModificationOnReducingEnd(WURCSGraph a_graph) throws WURCSException {
        if (WURCSGraphStateDeterminer.hasMultipleReducingEnd(a_graph)) {
            return null;
        }
        Backbone bbRoot = a_graph.getRootBackbones().get(0);
        return WURCSGraphStateDeterminer.getAnomericModification(bbRoot);
    }

    public static boolean isGlycoside(Backbone a_bb) throws WURCSException {
        Modification modOnAnom = WURCSGraphStateDeterminer.getAnomericModification(a_bb);
        if (modOnAnom == null) {
            return false;
        }
        return !modOnAnom.isGlycosidic();
    }

    public static Modification getAnomericModification(Backbone a_bb) throws WURCSException {
        if (a_bb.getAnomericEdge() == null) {
            return null;
        }
        return a_bb.getAnomericEdge().getModification();
    }

    public static boolean hasUncertainAnomericState(WURCSGraph a_graph) throws WURCSException {
        for (Backbone bbRoot : a_graph.getRootBackbones()) {
            if (!WURCSGraphStateDeterminer.hasUncertainAnomericState(bbRoot)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUncertainAnomericState(Backbone a_bb) {
        for (BackboneCarbon bc : a_bb.getBackboneCarbons()) {
            if (bc.getDescriptor() != CarbonDescriptor.SSX_UNDEF_U && bc.getDescriptor() != CarbonDescriptor.SZX_UNDEF_L) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnomerOnReducingEnd(WURCSGraph a_graph) throws WURCSException {
        for (Backbone bbRoot : a_graph.getRootBackbones()) {
            if (!WURCSGraphStateDeterminer.hasAnomer(bbRoot)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnomer(Backbone a_bb) {
        return a_bb.getAnomericSymbol() != 'o';
    }

    public static String getAnomericSymbolOnReducingEnd(WURCSGraph a_graph) throws WURCSException {
        Backbone bbRoot = a_graph.getRootBackbones().get(0);
        return WURCSGraphStateDeterminer.getAnomericSymbol(bbRoot);
    }

    public static String getAnomericSymbol(Backbone a_bb) {
        return "" + a_bb.getAnomericSymbol();
    }
}

