/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph;

import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.map.MAPGraphImporter;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPGraph;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPStar;

public class ModificationAnalyzer {
    private Modification m_oModification;
    private boolean m_bIsHydroxy = false;
    private boolean m_bIsEther = false;
    private LinkedList<String> m_aParsedAtoms = new LinkedList();
    private LinkedList<String> m_aPrevAtoms = new LinkedList();
    private LinkedList<Integer> m_aPrevPoss = new LinkedList();
    private LinkedList<Integer> m_aEtherONums = new LinkedList();
    private MAPGraph m_oMAPGraph;

    public ModificationAnalyzer(Modification a_oModification) throws WURCSFormatException {
        this.m_oModification = a_oModification;
        if (!a_oModification.canOmitMAP()) {
            this.m_oMAPGraph = MAPGraphImporter.parseMAP(a_oModification.getMAPCode());
            this.parseMAPToAtoms(a_oModification.getMAPCode());
            this.collectEtherONum();
            return;
        }
        if (a_oModification.isGlycosidic()) {
            this.m_bIsEther = true;
            return;
        }
        this.m_bIsHydroxy = true;
    }

    public boolean isHydroxy() {
        return this.m_bIsHydroxy;
    }

    public boolean isEther() {
        return this.m_bIsEther;
    }

    public boolean isTypeII() {
        return true;
    }

    public String getConnectedAtom(int a_iCarbonID) {
        if (this.m_bIsHydroxy || this.m_bIsEther) {
            return "O";
        }
        for (MAPStar t_oCarbon : this.m_oMAPGraph.getStars()) {
            if (t_oCarbon.getStarIndex() != a_iCarbonID) continue;
            if (t_oCarbon.getParentConnection() == null) {
                if (t_oCarbon.getChildConnections().isEmpty()) {
                    return "H";
                }
                return t_oCarbon.getChildConnections().getFirst().getAtom().getSymbol();
            }
            return t_oCarbon.getParentConnection().getAtom().getSymbol();
        }
        return null;
    }

    public String getAtomConnectedBackboneCarbon(int a_iCarbonID) {
        int t_iAtomPos;
        if (this.m_bIsHydroxy || this.m_bIsEther) {
            return "O";
        }
        String t_strCarbon = "*";
        if (a_iCarbonID != 0) {
            t_strCarbon = t_strCarbon + a_iCarbonID;
        }
        if ((t_iAtomPos = this.m_aParsedAtoms.indexOf(t_strCarbon)) == 0) {
            return this.m_aParsedAtoms.get(1);
        }
        return this.m_aPrevAtoms.get(t_iAtomPos);
    }

    public boolean containEther() {
        return !this.m_aEtherONums.isEmpty();
    }

    private boolean isConnectedEtherO(int a_iCarbonID) {
        int t_iAtomPos;
        String t_strCarbon = "*";
        if (a_iCarbonID != 0) {
            t_strCarbon = t_strCarbon + a_iCarbonID;
        }
        if ((t_iAtomPos = this.m_aParsedAtoms.indexOf(t_strCarbon)) == 0 && this.m_aEtherONums.contains(1)) {
            return true;
        }
        int t_iPrevNum = this.m_aPrevPoss.get(t_iAtomPos);
        return this.m_aEtherONums.contains(t_iPrevNum);
    }

    public boolean isTypeIIICarbon(int a_iCarbonID) {
        if (this.isConnectedEtherO(a_iCarbonID)) {
            return false;
        }
        return "O".equals(this.getAtomConnectedBackboneCarbon(a_iCarbonID));
    }

    private void parseMAPToAtoms(String a_strMAPCode) {
        int t_iPrevPos = -1;
        String t_strPrevAtom = null;
        for (int i = 0; i < a_strMAPCode.length(); ++i) {
            char t_cNext;
            char t_cNext2;
            char t_cX = a_strMAPCode.charAt(i);
            if (t_cX == '(' || t_cX == ')' || t_cX == '=' || t_cX == '#') continue;
            if (t_cX == '^') {
                ++i;
                continue;
            }
            String t_strPos = "";
            while (i + 1 < a_strMAPCode.length() && Character.isDigit(t_cNext2 = a_strMAPCode.charAt(i + 1))) {
                t_strPos = t_strPos + t_cNext2;
                ++i;
            }
            String t_strAtom = "" + t_cX;
            if (t_cX == '*') {
                t_strAtom = t_strAtom + t_strPos;
            } else if (!t_strPos.equals("")) {
                int t_iPos = Integer.valueOf(t_strPos);
                String t_strTargetAtom = this.m_aParsedAtoms.get(t_iPos - 1);
                if (t_cX == '/') {
                    t_iPrevPos = t_iPos - 1;
                    t_strPrevAtom = t_strTargetAtom;
                    continue;
                }
                if (t_cX == '$') {
                    t_strAtom = t_strTargetAtom;
                }
            } else if (i + 1 < a_strMAPCode.length() && Character.isLowerCase(t_cNext = a_strMAPCode.charAt(i + 1))) {
                t_strAtom = t_strAtom + t_cNext;
            }
            this.m_aPrevAtoms.addLast(t_strPrevAtom);
            this.m_aParsedAtoms.addLast(t_strAtom);
            this.m_aPrevPoss.addLast(t_iPrevPos);
            t_strPrevAtom = t_strAtom;
            t_iPrevPos = i;
        }
    }

    private void collectEtherONum() {
        int i;
        if (this.m_bIsHydroxy) {
            return;
        }
        if (this.m_bIsEther) {
            this.m_aEtherONums.addLast(1);
            return;
        }
        if (this.m_aParsedAtoms.size() < 3) {
            return;
        }
        if (this.m_aParsedAtoms.get(1).equals("O")) {
            for (i = 2; i < this.m_aParsedAtoms.size(); ++i) {
                int t_iPrevNum;
                String t_strAtom = this.m_aParsedAtoms.get(i);
                if (t_strAtom == null || !t_strAtom.contains("*") || (t_iPrevNum = this.m_aPrevPoss.get(i).intValue()) != 1) continue;
                this.m_aEtherONums.addLast(1);
            }
        }
        for (i = 2; i < this.m_aParsedAtoms.size(); ++i) {
            String t_strAtom1 = this.m_aParsedAtoms.get(i);
            if (t_strAtom1 == null || !t_strAtom1.contains("*") || "O".equals(this.m_aPrevAtoms.get(i))) continue;
            int t_iPrevNum1 = this.m_aPrevPoss.get(i);
            for (int j = i + 1; j < this.m_aParsedAtoms.size(); ++j) {
                int t_iPrevNum2;
                String t_strAtom2 = this.m_aParsedAtoms.get(j);
                if (t_strAtom2 == null || !t_strAtom2.contains("*") || t_iPrevNum1 != (t_iPrevNum2 = this.m_aPrevPoss.get(j).intValue())) continue;
                this.m_aEtherONums.addLast(t_iPrevNum1);
            }
        }
    }
}

