/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.util;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberUtils {
    public static Double parseDoubleStr(String str, Double defaultValue) {
        try {
            return Double.parseDouble(str);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static Integer parseIntStr(String str, Integer defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static ArrayList<Integer> parseMultipleIntStr(String str, String delim, Integer defaultValue) {
        String[] substrings;
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        String[] stringArray = substrings = str.split(delim);
        int n = substrings.length;
        int n2 = 0;
        while (n2 < n) {
            String substr = stringArray[n2];
            try {
                Integer strValue = Integer.parseInt(substr);
                resultList.add(strValue);
            }
            catch (Throwable e) {
                resultList.add(defaultValue);
            }
            ++n2;
        }
        return resultList;
    }

    public static double nullsaveDoubleValue(Double theDouble, double defaultValue) {
        if (theDouble != null) {
            return theDouble;
        }
        return defaultValue;
    }

    public static double nullsaveDoubleValue(Double theDouble) {
        return NumberUtils.nullsaveDoubleValue(theDouble, 0.0);
    }

    public static int nullsaveIntValue(Integer theInt, int defaultValue) {
        if (theInt != null) {
            return theInt;
        }
        return defaultValue;
    }

    public static int nullsaveIntValue(Integer theInt) {
        return NumberUtils.nullsaveIntValue(theInt, 0);
    }
}

