/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResidueRepresentationFormat {
    GIF("gif", "graphic", false, true, "gif image format"),
    JPG("jpg", "graphic", false, true, "jpg image format"),
    SVG("svg", "graphic", true, false, "scalable vector graphics format"),
    PNG("png", "graphic", false, true, "png image format"),
    PDB("pdb", "3d structure", false, false, "pdb structure file format"),
    CHEM_COMP("chem_comp", "3d structure", false, false, "CCPN ChemComp file format"),
    MOL2("mol2", "3d structure", false, false, "mol2 structure file format");

    private String formatName;
    private String formatType;
    private String description;
    private boolean scalable;
    private boolean binary;
    public static final String FORMAT_TYPE_GRAPHICS = "graphic";
    public static final String FORMAT_TYPE_COORDINATES = "3d structure";

    private ResidueRepresentationFormat(String name, String type, boolean isScalable, boolean isBinary, String desc) {
        this.setFormatName(name);
        this.setFormatType(type);
        this.setDescription(desc);
        this.setScalable(isScalable);
        this.setBinary(isBinary);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getFormatName() {
        return this.formatName;
    }

    private void setFormatName(String name) {
        this.formatName = name;
    }

    public String getFormatType() {
        return this.formatType;
    }

    private void setFormatType(String type) {
        this.formatType = type;
    }

    public boolean isScalable() {
        return this.scalable;
    }

    private void setScalable(boolean isScalable) {
        this.scalable = isScalable;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean flag) {
        this.binary = flag;
    }

    public static ResidueRepresentationFormat forName(String nameStr) {
        ResidueRepresentationFormat[] residueRepresentationFormatArray = ResidueRepresentationFormat.values();
        int n = residueRepresentationFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResidueRepresentationFormat rrf = residueRepresentationFormatArray[n2];
            if (rrf.getFormatName().equalsIgnoreCase(nameStr)) {
                return rrf;
            }
            ++n2;
        }
        return null;
    }
}

