/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Ringtype {
    PYRANOSE(6, "pyranose", "p", "p"),
    FURANOSE(5, "furanose", "f", "f"),
    OPEN(0, "open chain", "", "a"),
    UNKNOWN(-1, "unknown", "", "?");

    private int size;
    private String name;
    private String carbbankSymbol;
    private String bcsdbSymbol;

    private Ringtype(int rtSize, String rtName, String rtCarbbankSymbol, String rtBcsdbSymbol) {
        this.setSize(rtSize);
        this.setName(rtName);
        this.setCarbbankSymbol(rtCarbbankSymbol);
        this.setBcsdbSymbol(rtBcsdbSymbol);
    }

    public String getCarbbankSymbol() {
        return this.carbbankSymbol;
    }

    private void setCarbbankSymbol(String carbbankSymbol) {
        this.carbbankSymbol = carbbankSymbol;
    }

    public String getBcsdbSymbol() {
        return this.bcsdbSymbol;
    }

    public void setBcsdbSymbol(String bcsdbSymbol) {
        this.bcsdbSymbol = bcsdbSymbol;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    private void setSize(int size) {
        this.size = size;
    }

    public static Ringtype forSize(int size) {
        Ringtype[] ringtypeArray = Ringtype.values();
        int n = ringtypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ringtype r = ringtypeArray[n2];
            if (r.getSize() == size) {
                return r;
            }
            ++n2;
        }
        return null;
    }

    public static Ringtype forCarbbankSymbol(String sym2) {
        Ringtype[] ringtypeArray = Ringtype.values();
        int n = ringtypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ringtype r = ringtypeArray[n2];
            if (r.getCarbbankSymbol().equals(sym2)) {
                return r;
            }
            ++n2;
        }
        return null;
    }

    public static Ringtype forBcsdbSymbol(String sym2) {
        Ringtype[] ringtypeArray = Ringtype.values();
        int n = ringtypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ringtype r = ringtypeArray[n2];
            if (r.getBcsdbSymbol().equals(sym2)) {
                return r;
            }
            ++n2;
        }
        return null;
    }
}

