/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExporter;
import org.eurocarbdb.resourcesdb.io.StandardExporter;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.Ringtype;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.monosaccharide.SubstituentSubpartTreeNode;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.template.TrivialnameTemplate;
import org.eurocarbdb.resourcesdb.template.TrivialnameTemplateContainer;
import org.eurocarbdb.resourcesdb.util.Utils;

public class CfgExporter
extends StandardExporter
implements MonosaccharideExporter {
    public CfgExporter() {
        this((Config)null);
    }

    public CfgExporter(Config conf) {
        this(conf, null);
    }

    public CfgExporter(Config conf, TemplateContainer container) {
        super(GlycanNamescheme.CFG, conf, container);
    }

    public String export(Monosaccharide ms) throws ResourcesDbException {
        if (ms.getConfiguration() == null) {
            String stereo = ms.getStereoStrWithoutAnomeric();
            ms.setConfiguration(Stereocode.getConfigurationFromStereoString(stereo));
        }
        if (ms.getConfiguration().equals((Object)StereoConfiguration.Unknown)) {
            return null;
        }
        if (!ms.getRingtype().equals((Object)Ringtype.PYRANOSE) && !ms.getRingtype().equals((Object)Ringtype.FURANOSE)) {
            return null;
        }
        String nameStr = "";
        TrivialnameTemplateContainer container = this.getTemplateContainer().getTrivialnameTemplateContainer();
        TrivialnameTemplate cfgTemplate = container.checkMsForTrivialname(GlycanNamescheme.CFG, ms);
        if (cfgTemplate == null) {
            return null;
        }
        this.setUsedTrivialnameTemplate(cfgTemplate);
        nameStr = String.valueOf(nameStr) + cfgTemplate.getPrimaryName(this.getNamescheme());
        if (!ms.getConfiguration().equals((Object)cfgTemplate.getDefaultConfiguration())) {
            if (cfgTemplate.isDefaultConfigIsCompulsory()) {
                return null;
            }
            if (ms.getRingEnd() == cfgTemplate.getDefaultRingend()) {
                nameStr = String.valueOf(nameStr) + "'";
            }
        }
        if (ms.getRingStart() != cfgTemplate.getCarbonylPosition()) {
            return null;
        }
        if (ms.getRingEnd() != cfgTemplate.getDefaultRingend()) {
            nameStr = ms.getConfiguration().equals((Object)cfgTemplate.getDefaultConfiguration()) ? String.valueOf(nameStr) + "^" : String.valueOf(nameStr) + "~";
        }
        String substStr = "";
        for (Substitution subst : ms.getSubstitutions()) {
            if (cfgTemplate.hasSubstitution(subst)) continue;
            if (substStr.length() > 0) {
                substStr = String.valueOf(substStr) + ",";
            }
            try {
                substStr = String.valueOf(substStr) + this.formatSubstitution(subst, cfgTemplate);
            }
            catch (ResourcesDbException rEx) {
                return null;
            }
        }
        if (substStr.length() > 0) {
            nameStr = String.valueOf(nameStr) + "[" + substStr + "]";
        }
        nameStr = String.valueOf(nameStr) + ms.getAnomer().getCarbbankSymbol();
        return nameStr;
    }

    private String formatSubstitution(Substitution subst, TrivialnameTemplate cfgTemplate) throws ResourcesDbException {
        String outStr = "";
        outStr = String.valueOf(outStr) + Utils.formatPositionsString(subst.getPosition1(), "/", "?");
        if (subst.hasPosition2()) {
            outStr = String.valueOf(outStr) + "," + Utils.formatPositionsString(subst.getPosition2(), "/", "?");
        }
        SubstituentTemplate substTmpl = null;
        LinkageType linktype = null;
        for (Substitution cfgTmplSubst : cfgTemplate.getSubstitutions()) {
            if (!cfgTmplSubst.positionsEqual(subst)) continue;
            SubstituentSubpartTreeNode substRoot = subst.getTemplate().getSubparts();
            if (!cfgTmplSubst.getTemplate().getName().equals(substRoot.getSubstTmpl(this.getTemplateContainer().getSubstituentTemplateContainer()).getName()) || substRoot.getChildCount() != 1) continue;
            substTmpl = ((SubstituentSubpartTreeNode)substRoot.getFirstChild()).getSubstTmpl(this.getTemplateContainer().getSubstituentTemplateContainer());
            linktype = LinkageType.H_AT_OH;
        }
        if (substTmpl == null) {
            substTmpl = subst.getTemplate();
            linktype = subst.getLinkagetype1();
        }
        outStr = String.valueOf(outStr) + substTmpl.getPrimaryAlias(GlycanNamescheme.CFG, linktype).getResidueIncludedName();
        return outStr;
    }
}

