/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.glycoconjugate_derived;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbAnomer;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbBaseType;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbModification;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbModificationType;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbMonosaccharide;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbSuperclass;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException;
import org.eurocarbdb.resourcesdb.io.NameParsingException;

public class EcdbResidueParser {
    private char m_cToken = (char)32;
    private String m_strMS = "";
    private int m_iPosition = -1;
    private GlycanNamescheme namescheme;

    public EcdbResidueParser(GlycanNamescheme scheme) {
        this.setNamescheme(scheme);
    }

    public GlycanNamescheme getNamescheme() {
        return this.namescheme;
    }

    public void setNamescheme(GlycanNamescheme namescheme) {
        this.namescheme = namescheme;
    }

    private void nextToken() throws NameParsingException {
        ++this.m_iPosition;
        try {
            this.m_cToken = this.m_strMS.charAt(this.m_iPosition);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NameParsingException("COMMON000 (unexpected end of residue name) ", this.m_strMS, this.m_iPosition);
        }
    }

    private int number() throws NameParsingException {
        int t_iResult = 0;
        char t_iDigit = '\u0000';
        if (this.m_cToken == '0') {
            this.nextToken();
            return t_iResult;
        }
        t_iDigit = this.m_cToken;
        if (t_iDigit < '1' || t_iDigit > '9') {
            throw new NameParsingException("COMMON004 (number expected) ", this.m_strMS, this.m_iPosition);
        }
        t_iResult = t_iDigit - 48;
        this.nextToken();
        t_iDigit = this.m_cToken;
        while (t_iDigit > '/' && t_iDigit < ':') {
            t_iResult = t_iResult * 10 + (t_iDigit - 48);
            this.nextToken();
            t_iDigit = this.m_cToken;
        }
        return t_iResult;
    }

    /*
     * Unable to fully structure code
     */
    public EcdbMonosaccharide createEcdbResidue(String a_strMS) throws NameParsingException {
        this.m_iPosition = -1;
        this.m_strMS = String.valueOf(a_strMS) + " ";
        this.nextToken();
        try {
            t_objAnomer = EcdbAnomer.forName(this.m_cToken);
        }
        catch (GlycoconjugateException ge) {
            npe = new NameParsingException("Illegal anomeric value", this.m_strMS, this.m_iPosition);
            npe.initCause(ge);
            throw npe;
        }
        this.nextToken();
        if (this.m_cToken != '-') {
            throw new NameParsingException("GLYCOCTC007 (unexpected token: '" + this.m_cToken + "')", this.m_strMS, this.m_iPosition);
        }
        this.nextToken();
        t_iMaxPos = this.m_strMS.indexOf(":", this.m_iPosition) - 7;
        t_aConfiguration = new ArrayList<EcdbBaseType>();
        t_strInformation = "";
        while (this.m_iPosition < t_iMaxPos) {
            t_strInformation = "";
            t_iCounter = 0;
            while (t_iCounter < 4) {
                t_strInformation = String.valueOf(t_strInformation) + this.m_cToken;
                this.nextToken();
                ++t_iCounter;
            }
            try {
                t_aConfiguration.add(EcdbBaseType.forName(t_strInformation));
            }
            catch (Exception e) {
                throw new NameParsingException("GLYCOCTC008 ", this.m_strMS, this.m_iPosition);
            }
            if (this.m_cToken != '-') {
                throw new NameParsingException("GLYCOCTC007 (unexpected token: " + this.m_cToken + ") ", this.m_strMS, this.m_iPosition);
            }
            this.nextToken();
        }
        t_strInformation = "";
        t_iCounter = 0;
        while (t_iCounter < 3) {
            t_strInformation = String.valueOf(t_strInformation) + this.m_cToken;
            this.nextToken();
            ++t_iCounter;
        }
        try {
            t_objSuper = EcdbSuperclass.forName(t_strInformation.toLowerCase());
        }
        catch (Exception e) {
            throw new NameParsingException("GLYCOCTC009 ", this.m_strMS, this.m_iPosition);
        }
        try {
            t_objMS = new EcdbMonosaccharide(t_objAnomer, t_objSuper);
            t_objMS.setBaseType(t_aConfiguration);
        }
        catch (GlycoconjugateException ge) {
            npe = new NameParsingException("Internal error in setting monosaccharide");
            npe.initCause(ge);
            throw npe;
        }
        if (this.m_cToken != '-') {
            throw new NameParsingException("GLYCOCTC007 (unexpected token: " + this.m_cToken + ")", this.m_strMS, this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == 'x') {
            t_iRingStart = -1;
            this.nextToken();
        } else {
            t_iRingStart = this.number();
        }
        if (this.m_cToken != ':') {
            throw new NameParsingException("GLYCOCTC005 (unexpected token: " + this.m_cToken + ")", this.m_strMS, this.m_iPosition);
        }
        this.nextToken();
        try {
            block30: {
                if (this.m_cToken != 'x') break block30;
                t_objMS.setRing(t_iRingStart, -1);
                this.nextToken();
                ** GOTO lbl114
            }
            t_objMS.setRing(t_iRingStart, this.number());
            if (true) ** GOTO lbl114
        }
        catch (GlycoconjugateException ge) {
            npe = new NameParsingException("Illegal ring value", this.m_strMS, this.m_iPosition);
            npe.initCause(ge);
            throw npe;
        }
        do {
            t_iPosTwo = null;
            this.nextToken();
            if (this.m_cToken == 'x') {
                t_iPosOne = 0;
                this.nextToken();
            } else {
                t_iPosOne = this.number();
            }
            if (this.m_cToken == ',') {
                this.nextToken();
                t_iPosTwo = this.number();
            }
            if (this.m_cToken != ':') {
                throw new NameParsingException("GLYCOCTC005  (unexpected token: " + this.m_cToken + ")", this.m_strMS, this.m_iPosition);
            }
            this.nextToken();
            t_iStart = this.m_iPosition;
            this.modification_name();
            try {
                t_enumMod = EcdbModificationType.forName(this.m_strMS.substring(t_iStart, this.m_iPosition));
            }
            catch (Exception e) {
                throw new NameParsingException("GLYCOCTC010", this.m_strMS, this.m_iPosition);
            }
            try {
                t_objModi = new EcdbModification(t_enumMod, (Integer)t_iPosOne, t_iPosTwo);
                if (t_objModi.getModificationType().isMsdbOnly() && !GlycanNamescheme.MONOSACCHARIDEDB.equals((Object)this.getNamescheme())) {
                    throw new NameParsingException("Modification " + t_objModi.getName() + " is not valid in namescheme " + this.getNamescheme().getNameStr());
                }
                t_objMS.addModification(t_objModi);
            }
            catch (GlycoconjugateException ge) {
                npe = new NameParsingException("Error in setting modification", this.m_strMS, this.m_iPosition);
                npe.initCause(ge);
                throw npe;
            }
lbl114:
            // 3 sources

        } while (this.m_cToken == '|');
        if (this.m_iPosition != this.m_strMS.length() - 1) {
            System.out.println("position: " + this.m_iPosition + " length: " + this.m_strMS.length());
            throw new NameParsingException("GLYCOCTC005  (unexpected token: " + this.m_cToken + ")", this.m_strMS, this.m_iPosition);
        }
        return t_objMS;
    }

    private void modification_name() throws NameParsingException {
        boolean t_bNext = true;
        while (t_bNext) {
            t_bNext = false;
            if (this.m_cToken >= 'A' && this.m_cToken <= 'Z') {
                this.nextToken();
                t_bNext = true;
                continue;
            }
            if (this.m_cToken < 'a' || this.m_cToken > 'z') continue;
            this.nextToken();
            t_bNext = true;
        }
    }
}

