/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;

public class TextUtils {
    private TextUtils() {
    }

    public static boolean isInteger(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPositiveInteger(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        try {
            return Integer.parseInt(text) >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String consume(InputStream is) {
        try {
            int read;
            BufferedInputStream bis = new BufferedInputStream(is);
            StringBuilder str = new StringBuilder();
            while ((read = bis.read()) != -1) {
                str.append((char)read);
            }
            return str.toString();
        }
        catch (Exception e) {
            LogUtils.report(e);
            return "";
        }
    }

    public static String invert(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = str.length() - 1; i >= 0; --i) {
            ret.append(str.charAt(i));
        }
        return ret.toString();
    }

    public static String delete(String str, char c) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == c) continue;
            ret.append(str.charAt(i));
        }
        return ret.toString();
    }

    public static String squeeze(String str, char c) {
        int end;
        int start;
        if (str == null || str.length() == 0) {
            return str;
        }
        for (start = 0; start < str.length() && str.charAt(start) == c; ++start) {
        }
        if (start == str.length()) {
            return "";
        }
        for (end = str.length(); end > 0 && str.charAt(end - 1) == c; --end) {
        }
        return str.substring(start, end);
    }

    public static String squeezeAll(String str, char c) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder ret = new StringBuilder();
        char last_char = '\u0000';
        for (int i = 0; i < str.length(); ++i) {
            if (i == 0 || str.charAt(i) != c || str.charAt(i) != last_char) {
                ret.append(str.charAt(i));
            }
            last_char = str.charAt(i);
        }
        return ret.toString();
    }

    public static String trim(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        str = TextUtils.squeeze(str, ' ');
        str = TextUtils.squeeze(str, '\t');
        str = TextUtils.squeeze(str, '\n');
        str = TextUtils.squeeze(str, '\r');
        return str;
    }

    public static LinkedList<String> tokenize(String str, String delims) {
        LinkedList<String> out = new LinkedList<String>();
        if (str == null || str.length() == 0 || delims == null || delims.length() == 0) {
            return out;
        }
        StringBuilder token = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (delims.indexOf(str.charAt(i)) != -1) {
                if (token.length() <= 0) continue;
                out.addLast(token.toString());
                token = new StringBuilder(str.length());
                continue;
            }
            token.append(str.charAt(i));
        }
        if (token.length() > 0) {
            out.addLast(token.toString());
        }
        return out;
    }

    public static Vector<String> tokenize(String str, String delims, char open_par, char closed_par) {
        Vector<String> out = new Vector<String>();
        if (str == null || str.length() == 0 || delims == null || delims.length() == 0) {
            return out;
        }
        StringBuilder token = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == open_par) {
                token.append(str.charAt(i));
                ++i;
                while (i < str.length() && str.charAt(i) != closed_par) {
                    token.append(str.charAt(i));
                    ++i;
                }
                if (i >= str.length()) continue;
                token.append(str.charAt(i));
                continue;
            }
            if (delims.indexOf(str.charAt(i)) != -1) {
                if (token.length() <= 0) continue;
                out.addElement(token.toString());
                token = new StringBuilder(str.length());
                continue;
            }
            token.append(str.charAt(i));
        }
        if (token.length() > 0) {
            out.addElement(token.toString());
        }
        return out;
    }

    public static Vector<String> splitLines(String str) {
        Vector<String> v = new Vector<String>();
        if (str == null || str.length() == 0) {
            return v;
        }
        BufferedReader br = new BufferedReader(new StringReader(str));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                v.addElement(line);
            }
        }
        catch (IOException ex) {
            LogUtils.report(ex);
        }
        return v;
    }

    public static int findEnclosed(String str) {
        return TextUtils.findEnclosed(str, 0, '(', ')');
    }

    public static int findEnclosed(String str, int start, char open_par, char closed_par) {
        if (str == null || str.length() == 0) {
            return -1;
        }
        if (str.charAt(start) != open_par) {
            return -1;
        }
        return TextUtils.findClosedParenthesis(str, start + 1, open_par, closed_par);
    }

    public static int findClosedParenthesis(String str) {
        return TextUtils.findClosedParenthesis(str, 0, '(', ')');
    }

    public static int findClosedParenthesis(String str, int start_from) {
        return TextUtils.findClosedParenthesis(str, start_from, '(', ')');
    }

    public static int findClosedParenthesis(String str, int start_from, char open_par, char closed_par) {
        if (str == null || str.length() == 0) {
            return -1;
        }
        int nopen = 0;
        for (int i = start_from; i < str.length(); ++i) {
            if (str.charAt(i) == closed_par) {
                if (nopen == 0) {
                    return i;
                }
                --nopen;
                continue;
            }
            if (str.charAt(i) != open_par) continue;
            ++nopen;
        }
        return -1;
    }

    public static int findEnclosedInvert(String str, int start, char open_par, char closed_par) throws Exception {
        if (str == null || str.length() == 0) {
            return -1;
        }
        if (str.charAt(start) != closed_par) {
            return -1;
        }
        return TextUtils.findClosedParenthesisInvert(str, start - 1, open_par, closed_par);
    }

    public static int findClosedParenthesisInvert(String str, int start_from, char open_par, char closed_par) {
        if (str == null || str.length() == 0) {
            return -1;
        }
        int nopen = 0;
        for (int i = start_from; i >= 0; --i) {
            if (str.charAt(i) == open_par) {
                if (nopen == 0) {
                    return i;
                }
                --nopen;
                continue;
            }
            if (str.charAt(i) != closed_par) continue;
            ++nopen;
        }
        return -1;
    }

    public static String removeTrailingParentheses(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        String ret = str;
        try {
            while (ret.startsWith("(") && ret.endsWith(")") && TextUtils.findClosedParenthesis(ret, 1) == ret.length() - 1) {
                ret = ret.substring(1, ret.length() - 1);
            }
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
        return ret;
    }

    public static int findFirstOf(String str, String chars) {
        if (str == null || str.length() == 0 || chars == null || chars.length() == 0) {
            return -1;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (chars.indexOf(str.charAt(i)) == -1) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstOfWithParentheses(String str, String chars) throws Exception {
        if (str == null || str.length() == 0 || chars == null || chars.length() == 0) {
            return -1;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '(' && (i = TextUtils.findClosedParenthesis(str, i + 1)) == -1) {
                throw new Exception("Unmatched parenthesis in : " + str);
            }
            if (chars.indexOf(str.charAt(i)) == -1) continue;
            return i;
        }
        return -1;
    }

    public static String toString(int[] v, char delim) {
        if (v == null) {
            return "";
        }
        StringBuilder strbuf = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            if (i > 0) {
                strbuf.append(delim);
            }
            strbuf.append(v[i]);
        }
        return strbuf.toString();
    }

    public static String toString(Object[] v, char delim) {
        if (v == null) {
            return "";
        }
        StringBuilder strbuf = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            if (i > 0) {
                strbuf.append(delim);
            }
            strbuf.append(v[i].toString());
        }
        return strbuf.toString();
    }

    public static String toString(Collection<? extends Object> v, char delim) {
        if (v == null) {
            return "";
        }
        StringBuilder strbuf = new StringBuilder();
        for (Object object : v) {
            if (strbuf.length() > 0) {
                strbuf.append(delim);
            }
            strbuf.append(object.toString());
        }
        return strbuf.toString();
    }

    public static String toGreek(char c) {
        StringBuilder txt = new StringBuilder();
        if (Character.isLetter(c)) {
            txt.appendCodePoint(945 + c - 97);
        } else {
            txt.append(c);
        }
        return txt.toString();
    }
}

