/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.util;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.renderutil.ResAngle;

public class GraphicOptions {
    public String NOTATION = "snfg";
    public static final String NOTATION_CFG = "cfg";
    public static final String NOTATION_CFGBW = "cfgbw";
    public static final String NOTATION_CFGLINK = "cfglink";
    public static final String NOTATION_UOXF = "uoxf";
    public static final String NOTATION_TEXT = "text";
    public static final String NOTATION_UOXFCOL = "uoxfcol";
    public static final String NOTATION_SNFG = "snfg";
    public String THEME = "org.pushingpixels.substance.api.skin.OfficeBlue2007Skin";
    public String DISPLAY = "compact";
    public static final String DISPLAY_CUSTOM = "custom";
    public static final String DISPLAY_COMPACT = "compact";
    public static final String DISPLAY_NORMAL = "normal";
    public static final String DISPLAY_NORMALINFO = "normalinfo";
    public int ORIENTATION = 0;
    public static final int RL = 0;
    public static final int BT = 1;
    public static final int LR = 2;
    public static final int TB = 3;
    public double SCALE_CANVAS = 1.0;
    public boolean COLLAPSE_MULTIPLE_ANTENNAE = true;
    public boolean SHOW_MASSES_CANVAS = true;
    public boolean SHOW_REDEND_CANVAS = true;
    public boolean SHOW_MASSES = false;
    public boolean SHOW_REDEND = false;
    public boolean SHOW_INFO = true;
    public int MARGIN_LEFT = 30;
    public int MARGIN_TOP = 30;
    public int MARGIN_RIGHT = 30;
    public int MARGIN_BOTTOM = 30;
    public int NODE_SIZE = 22;
    public int NODE_FONT_SIZE = 14;
    public String NODE_FONT_FACE = "SansSerif.plain";
    public int COMPOSITION_FONT_SIZE = 18;
    public String COMPOSITION_FONT_FACE = "SansSerif.plain";
    public int LINKAGE_INFO_SIZE = 12;
    public String LINKAGE_INFO_FONT_FACE = "Serif.plain";
    public int NODE_SPACE = 30;
    public int NODE_SUB_SPACE = 1;
    public int STRUCTURES_SPACE = 40;
    public int MASS_TEXT_SPACE = 15;
    public int MASS_TEXT_SIZE = 14;
    public String MASS_TEXT_FONT_FACE = "SansSerif.plain";
    public double SCALE = 1.0;
    public int MARGIN_LEFT_CUSTOM = 30;
    public int MARGIN_TOP_CUSTOM = 30;
    public int MARGIN_RIGHT_CUSTOM = 30;
    public int MARGIN_BOTTOM_CUSTOM = 30;
    public boolean SHOW_INFO_CUSTOM = true;
    public int NODE_SIZE_CUSTOM = 22;
    public int NODE_FONT_SIZE_CUSTOM = 14;
    public String NODE_FONT_FACE_CUSTOM = "SansSerif.plain";
    public int COMPOSITION_FONT_SIZE_CUSTOM = 18;
    public String COMPOSITION_FONT_FACE_CUSTOM = "SansSerif.plain";
    public int LINKAGE_INFO_SIZE_CUSTOM = 12;
    public String LINKAGE_INFO_FONT_FACE_CUSTOM = "Serif.plain";
    public int NODE_SPACE_CUSTOM = 30;
    public int NODE_SUB_SPACE_CUSTOM = 1;
    public int STRUCTURES_SPACE_CUSTOM = 40;
    public int MASS_TEXT_SPACE_CUSTOM = 15;
    public int MASS_TEXT_SIZE_CUSTOM = 14;
    public String MASS_TEXT_FONT_FACE_CUSTOM = "SansSerif.plain";
    private static final int MARGIN_LEFT_DEFAULT = 30;
    private static final int MARGIN_TOP_DEFAULT = 30;
    private static final int MARGIN_RIGHT_DEFAULT = 30;
    private static final int MARGIN_BOTTOM_DEFAULT = 30;
    private static final int NODE_SIZE_DEFAULT = 22;
    private static final int NODE_FONT_SIZE_DEFAULT = 14;
    private static final String NODE_FONT_FACE_DEFAULT = "SansSerif.plain";
    private static final int COMPOSITION_FONT_SIZE_DEFAULT = 18;
    private static final String COMPOSITION_FONT_FACE_DEFAULT = "SansSerif.plain";
    private static final int LINKAGE_INFO_SIZE_DEFAULT = 12;
    private static final String LINKAGE_INFO_FONT_FACE_DEFAULT = "Serif.plain";
    private static final int NODE_SPACE_DEFAULT = 30;
    private static final int NODE_SUB_SPACE_DEFAULT = 1;
    private static final int MASS_TEXT_SPACE_DEFAULT = 15;
    private static final int MASS_TEXT_SIZE_DEFAULT = 14;
    private static final String MASS_TEXT_FONT_FACE_DEFAULT = "SansSerif.plain";
    private static final int STRUCTURES_SPACE_DEFAULT = 40;
    public static final int ICON_SIZE_MEDIUM = 26;
    public static final int ICON_SIZE_SMALL = 26;
    private static final boolean SAVE_SPECTRA_DEFAULT = false;
    private boolean SAVE_SPECTRA = false;
    public boolean SAVE_SPECTRA_CUSTOM = false;

    public GraphicOptions() {
    }

    public GraphicOptions(GraphicOptions other) {
        if (other != null) {
            this.copy(other);
        }
    }

    public GraphicOptions(String display) {
        this.SCALE = 1.0;
        this.setDisplay(display);
    }

    public static Vector<String> getAllFontFaces() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Vector<String> ret = new Vector<String>();
        Font[] all_fonts = ge.getAllFonts();
        for (int i = 0; i < all_fonts.length; ++i) {
            ret.add(all_fonts[i].getFontName());
        }
        return ret;
    }

    public void initCustomDisplay(String display) {
        this.MARGIN_LEFT_CUSTOM = 30;
        this.MARGIN_TOP_CUSTOM = 30;
        this.MARGIN_RIGHT_CUSTOM = 30;
        this.MARGIN_BOTTOM_CUSTOM = 30;
        this.NODE_SIZE_CUSTOM = 22;
        this.NODE_FONT_SIZE_CUSTOM = 14;
        this.NODE_FONT_FACE_CUSTOM = "SansSerif.plain";
        this.COMPOSITION_FONT_SIZE_CUSTOM = 18;
        this.COMPOSITION_FONT_FACE_CUSTOM = "SansSerif.plain";
        this.LINKAGE_INFO_SIZE_CUSTOM = 12;
        this.LINKAGE_INFO_FONT_FACE_CUSTOM = LINKAGE_INFO_FONT_FACE_DEFAULT;
        this.NODE_SUB_SPACE_CUSTOM = 1;
        this.STRUCTURES_SPACE_CUSTOM = 40;
        this.MASS_TEXT_SPACE_CUSTOM = 15;
        this.MASS_TEXT_SIZE_CUSTOM = 14;
        this.MASS_TEXT_FONT_FACE_CUSTOM = "SansSerif.plain";
        if (display.equals(DISPLAY_COMPACT)) {
            this.NODE_SPACE_CUSTOM = (int)(30.0 * this.SCALE / 2.0);
            this.SHOW_INFO_CUSTOM = false;
        } else if (display.equals(DISPLAY_NORMAL)) {
            this.NODE_SPACE_CUSTOM = (int)(30.0 * this.SCALE);
            this.SHOW_INFO_CUSTOM = false;
        } else {
            this.NODE_SPACE_CUSTOM = (int)(30.0 * this.SCALE);
            this.SHOW_INFO_CUSTOM = this.SCALE >= 1.0;
        }
        this.SAVE_SPECTRA_CUSTOM = false;
    }

    public void setDisplay(String display) {
        if (!display.equals(DISPLAY_CUSTOM)) {
            this.MARGIN_LEFT = (int)(30.0 * this.SCALE);
            this.MARGIN_TOP = (int)(30.0 * this.SCALE);
            this.MARGIN_RIGHT = (int)(30.0 * this.SCALE);
            this.MARGIN_BOTTOM = (int)(30.0 * this.SCALE);
            this.NODE_SIZE = (int)(22.0 * this.SCALE);
            this.NODE_FONT_SIZE = Math.max(10, (int)(14.0 * this.SCALE));
            this.NODE_FONT_FACE = "SansSerif.plain";
            this.COMPOSITION_FONT_SIZE = Math.max(14, (int)(18.0 * this.SCALE));
            this.COMPOSITION_FONT_FACE = "SansSerif.plain";
            this.LINKAGE_INFO_SIZE = Math.max(8, (int)(12.0 * this.SCALE));
            this.LINKAGE_INFO_FONT_FACE = LINKAGE_INFO_FONT_FACE_DEFAULT;
            this.NODE_SUB_SPACE = (int)(1.0 * this.SCALE);
            this.STRUCTURES_SPACE = (int)(40.0 * this.SCALE);
            this.MASS_TEXT_SPACE = (int)(15.0 * this.SCALE);
            this.MASS_TEXT_SIZE = Math.max(10, (int)(14.0 * this.SCALE));
            this.MASS_TEXT_FONT_FACE = "SansSerif.plain";
            if (display.equals(DISPLAY_NORMAL)) {
                this.NODE_SPACE = (int)(30.0 * this.SCALE);
                this.SHOW_INFO = false;
                this.DISPLAY = DISPLAY_NORMAL;
            } else {
                this.NODE_SPACE = (int)(30.0 * this.SCALE / 2.0);
                this.SHOW_INFO = false;
                this.DISPLAY = DISPLAY_COMPACT;
            }
            this.SAVE_SPECTRA = false;
        } else {
            this.MARGIN_LEFT = (int)((double)this.MARGIN_LEFT_CUSTOM * this.SCALE);
            this.MARGIN_TOP = (int)((double)this.MARGIN_TOP_CUSTOM * this.SCALE);
            this.MARGIN_RIGHT = (int)((double)this.MARGIN_RIGHT_CUSTOM * this.SCALE);
            this.MARGIN_BOTTOM = (int)((double)this.MARGIN_BOTTOM_CUSTOM * this.SCALE);
            this.SHOW_INFO = this.SHOW_INFO_CUSTOM && this.SCALE >= 1.0;
            this.NODE_SIZE = (int)((double)this.NODE_SIZE_CUSTOM * this.SCALE);
            this.NODE_FONT_SIZE = Math.max(10, (int)((double)this.NODE_FONT_SIZE_CUSTOM * this.SCALE));
            this.NODE_FONT_FACE = this.NODE_FONT_FACE_CUSTOM;
            this.COMPOSITION_FONT_SIZE = Math.max(14, (int)((double)this.COMPOSITION_FONT_SIZE_CUSTOM * this.SCALE));
            this.COMPOSITION_FONT_FACE = this.COMPOSITION_FONT_FACE_CUSTOM;
            this.LINKAGE_INFO_SIZE = Math.max(8, (int)((double)this.LINKAGE_INFO_SIZE_CUSTOM * this.SCALE));
            this.LINKAGE_INFO_FONT_FACE = this.LINKAGE_INFO_FONT_FACE_CUSTOM;
            this.NODE_SPACE = (int)((double)this.NODE_SPACE_CUSTOM * this.SCALE);
            this.NODE_SUB_SPACE = (int)((double)this.NODE_SUB_SPACE_CUSTOM * this.SCALE);
            this.STRUCTURES_SPACE = (int)((double)this.STRUCTURES_SPACE_CUSTOM * this.SCALE);
            this.MASS_TEXT_SPACE = (int)((double)this.MASS_TEXT_SPACE_CUSTOM * this.SCALE);
            this.MASS_TEXT_SIZE = Math.max(10, (int)((double)this.MASS_TEXT_SIZE_CUSTOM * this.SCALE));
            this.MASS_TEXT_FONT_FACE = this.MASS_TEXT_FONT_FACE_CUSTOM;
            this.DISPLAY = DISPLAY_CUSTOM;
            this.SAVE_SPECTRA = this.SAVE_SPECTRA_CUSTOM;
        }
    }

    public ResAngle getOrientationAngle() {
        return GraphicOptions.getOrientationAngle(this.ORIENTATION);
    }

    public static ResAngle getOrientationAngle(int orientation) {
        if (orientation == 2) {
            return new ResAngle(0);
        }
        if (orientation == 0) {
            return new ResAngle(180);
        }
        if (orientation == 1) {
            return new ResAngle(-90);
        }
        if (orientation == 3) {
            return new ResAngle(90);
        }
        return new ResAngle(0);
    }

    public double setScale(double scale) {
        this.SCALE = !this.DISPLAY.equals(DISPLAY_CUSTOM) ? ((int)(22.0 * scale) % 2 == 1 ? (double)((int)(22.0 * scale) + 1) / 22.0 : scale) : ((int)((double)this.NODE_SIZE_CUSTOM * scale) % 2 == 1 ? (double)((int)((double)this.NODE_SIZE_CUSTOM * scale) + 1) / (double)this.NODE_SIZE_CUSTOM : scale);
        this.setDisplay(this.DISPLAY);
        return this.SCALE;
    }

    public void store(Configuration config) {
        config.put("GraphicOptions", "notation", this.NOTATION);
        config.put("GraphicOptions", "display", this.DISPLAY);
        config.put("GraphicOptions", "orientation", this.ORIENTATION);
        config.put("GraphicOptions", "show_info", this.SHOW_INFO);
        config.put("GraphicOptions", "scale_canvas", this.SCALE_CANVAS);
        config.put("GraphicOptions", "collapse_multiple_antennae", this.COLLAPSE_MULTIPLE_ANTENNAE);
        config.put("GraphicOptions", "show_masses_canvas", this.SHOW_MASSES_CANVAS);
        config.put("GraphicOptions", "show_masses", this.SHOW_MASSES);
        config.put("GraphicOptions", "show_redend", this.SHOW_REDEND);
        config.put("GraphicOptions", "show_info_custom", this.SHOW_INFO_CUSTOM);
        config.put("GraphicOptions", "node_size_custom", this.NODE_SIZE_CUSTOM);
        config.put("GraphicOptions", "node_font_size_custom", this.NODE_FONT_SIZE_CUSTOM);
        config.put("GraphicOptions", "node_font_face_custom", this.NODE_FONT_FACE_CUSTOM);
        config.put("GraphicOptions", "composition_font_size_custom", this.COMPOSITION_FONT_SIZE_CUSTOM);
        config.put("GraphicOptions", "composition_font_face_custom", this.COMPOSITION_FONT_FACE_CUSTOM);
        config.put("GraphicOptions", "linkage_info_size_custom", this.LINKAGE_INFO_SIZE_CUSTOM);
        config.put("GraphicOptions", "linkage_info_font_face_custom", this.LINKAGE_INFO_FONT_FACE_CUSTOM);
        config.put("GraphicOptions", "node_space_custom", this.NODE_SPACE_CUSTOM);
        config.put("GraphicOptions", "node_sub_space_custom", this.NODE_SUB_SPACE_CUSTOM);
        config.put("GraphicOptions", "structures_space_custom", this.STRUCTURES_SPACE_CUSTOM);
        config.put("GraphicOptions", "mass_text_space_custom", this.MASS_TEXT_SPACE_CUSTOM);
        config.put("GraphicOptions", "mass_text_size_custom", this.MASS_TEXT_SIZE_CUSTOM);
        config.put("GraphicOptions", "mass_text_font_face_custom", this.MASS_TEXT_FONT_FACE_CUSTOM);
        config.put("GraphicOptions", "theme", this.THEME);
        config.put("GraphicOptions", "save_spectra", this.SAVE_SPECTRA_CUSTOM);
    }

    public void retrieve(Configuration config) {
        this.NOTATION = config.get("GraphicOptions", "notation", this.NOTATION);
        this.DISPLAY = config.get("GraphicOptions", "display", this.DISPLAY);
        this.ORIENTATION = config.get("GraphicOptions", "orientation", this.ORIENTATION);
        this.SHOW_INFO = config.get("GraphicOptions", "show_info", this.SHOW_INFO);
        this.SCALE_CANVAS = config.get("GraphicOptions", "scale_canvas", this.SCALE_CANVAS);
        this.COLLAPSE_MULTIPLE_ANTENNAE = config.get("GraphicOptions", "collapse_multiple_antennae", this.COLLAPSE_MULTIPLE_ANTENNAE);
        this.SHOW_MASSES_CANVAS = config.get("GraphicOptions", "show_masses_canvas", this.SHOW_MASSES_CANVAS);
        this.SHOW_MASSES = config.get("GraphicOptions", "show_masses", this.SHOW_MASSES);
        this.SHOW_REDEND = config.get("GraphicOptions", "show_redend", this.SHOW_REDEND);
        this.SHOW_INFO_CUSTOM = config.get("GraphicOptions", "show_info_custom", this.SHOW_INFO_CUSTOM);
        this.NODE_SIZE_CUSTOM = config.get("GraphicOptions", "node_size_custom", this.NODE_SIZE_CUSTOM);
        this.NODE_FONT_SIZE_CUSTOM = config.get("GraphicOptions", "node_font_size_custom", this.NODE_FONT_SIZE_CUSTOM);
        this.NODE_FONT_FACE_CUSTOM = config.get("GraphicOptions", "node_font_face_custom", this.NODE_FONT_FACE_CUSTOM);
        this.COMPOSITION_FONT_SIZE_CUSTOM = config.get("GraphicOptions", "composition_font_size_custom", this.COMPOSITION_FONT_SIZE_CUSTOM);
        this.COMPOSITION_FONT_FACE_CUSTOM = config.get("GraphicOptions", "composition_font_face_custom", this.COMPOSITION_FONT_FACE_CUSTOM);
        this.LINKAGE_INFO_SIZE_CUSTOM = config.get("GraphicOptions", "linkage_info_size_custom", this.LINKAGE_INFO_SIZE_CUSTOM);
        this.LINKAGE_INFO_FONT_FACE_CUSTOM = config.get("GraphicOptions", "linkage_info_font_face_custom", this.LINKAGE_INFO_FONT_FACE_CUSTOM);
        this.NODE_SPACE_CUSTOM = config.get("GraphicOptions", "node_space_custom", this.NODE_SPACE_CUSTOM);
        this.NODE_SUB_SPACE_CUSTOM = config.get("GraphicOptions", "node_sub_space_custom", this.NODE_SUB_SPACE_CUSTOM);
        this.STRUCTURES_SPACE_CUSTOM = config.get("GraphicOptions", "structures_space_custom", this.STRUCTURES_SPACE_CUSTOM);
        this.MASS_TEXT_SPACE_CUSTOM = config.get("GraphicOptions", "mass_text_space_custom", this.MASS_TEXT_SPACE_CUSTOM);
        this.MASS_TEXT_SIZE_CUSTOM = config.get("GraphicOptions", "mass_text_size_custom", this.MASS_TEXT_SIZE_CUSTOM);
        this.MASS_TEXT_FONT_FACE_CUSTOM = config.get("GraphicOptions", "mass_text_font_face_custom", this.MASS_TEXT_FONT_FACE_CUSTOM);
        this.THEME = config.get("GraphicOptions", "theme", this.THEME);
        this.SAVE_SPECTRA_CUSTOM = config.get("GraphicOptions", "save_spectra", true);
    }

    public GraphicOptions clone() {
        GraphicOptions ret = new GraphicOptions();
        ret.copy(this);
        return ret;
    }

    public void copy(GraphicOptions other) {
        this.NOTATION = other.NOTATION;
        this.DISPLAY = other.DISPLAY;
        this.ORIENTATION = other.ORIENTATION;
        this.SCALE_CANVAS = other.SCALE_CANVAS;
        this.COLLAPSE_MULTIPLE_ANTENNAE = other.COLLAPSE_MULTIPLE_ANTENNAE;
        this.SHOW_MASSES_CANVAS = other.SHOW_MASSES_CANVAS;
        this.SHOW_MASSES = other.SHOW_MASSES;
        this.SHOW_REDEND = other.SHOW_REDEND;
        this.SHOW_INFO = other.SHOW_INFO;
        this.MARGIN_LEFT = other.MARGIN_LEFT;
        this.MARGIN_TOP = other.MARGIN_TOP;
        this.MARGIN_RIGHT = other.MARGIN_RIGHT;
        this.MARGIN_BOTTOM = other.MARGIN_BOTTOM;
        this.NODE_SIZE = other.NODE_SIZE;
        this.NODE_FONT_SIZE = other.NODE_FONT_SIZE;
        this.NODE_FONT_FACE = other.NODE_FONT_FACE;
        this.COMPOSITION_FONT_SIZE = other.COMPOSITION_FONT_SIZE;
        this.COMPOSITION_FONT_FACE = other.COMPOSITION_FONT_FACE;
        this.LINKAGE_INFO_SIZE = other.LINKAGE_INFO_SIZE;
        this.LINKAGE_INFO_FONT_FACE = other.LINKAGE_INFO_FONT_FACE;
        this.NODE_SPACE = other.NODE_SPACE;
        this.NODE_SUB_SPACE = other.NODE_SUB_SPACE;
        this.STRUCTURES_SPACE = other.STRUCTURES_SPACE;
        this.MASS_TEXT_SPACE = other.MASS_TEXT_SPACE;
        this.MASS_TEXT_SIZE = other.MASS_TEXT_SIZE;
        this.MASS_TEXT_FONT_FACE = other.MASS_TEXT_FONT_FACE;
        this.SHOW_INFO_CUSTOM = other.SHOW_INFO_CUSTOM;
        this.NODE_SIZE_CUSTOM = other.NODE_SIZE_CUSTOM;
        this.NODE_FONT_SIZE_CUSTOM = other.NODE_FONT_SIZE_CUSTOM;
        this.NODE_FONT_FACE_CUSTOM = other.NODE_FONT_FACE_CUSTOM;
        this.COMPOSITION_FONT_SIZE_CUSTOM = other.COMPOSITION_FONT_SIZE_CUSTOM;
        this.COMPOSITION_FONT_FACE_CUSTOM = other.COMPOSITION_FONT_FACE_CUSTOM;
        this.LINKAGE_INFO_SIZE_CUSTOM = other.LINKAGE_INFO_SIZE_CUSTOM;
        this.LINKAGE_INFO_FONT_FACE_CUSTOM = other.LINKAGE_INFO_FONT_FACE_CUSTOM;
        this.NODE_SPACE_CUSTOM = other.NODE_SPACE_CUSTOM;
        this.NODE_SUB_SPACE_CUSTOM = other.NODE_SUB_SPACE_CUSTOM;
        this.STRUCTURES_SPACE_CUSTOM = other.STRUCTURES_SPACE_CUSTOM;
        this.MASS_TEXT_SPACE_CUSTOM = other.MASS_TEXT_SPACE_CUSTOM;
        this.MASS_TEXT_SIZE_CUSTOM = other.MASS_TEXT_SIZE_CUSTOM;
        this.MASS_TEXT_FONT_FACE_CUSTOM = other.MASS_TEXT_FONT_FACE_CUSTOM;
        this.SCALE = other.SCALE;
        this.THEME = other.THEME;
        this.SAVE_SPECTRA_CUSTOM = other.SAVE_SPECTRA_CUSTOM;
    }
}

