/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.renderutil;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.renderutil.ResAngle;

public class PositionManager {
    protected static final ResAngle[] static_positions = new ResAngle[5];
    protected HashMap<Residue, ResAngle> orientations = new HashMap();
    protected HashMap<Residue, ResAngle> rotations = new HashMap();
    protected HashMap<Residue, ResAngle> relative_positions = new HashMap();
    protected HashMap<Residue, ResAngle> absolute_positions = new HashMap();
    protected HashMap<Residue, Boolean> onborder_flags = new HashMap();
    protected HashMap<Residue, Boolean> sticky_flags = new HashMap();

    public void reset() {
        this.orientations.clear();
        this.rotations.clear();
        this.relative_positions.clear();
        this.absolute_positions.clear();
        this.onborder_flags.clear();
        this.sticky_flags.clear();
    }

    public void add(Residue node, ResAngle parent_orientation, ResAngle relative_position, boolean on_border, boolean sticky) {
        if (node != null) {
            ResAngle absolute_position = parent_orientation.combine(relative_position);
            ResAngle rotation = sticky ? relative_position : new ResAngle();
            ResAngle orientation = parent_orientation;
            if (sticky && !relative_position.equals(-45) && !relative_position.equals(45) && !on_border) {
                orientation = absolute_position;
            }
            this.orientations.put(node, orientation);
            this.rotations.put(node, rotation);
            this.relative_positions.put(node, relative_position);
            this.absolute_positions.put(node, absolute_position);
            this.onborder_flags.put(node, on_border);
            this.sticky_flags.put(node, sticky);
        }
    }

    public ResAngle getOrientation(Residue node) {
        return this.orientations.get(node);
    }

    public ResAngle getRotation(Residue node) {
        return this.rotations.get(node);
    }

    public ResAngle getRelativePosition(Residue node) {
        return this.relative_positions.get(node);
    }

    public ResAngle getAbsolutePosition(Residue node) {
        return this.absolute_positions.get(node);
    }

    public boolean isOnBorder(Residue node) {
        Boolean b = this.onborder_flags.get(node);
        if (b == null) {
            return false;
        }
        return b;
    }

    public boolean isSticky(Residue node) {
        Boolean b = this.sticky_flags.get(node);
        if (b == null) {
            return false;
        }
        return b;
    }

    public static ResAngle[] getPossiblePositions() {
        return static_positions;
    }

    public ResAngle[] getAvailablePositions(Residue current, ResAngle orientation) {
        ResAngle[] positions = PositionManager.getPossiblePositions();
        if (current == null) {
            return positions;
        }
        Residue parent = current.getParent();
        if (parent == null) {
            return positions;
        }
        ResAngle cur_abs_pos = this.getAbsolutePosition(current);
        if (cur_abs_pos == null) {
            return positions;
        }
        Vector<ResAngle> vec_available_positions = new Vector<ResAngle>();
        for (int i = 0; i < positions.length; ++i) {
            ResAngle pos = positions[i];
            ResAngle abs_pos = orientation.combine(pos);
            if (cur_abs_pos.isOpposite(abs_pos)) continue;
            vec_available_positions.add(pos);
        }
        Object[] available_positions = new ResAngle[vec_available_positions.size()];
        vec_available_positions.copyInto(available_positions);
        return available_positions;
    }

    public LinkedList<Residue> getChildrenAtPosition(Residue parent, ResAngle position) {
        LinkedList<Residue> nodes = new LinkedList<Residue>();
        Iterator<Linkage> i = parent.iterator();
        while (i.hasNext()) {
            Residue child = i.next().getChildResidue();
            if (!this.getRelativePosition(child).equals(position)) continue;
            nodes.add(child);
        }
        return nodes;
    }

    public LinkedList<Residue> getChildrenAtPosition(Residue parent, ResAngle position, boolean on_border) {
        LinkedList<Residue> nodes = new LinkedList<Residue>();
        Iterator<Linkage> i = parent.iterator();
        while (i.hasNext()) {
            Residue child = i.next().getChildResidue();
            if (!this.getRelativePosition(child).equals(position) || this.isOnBorder(child) != on_border) continue;
            nodes.add(child);
        }
        return nodes;
    }

    static {
        try {
            PositionManager.static_positions[0] = new ResAngle(-90);
            PositionManager.static_positions[1] = new ResAngle(-45);
            PositionManager.static_positions[2] = new ResAngle(0);
            PositionManager.static_positions[3] = new ResAngle(45);
            PositionManager.static_positions[4] = new ResAngle(90);
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }
}

