/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.dataset;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.CrossRingFragmentType;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class CrossRingFragmentDictionary {
    private static Vector<CrossRingFragmentType> dictionary = new Vector();

    private CrossRingFragmentDictionary() {
    }

    public static void loadDictionary(String filename) {
        dictionary.clear();
        try {
            String line;
            BufferedReader is;
            if (filename.startsWith("http")) {
                URLConnection conn = new URL(filename).openConnection();
                is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            } else {
                URL file_url = ResidueDictionary.class.getResource(filename);
                if (file_url == null) {
                    File file = new File(filename);
                    if (!file.exists()) {
                        throw new FileNotFoundException(filename);
                    }
                    is = new BufferedReader(new FileReader(file));
                } else {
                    is = new BufferedReader(new InputStreamReader(file_url.openStream()));
                }
            }
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim(line)).length() <= 0 || line.startsWith("%")) continue;
                CrossRingFragmentType toadd = new CrossRingFragmentType(line);
                dictionary.add(toadd);
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report(e);
            dictionary.clear();
        }
    }

    public static Collection<CrossRingFragmentType> getCrossRingFragmentTypes(Residue r) {
        Vector<CrossRingFragmentType> ret = new Vector<CrossRingFragmentType>();
        for (CrossRingFragmentType crt : dictionary) {
            if (!crt.matches(r)) continue;
            ret.add(crt);
        }
        return ret;
    }

    public static Collection<CrossRingFragmentType> getCrossRingFragmentTypesA(Residue r) {
        Vector<CrossRingFragmentType> ret = new Vector<CrossRingFragmentType>();
        for (CrossRingFragmentType crt : dictionary) {
            if (!crt.matches(r) || !crt.isACleavage()) continue;
            ret.add(crt);
        }
        return ret;
    }

    public static Collection<CrossRingFragmentType> getCrossRingFragmentTypesX(Residue r) {
        Vector<CrossRingFragmentType> ret = new Vector<CrossRingFragmentType>();
        for (CrossRingFragmentType crt : dictionary) {
            if (!crt.matches(r) || !crt.isXCleavage()) continue;
            ret.add(crt);
        }
        return ret;
    }

    public static CrossRingFragmentType getCrossRingFragmentType(char fragment_type, int first_pos, int last_pos, Residue r) {
        for (CrossRingFragmentType crt : dictionary) {
            if (!crt.matches(fragment_type, first_pos, last_pos, r)) continue;
            return crt;
        }
        return null;
    }

    public static Residue newCrossRingFragment(char fragment_type, int first_pos, int last_pos, Residue r) throws Exception {
        if (r == null) {
            throw new Exception("Cannot create a cross ring fragment without a residue");
        }
        CrossRingFragmentType type = CrossRingFragmentDictionary.getCrossRingFragmentType(fragment_type, first_pos, last_pos, r);
        if (type == null) {
            throw new Exception("Invalid " + fragment_type + " cross-ring cleavage at positions " + first_pos + "," + last_pos + " of residue " + r.getTypeName());
        }
        Residue ret = new Residue(type);
        ret.setCleavedResidue(r);
        return ret;
    }

    public static Residue newFragment(String type_name, Residue cleaved) {
        int last_pos;
        int first_pos;
        if (type_name == null || cleaved == null) {
            return null;
        }
        if (!type_name.startsWith("#acleavage") && !type_name.startsWith("#xcleavage")) {
            return null;
        }
        LinkedList<String> tokens = TextUtils.tokenize(type_name, "_");
        char fragment_type = type_name.charAt(1);
        CrossRingFragmentType crt = CrossRingFragmentDictionary.getCrossRingFragmentType(fragment_type, first_pos = Integer.parseInt(tokens.get(1)), last_pos = Integer.parseInt(tokens.get(2)), cleaved);
        return crt != null ? new Residue(crt) : null;
    }
}

