/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class TypePattern
implements Comparable<TypePattern> {
    private TreeMap<String, Integer> pattern = new TreeMap();
    private int count = 0;

    public TypePattern clone() {
        TypePattern ret = new TypePattern();
        ret.pattern = (TreeMap)this.pattern.clone();
        ret.count = this.count;
        return ret;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TypePattern)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean contains(TypePattern other) {
        if (other == null) {
            return true;
        }
        if (this.count < other.count) {
            return false;
        }
        for (Map.Entry<String, Integer> entry : other.pattern.entrySet()) {
            Integer value = this.pattern.get(entry.getKey());
            if (value != null && value >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TypePattern other) {
        if (other == null) {
            return 1;
        }
        if (this.count < other.count) {
            return -1;
        }
        for (Map.Entry<String, Integer> entry : other.pattern.entrySet()) {
            Integer value = this.pattern.get(entry.getKey());
            if (value != null && value >= entry.getValue()) continue;
            return -1;
        }
        if (this.count == other.count) {
            return 0;
        }
        return 1;
    }

    public int size() {
        return this.count;
    }

    public void add(String type) {
        this.add(type, 1);
    }

    public void add(String type, int num) {
        if (num == 0) {
            return;
        }
        Integer old_num = this.pattern.get(type);
        if (old_num == null) {
            this.pattern.put(type, num);
        } else if (old_num + num == 0) {
            this.pattern.remove(type);
        } else {
            this.pattern.put(type, old_num + num);
        }
        this.count += num;
    }

    public TypePattern and(String type) {
        return this.and(type, 1);
    }

    public TypePattern and(String type, int num) {
        TypePattern ret = this.clone();
        ret.add(type, num);
        return ret;
    }

    public Collection<String> getTypes() {
        Vector<String> types = new Vector<String>();
        for (Map.Entry<String, Integer> e : this.pattern.entrySet()) {
            for (int i = 0; i < e.getValue(); ++i) {
                types.add(e.getKey());
            }
        }
        return types;
    }

    public Collection<TypePattern> subPatterns(int size) {
        Vector<TypePattern> sub_patterns = new Vector<TypePattern>();
        this.subPatterns(new TypePattern(), this.pattern.entrySet().iterator(), size, sub_patterns);
        return sub_patterns;
    }

    private void subPatterns(TypePattern toadd, Iterator<Map.Entry<String, Integer>> current, int size, Vector<TypePattern> buffer) {
        if (size == 0) {
            buffer.add(toadd);
        } else if (current.hasNext()) {
            Map.Entry<String, Integer> type_num = current.next();
            for (int i = 0; i <= type_num.getValue() && i <= size; ++i) {
                this.subPatterns(toadd.and(type_num.getKey(), i), current, size - i, buffer);
            }
        }
    }

    public TypePattern subtract(TypePattern other) {
        TypePattern ret = this.clone();
        for (Map.Entry<String, Integer> e : other.pattern.entrySet()) {
            ret.add(e.getKey(), -e.getValue().intValue());
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> e : this.pattern.entrySet()) {
            if (e.getValue() > 0) {
                sb.append("+");
            } else if (e.getValue() == -1) {
                sb.append("-");
            }
            if (e.getValue() != 1 && e.getValue() != -1) {
                sb.append(e.getValue());
            }
            sb.append(e.getKey());
        }
        return sb.toString();
    }
}

