/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;

public class GlycanShorthandConverterLDA {
    public String buildGlycanShorthand(Glycan structure) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Residue> allResidues = new ArrayList<Residue>();
        if (structure.getRoot() != null) {
            allResidues.addAll(this.collectChildResidues(structure.getRoot()));
        }
        TreeMap<String, Integer> residueCount = new TreeMap<String, Integer>();
        for (Residue res : allResidues) {
            String resDesc = res.getType().getName();
            if (!residueCount.containsKey(resDesc)) {
                residueCount.put(resDesc, 0);
            }
            residueCount.put(resDesc, (Integer)residueCount.get(resDesc) + 1);
        }
        ArrayList resTypes = new ArrayList(residueCount.keySet());
        Collections.sort(resTypes);
        if (resTypes.contains("Cer")) {
            resTypes.remove("Cer");
            resTypes.add("Cer");
        }
        for (int i = 0; i < resTypes.size(); ++i) {
            String res = (String)resTypes.get(i);
            sb.append(res);
            sb.append((Integer)residueCount.get(res) > 1 ? residueCount.get(res) : "");
            if (i >= resTypes.size() - 1) continue;
            sb.append("_");
        }
        return sb.toString();
    }

    private ArrayList<Residue> collectChildResidues(Residue r) {
        ArrayList<Residue> children = new ArrayList<Residue>();
        children.add(r);
        for (Linkage l : r.getChildrenLinkages()) {
            children.addAll(this.collectChildResidues(l.getChildResidue()));
        }
        return children;
    }
}

