/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.BaseWorkspace;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.ResidueHistory;
import org.eurocarbdb.application.glycanbuilder.ResidueStyleDictionary;
import org.eurocarbdb.application.glycanbuilder.dataset.CoreDictionary;
import org.eurocarbdb.application.glycanbuilder.dataset.CrossRingFragmentDictionary;
import org.eurocarbdb.application.glycanbuilder.dataset.DictionaryConfiguration;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.dataset.ResiduePlacementDictionary;
import org.eurocarbdb.application.glycanbuilder.dataset.TerminalDictionary;
import org.eurocarbdb.application.glycanbuilder.fileutil.FileHistory;
import org.eurocarbdb.application.glycanbuilder.linkage.LinkageStyleDictionary;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.massutil.CompositionOptions;
import org.eurocarbdb.application.glycanbuilder.massutil.MassOptions;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.util.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.util.XMLUtils;
import org.glycoinfo.application.glycanbuilder.dataset.CrossLinkedSubstituentDictionary;
import org.glycoinfo.application.glycanbuilder.dataset.NonSymbolicResidueDictionary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BuilderWorkspace
extends BaseDocument
implements BaseWorkspace,
BaseDocument.DocumentChangeListener {
    protected static boolean loaded = false;
    protected boolean autosave;
    protected ResiduePlacementDictionary theResiduePlacementDictionary;
    protected ResidueStyleDictionary theResidueStyleDictionary;
    protected LinkageStyleDictionary theLinkageStyleDictionary;
    protected Configuration theConfiguration;
    protected FileHistory theFileHistory;
    protected ResidueHistory theResidueHistory;
    protected MassOptions theMassOptions;
    protected GraphicOptions theGraphicOptions;
    protected CompositionOptions theCompositionOptions;
    protected PrinterJob thePrinterJob;
    protected GlycanDocument theStructures;
    protected GlycanRenderer theGlycanRenderer;
    protected DictionaryConfiguration dictConfig;

    public BuilderWorkspace(GlycanRenderer glycanRenderer) {
        super(false);
        this.init();
        this.theGlycanRenderer = glycanRenderer;
        this.theGlycanRenderer.setGraphicOptions(this.theGraphicOptions);
        this.theGlycanRenderer.setResiduePlacementDictionary(this.theResiduePlacementDictionary);
        this.theGlycanRenderer.setResidueStyleDictionary(this.theResidueStyleDictionary);
        this.theGlycanRenderer.setLinkageStyleDictionary(this.theLinkageStyleDictionary);
    }

    public BuilderWorkspace(String config_file, boolean create, GlycanRenderer glycanRenderer, String residueTypesFile, String terminalTypesFile, String coreTypesFile, String crossRingFragmentTypesFile) {
        this.components = new HashMap();
        this.dictConfig = new DictionaryConfiguration();
        if (residueTypesFile != null) {
            this.dictConfig.setDictionaryFile(DictionaryConfiguration.RESIDUE_TYPES_FILE, residueTypesFile);
        }
        if (coreTypesFile != null) {
            this.dictConfig.setDictionaryFile(DictionaryConfiguration.CORE_TYPES_FILE, coreTypesFile);
        }
        if (terminalTypesFile != null) {
            this.dictConfig.setDictionaryFile(DictionaryConfiguration.TERMINAL_TYPES_FILE, terminalTypesFile);
        }
        if (crossRingFragmentTypesFile != null) {
            this.dictConfig.setDictionaryFile(DictionaryConfiguration.CROSS_RING_FRAGMENT_TYPES_FILE, crossRingFragmentTypesFile);
        }
        loaded = false;
        this.commonInit(config_file, create, glycanRenderer);
    }

    public BuilderWorkspace(String config_file, boolean create, GlycanRenderer glycanRenderer) {
        super(false);
        this.commonInit(config_file, create, glycanRenderer);
    }

    private void commonInit(String config_file, boolean create, GlycanRenderer glycanRenderer) {
        this.theGlycanRenderer = glycanRenderer;
        this.init(config_file, create, false);
        this.init();
        this.theGlycanRenderer.setGraphicOptions(this.theGraphicOptions);
        this.theGlycanRenderer.setResiduePlacementDictionary(this.theResiduePlacementDictionary);
        this.theGlycanRenderer.setResidueStyleDictionary(this.theResidueStyleDictionary);
        this.theGlycanRenderer.setLinkageStyleDictionary(this.theLinkageStyleDictionary);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public String getName() {
        return "Workspace";
    }

    @Override
    public Collection<FileFilter> getFileFormats() {
        return new Vector<FileFilter>();
    }

    @Override
    public FileFilter getAllFileFormats() {
        return null;
    }

    @Override
    public void initData() {
        this.init(null, false, true);
    }

    protected void createConfiguration() {
        this.theConfiguration = new Configuration();
        this.theFileHistory = new FileHistory();
        this.theResidueHistory = new ResidueHistory();
        this.theMassOptions = new MassOptions();
        this.theGraphicOptions = new GraphicOptions();
        this.theCompositionOptions = new CompositionOptions();
        if (this.dictConfig == null) {
            this.dictConfig = new DictionaryConfiguration();
        }
        this.thePrinterJob = null;
    }

    public void init(String config_file, boolean create, boolean keep_configuration) {
        if (!keep_configuration || this.theConfiguration == null) {
            this.createConfiguration();
            if (config_file != null && this.theConfiguration.open(config_file)) {
                this.retrieveFromConfiguration();
                loaded = false;
            } else {
                this.storeToConfiguration(true);
                if (config_file != null && create) {
                    this.theConfiguration.save(config_file);
                }
            }
            if (!loaded) {
                ResidueDictionary.loadDictionary(this.dictConfig.getDictionaryFile(DictionaryConfiguration.RESIDUE_TYPES_FILE));
                TerminalDictionary.loadDictionary(this.dictConfig.getDictionaryFile(DictionaryConfiguration.TERMINAL_TYPES_FILE));
                CoreDictionary.loadDictionary(this.dictConfig.getDictionaryFile(DictionaryConfiguration.CORE_TYPES_FILE));
                CrossRingFragmentDictionary.loadDictionary(this.dictConfig.getDictionaryFile(DictionaryConfiguration.CROSS_RING_FRAGMENT_TYPES_FILE));
                NonSymbolicResidueDictionary.loadDictionary(this.dictConfig.getDictionaryFile(DictionaryConfiguration.NON_SYMBOLIC_RESIDUE_TYPES_FILE));
                CrossLinkedSubstituentDictionary.loadDictionary(this.dictConfig.getDictionaryFile(DictionaryConfiguration.CROSS_LINKED_SUBSTITUENT_TYPES_FILE));
                loaded = true;
            }
            this.theResiduePlacementDictionary = new ResiduePlacementDictionary();
            this.theResidueStyleDictionary = new ResidueStyleDictionary();
            this.theLinkageStyleDictionary = new LinkageStyleDictionary();
            this.loadStyles(this.theGraphicOptions.NOTATION);
            this.setDisplay(this.theGraphicOptions.DISPLAY);
        }
        this.theStructures = new GlycanDocument(this);
    }

    public static URL getResource(String resource) {
        return BuilderWorkspace.class.getResource(resource);
    }

    protected void retrieveFromConfiguration() {
        this.theFileHistory.retrieve(this.theConfiguration);
        this.theResidueHistory.retrieve(this.theConfiguration);
        this.theMassOptions.retrieve(this.theConfiguration);
        this.theGraphicOptions.retrieve(this.theConfiguration);
        this.theCompositionOptions.retrieve(this.theConfiguration);
        this.dictConfig.retrieve(this.theConfiguration);
    }

    protected void storeToConfiguration(boolean save_options) {
        this.theFileHistory.store(this.theConfiguration);
        this.theResidueHistory.store(this.theConfiguration);
        if (save_options) {
            this.theMassOptions.store(this.theConfiguration);
            this.theGraphicOptions.store(this.theConfiguration);
            this.theCompositionOptions.store(this.theConfiguration);
            this.dictConfig.store(this.theConfiguration);
        }
    }

    public void exit(String config_file) {
        if (config_file != null) {
            this.storeConfiguration(config_file);
        }
    }

    public void storeConfiguration(String config_file) {
        this.storeToConfiguration(this.autosave);
        this.theConfiguration.save(config_file);
    }

    public boolean getAutoSave() {
        return this.autosave;
    }

    public void setAutoSave(boolean flag) {
        this.autosave = flag;
    }

    public Configuration getConfiguration() {
        return this.theConfiguration;
    }

    public FileHistory getFileHistory() {
        return this.theFileHistory;
    }

    public void storeFileHistory() {
        this.theFileHistory.store(this.theConfiguration);
    }

    public ResidueHistory getResidueHistory() {
        return this.theResidueHistory;
    }

    public void storeResidueHistory() {
        this.theResidueHistory.store(this.theConfiguration);
    }

    @Override
    public MassOptions getDefaultMassOptions() {
        return this.theMassOptions;
    }

    public void setDefaultMassOptions(MassOptions mass_opt) {
        if (mass_opt != null) {
            this.theMassOptions = mass_opt;
        }
    }

    public void storeDefaultMassOptions() {
        this.theMassOptions.store(this.theConfiguration);
    }

    public GraphicOptions getGraphicOptions() {
        return this.theGraphicOptions;
    }

    public void storeGraphicOptions() {
        this.theGraphicOptions.store(this.theConfiguration);
    }

    public CompositionOptions getCompositionOptions() {
        return this.theCompositionOptions;
    }

    public void storeCompositionOptions() {
        this.theCompositionOptions.store(this.theConfiguration);
    }

    public PrinterJob getPrinterJob() {
        if (this.thePrinterJob == null) {
            try {
                this.thePrinterJob = PrinterJob.getPrinterJob();
            }
            catch (Exception e) {
                LogUtils.report(e);
            }
        }
        return this.thePrinterJob;
    }

    public GlycanDocument getStructures() {
        return this.theStructures;
    }

    public GlycanRenderer getGlycanRenderer() {
        return this.theGlycanRenderer;
    }

    public void setNotation(String notation) {
        this.theGraphicOptions.NOTATION = notation;
        this.loadStyles(notation);
    }

    public void setDisplay(String display) {
        this.theGraphicOptions.setDisplay(display);
    }

    protected void loadStyles(String notation) {
        if (notation.equals("uoxf")) {
            this.theResiduePlacementDictionary.loadPlacements(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.UOXF_RESIDUE_PLACEMENTS_FILE));
            this.theResidueStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.UOXF_RESIDUE_STYLES_FILE));
            this.theLinkageStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.UOXF_LINKAGE_STYLES_FILE));
        } else if (notation.equals("uoxfcol")) {
            this.theResiduePlacementDictionary.loadPlacements(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.UOXF_RESIDUE_PLACEMENTS_FILE));
            this.theResidueStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.UOXFCOL_RESIDUE_STYLES_FILE));
            this.theLinkageStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.UOXF_LINKAGE_STYLES_FILE));
        } else if (notation.equals("text")) {
            this.theResiduePlacementDictionary.loadPlacements(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.TEXT_RESIDUE_PLACEMENTS_FILE));
            this.theResidueStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.TEXT_RESIDUE_STYLES_FILE));
            this.theLinkageStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.TEXT_LINKAGE_STYLES_FILE));
        } else if (notation.equals("cfglink")) {
            this.theResiduePlacementDictionary.loadPlacements(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.CFGLINK_RESIDUE_PLACEMENTS_FILE));
            this.theResidueStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.CFGLINK_RESIDUE_STYLES_FILE));
            this.theLinkageStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.CFGLINK_LINKAGE_STYLES_FILE));
        } else if (notation.equals("cfgbw")) {
            this.theResiduePlacementDictionary.loadPlacements(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.CFGBW_RESIDUE_PLACEMENTS_FILE));
            this.theResidueStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.CFGBW_RESIDUE_STYLES_FILE));
            this.theLinkageStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.CFGBW_LINKAGE_STYLES_FILE));
        } else if (notation.equals("cfg")) {
            this.theResiduePlacementDictionary.loadPlacements(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.CFG_RESIDUE_PLACEMENTS_FILE));
            this.theResidueStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.CFG_RESIDUE_STYLES_FILE));
            this.theLinkageStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.CFG_LINKAGE_STYLES_FILE));
        } else {
            this.theResiduePlacementDictionary.loadPlacements(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.SNFG_RESIDUE_PLACEMENTS_FILE));
            this.theResidueStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.SNFG_RESIDUE_STYLES_FILE));
            this.theLinkageStyleDictionary.loadStyles(this.getDictionaryConfig().getDictionaryFile(DictionaryConfiguration.SNFG_LINKAGE_STYLES_FILE));
        }
    }

    public Collection<BaseDocument> getAllDocuments() {
        Vector<BaseDocument> ret = new Vector<BaseDocument>();
        ret.add(this);
        ret.add(this.theStructures);
        return ret;
    }

    public Collection<BaseDocument> getUnsavedDocuments() {
        Vector<BaseDocument> ret = new Vector<BaseDocument>();
        if (this.theStructures.hasChanged()) {
            ret.add(this.theStructures);
        }
        return ret;
    }

    public void resetChanges() {
        this.resetStatus();
        this.theStructures.resetStatus();
        this.fireDocumentInit();
    }

    @Override
    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        this.setChanged(true);
        this.fireDocumentChanged((BaseDocument)e.getSource());
    }

    @Override
    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        this.setChanged(true);
        this.fireDocumentChanged((BaseDocument)e.getSource());
    }

    @Override
    public void fireDocumentInit() {
        super.fireDocumentInit();
        this.theStructures.fireDocumentInit();
    }

    @Override
    public void fireDocumentInit(BaseDocument source) {
        if (source == this) {
            this.fireDocumentInit();
        } else {
            super.fireDocumentInit(source);
        }
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Document document = XMLUtils.newDocument();
        document.appendChild(this.toXML(document));
        XMLUtils.write(bos, document);
        return bos.toString();
    }

    @Override
    public void fromString(String str, boolean merge) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes());
        Document document = XMLUtils.read(bis);
        if (document == null) {
            throw new Exception("Cannot read from string");
        }
        this.fromXML(XMLUtils.assertChild(document, "GlycanWorkspace"), merge);
    }

    public void fromXML(Node w_node, boolean merge) throws Exception {
        this.resetStatus();
        Node gd_node = XMLUtils.findChild(w_node, "Structures");
        if (gd_node != null) {
            this.theStructures.fromXML(gd_node, merge);
        }
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element w_node = document.createElement("GlycanWorkspace");
        this.storeToConfiguration(true);
        w_node.appendChild(this.theConfiguration.toXML(document));
        w_node.appendChild(this.theStructures.toXML(document));
        return w_node;
    }

    public ResiduePlacementDictionary getTheResiduePlacementDictionary() {
        return this.theResiduePlacementDictionary;
    }

    public void setTheResiduePlacementDictionary(ResiduePlacementDictionary theResiduePlacementDictionary) {
        this.theResiduePlacementDictionary = theResiduePlacementDictionary;
    }

    public ResidueStyleDictionary getTheResidueStyleDictionary() {
        return this.theResidueStyleDictionary;
    }

    public void setTheResidueStyleDictionary(ResidueStyleDictionary theResidueStyleDictionary) {
        this.theResidueStyleDictionary = theResidueStyleDictionary;
    }

    public LinkageStyleDictionary getTheLinkageStyleDictionary() {
        return this.theLinkageStyleDictionary;
    }

    public void setTheLinkageStyleDictionary(LinkageStyleDictionary theLinkageStyleDictionary) {
        this.theLinkageStyleDictionary = theLinkageStyleDictionary;
    }

    public DictionaryConfiguration getDictionaryConfig() {
        return this.dictConfig;
    }

    public void setDictionaryConfig(DictionaryConfiguration dictConfig) {
        this.dictConfig = dictConfig;
    }
}

