/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine;

import java.util.ArrayList;
import java.util.Vector;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.analytical.mass.GlycoVisitorRepeatLinkType;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.MatrixDataObject;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserSimple;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

public class SearchVisitor
implements GlycoVisitor {
    Vector<MatrixDataObject> v_Graph = new Vector();
    private GlycoVisitorNodeType m_visNodeType = new GlycoVisitorNodeType();
    private ArrayList<GlycoNode> rootRes = new ArrayList();

    @Override
    public void clear() {
        this.v_Graph.removeAllElements();
        this.rootRes.clear();
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserSimple(a_objVisitor);
    }

    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        try {
            this.rootRes = a_objSugar.getRootNodes();
        }
        catch (GlycoconjugateException e) {
            e.printStackTrace();
        }
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objSugar);
    }

    @Override
    public void visit(Monosaccharide a_objMonosaccharid) throws GlycoVisitorException {
        Boolean normalNode = true;
        for (GlycoEdge edge : a_objMonosaccharid.getChildEdges()) {
            if (this.m_visNodeType.getNodeType(edge.getChild()) == 5) {
                normalNode = false;
            }
            if (this.m_visNodeType.getNodeType(edge.getChild()) == 3) {
                normalNode = false;
            }
            if (this.m_visNodeType.getNodeType(edge.getChild()) == 2) {
                normalNode = false;
            }
            if (this.m_visNodeType.getNodeType(edge.getChild()) != 3) continue;
            normalNode = false;
        }
        if (normalNode.booleanValue()) {
            MatrixDataObject MDO = new MatrixDataObject();
            MDO.setNode(a_objMonosaccharid);
            MDO.setChildren(a_objMonosaccharid.getChildEdges());
            if (this.rootRes.contains(a_objMonosaccharid)) {
                MDO.reducingEnd = true;
            }
            this.v_Graph.add(MDO);
        }
    }

    @Override
    public void visit(NonMonosaccharide a_objResidue) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        GlycoNode t_objParent;
        GlycoNode t_objNode;
        GlycoTraverser t_traverser = this.getTraverser(this);
        if (a_objRepeat.getNodes().size() > 1) {
            t_traverser.traverseGraph(a_objRepeat);
        }
        if ((t_objNode = a_objRepeat.getParentNode()) != null && (t_objParent = this.getSimpleNode(t_objNode, true)) != null) {
            MatrixDataObject MDO = new MatrixDataObject();
            MDO.setNode(t_objNode);
            ArrayList<GlycoEdge> t_aFinal = new ArrayList<GlycoEdge>();
            try {
                GlycoEdge t_edge = a_objRepeat.getParentEdge().copy();
                ArrayList<Linkage> arrayList = t_edge.getGlycosidicLinkages();
                GlycoVisitorRepeatLinkType t_vis = new GlycoVisitorRepeatLinkType();
                t_vis.setRepeatIn(true);
                t_vis.visit(a_objRepeat);
                GlycoEdge CorrectedEge = t_vis.getEdge();
                for (Linkage lin : arrayList) {
                    for (Linkage linkage : CorrectedEge.getGlycosidicLinkages()) {
                        if (!lin.getChildLinkages().containsAll(linkage.getChildLinkages())) continue;
                        lin.setChildLinkageType(linkage.getChildLinkageType());
                    }
                }
                GlycoEdge t_newEdge = new GlycoEdge();
                t_newEdge.setGlycosidicLinkages(arrayList);
                t_newEdge.setChild(this.getSimpleNode(a_objRepeat.getRepeatLinkage().getChild(), true));
                t_newEdge.setParent(t_objNode);
                t_aFinal.add(t_newEdge);
            }
            catch (GlycoconjugateException e) {
                e.printStackTrace();
            }
            for (GlycoEdge glycoEdge : t_objNode.getChildEdges()) {
                if (!this.m_visNodeType.isMonosaccharide(glycoEdge.getChild()) && !this.m_visNodeType.isNonMonosaccharide(glycoEdge.getChild())) continue;
                t_aFinal.add(glycoEdge);
            }
            MDO.setChildren(t_aFinal);
            this.v_Graph.add(MDO);
        }
        GlycoNode Parent2 = a_objRepeat.getRepeatLinkage().getParent();
        ArrayList<GlycoEdge> EdgesOut = a_objRepeat.getChildEdges();
        if (EdgesOut.size() != 0) {
            MatrixDataObject MDO = new MatrixDataObject();
            MDO.setNode(Parent2);
            ArrayList<GlycoEdge> t_aFinal = new ArrayList<GlycoEdge>();
            for (GlycoEdge t_outgoing : EdgesOut) {
                try {
                    GlycoEdge t_edge = t_outgoing.copy();
                    ArrayList<Linkage> linkages = t_edge.getGlycosidicLinkages();
                    GlycoVisitorRepeatLinkType t_vis = new GlycoVisitorRepeatLinkType();
                    t_vis.setRepeatIn(false);
                    t_vis.visit(a_objRepeat);
                    GlycoEdge CorrectedEge = t_vis.getEdge();
                    for (Linkage lin : linkages) {
                        for (Linkage linCorrected : CorrectedEge.getGlycosidicLinkages()) {
                            if (!lin.getParentLinkages().containsAll(linCorrected.getParentLinkages())) continue;
                            lin.setParentLinkageType(linCorrected.getParentLinkageType());
                        }
                    }
                    GlycoEdge glycoEdge = new GlycoEdge();
                    glycoEdge.setGlycosidicLinkages(linkages);
                    glycoEdge.setChild(t_outgoing.getChild());
                    glycoEdge.setParent(Parent2);
                    t_aFinal.add(glycoEdge);
                }
                catch (GlycoconjugateException e) {
                    e.printStackTrace();
                }
            }
            MDO.setChildren(t_aFinal);
            this.v_Graph.add(MDO);
        }
        GlycoEdge internal = a_objRepeat.getRepeatLinkage();
        MatrixDataObject MDO = new MatrixDataObject();
        MDO.setNode(internal.getParent());
        ArrayList<GlycoEdge> arrayList = new ArrayList<GlycoEdge>();
        arrayList.add(internal);
        arrayList.addAll(internal.getParent().getChildEdges());
        MDO.setChildren(arrayList);
        this.v_Graph.add(MDO);
    }

    @Override
    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        Boolean normalNode = true;
        for (GlycoEdge edge : a_objSubstituent.getChildEdges()) {
            if (this.m_visNodeType.getNodeType(edge.getChild()) == 5) {
                normalNode = false;
            }
            if (this.m_visNodeType.getNodeType(edge.getChild()) == 3) {
                normalNode = false;
            }
            if (this.m_visNodeType.getNodeType(edge.getChild()) == 2) {
                normalNode = false;
            }
            if (this.m_visNodeType.getNodeType(edge.getChild()) != 3) continue;
            normalNode = false;
        }
        if (normalNode.booleanValue()) {
            MatrixDataObject MDO = new MatrixDataObject();
            MDO.setNode(a_objSubstituent);
            MDO.setChildren(a_objSubstituent.getChildEdges());
            this.v_Graph.add(MDO);
        }
    }

    @Override
    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
        GlycoNode t_objChild;
        GlycoNode t_objParent = this.getSimpleNode(a_objCyclic.getParentNode(), false);
        if (t_objParent != null && (t_objChild = this.getSimpleNode(a_objCyclic.getCyclicStart(), true)) != null) {
            MatrixDataObject MDO = new MatrixDataObject();
            MDO.setNode(t_objParent);
            ArrayList<GlycoEdge> t_Edges = new ArrayList<GlycoEdge>();
            try {
                GlycoEdge t_edge = a_objCyclic.getParentEdge().copy();
                t_edge.setParent(t_objParent);
                t_edge.setChild(t_objChild);
                t_Edges.add(t_edge);
                t_Edges.addAll(t_objParent.getChildEdges());
                t_Edges.remove(a_objCyclic.getParentEdge());
                MDO.setChildren(t_Edges);
                this.v_Graph.add(MDO);
            }
            catch (GlycoconjugateException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(SugarUnitAlternative a_objAlternative) {
        try {
            GlycoTraverser t_traverser = this.getTraverser(this);
            for (GlycoGraphAlternative t_objAlt : a_objAlternative.getAlternatives()) {
                GlycoEdge t_edge;
                t_traverser.traverseGraph(t_objAlt);
                GlycoNode Parent22 = a_objAlternative.getParentNode();
                GlycoNode LeadInNode = t_objAlt.getLeadInNode();
                try {
                    t_edge = a_objAlternative.getParentEdge().copy();
                    t_edge.setParent(Parent22);
                    t_edge.setChild(LeadInNode);
                    ArrayList<GlycoEdge> t_Edges = new ArrayList<GlycoEdge>();
                    t_Edges.add(t_edge);
                    t_Edges.addAll(Parent22.getChildEdges());
                    t_Edges.remove(a_objAlternative.getParentEdge());
                    MatrixDataObject MDO = new MatrixDataObject();
                    MDO.setNode(Parent22);
                    MDO.setChildren(t_Edges);
                    this.v_Graph.add(MDO);
                }
                catch (GlycoconjugateException e) {
                    throw new GlycoVisitorException(e.getMessage(), e);
                }
                for (GlycoNode Parent22 : t_objAlt.getLeadOutNodeToNode().keySet()) {
                    GlycoNode Child = t_objAlt.getLeadOutNodeToNode().get(Parent22);
                    for (GlycoEdge t_edges : a_objAlternative.getChildEdges()) {
                        if (t_edges.getChild() != Child) continue;
                        try {
                            t_edge = t_edges.copy();
                            t_edge.setParent(Parent22);
                            t_edge.setChild(Child);
                            ArrayList<GlycoEdge> t_Edges = new ArrayList<GlycoEdge>();
                            t_Edges.add(t_edge);
                            t_Edges.addAll(Parent22.getChildEdges());
                            MatrixDataObject MDO = new MatrixDataObject();
                            MDO.setNode(Parent22);
                            MDO.setChildren(t_Edges);
                            this.v_Graph.add(MDO);
                        }
                        catch (GlycoconjugateException e) {
                            throw new GlycoVisitorException(e.getMessage(), e);
                        }
                    }
                }
                continue;
                return;
            }
        }
        catch (GlycoVisitorException glycoVisitorException) {
            // empty catch block
        }
    }

    @Override
    public void visit(UnvalidatedGlycoNode a_objUnvalidated) throws GlycoVisitorException {
        Boolean normalNode = true;
        for (GlycoEdge edge : a_objUnvalidated.getChildEdges()) {
            if (this.m_visNodeType.getNodeType(edge.getChild()) == 5) {
                normalNode = false;
            }
            if (this.m_visNodeType.getNodeType(edge.getChild()) == 3) {
                normalNode = false;
            }
            if (this.m_visNodeType.getNodeType(edge.getChild()) == 2) {
                normalNode = false;
            }
            if (this.m_visNodeType.getNodeType(edge.getChild()) != 3) continue;
            normalNode = false;
        }
        if (normalNode.booleanValue()) {
            MatrixDataObject MDO = new MatrixDataObject();
            MDO.setNode(a_objUnvalidated);
            MDO.setChildren(a_objUnvalidated.getChildEdges());
            this.v_Graph.add(MDO);
        }
    }

    @Override
    public void visit(GlycoEdge a_objLinkage) throws GlycoVisitorException {
    }

    public Vector<MatrixDataObject> getVector() {
        return this.v_Graph;
    }

    private GlycoNode getSimpleNode(GlycoNode a_objResidue, boolean a_bRepeatInGoingLinkage) throws GlycoVisitorException {
        int t_iNodeType = this.m_visNodeType.getNodeType(a_objResidue);
        if (t_iNodeType == 2) {
            if (a_bRepeatInGoingLinkage) {
                return this.getSimpleNode(this.m_visNodeType.getSugarUnitRepeat(a_objResidue).getRepeatLinkage().getChild(), a_bRepeatInGoingLinkage);
            }
            return this.getSimpleNode(this.m_visNodeType.getSugarUnitRepeat(a_objResidue).getRepeatLinkage().getParent(), a_bRepeatInGoingLinkage);
        }
        if (t_iNodeType == 3) {
            this.getSimpleNode(this.m_visNodeType.getSugarUnitCyclic(a_objResidue).getCyclicStart(), a_bRepeatInGoingLinkage);
        } else if (t_iNodeType == 5) {
            this.getSimpleNode(this.m_visNodeType.getSugarUnitAlternative(a_objResidue), a_bRepeatInGoingLinkage);
        }
        return a_objResidue;
    }
}

