/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.Glyde;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eurocarbdb.MolecularFramework.io.Glyde.GlydeLinkage;
import org.eurocarbdb.MolecularFramework.io.MonosaccharideBuilder;
import org.eurocarbdb.MolecularFramework.io.SugarImporter;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SugarImporterGlydeII
extends SugarImporter {
    private Element m_objRoot = null;
    private Document m_objDocument = null;
    private HashMap<String, GlycoNode> m_hashResidues = new HashMap();
    private ArrayList<Sugar> m_aSugars = new ArrayList();
    private ArrayList<GlydeLinkage> m_aLinkages = new ArrayList();
    private ArrayList<Substituent> m_aSubst = new ArrayList();

    @Override
    public Sugar parse(String a_strXML) throws SugarImporterException {
        this.clear();
        this.m_aSugars.clear();
        SAXBuilder builder = new SAXBuilder();
        try {
            this.m_objDocument = builder.build(new StringReader(a_strXML));
            if (builder.getValidation()) {
                throw new SugarImporterException("XML Validation error");
            }
            List t_lMainElements = this.m_objDocument.getRootElement().getChildren();
            for (Element t_objMain : t_lMainElements) {
                String t_strType;
                if (!t_objMain.getName().equals("molecule") || (t_strType = t_objMain.getAttributeValue("subtype")) == null) continue;
                if (t_strType.equals("glycan")) {
                    this.parse(t_objMain);
                    for (Substituent t_subst : this.m_aSubst) {
                        if (t_subst.getParentEdge() != null) {
                            for (Linkage t_linkage : t_subst.getParentEdge().getGlycosidicLinkages()) {
                                t_linkage.setChildLinkageType(LinkageType.NONMONOSACCHARID);
                                t_linkage.setChildLinkages(this.linkageArray(1));
                            }
                        }
                        for (GlycoEdge t_edge : t_subst.getChildEdges()) {
                            for (Linkage t_linkage : t_edge.getGlycosidicLinkages()) {
                                t_linkage.setParentLinkageType(LinkageType.NONMONOSACCHARID);
                                t_linkage.setChildLinkages(this.linkageArray(1));
                            }
                        }
                    }
                }
                this.m_aSugars.add(this.m_objSugar);
            }
            if (this.m_aSugars.size() != 1) {
                return null;
            }
            return this.m_aSugars.get(0);
        }
        catch (JDOMException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
        catch (NumberFormatException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
    }

    private ArrayList<Integer> linkageArray(int a_i) {
        ArrayList<Integer> t_result = new ArrayList<Integer>();
        t_result.add(a_i);
        return t_result;
    }

    public Sugar parse(Element a_objRoot) throws SugarImporterException {
        try {
            this.clear();
            this.m_objSugar = new Sugar();
            this.m_objRoot = a_objRoot;
            if (!a_objRoot.getName().equals("molecule")) {
                throw new SugarImporterException("Importer can only read molecule tags.");
            }
            String t_strType = a_objRoot.getAttributeValue("subtype");
            if (t_strType == null) {
                throw new SugarImporterException("Molecule tag must have a subtype=glycan attribute.");
            }
            if (!t_strType.equals("glycan")) {
                throw new SugarImporterException("Molecule tag must have a subtype=glycan attribute.");
            }
            List t_lMainElements = this.m_objRoot.getChildren();
            for (Element t_objMain : t_lMainElements) {
                if (t_objMain.getName().equals("residue")) {
                    this.parseResidueEntry(t_objMain);
                    continue;
                }
                if (t_objMain.getName().equals("residue_link")) {
                    this.parseLinkageEntry(t_objMain);
                    continue;
                }
                if (t_objMain.getName().equals("repeat_block")) {
                    this.parseRepeatEntry(t_objMain);
                    continue;
                }
                if (!t_objMain.getName().equals("combination")) continue;
                this.parseCombinationEntry(t_objMain);
            }
            this.buildSugar();
            return this.m_objSugar;
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
    }

    private void clear() {
        this.m_objRoot = null;
        this.m_objDocument = null;
        this.m_hashResidues.clear();
        this.m_aLinkages.clear();
        this.m_aSubst.clear();
    }

    private void parseResidueEntry(Element a_objMainElement) throws GlycoconjugateException, JDOMException, SugarImporterException {
        GlycoNode t_objResidue;
        String t_strSubtype = a_objMainElement.getAttributeValue("subtype");
        String t_strName = a_objMainElement.getAttributeValue("ref");
        String t_strID = a_objMainElement.getAttributeValue("partid");
        int t_iPosition = t_strName.lastIndexOf(61);
        if (t_strSubtype == null || t_strName == null || t_strID == null) {
            throw new SugarImporterException("Error in XML format (subtype, ref or partid missing).");
        }
        if (t_strSubtype.equals("substituent")) {
            if (t_iPosition > -1) {
                t_strName = t_strName.substring(t_iPosition + 1);
            }
            Substituent t_subst = new Substituent(SubstituentType.forName(t_strName));
            this.m_aSubst.add(t_subst);
            t_objResidue = t_subst;
        } else if (t_strSubtype.equals("base_type")) {
            if (t_iPosition > -1) {
                t_strName = t_strName.substring(t_iPosition + 1);
            }
            if ((t_objResidue = MonosaccharideBuilder.fromGlycoCT(t_strName)) == null) {
                throw new SugarImporterException("The name of the base_type is not in GlycoCT format.");
            }
        } else {
            throw new SugarImporterException("Only substituent and base_type subtypes are supportet in Glycan molecules.");
        }
        if (this.m_hashResidues.get(t_strID) != null) {
            throw new SugarImporterException("Dublicated partid in glycan.");
        }
        this.m_hashResidues.put(t_strID, t_objResidue);
    }

    private void parseLinkageEntry(Element a_objLinkage) throws SugarImporterException, GlycoconjugateException {
        GlydeLinkage t_objLinkage = new GlydeLinkage();
        t_objLinkage.m_strFromID = a_objLinkage.getAttributeValue("from");
        t_objLinkage.m_strToID = a_objLinkage.getAttributeValue("to");
        if (t_objLinkage.m_strToID == null || t_objLinkage.m_strFromID == null) {
            throw new SugarImporterException("Missing from or to attribute in residue_link.");
        }
        String t_strTemp = a_objLinkage.getAttributeValue("stat");
        if (t_strTemp != null) {
            try {
                t_objLinkage.m_dStatistical = Double.parseDouble(t_strTemp);
                throw new SugarImporterException("Statistical distribution not supported at the moment.");
            }
            catch (NumberFormatException e) {
                throw new SugarImporterException(e.getMessage(), e);
            }
        }
        t_objLinkage.m_objLinkage = new GlycoEdge();
        List t_lMainElements = a_objLinkage.getChildren();
        for (Element t_objAtomLink : t_lMainElements) {
            if (!t_objAtomLink.getName().equals("atom_link")) continue;
            Linkage t_objLinkageObject = new Linkage();
            t_strTemp = t_objAtomLink.getAttributeValue("bond_order");
            if (t_strTemp != null && !t_strTemp.equals("1")) {
                throw new SugarImporterException("Only bondorder 1 is allowed for glycosidic linkages.");
            }
            String t_strFrom = t_objAtomLink.getAttributeValue("from");
            String t_strTo = t_objAtomLink.getAttributeValue("to");
            String t_strFromReplace = t_objAtomLink.getAttributeValue("from_replaces");
            String t_strToReplace = t_objAtomLink.getAttributeValue("to_replaces");
            if (t_strFrom == null || t_strTo == null) {
                throw new SugarImporterException("Missing from and/or to attribute in residue_link.");
            }
            t_objLinkageObject.setChildLinkages(this.getFromLinkages(t_strFrom));
            t_objLinkageObject.setParentLinkages(this.getToLinkages(t_strTo));
            t_objLinkageObject.setChildLinkageType(this.getFromLinkageType(t_strFrom, t_strFromReplace, t_strToReplace));
            t_objLinkageObject.setParentLinkageType(this.getToLinkageType(t_strTo, t_strFromReplace, t_strToReplace));
            t_objLinkage.m_objLinkage.addGlycosidicLinkage(t_objLinkageObject);
        }
        this.m_aLinkages.add(t_objLinkage);
    }

    private LinkageType getToLinkageType(String a_strTo, String a_strFromReplace, String a_strToReplace) throws SugarImporterException {
        String t_strBefore = "";
        int t_iPosition = this.findNumber(a_strTo);
        if (t_iPosition == -1) {
            throw new SugarImporterException("Linkageposition of to is not valid.");
        }
        t_strBefore = a_strTo.substring(0, t_iPosition);
        if (t_strBefore.equals("C")) {
            return LinkageType.DEOXY;
        }
        if (t_strBefore.equals("O")) {
            return LinkageType.H_AT_OH;
        }
        if (t_strBefore.equals("X")) {
            return LinkageType.NONMONOSACCHARID;
        }
        throw new SugarImporterException("Unknown linkage atom (only C,O,X allowed in this version).");
    }

    private LinkageType getFromLinkageType(String a_strFrom, String a_strFromReplace, String a_strToReplace) throws SugarImporterException {
        String t_strBefore = "";
        int t_iPosition = this.findNumber(a_strFrom);
        if (t_iPosition == -1) {
            if (this.isSubstNoPosConnection(a_strFrom)) {
                return LinkageType.NONMONOSACCHARID;
            }
            throw new SugarImporterException("Linkageposition of to is not valid.");
        }
        t_strBefore = a_strFrom.substring(0, t_iPosition);
        if (t_strBefore.equals("C")) {
            return LinkageType.DEOXY;
        }
        if (t_strBefore.equals("O")) {
            return LinkageType.H_AT_OH;
        }
        if (t_strBefore.equals("X")) {
            return LinkageType.NONMONOSACCHARID;
        }
        if (t_strBefore.equals("N")) {
            return LinkageType.NONMONOSACCHARID;
        }
        if (t_strBefore.equals("P")) {
            return LinkageType.NONMONOSACCHARID;
        }
        if (t_strBefore.equals("S")) {
            return LinkageType.NONMONOSACCHARID;
        }
        throw new SugarImporterException("Unknown linkage atom (only C,O,N,P,X,S allowed in this version).");
    }

    private ArrayList<Integer> getToLinkages(String a_strTo) throws SugarImporterException {
        ArrayList<Integer> t_aPositions = new ArrayList<Integer>();
        String[] a_aParts = a_strTo.split("\\|");
        String t_strBefore = "";
        String t_strAfter = "";
        String t_strType = null;
        for (int t_iCounter = 0; t_iCounter < a_aParts.length; ++t_iCounter) {
            int t_iPosition = this.findNumber(a_aParts[t_iCounter]);
            if (t_iPosition == -1) {
                throw new SugarImporterException("Linkageposition of to is not valid.");
            }
            t_strBefore = a_aParts[t_iCounter].substring(0, t_iPosition);
            t_strAfter = a_aParts[t_iCounter].substring(t_iPosition);
            if (t_strType == null) {
                t_strType = t_strBefore;
            }
            if (!t_strType.equals(t_strBefore)) {
                throw new SugarImporterException("Different LinkageTypes for a atom_link are not supported.");
            }
            try {
                t_aPositions.add(Integer.parseInt(t_strAfter));
                continue;
            }
            catch (NumberFormatException e) {
                throw new SugarImporterException("Linkageposition to is not a valid number.");
            }
        }
        return t_aPositions;
    }

    private ArrayList<Integer> getFromLinkages(String a_strFrom) throws SugarImporterException {
        ArrayList<Integer> t_aPositions = new ArrayList<Integer>();
        String[] a_aParts = a_strFrom.split("\\|");
        String t_strBefore = "";
        String t_strAfter = "";
        String t_strType = null;
        for (int t_iCounter = 0; t_iCounter < a_aParts.length; ++t_iCounter) {
            int t_iPosition = this.findNumber(a_aParts[t_iCounter]);
            if (t_iPosition == -1) {
                if (this.isSubstNoPosConnection(a_aParts[t_iCounter])) {
                    t_aPositions.add(-1);
                    continue;
                }
                throw new SugarImporterException("Linkageposition of from is not valid.");
            }
            t_strBefore = a_aParts[t_iCounter].substring(0, t_iPosition);
            t_strAfter = a_aParts[t_iCounter].substring(t_iPosition);
            if (t_strType == null) {
                t_strType = t_strBefore;
            }
            if (!t_strType.equals(t_strBefore)) {
                throw new SugarImporterException("Different LinkageTypes for a atom_link are not supported.");
            }
            try {
                t_strAfter = t_strAfter.replace("H", "");
                t_aPositions.add(Integer.parseInt(t_strAfter));
                continue;
            }
            catch (NumberFormatException e) {
                throw new SugarImporterException("Linkageposition from is not a valid number.");
            }
        }
        return t_aPositions;
    }

    private boolean isSubstNoPosConnection(String a_connection) {
        if (a_connection.equals("N")) {
            return true;
        }
        if (a_connection.equals("S")) {
            return true;
        }
        if (a_connection.equals("P")) {
            return true;
        }
        if (a_connection.equals("F")) {
            return true;
        }
        if (a_connection.equals("Cl")) {
            return true;
        }
        if (a_connection.equals("Br")) {
            return true;
        }
        return a_connection.equals("I");
    }

    private int findNumber(String a_strText) {
        int t_iLength = a_strText.length();
        for (int t_iCounter = 0; t_iCounter < t_iLength; ++t_iCounter) {
            char t_iDigit = a_strText.charAt(t_iCounter);
            if (t_iDigit > '/' && t_iDigit < ':') {
                return t_iCounter;
            }
            if (a_strText.charAt(t_iCounter) != '-') continue;
            return t_iCounter;
        }
        return -1;
    }

    private void parseRepeatEntry(Element a_objRepeat) throws SugarImporterException, GlycoconjugateException {
        throw new SugarImporterException("Repeat units are not supported in this version of the Translator.");
    }

    private void parseCombinationEntry(Element a_objCombination) throws SugarImporterException, GlycoconjugateException {
        throw new SugarImporterException("Combinations are not supported in this version of the Translator.");
    }

    private void buildSugar() throws SugarImporterException, GlycoconjugateException {
        Iterator<String> t_iterResidues = this.m_hashResidues.keySet().iterator();
        while (t_iterResidues.hasNext()) {
            this.m_objSugar.addNode(this.m_hashResidues.get(t_iterResidues.next()));
        }
        for (GlydeLinkage t_objLinkage : this.m_aLinkages) {
            GlycoNode t_objParent = this.m_hashResidues.get(t_objLinkage.m_strToID);
            GlycoNode t_objChild = this.m_hashResidues.get(t_objLinkage.m_strFromID);
            if (t_objChild == null || t_objParent == null) {
                throw new SugarImporterException("Unknown residue in linkage.");
            }
            this.m_objSugar.addEdge(t_objParent, t_objChild, t_objLinkage.m_objLinkage);
        }
    }
}

