/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.GlycoCT;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eurocarbdb.MolecularFramework.io.SugarImporter;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.Anomer;
import org.eurocarbdb.MolecularFramework.sugar.BaseType;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SugarImporterGlycoCT
extends SugarImporter {
    public static final int MAX_BASE_TYPE = 5;
    private Element m_objRoot = null;
    private Document m_objDocument = null;
    private HashMap<Integer, GlycoNode> m_hashResidues = new HashMap();
    private HashMap<Integer, GlycoEdge> m_hashLinkages = new HashMap();
    private HashMap<Integer, SugarUnitRepeat> m_hashRepeats = new HashMap();
    private HashMap<Integer, SugarUnitAlternative> m_hashAlternatives = new HashMap();
    private GlycoGraph m_objSugarUnit = null;
    private HashMap<GlycoNode, GlycoGraph> m_hashGraphs = new HashMap();

    @Override
    public Sugar parse(String a_strXML) throws SugarImporterException {
        SAXBuilder builder = new SAXBuilder();
        try {
            this.m_objDocument = builder.build(new StringReader(a_strXML));
            if (builder.getValidation()) {
                throw new SugarImporterException("XML Validation error");
            }
            return this.parse(this.m_objDocument.getRootElement());
        }
        catch (JDOMException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
        catch (NumberFormatException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
    }

    public Sugar parse(Element a_objRoot) throws SugarImporterException {
        try {
            this.clear();
            this.m_objSugar = new Sugar();
            this.m_objSugarUnit = this.m_objSugar;
            this.m_objRoot = a_objRoot;
            List t_lMainElements = this.m_objRoot.getChildren();
            for (Element t_objMain : t_lMainElements) {
                if (t_objMain.getName().equals("residues")) {
                    this.parseResidueSection(t_objMain);
                    continue;
                }
                if (t_objMain.getName().equals("linkages")) {
                    this.parseLinkageSection(t_objMain);
                    continue;
                }
                if (t_objMain.getName().equals("repeat")) {
                    this.parseRepeatSection(t_objMain);
                    continue;
                }
                if (t_objMain.getName().equals("aglyca")) {
                    this.parseAglycaSection(t_objMain);
                    continue;
                }
                if (t_objMain.getName().equals("underDeterminedSubtrees")) {
                    this.parseUnderdetermindedSubtreeSection(t_objMain);
                    continue;
                }
                if (!t_objMain.getName().equals("alternative")) continue;
                this.parseAlternativeSection(t_objMain);
            }
            return this.m_objSugar;
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new SugarImporterException(e.getMessage(), e);
        }
    }

    private void clear() {
        this.m_objRoot = null;
        this.m_objDocument = null;
        this.m_objSugarUnit = null;
        this.m_hashResidues.clear();
        this.m_hashResidues.clear();
        this.m_hashRepeats.clear();
        this.m_hashAlternatives.clear();
        this.m_hashGraphs.clear();
        this.m_hashLinkages.clear();
    }

    private void parseResidueSection(Element a_objMainElement) throws GlycoconjugateException, JDOMException, SugarImporterException {
        List t_lMainElements = a_objMainElement.getChildren();
        for (Element t_objResidue : t_lMainElements) {
            if (t_objResidue.getName().equals("basetype")) {
                this.parseBasetype(t_objResidue);
                continue;
            }
            if (t_objResidue.getName().equals("substituent")) {
                this.parseSubstitutent(t_objResidue);
                continue;
            }
            if (t_objResidue.getName().equals("repeat")) {
                this.parseRepeat(t_objResidue);
                continue;
            }
            if (t_objResidue.getName().equals("alternative")) {
                this.parseAlternative(t_objResidue);
                continue;
            }
            if (!t_objResidue.getName().equals("monosaccharide")) continue;
            this.parseBasetype(t_objResidue);
        }
    }

    private void parseSubstitutent(Element a_objResidue) throws SugarImporterException, GlycoconjugateException {
        String t_strAttribute = a_objResidue.getAttributeValue("name");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> must have a name attribute.");
        }
        Substituent t_objSubst = new Substituent(SubstituentType.forName(t_strAttribute));
        this.m_objSugarUnit.addNode(t_objSubst);
        this.m_hashGraphs.put(t_objSubst, this.m_objSugarUnit);
        t_strAttribute = a_objResidue.getAttributeValue("id");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> must have a id.");
        }
        Integer t_iID = Integer.parseInt(t_strAttribute);
        if (this.m_hashResidues.containsKey(t_iID)) {
            throw new SugarImporterException("Dupplicated residue ID.");
        }
        this.m_hashResidues.put(t_iID, t_objSubst);
    }

    private void parseBasetype(Element a_objResidue) throws GlycoconjugateException, SugarImporterException {
        String t_strAttribute = a_objResidue.getAttributeValue("anomer");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> of type b must have an anomer.");
        }
        Anomer t_enumAnomer = Anomer.forSymbol(t_strAttribute.charAt(0));
        t_strAttribute = a_objResidue.getAttributeValue("superclass");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> of type b must have a superclass.");
        }
        Superclass t_enumSuperclass = Superclass.forName(t_strAttribute);
        Monosaccharide t_objMS = new Monosaccharide(t_enumAnomer, t_enumSuperclass);
        t_strAttribute = a_objResidue.getAttributeValue("ringStart");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> of type b must have a ring start.");
        }
        int t_iStart = Integer.parseInt(t_strAttribute);
        t_strAttribute = a_objResidue.getAttributeValue("ringEnd");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> of type b must have a ring end.");
        }
        int t_iEnd = Integer.parseInt(t_strAttribute);
        t_objMS.setRing(t_iStart, t_iEnd);
        List t_lMainElements = a_objResidue.getChildren();
        ArrayList<BaseType> t_aBaseType = new ArrayList<BaseType>();
        for (int i = 0; i < 5; ++i) {
            t_aBaseType.add(null);
        }
        for (Element t_objSubTag : t_lMainElements) {
            Modification t_objModi;
            int t_iPos;
            if (t_objSubTag.getName().equals("basetype")) {
                t_strAttribute = t_objSubTag.getAttributeValue("id");
                if (t_strAttribute == null) {
                    throw new SugarImporterException("<basetype> of must have a id.");
                }
                t_iPos = Integer.parseInt(t_strAttribute);
                if (--t_iPos < 0 || t_iPos > 5) {
                    throw new SugarImporterException("<basetype> id must be a number between 0 and 5");
                }
                t_strAttribute = t_objSubTag.getAttributeValue("type");
                if (t_strAttribute == null) {
                    throw new SugarImporterException("<basetype> of must have a type.");
                }
                t_aBaseType.set(t_iPos, BaseType.forName(t_strAttribute));
                continue;
            }
            if (t_objSubTag.getName().equals("stemtype")) {
                t_strAttribute = t_objSubTag.getAttributeValue("id");
                if (t_strAttribute == null) {
                    throw new SugarImporterException("<stemtype> of must have a id.");
                }
                t_iPos = Integer.parseInt(t_strAttribute);
                if (--t_iPos < 0 || t_iPos > 5) {
                    throw new SugarImporterException("<stemtype> id must be a number between 0 and 5");
                }
                t_strAttribute = t_objSubTag.getAttributeValue("type");
                if (t_strAttribute == null) {
                    throw new SugarImporterException("<stemtype> of must have a type.");
                }
                t_aBaseType.set(t_iPos, BaseType.forName(t_strAttribute));
                continue;
            }
            if (!t_objSubTag.getName().equals("modification")) continue;
            String t_strName = t_objSubTag.getAttributeValue("type");
            if (t_strName == null) {
                throw new SugarImporterException("<modification> of must have a type.");
            }
            t_strAttribute = t_objSubTag.getAttributeValue("pos_one");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<modification> of must have a pos_one attribute.");
            }
            int t_iPosOne = Integer.parseInt(t_strAttribute);
            t_strAttribute = t_objSubTag.getAttributeValue("pos_two");
            if (t_strAttribute == null) {
                t_objModi = new Modification(t_strName, t_iPosOne);
            } else {
                int t_iPosTwo = Integer.parseInt(t_strAttribute);
                t_objModi = new Modification(t_strName, t_iPosOne, (Integer)t_iPosTwo);
            }
            t_objMS.addModification(t_objModi);
        }
        boolean t_bNull = false;
        for (int i = 0; i < 5; ++i) {
            if (t_bNull) {
                if (t_aBaseType.get(i) == null) continue;
                throw new SugarImporterException("<basetype> id " + i + " is missing.");
            }
            if (t_aBaseType.get(i) == null) {
                t_bNull = true;
                continue;
            }
            t_objMS.addBaseType((BaseType)((Object)t_aBaseType.get(i)));
        }
        t_strAttribute = a_objResidue.getAttributeValue("name");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> must have a name attribute.");
        }
        if (!t_objMS.getGlycoCTName().equalsIgnoreCase(t_strAttribute)) {
            throw new SugarImporterException("Calculated glycoCT name and name are not equal : " + t_objMS.getGlycoCTName() + " != " + t_strAttribute);
        }
        this.m_objSugarUnit.addNode(t_objMS);
        this.m_hashGraphs.put(t_objMS, this.m_objSugarUnit);
        t_strAttribute = a_objResidue.getAttributeValue("id");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> must have a id.");
        }
        Integer t_iID = Integer.parseInt(t_strAttribute);
        if (this.m_hashResidues.containsKey(t_iID)) {
            throw new SugarImporterException("Dupplicated residue ID.");
        }
        this.m_hashResidues.put(t_iID, t_objMS);
    }

    private void parseLinkageSection(Element a_objLinkage) throws SugarImporterException, GlycoconjugateException {
        List t_lMainElements = a_objLinkage.getChildren();
        for (Element t_objConnection : t_lMainElements) {
            Integer t_objID;
            String t_strAttribute;
            if (!t_objConnection.getName().equals("connection")) continue;
            GlycoEdge t_objEdge = new GlycoEdge();
            List t_lSubElements = t_objConnection.getChildren();
            for (Element t_objLin : t_lSubElements) {
                if (!t_objLin.getName().equals("linkage")) continue;
                Linkage t_objLinkage = new Linkage();
                t_strAttribute = t_objLin.getAttributeValue("parentType");
                if (t_strAttribute == null) {
                    throw new SugarImporterException("<linkage> must have a parentType.");
                }
                t_objLinkage.setParentLinkageType(LinkageType.forName(t_strAttribute.charAt(0)));
                t_strAttribute = t_objLin.getAttributeValue("childType");
                if (t_strAttribute == null) {
                    throw new SugarImporterException("<linkage> must have a childType.");
                }
                t_objLinkage.setChildLinkageType(LinkageType.forName(t_strAttribute.charAt(0)));
                List t_lSubSubElements = t_objLin.getChildren();
                for (Element t_objFromTo : t_lSubSubElements) {
                    if (t_objFromTo.getName().equals("parent")) {
                        t_strAttribute = t_objFromTo.getAttributeValue("pos");
                        if (t_strAttribute == null) {
                            throw new SugarImporterException("<from> or <to> must have a pos attribute.");
                        }
                        t_objID = Integer.parseInt(t_strAttribute);
                        t_objLinkage.addParentLinkage(t_objID);
                        continue;
                    }
                    if (!t_objFromTo.getName().equals("child")) continue;
                    t_strAttribute = t_objFromTo.getAttributeValue("pos");
                    if (t_strAttribute == null) {
                        throw new SugarImporterException("<from> or <to> must have a pos attribute.");
                    }
                    t_objID = Integer.parseInt(t_strAttribute);
                    t_objLinkage.addChildLinkage(t_objID);
                }
                t_objEdge.addGlycosidicLinkage(t_objLinkage);
            }
            if (t_objEdge.getGlycosidicLinkages().size() == 0) {
                throw new SugarImporterException("<connection> must have at least on <lin> subtag.");
            }
            t_strAttribute = t_objConnection.getAttributeValue("parent");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<connection> must have a parent.");
            }
            t_objID = Integer.parseInt(t_strAttribute);
            GlycoNode t_objParent = this.m_hashResidues.get(t_objID);
            t_strAttribute = t_objConnection.getAttributeValue("child");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<connection> must have a child.");
            }
            t_objID = Integer.parseInt(t_strAttribute);
            GlycoNode t_objChild = this.m_hashResidues.get(t_objID);
            if (t_objParent == null || t_objChild == null) {
                throw new SugarImporterException("parent or child id invalde in <connection> .");
            }
            this.m_objSugarUnit.addEdge(t_objParent, t_objChild, t_objEdge);
            t_strAttribute = t_objConnection.getAttributeValue("id");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<connection> must have a id.");
            }
            Integer t_iID = Integer.parseInt(t_strAttribute);
            if (this.m_hashLinkages.containsKey(t_iID)) {
                throw new SugarImporterException("Dupplicated linkage ID.");
            }
            this.m_hashLinkages.put(t_iID, t_objEdge);
        }
    }

    private void parseRepeat(Element a_objRepeat) throws SugarImporterException, GlycoconjugateException {
        SugarUnitRepeat t_objRepeat = new SugarUnitRepeat();
        this.m_objSugarUnit.addNode(t_objRepeat);
        this.m_hashGraphs.put(t_objRepeat, this.m_objSugarUnit);
        String t_strAttribute = a_objRepeat.getAttributeValue("id");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> must have a id.");
        }
        Integer t_iID = Integer.parseInt(t_strAttribute);
        if (this.m_hashResidues.containsKey(t_iID)) {
            throw new SugarImporterException("Dupplicated residue ID.");
        }
        this.m_hashResidues.put(t_iID, t_objRepeat);
        t_strAttribute = a_objRepeat.getAttributeValue("repeatId");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> must have a name attribute.");
        }
        t_iID = Integer.parseInt(t_strAttribute);
        if (this.m_hashRepeats.containsKey(t_iID)) {
            throw new SugarImporterException("Dupplicated repeat ID.");
        }
        this.m_hashRepeats.put(t_iID, t_objRepeat);
    }

    private void parseAglycaSection(Element a_objAglyca) throws SugarImporterException, GlycoconjugateException {
        List t_lMainElements = a_objAglyca.getChildren();
        for (Element t_objCategory : t_lMainElements) {
            if (t_objCategory.getName().equals("historicalData")) {
                this.parseHistorical(t_objCategory);
                continue;
            }
            throw new SugarImporterException("Not supported yet " + t_objCategory.getName());
        }
    }

    private void parseHistorical(Element a_objCategory) throws SugarImporterException, GlycoconjugateException {
        List t_lMainElements = a_objCategory.getChildren();
        for (Element t_objAGL : t_lMainElements) {
            GlycoNode t_objResidue;
            Integer t_objID;
            List t_lSubElements;
            Linkage t_objLinkage;
            List t_lElements;
            int t_iID;
            GlycoEdge t_objEdge;
            if (!t_objAGL.getName().equals("entry")) {
                throw new SugarImporterException("Forbiden tag " + t_objAGL.getName() + " in historicalData section.");
            }
            String t_strAttribute = t_objAGL.getAttributeValue("name");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<entry> must have a name attribute.");
            }
            NonMonosaccharide t_objHistorical = new NonMonosaccharide(t_strAttribute);
            t_strAttribute = t_objAGL.getAttributeValue("fromResidue");
            if (t_strAttribute != null) {
                t_objEdge = new GlycoEdge();
                t_iID = Integer.parseInt(t_strAttribute);
                t_lElements = t_objAGL.getChildren();
                for (Element t_objLin : t_lElements) {
                    if (!t_objLin.getName().equals("linkage")) {
                        throw new SugarImporterException("Invalde tag " + t_objLin.getName() + " in connection section.");
                    }
                    t_objLinkage = new Linkage();
                    t_strAttribute = t_objLin.getAttributeValue("parentType");
                    if (t_strAttribute == null) {
                        throw new SugarImporterException("<linkage> must have a parentType.");
                    }
                    t_objLinkage.setParentLinkageType(LinkageType.forName(t_strAttribute.charAt(0)));
                    t_strAttribute = t_objLin.getAttributeValue("childType");
                    if (t_strAttribute == null) {
                        throw new SugarImporterException("<linkage> must have a childType.");
                    }
                    t_objLinkage.setChildLinkageType(LinkageType.forName(t_strAttribute.charAt(0)));
                    t_lSubElements = t_objLin.getChildren();
                    for (Element t_objFromTo : t_lSubElements) {
                        t_strAttribute = t_objFromTo.getAttributeValue("pos");
                        if (t_strAttribute == null) {
                            throw new SugarImporterException("<from> or <to> must have a pos attribute.");
                        }
                        t_objID = Integer.parseInt(t_strAttribute);
                        if (t_objFromTo.getName().equals("parent")) {
                            t_objLinkage.addParentLinkage(t_objID);
                            continue;
                        }
                        if (t_objFromTo.getName().equals("child")) {
                            t_objLinkage.addChildLinkage(t_objID);
                            continue;
                        }
                        throw new SugarImporterException("Invalde tag " + t_objFromTo.getName() + " in lin section.");
                    }
                    t_objEdge.addGlycosidicLinkage(t_objLinkage);
                }
                if (t_objEdge.getGlycosidicLinkages().size() == 0) {
                    throw new SugarImporterException("<entry> must have at least on <lin> subtag.");
                }
                t_objResidue = this.m_hashResidues.get(t_iID);
                this.m_objSugarUnit.addEdge(t_objResidue, t_objHistorical, t_objEdge);
                continue;
            }
            t_strAttribute = t_objAGL.getAttributeValue("toResidue");
            if (t_strAttribute == null) continue;
            t_objEdge = new GlycoEdge();
            t_iID = Integer.parseInt(t_strAttribute);
            t_lElements = t_objAGL.getChildren();
            for (Element t_objLin : t_lElements) {
                if (!t_objLin.getName().equals("linkage")) {
                    throw new SugarImporterException("Invalde tag " + t_objLin.getName() + " in connection section.");
                }
                t_objLinkage = new Linkage();
                t_strAttribute = t_objLin.getAttributeValue("parentType");
                if (t_strAttribute == null) {
                    throw new SugarImporterException("<linkage> must have a parentType.");
                }
                t_objLinkage.setParentLinkageType(LinkageType.forName(t_strAttribute.charAt(0)));
                t_strAttribute = t_objLin.getAttributeValue("childType");
                if (t_strAttribute == null) {
                    throw new SugarImporterException("<linkage> must have a childType.");
                }
                t_objLinkage.setChildLinkageType(LinkageType.forName(t_strAttribute.charAt(0)));
                t_lSubElements = t_objLin.getChildren();
                for (Element t_objFromTo : t_lSubElements) {
                    t_strAttribute = t_objFromTo.getAttributeValue("pos");
                    if (t_strAttribute == null) {
                        throw new SugarImporterException("<from> or <to> must have a pos attribute.");
                    }
                    t_objID = Integer.parseInt(t_strAttribute);
                    if (t_objFromTo.getName().equals("parent")) {
                        t_objLinkage.addParentLinkage(t_objID);
                        continue;
                    }
                    if (t_objFromTo.getName().equals("child")) {
                        t_objLinkage.addChildLinkage(t_objID);
                        continue;
                    }
                    throw new SugarImporterException("Invalde tag " + t_objFromTo.getName() + " in lin section.");
                }
                t_objEdge.addGlycosidicLinkage(t_objLinkage);
            }
            if (t_objEdge.getGlycosidicLinkages().size() == 0) {
                throw new SugarImporterException("<entry> must have at least on <lin> subtag.");
            }
            t_objResidue = this.m_hashResidues.get(t_iID);
            this.m_objSugarUnit.addEdge(t_objHistorical, t_objResidue, t_objEdge);
        }
    }

    private void parseRepeatSection(Element a_objMainElement) throws SugarImporterException, GlycoconjugateException, JDOMException {
        List t_lMainElements = a_objMainElement.getChildren();
        for (Element t_objUnit : t_lMainElements) {
            if (!t_objUnit.getName().equals("unit")) continue;
            String t_strAttribute = t_objUnit.getAttributeValue("id");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<unit> must have a id.");
            }
            SugarUnitRepeat t_objRepeat = this.m_hashRepeats.get(Integer.parseInt(t_strAttribute));
            if (t_objRepeat == null) {
                throw new SugarImporterException("Critical error repeat unit id " + t_strAttribute + "never declarated before.");
            }
            t_strAttribute = t_objUnit.getAttributeValue("minOccur");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<unit> must have a minOccur.");
            }
            t_objRepeat.setMinRepeatCount(Integer.parseInt(t_strAttribute));
            t_strAttribute = t_objUnit.getAttributeValue("maxOccur");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<unit> must have a maxOccur.");
            }
            t_objRepeat.setMaxRepeatCount(Integer.parseInt(t_strAttribute));
            this.m_objSugarUnit = t_objRepeat;
            List t_lSubElements = t_objUnit.getChildren();
            for (Element t_objMain : t_lSubElements) {
                if (t_objMain.getName().equals("residues")) {
                    this.parseResidueSection(t_objMain);
                    continue;
                }
                if (t_objMain.getName().equals("linkages")) {
                    this.parseLinkageSection(t_objMain);
                    continue;
                }
                if (!t_objMain.getName().equals("internalLinkage")) continue;
                this.parseInternalLinkage(t_objMain, t_objRepeat);
            }
        }
    }

    private void parseInternalLinkage(Element a_objInternal, SugarUnitRepeat a_objRepeat) throws SugarImporterException, GlycoconjugateException {
        String t_strAttribute = a_objInternal.getAttributeValue("parent");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<internalLinkage> must have a parent attribute.");
        }
        GlycoNode t_objParent = this.m_hashResidues.get(Integer.parseInt(t_strAttribute));
        t_strAttribute = a_objInternal.getAttributeValue("child");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<internalLinkage> must have a child attribute.");
        }
        GlycoNode t_objChild = this.m_hashResidues.get(Integer.parseInt(t_strAttribute));
        if (t_objChild == null || t_objParent == null) {
            throw new SugarImporterException("Error in <internalLinkage> residues are not declareded.");
        }
        GlycoEdge t_objEdge = new GlycoEdge();
        List t_lElements = a_objInternal.getChildren();
        for (Element t_objLin : t_lElements) {
            if (!t_objLin.getName().equals("linkage")) continue;
            Linkage t_objLinkage = new Linkage();
            t_strAttribute = t_objLin.getAttributeValue("parentType");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<linkage> must have a parentType.");
            }
            t_objLinkage.setParentLinkageType(LinkageType.forName(t_strAttribute.charAt(0)));
            t_strAttribute = t_objLin.getAttributeValue("childType");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<linkage> must have a childType.");
            }
            t_objLinkage.setChildLinkageType(LinkageType.forName(t_strAttribute.charAt(0)));
            List t_lSubElements = t_objLin.getChildren();
            for (Element t_objFromTo : t_lSubElements) {
                Integer t_objID;
                if (t_objFromTo.getName().equals("parent")) {
                    t_strAttribute = t_objFromTo.getAttributeValue("pos");
                    if (t_strAttribute == null) {
                        throw new SugarImporterException("<from> or <to> must have a pos attribute.");
                    }
                    t_objID = Integer.parseInt(t_strAttribute);
                    t_objLinkage.addParentLinkage(t_objID);
                    continue;
                }
                if (!t_objFromTo.getName().equals("child")) continue;
                t_strAttribute = t_objFromTo.getAttributeValue("pos");
                if (t_strAttribute == null) {
                    throw new SugarImporterException("<from> or <to> must have a pos attribute.");
                }
                t_objID = Integer.parseInt(t_strAttribute);
                t_objLinkage.addChildLinkage(t_objID);
            }
            t_objEdge.addGlycosidicLinkage(t_objLinkage);
        }
        if (t_objEdge.getGlycosidicLinkages().size() == 0) {
            throw new SugarImporterException("<connection> must have at least on <lin> subtag.");
        }
        a_objRepeat.setRepeatLinkage(t_objEdge, t_objParent, t_objChild);
    }

    private void parseUnderdetermindedSubtreeSection(Element a_objMainElement) throws SugarImporterException, GlycoconjugateException, JDOMException {
        List t_lMainElements = a_objMainElement.getChildren();
        Iterator t_iterElements = t_lMainElements.iterator();
        while (t_iterElements.hasNext()) {
            GlycoGraph t_objRepeat;
            UnderdeterminedSubTree t_objSubtree = new UnderdeterminedSubTree();
            Element t_objTree = (Element)t_iterElements.next();
            if (!t_objTree.getName().equals("tree")) continue;
            String t_strAttribute = t_objTree.getAttributeValue("probLow");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<tree> must have a probLow.");
            }
            Double t_dLow = Double.parseDouble(t_strAttribute);
            t_strAttribute = t_objTree.getAttributeValue("probUp");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<tree> must have a probUp.");
            }
            Double t_dHigh = Double.parseDouble(t_strAttribute);
            t_objSubtree.setProbability(t_dLow, t_dHigh);
            this.m_objSugarUnit = t_objSubtree;
            List t_lSubElements = t_objTree.getChildren();
            ArrayList<Object> t_aParents = new ArrayList();
            for (Element element : t_lSubElements) {
                if (element.getName().equals("residues")) {
                    this.parseResidueSection(element);
                    continue;
                }
                if (element.getName().equals("linkages")) {
                    this.parseLinkageSection(element);
                    continue;
                }
                if (element.getName().equals("parents")) {
                    t_aParents = this.parseParents(element);
                    continue;
                }
                if (!element.getName().equals("connection")) continue;
                t_objSubtree.setConnection(this.parseConnection(element));
            }
            GlycoGraph t_objUnit = this.m_hashGraphs.get(t_aParents.get(0));
            if (t_objUnit.getClass() == SugarUnitRepeat.class) {
                t_objRepeat = (SugarUnitRepeat)t_objUnit;
                ((SugarUnitRepeat)t_objRepeat).addUndeterminedSubTree(t_objSubtree);
                for (GlycoNode glycoNode : t_aParents) {
                    if (this.m_hashGraphs.get(glycoNode) != t_objUnit) {
                        throw new SugarImporterException("Error in <underDeterminedSubtree> all parents must be in the same unit.");
                    }
                    ((SugarUnitRepeat)t_objRepeat).addUndeterminedSubTreeParent(t_objSubtree, glycoNode);
                }
                continue;
            }
            if (t_objUnit.getClass() == Sugar.class) {
                t_objRepeat = (Sugar)t_objUnit;
                ((Sugar)t_objRepeat).addUndeterminedSubTree(t_objSubtree);
                for (GlycoNode glycoNode : t_aParents) {
                    if (this.m_hashGraphs.get(glycoNode) != t_objUnit) {
                        throw new SugarImporterException("Error in <underDeterminedSubtree> all parents must be in the same unit.");
                    }
                    ((Sugar)t_objRepeat).addUndeterminedSubTreeParent(t_objSubtree, glycoNode);
                }
                continue;
            }
            throw new SugarImporterException("Error in <underDeterminedSubtree>: Tree is connected to a " + t_objUnit.getClass().getName() + ".");
        }
    }

    private GlycoEdge parseConnection(Element a_objConnection) throws SugarImporterException, GlycoconjugateException {
        GlycoEdge t_objEdge = new GlycoEdge();
        List t_lElements = a_objConnection.getChildren();
        for (Element t_objLin : t_lElements) {
            if (!t_objLin.getName().equals("linkage")) continue;
            Linkage t_objLinkage = new Linkage();
            String t_strAttribute = t_objLin.getAttributeValue("parentType");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<linkage> must have a parentType.");
            }
            t_objLinkage.setParentLinkageType(LinkageType.forName(t_strAttribute.charAt(0)));
            t_strAttribute = t_objLin.getAttributeValue("childType");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<linkage> must have a childType.");
            }
            t_objLinkage.setChildLinkageType(LinkageType.forName(t_strAttribute.charAt(0)));
            List t_lSubElements = t_objLin.getChildren();
            for (Element t_objFromTo : t_lSubElements) {
                Integer t_objID;
                if (t_objFromTo.getName().equals("parent")) {
                    t_strAttribute = t_objFromTo.getAttributeValue("pos");
                    if (t_strAttribute == null) {
                        throw new SugarImporterException("<from> or <to> must have a pos attribute.");
                    }
                    t_objID = Integer.parseInt(t_strAttribute);
                    t_objLinkage.addParentLinkage(t_objID);
                    continue;
                }
                if (!t_objFromTo.getName().equals("child")) continue;
                t_strAttribute = t_objFromTo.getAttributeValue("pos");
                if (t_strAttribute == null) {
                    throw new SugarImporterException("<from> or <to> must have a pos attribute.");
                }
                t_objID = Integer.parseInt(t_strAttribute);
                t_objLinkage.addChildLinkage(t_objID);
            }
            t_objEdge.addGlycosidicLinkage(t_objLinkage);
        }
        if (t_objEdge.getGlycosidicLinkages().size() == 0) {
            throw new SugarImporterException("<connection> must have at least on <lin> subtag.");
        }
        return t_objEdge;
    }

    private ArrayList<GlycoNode> parseParents(Element a_objParentElement) throws SugarImporterException {
        ArrayList<GlycoNode> t_aParents = new ArrayList<GlycoNode>();
        List t_lSubElements = a_objParentElement.getChildren();
        for (Element t_objParent : t_lSubElements) {
            if (!t_objParent.getName().equals("parent")) continue;
            String t_strAttribute = t_objParent.getAttributeValue("res_id");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<parent> must have a res_id attribute.");
            }
            Integer t_iID = Integer.parseInt(t_strAttribute);
            GlycoNode t_objParentNode = this.m_hashResidues.get(t_iID);
            if (t_objParentNode == null) {
                throw new SugarImporterException("Invalide <parent>. Residue was not declareted before.");
            }
            t_aParents.add(t_objParentNode);
        }
        return t_aParents;
    }

    private void parseAlternative(Element a_objAlternativeElement) throws SugarImporterException, GlycoconjugateException {
        SugarUnitAlternative t_objAlternative = new SugarUnitAlternative();
        this.m_objSugarUnit.addNode(t_objAlternative);
        this.m_hashGraphs.put(t_objAlternative, this.m_objSugarUnit);
        String t_strAttribute = a_objAlternativeElement.getAttributeValue("id");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> must have a id.");
        }
        Integer t_iID = Integer.parseInt(t_strAttribute);
        if (this.m_hashResidues.containsKey(t_iID)) {
            throw new SugarImporterException("Dupplicated residue ID.");
        }
        this.m_hashResidues.put(t_iID, t_objAlternative);
        t_strAttribute = a_objAlternativeElement.getAttributeValue("alternativeId");
        if (t_strAttribute == null) {
            throw new SugarImporterException("<res> must have a name attribute.");
        }
        t_iID = Integer.parseInt(t_strAttribute);
        if (this.m_hashAlternatives.containsKey(t_iID)) {
            throw new SugarImporterException("Dupplicated alternative ID.");
        }
        this.m_hashAlternatives.put(t_iID, t_objAlternative);
    }

    private void parseAlternativeSection(Element a_objAlternativeElement) throws SugarImporterException, GlycoconjugateException, JDOMException {
        List t_lAlternativeElements = a_objAlternativeElement.getChildren();
        for (Element t_objUnitElement : t_lAlternativeElements) {
            if (!t_objUnitElement.getName().equals("unit")) continue;
            String t_strAttribute = t_objUnitElement.getAttributeValue("id");
            if (t_strAttribute == null) {
                throw new SugarImporterException("<unit> must have a id.");
            }
            SugarUnitAlternative t_objAlternative = this.m_hashAlternatives.get(Integer.parseInt(t_strAttribute));
            if (t_objAlternative == null) {
                throw new SugarImporterException("Critical error alternative unit id " + t_strAttribute + " never declarated before.");
            }
            List t_lUnitElements = t_objUnitElement.getChildren();
            for (Element t_objSubstructuresElement : t_lUnitElements) {
                if (!t_objSubstructuresElement.getName().equals("substructure")) continue;
                GlycoGraphAlternative t_objAltGraph = new GlycoGraphAlternative();
                t_objAlternative.addAlternative(t_objAltGraph);
                this.m_objSugarUnit = t_objAltGraph;
                List t_lSubElements = t_objSubstructuresElement.getChildren();
                for (Element t_objSubElement : t_lSubElements) {
                    if (t_objSubElement.getName().equals("residues")) {
                        this.parseResidueSection(t_objSubElement);
                        continue;
                    }
                    if (t_objSubElement.getName().equals("linkages")) {
                        this.parseLinkageSection(t_objSubElement);
                        continue;
                    }
                    if (t_objSubElement.getName().equals("lead_in")) {
                        t_strAttribute = t_objSubElement.getAttributeValue("residue_id");
                        if (t_strAttribute == null) {
                            throw new SugarImporterException("<lead_in> must have a residue_id.");
                        }
                        GlycoNode t_objNode = this.m_hashResidues.get(Integer.parseInt(t_strAttribute));
                        t_objAlternative.setLeadInNode(t_objNode, t_objAltGraph);
                        continue;
                    }
                    if (!t_objSubElement.getName().equals("lead_out")) continue;
                    t_strAttribute = t_objSubElement.getAttributeValue("residue_id");
                    if (t_strAttribute == null) {
                        throw new SugarImporterException("<lead_out> must have a residue_id.");
                    }
                    GlycoNode t_objNodeInner = this.m_hashResidues.get(Integer.parseInt(t_strAttribute));
                    t_strAttribute = t_objSubElement.getAttributeValue("connected_to");
                    if (t_strAttribute == null) {
                        throw new SugarImporterException("<lead_out> must have a connected_to.");
                    }
                    GlycoNode t_objNodeOuter = this.m_hashResidues.get(Integer.parseInt(t_strAttribute));
                    if (t_objNodeInner == null || t_objNodeOuter == null) {
                        throw new SugarImporterException("Values for lead out are invalide. Residues are not defined before.");
                    }
                    t_objAlternative.addLeadOutNodeToNode(t_objNodeInner, t_objAltGraph, t_objNodeOuter);
                }
            }
        }
    }
}

