/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.ognl.OgnlTypeConverterWrapper;
import com.opensymphony.xwork2.ognl.OgnlUtil;
import com.opensymphony.xwork2.ognl.SecurityMemberAccess;
import com.opensymphony.xwork2.ognl.accessor.CompoundRootAccessor;
import com.opensymphony.xwork2.util.ClearableValueStack;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.MemberAccessValueStack;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.logging.LoggerUtils;
import com.opensymphony.xwork2.util.reflection.ReflectionContextState;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.PropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OgnlValueStack
implements Serializable,
ValueStack,
ClearableValueStack,
MemberAccessValueStack {
    private static final long serialVersionUID = 370737852934925530L;
    private static Logger LOG = LoggerFactory.getLogger(OgnlValueStack.class);
    private boolean devMode;
    private boolean logMissingProperties;
    CompoundRoot root;
    transient Map<String, Object> context;
    Class defaultType;
    Map<Object, Object> overrides;
    transient OgnlUtil ognlUtil;
    transient SecurityMemberAccess securityMemberAccess;
    private static final String MAP_IDENTIFIER_KEY = "com.opensymphony.xwork2.util.OgnlValueStack.MAP_IDENTIFIER_KEY";

    public static void link(Map<String, Object> context, Class clazz, String name) {
        context.put("__link", new Object[]{clazz, name});
    }

    protected OgnlValueStack(XWorkConverter xworkConverter, CompoundRootAccessor accessor, TextProvider prov, boolean allowStaticAccess) {
        this.setRoot(xworkConverter, accessor, new CompoundRoot(), allowStaticAccess);
        this.push(prov);
    }

    protected OgnlValueStack(ValueStack vs, XWorkConverter xworkConverter, CompoundRootAccessor accessor, boolean allowStaticAccess) {
        this.setRoot(xworkConverter, accessor, new CompoundRoot(vs.getRoot()), allowStaticAccess);
    }

    @Inject
    public void setOgnlUtil(OgnlUtil ognlUtil) {
        this.ognlUtil = ognlUtil;
    }

    protected void setRoot(XWorkConverter xworkConverter, CompoundRootAccessor accessor, CompoundRoot compoundRoot, boolean allowStaticMethodAccess) {
        this.root = compoundRoot;
        this.securityMemberAccess = new SecurityMemberAccess(allowStaticMethodAccess);
        this.context = Ognl.createDefaultContext(this.root, accessor, new OgnlTypeConverterWrapper(xworkConverter), this.securityMemberAccess);
        this.context.put("com.opensymphony.xwork2.util.ValueStack.ValueStack", this);
        Ognl.setClassResolver(this.context, accessor);
        ((OgnlContext)this.context).setTraceEvaluations(false);
        ((OgnlContext)this.context).setKeepLastEvaluation(false);
    }

    @Inject(value="devMode")
    public void setDevMode(String mode) {
        this.devMode = "true".equalsIgnoreCase(mode);
    }

    @Inject(value="logMissingProperties")
    public void setLogMissingProperties(String logMissingProperties) {
        this.logMissingProperties = "true".equalsIgnoreCase(logMissingProperties);
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public void setDefaultType(Class defaultType) {
        this.defaultType = defaultType;
    }

    @Override
    public void setExprOverrides(Map<Object, Object> overrides) {
        if (this.overrides == null) {
            this.overrides = overrides;
        } else {
            this.overrides.putAll(overrides);
        }
    }

    @Override
    public Map<Object, Object> getExprOverrides() {
        return this.overrides;
    }

    @Override
    public CompoundRoot getRoot() {
        return this.root;
    }

    @Override
    public void setValue(String expr, Object value) {
        this.setValue(expr, value, this.devMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String expr, Object value, boolean throwExceptionOnFailure) {
        Map<String, Object> context = this.getContext();
        try {
            context.put("conversion.property.fullName", expr);
            context.put("com.opensymphony.xwork2.util.ValueStack.ReportErrorsOnNoProp", throwExceptionOnFailure ? Boolean.TRUE : Boolean.FALSE);
            this.ognlUtil.setValue(expr, context, this.root, value);
        }
        catch (OgnlException e) {
            if (throwExceptionOnFailure) {
                e.printStackTrace(System.out);
                System.out.println("expr: " + expr + " val: " + value + " context: " + context + " root:" + this.root + " value: " + value);
                String msg = "Error setting expression '" + expr + "' with value '" + value + "'";
                throw new XWorkException(msg, e);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Error setting value", e, new String[0]);
            }
        }
        catch (RuntimeException re) {
            if (throwExceptionOnFailure) {
                StringBuilder msg = new StringBuilder();
                msg.append("Error setting expression '");
                msg.append(expr);
                msg.append("' with value ");
                if (value instanceof Object[]) {
                    Object[] valueArray = (Object[])value;
                    msg.append("[");
                    for (int index = 0; index < valueArray.length; ++index) {
                        msg.append("'");
                        msg.append(valueArray[index]);
                        msg.append("'");
                        if (index >= valueArray.length + 1) continue;
                        msg.append(", ");
                    }
                    msg.append("]");
                } else {
                    msg.append("'");
                    msg.append(value);
                    msg.append("'");
                }
                throw new XWorkException(msg.toString(), re);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Error setting value", re, new String[0]);
            }
        }
        finally {
            ReflectionContextState.clear(context);
            context.remove("conversion.property.fullName");
            context.remove("com.opensymphony.xwork2.util.ValueStack.ReportErrorsOnNoProp");
        }
    }

    @Override
    public String findString(String expr) {
        return (String)this.findValue(expr, String.class);
    }

    @Override
    public String findString(String expr, boolean throwExceptionOnFailure) {
        return (String)this.findValue(expr, String.class, throwExceptionOnFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findValue(String expr, boolean throwExceptionOnFailure) {
        try {
            if (expr == null) {
                Object var3_3 = null;
                return var3_3;
            }
            if (this.overrides != null && this.overrides.containsKey(expr)) {
                expr = (String)this.overrides.get(expr);
            }
            if (this.defaultType != null) {
                Object object = this.findValue(expr, this.defaultType);
                return object;
            }
            Object value = this.ognlUtil.getValue(expr, this.context, this.root);
            if (value != null) {
                Object object = value;
                return object;
            }
            this.checkForInvalidProperties(expr, throwExceptionOnFailure, throwExceptionOnFailure);
            Object object = this.findInContext(expr);
            return object;
        }
        catch (OgnlException e) {
            this.checkForInvalidProperties(expr, throwExceptionOnFailure, throwExceptionOnFailure);
            Object object = this.findInContext(expr);
            return object;
        }
        catch (Exception e) {
            this.logLookupFailure(expr, e);
            if (throwExceptionOnFailure) {
                throw new XWorkException(e);
            }
            Object object = this.findInContext(expr);
            return object;
        }
        finally {
            ReflectionContextState.clear(this.context);
        }
    }

    @Override
    public Object findValue(String expr) {
        return this.findValue(expr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findValue(String expr, Class asType, boolean throwExceptionOnFailure) {
        try {
            Object value;
            if (expr == null) {
                Object var4_4 = null;
                return var4_4;
            }
            if (this.overrides != null && this.overrides.containsKey(expr)) {
                expr = (String)this.overrides.get(expr);
            }
            if ((value = this.ognlUtil.getValue(expr, this.context, this.root, asType)) != null) {
                Object object = value;
                return object;
            }
            this.checkForInvalidProperties(expr, throwExceptionOnFailure, throwExceptionOnFailure);
            Object object = this.findInContext(expr);
            return object;
        }
        catch (OgnlException e) {
            this.checkForInvalidProperties(expr, throwExceptionOnFailure, throwExceptionOnFailure);
            Object object = this.findInContext(expr);
            return object;
        }
        catch (Exception e) {
            this.logLookupFailure(expr, e);
            if (throwExceptionOnFailure) {
                throw new XWorkException(e);
            }
            Object object = this.findInContext(expr);
            return object;
        }
        finally {
            ReflectionContextState.clear(this.context);
        }
    }

    private Object findInContext(String name) {
        return this.getContext().get(name);
    }

    @Override
    public Object findValue(String expr, Class asType) {
        return this.findValue(expr, asType, false);
    }

    private void checkForInvalidProperties(String expr, boolean throwExceptionPropNotFound, boolean throwExceptionMethodFound) {
        if (expr.contains("(") && expr.contains(")")) {
            if (this.devMode) {
                LOG.warn("Could not find method [" + expr + "]", new String[0]);
            }
            if (throwExceptionMethodFound) {
                throw new XWorkException("Could not find method [" + expr + "]");
            }
        } else if (this.findInContext(expr) == null) {
            LinkedHashSet<String> availableProperties = new LinkedHashSet<String>();
            for (Object o : this.root) {
                if (!(o instanceof ActionSupport) && !o.getClass().getSimpleName().endsWith("Action")) continue;
                try {
                    this.findAvailableProperties(o.getClass(), expr, availableProperties, null);
                }
                catch (IntrospectionException ise) {}
            }
            if (!availableProperties.contains(expr)) {
                if (this.devMode && this.logMissingProperties) {
                    LOG.warn("Could not find property [" + expr + "]", new String[0]);
                }
                if (throwExceptionMethodFound) {
                    throw new XWorkException("Could not find property [" + expr + "]");
                }
            }
        }
    }

    private void findAvailableProperties(Class c, String expr, Set<String> availableProperties, String parent) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor pd : descriptors = this.ognlUtil.getPropertyDescriptors(c)) {
            Method[] methods;
            String name = pd.getDisplayName();
            if (parent != null && expr.contains(".")) {
                name = expr.substring(0, expr.indexOf(".") + 1) + name;
            }
            if (!expr.startsWith(name)) continue;
            availableProperties.add(parent != null ? parent + "." + name : name);
            if (expr.equals(name)) break;
            if (!expr.contains(".")) continue;
            String property = expr.substring(expr.indexOf(".") + 1);
            String rawProperty = property.contains(".") ? property.substring(0, property.indexOf(".")) : property;
            String methodToLookFor = "get" + rawProperty.substring(0, 1).toUpperCase() + rawProperty.substring(1);
            for (Method method : methods = pd.getPropertyType().getDeclaredMethods()) {
                if (!method.getName().equals(methodToLookFor)) continue;
                availableProperties.add(name + "." + rawProperty);
                Class<?> returnType = method.getReturnType();
                this.findAvailableProperties(returnType, property, availableProperties, name);
            }
        }
    }

    private void logLookupFailure(String expr, Exception e) {
        String msg = LoggerUtils.format("Caught an exception while evaluating expression '#0' against value stack", expr);
        if (this.devMode && LOG.isWarnEnabled()) {
            LOG.warn(msg, e, new String[0]);
            LOG.warn("NOTE: Previous warning message was issued due to devMode set to true.", new String[0]);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(msg, e, new String[0]);
        }
    }

    @Override
    public Object peek() {
        return this.root.peek();
    }

    @Override
    public Object pop() {
        return this.root.pop();
    }

    @Override
    public void push(Object o) {
        this.root.push(o);
    }

    @Override
    public void set(String key, Object o) {
        Map<String, Object> setMap = null;
        Object topObj = this.peek();
        if (topObj instanceof Map && ((Map)topObj).get(MAP_IDENTIFIER_KEY) != null) {
            setMap = (Map)topObj;
        } else {
            setMap = new HashMap<String, String>();
            setMap.put(MAP_IDENTIFIER_KEY, "");
            this.push(setMap);
        }
        setMap.put(key, o);
    }

    @Override
    public int size() {
        return this.root.size();
    }

    private Object readResolve() {
        ActionContext ac = ActionContext.getContext();
        Container cont = ac.getContainer();
        XWorkConverter xworkConverter = cont.getInstance(XWorkConverter.class);
        CompoundRootAccessor accessor = (CompoundRootAccessor)cont.getInstance(PropertyAccessor.class, CompoundRoot.class.getName());
        TextProvider prov = cont.getInstance(TextProvider.class, "system");
        boolean allow = "true".equals(cont.getInstance(String.class, "allowStaticMethodAccess"));
        OgnlValueStack aStack = new OgnlValueStack(xworkConverter, accessor, prov, allow);
        aStack.setOgnlUtil(cont.getInstance(OgnlUtil.class));
        aStack.setRoot(xworkConverter, accessor, this.root, allow);
        return aStack;
    }

    @Override
    public void clearContextValues() {
        ((OgnlContext)this.context).getValues().clear();
    }

    @Override
    public void setAcceptProperties(Set<Pattern> acceptedProperties) {
        this.securityMemberAccess.setAcceptProperties(acceptedProperties);
    }

    @Override
    public void setExcludeProperties(Set<Pattern> excludeProperties) {
        this.securityMemberAccess.setExcludeProperties(excludeProperties);
    }
}

