/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.swtimpl.NativeComponent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

class ModalDialogUtils {
    ModalDialogUtils() {
    }

    static void showModalDialog(Component component, final NativeModalComponent nativeModalComponent, final Runnable runnable) {
        Window window;
        Window window2 = window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        final JDialog dialog = Utils.IS_JAVA_6_OR_GREATER ? new JDialog(window, Dialog.ModalityType.APPLICATION_MODAL) : (window instanceof Dialog ? new JDialog((Dialog)window, true) : new JDialog((Frame)window, true));
        dialog.setUndecorated(true);
        dialog.setSize(0, 0);
        if (Utils.IS_WINDOWS) {
            Point location = component.getLocationOnScreen();
            location.x += component.getWidth() / 2 - 280;
            location.y += component.getHeight() / 2 - 200;
            dialog.setLocation(location);
        } else {
            dialog.setLocationRelativeTo(window);
        }
        dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                dialog.getContentPane().add(nativeModalComponent.createEmbeddableComponent(), "Center");
                nativeModalComponent.initializeNativePeer();
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(dialog){
                        private final /* synthetic */ JDialog val$dialog;
                        {
                            this.val$dialog = jDialog;
                        }

                        public void run() {
                            this.val$dialog.dispose();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        dialog.setVisible(true);
    }

    static class NativeModalComponent
    extends NativeComponent {
        NativeModalComponent() {
        }

        protected Component createEmbeddableComponent() {
            return super.createEmbeddableComponent(new HashMap<Object, Object>());
        }
    }
}

