/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.common.NetworkURLClassLoader;
import chrriis.common.SystemProperty;
import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.NativeSwing;
import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.InProcessMessagingInterface;
import chrriis.dj.nativeswing.swtimpl.LocalMessage;
import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.MessagingInterface;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.NativeInterfaceConfiguration;
import chrriis.dj.nativeswing.swtimpl.NativeInterfaceListener;
import chrriis.dj.nativeswing.swtimpl.OutProcessIOMessagingInterface;
import chrriis.dj.nativeswing.swtimpl.OutProcessSocketsMessagingInterface;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.widgets.Display;

public class NativeInterface {
    private static final boolean IS_SYNCING_MESSAGES = Boolean.parseBoolean(NSSystemPropertySWT.INTERFACE_SYNCMESSAGES.get());
    private static boolean isOpen;
    private static volatile NativeInterfaceConfiguration nativeInterfaceConfiguration;
    private static volatile boolean isInitialized;
    private static boolean isInProcess;
    private static final Object OPEN_CLOSE_SYNC_LOCK;
    private static final Object OPEN_STATE_LOCK;
    private static MessagingInterface messagingInterface;
    private static Display display;
    private static volatile boolean isEventPumpRunning;
    private static EventListenerList listenerList;
    private static volatile long lastProcessTime;

    static {
        OPEN_CLOSE_SYNC_LOCK = new Object();
        OPEN_STATE_LOCK = new Object();
        listenerList = new EventListenerList();
        lastProcessTime = Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isAlive() {
        Object object = OPEN_STATE_LOCK;
        synchronized (object) {
            return NativeInterface.isOpen() && messagingInterface.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOpen() {
        Object object = OPEN_STATE_LOCK;
        synchronized (object) {
            return isOpen;
        }
    }

    private static void checkOpen() {
        if (!NativeInterface.isOpen()) {
            throw new IllegalStateException("The native interface is not open! Please refer to the instructions to set it up properly.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Object object = OPEN_CLOSE_SYNC_LOCK;
        synchronized (object) {
            if (!NativeInterface.isOpen()) {
                return;
            }
            Object object2 = OPEN_STATE_LOCK;
            synchronized (object2) {
                isOpen = false;
                messagingInterface.destroy();
                messagingInterface = null;
            }
            NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
            int n = nativeInterfaceListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n2];
                listener.nativeInterfaceClosed();
                ++n2;
            }
        }
    }

    public static NativeInterfaceConfiguration getConfiguration() {
        if (nativeInterfaceConfiguration == null) {
            nativeInterfaceConfiguration = new NativeInterfaceConfiguration();
        }
        return nativeInterfaceConfiguration;
    }

    private static void loadClipboardDebuggingProperties() {
        try {
            Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (!systemClipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                return;
            }
            BufferedReader reader = new BufferedReader(new StringReader((String)systemClipboard.getData(DataFlavor.stringFlavor)));
            if ("[nativeswing debug]".equals(reader.readLine().trim().toLowerCase(Locale.ENGLISH))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    int index = line.indexOf(61);
                    if (index <= 0) break;
                    String propertyName = line.substring(0, index).trim();
                    String propertyValue = line.substring(index + 1).trim();
                    if (!propertyName.startsWith("nativeswing.")) continue;
                    System.setProperty(propertyName, propertyValue);
                }
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isInProcess() {
        Object object = OPEN_STATE_LOCK;
        synchronized (object) {
            return isInProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Object object = OPEN_CLOSE_SYNC_LOCK;
        synchronized (object) {
            if (NativeInterface.isInitialized()) {
                return;
            }
            if (SWT.getVersion() < 3617) {
                throw new IllegalStateException("The version of SWT that is required is 3.6M3 or later!");
            }
            if (nativeInterfaceConfiguration == null) {
                nativeInterfaceConfiguration = new NativeInterfaceConfiguration();
            }
            NativeSwing.initialize();
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                public void eventDispatched(AWTEvent e) {
                    KeyEvent ke = (KeyEvent)e;
                    if (ke.getID() == 401 && ke.getKeyCode() == 114 && ke.isControlDown() && ke.isAltDown() && ke.isShiftDown()) {
                        new Thread("Dump stack traces"){

                            public void run() {
                                CMN_dumpStackTraces cmnDumpStackTraces = new CMN_dumpStackTraces();
                                cmnDumpStackTraces.run(null);
                                if (!NativeInterface.isInProcess() && NativeInterface.isOpen()) {
                                    NativeInterface.syncSend(true, cmnDumpStackTraces);
                                }
                            }
                        }.start();
                    }
                }
            }, 8L);
            String inProcessProperty = NSSystemPropertySWT.INTERFACE_INPROCESS.get();
            isInProcess = inProcessProperty != null ? Boolean.parseBoolean(inProcessProperty) : Utils.IS_MAC;
            try {
                NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
                int n = nativeInterfaceListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NativeInterfaceListener listener = nativeInterfaceListenerArray[n2];
                    listener.nativeInterfaceInitialized();
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (NativeInterface.isInProcess()) {
                InProcess.initialize();
            }
            isInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open() {
        Object object = OPEN_CLOSE_SYNC_LOCK;
        synchronized (object) {
            if (NativeInterface.isOpen()) {
                return;
            }
            NativeInterface.initialize();
            NativeInterface.loadClipboardDebuggingProperties();
            if (NativeInterface.isInProcess()) {
                InProcess.createInProcessCommunicationChannel();
            } else {
                OutProcess.createOutProcessCommunicationChannel();
            }
            try {
                NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
                int n = nativeInterfaceListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NativeInterfaceListener listener = nativeInterfaceListenerArray[n2];
                    listener.nativeInterfaceOpened();
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean notifyKilled() {
        Object object = OPEN_STATE_LOCK;
        synchronized (object) {
            isOpen = false;
            messagingInterface = null;
        }
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
            int n = nativeInterfaceListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n2];
                listener.nativeInterfaceClosed();
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!OutProcess.isNativeSide() && nativeInterfaceConfiguration.isNativeSideRespawnedOnError()) {
            OutProcess.createOutProcessCommunicationChannel();
            return true;
        }
        return false;
    }

    static void notifyRespawned() {
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
            int n = nativeInterfaceListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n2];
                listener.nativeInterfaceOpened();
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private NativeInterface() {
    }

    static Object syncSend(boolean isTargetNativeSide, Message message) {
        NativeInterface.checkOpen();
        if (message instanceof LocalMessage) {
            LocalMessage localMessage = (LocalMessage)message;
            return localMessage.runCommand();
        }
        return NativeInterface.getMessagingInterface(!isTargetNativeSide).syncSend(message);
    }

    static void asyncSend(boolean isTargetNativeSide, Message message) {
        if (IS_SYNCING_MESSAGES) {
            NativeInterface.syncSend(isTargetNativeSide, message);
        } else {
            NativeInterface.checkOpen();
            if (message instanceof LocalMessage) {
                LocalMessage localMessage = (LocalMessage)message;
                localMessage.runCommand();
                return;
            }
            NativeInterface.getMessagingInterface(!isTargetNativeSide).asyncSend(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MessagingInterface getMessagingInterface(boolean isNativeSide) {
        Object object = OPEN_STATE_LOCK;
        synchronized (object) {
            if (NativeInterface.isInProcess()) {
                if (isNativeSide) {
                    InProcessMessagingInterface.SWTInProcessMessagingInterface swtInProcessMessagingInterface = (InProcessMessagingInterface.SWTInProcessMessagingInterface)((InProcessMessagingInterface.SwingInProcessMessagingInterface)messagingInterface).getMirrorMessagingInterface();
                    return swtInProcessMessagingInterface;
                }
                InProcessMessagingInterface.SwingInProcessMessagingInterface swingInProcessMessagingInterface = (InProcessMessagingInterface.SwingInProcessMessagingInterface)messagingInterface;
                return swingInProcessMessagingInterface;
            }
            if (isNativeSide) {
                if (messagingInterface instanceof OutProcessSocketsMessagingInterface.SWTOutProcessSocketsMessagingInterface) {
                    OutProcessSocketsMessagingInterface.SWTOutProcessSocketsMessagingInterface swtOutProcessSocketsMessagingInterface = (OutProcessSocketsMessagingInterface.SWTOutProcessSocketsMessagingInterface)messagingInterface;
                    return swtOutProcessSocketsMessagingInterface;
                }
                OutProcessIOMessagingInterface.SWTOutProcessIOMessagingInterface swtOutProcessIOMessagingInterface = (OutProcessIOMessagingInterface.SWTOutProcessIOMessagingInterface)messagingInterface;
                return swtOutProcessIOMessagingInterface;
            }
            if (messagingInterface instanceof OutProcessSocketsMessagingInterface.SwingOutProcessSocketsMessagingInterface) {
                OutProcessSocketsMessagingInterface.SwingOutProcessSocketsMessagingInterface swingOutProcessSocketsMessagingInterface = (OutProcessSocketsMessagingInterface.SwingOutProcessSocketsMessagingInterface)messagingInterface;
                return swingOutProcessSocketsMessagingInterface;
            }
            OutProcessIOMessagingInterface.SwingOutProcessIOMessagingInterface swingOutProcessIOMessagingInterface = (OutProcessIOMessagingInterface.SwingOutProcessIOMessagingInterface)messagingInterface;
            return swingOutProcessIOMessagingInterface;
        }
    }

    public static Display getDisplay() {
        return display;
    }

    public static boolean isUIThread(boolean isNativeSide) {
        if (!NativeInterface.isAlive()) {
            throw new IllegalStateException("The native interface is not alive!");
        }
        return NativeInterface.getMessagingInterface(isNativeSide).isUIThread();
    }

    static void checkUIThread(boolean isNativeSide) {
        if (!NativeInterface.isAlive()) {
            throw new IllegalStateException("The native interface is not alive!");
        }
        NativeInterface.getMessagingInterface(isNativeSide).checkUIThread();
    }

    public static void runEventPump() {
        if (!NativeInterface.isInitialized()) {
            throw new IllegalStateException("Cannot run the event pump when the interface is not initialized!");
        }
        if (isEventPumpRunning) {
            throw new IllegalStateException("runEventPump was already called and can only be called once (the first call should be at the end of the main method)!");
        }
        isEventPumpRunning = true;
        if (NativeInterface.isInProcess()) {
            InProcess.runEventPump();
        }
    }

    public static void addNativeInterfaceListener(NativeInterfaceListener listener) {
        listenerList.add(NativeInterfaceListener.class, listener);
    }

    public static void removeNativeInterfaceListener(NativeInterfaceListener listener) {
        listenerList.remove(NativeInterfaceListener.class, listener);
    }

    public static NativeInterfaceListener[] getNativeInterfaceListeners() {
        return (NativeInterfaceListener[])listenerList.getListeners(NativeInterfaceListener.class);
    }

    public static void main(String[] args) throws Exception {
        OutProcess.runNativeSide(args);
    }

    private static class CMJ_unlockSystemIn
    extends CommandMessage {
        private CMJ_unlockSystemIn() {
        }

        public Object run(Object[] args) throws Exception {
            new Message().asyncSend(true);
            return null;
        }
    }

    private static class CMN_dumpStackTraces
    extends CommandMessage {
        private CMN_dumpStackTraces() {
        }

        public Object run(Object[] args) {
            Utils.dumpStackTraces();
            return null;
        }
    }

    static class InProcess {
        InProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void createInProcessCommunicationChannel() {
            Object object = OPEN_STATE_LOCK;
            synchronized (object) {
                NativeInterface.messagingInterface = InProcess.createInProcessMessagingInterface();
                isOpen = true;
            }
        }

        private static void initialize() {
            Device.DEBUG = Boolean.parseBoolean(NSSystemPropertySWT.SWT_DEVICE_DEBUG.get());
            NativeInterface.display = Display.getCurrent();
            if (display == null && Boolean.parseBoolean(System.getProperty("nativeswing.interface.inprocess.useExternalSWTDisplay"))) {
                NativeInterface.display = Display.getDefault();
                if (display.getThread() == Thread.currentThread()) {
                    display.dispose();
                    NativeInterface.display = null;
                    System.setProperty("nativeswing.interface.inprocess.useExternalSWTDisplay", "false");
                }
            }
            if (display == null) {
                DeviceData data = new DeviceData();
                data.debug = Boolean.parseBoolean(System.getProperty("nativeswing.swt.devicedata.debug"));
                data.tracking = Boolean.parseBoolean(System.getProperty("nativeswing.swt.devicedata.tracking"));
                try {
                    NativeInterface.display = new Display(data);
                }
                catch (SWTException e) {
                    if (Utils.IS_MAC && e.code == 22) {
                        throw new IllegalStateException("An error occurred while creating the SWT Display! On a Mac, the Native Interface can only be initialized from the main thread and the Java process needs to be started with the \"-XstartOnFirstThread\" VM parameter.", e);
                    }
                    throw e;
                }
            }
        }

        private static MessagingInterface createInProcessMessagingInterface() {
            return new InProcessMessagingInterface.SWTInProcessMessagingInterface(display).getMirrorMessagingInterface();
        }

        static void runEventPump() {
            if (Boolean.parseBoolean(System.getProperty("nativeswing.interface.inprocess.useExternalSWTDisplay")) && display.getThread() != Thread.currentThread()) {
                return;
            }
            InProcess.startAutoShutdownThread();
            while (isEventPumpRunning) {
                try {
                    if (display.readAndDispatch() || !isEventPumpRunning) continue;
                    display.sleep();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            display.dispose();
        }

        static void startAutoShutdownThread() {
            final Thread displayThread = display.getThread();
            Thread autoShutdownThread = new Thread("NativeSwing Auto-Shutdown"){
                protected Thread[] activeThreads;
                {
                    super($anonymous0);
                    this.activeThreads = new Thread[1024];
                }

                public void run() {
                    boolean isAlive = true;
                    block2: while (isAlive) {
                        ThreadGroup group;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ThreadGroup parentGroup = group = Thread.currentThread().getThreadGroup();
                        while ((parentGroup = parentGroup.getParent()) != null) {
                            group = parentGroup;
                        }
                        isAlive = false;
                        int i = group.enumerate(this.activeThreads, true) - 1;
                        while (i >= 0) {
                            Thread t = this.activeThreads[i];
                            if (t != displayThread && !t.isDaemon() && t.isAlive()) {
                                isAlive = true;
                                continue block2;
                            }
                            --i;
                        }
                    }
                    display.asyncExec(new Runnable(){

                        public void run() {
                            isEventPumpRunning = false;
                        }
                    });
                }
            };
            autoShutdownThread.setDaemon(true);
            autoShutdownThread.start();
        }
    }

    static class OutProcess {
        private static final boolean IS_PROCESS_IO_CHANNEL_MODE = "processio".equals(NSSystemPropertySWT.INTERFACE_OUTPROCESS_COMMUNICATION.get());
        private static volatile int pid;

        OutProcess() {
        }

        static boolean isNativeSide() {
            return display != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void createOutProcessCommunicationChannel() {
            Object object = OPEN_STATE_LOCK;
            synchronized (object) {
                int i = 2;
                while (i >= 0) {
                    try {
                        NativeInterface.messagingInterface = OutProcess.createOutProcessMessagingInterface();
                        break;
                    }
                    catch (RuntimeException e) {
                        if (i == 0) {
                            throw e;
                        }
                        --i;
                    }
                }
                isOpen = true;
            }
            Properties nativeProperties = new Properties();
            Properties properties = System.getProperties();
            for (Object key : properties.keySet()) {
                Object value;
                if (!(key instanceof String) || !((value = properties.get(key)) instanceof String)) continue;
                nativeProperties.setProperty((String)key, (String)value);
            }
            new CMN_setProperties().syncExec(true, nativeProperties);
        }

        /*
         * WARNING - void declaration
         */
        private static Process createProcess(String localHostAddress, int port, int pid) {
            String[] flags;
            int n;
            String[] nativeClassPathReferenceResources;
            ArrayList<String> classPathList = new ArrayList<String>();
            String pathSeparator = SystemProperty.PATH_SEPARATOR.get();
            ArrayList<Object> referenceList = new ArrayList<Object>();
            Class<?>[] nativeClassPathReferenceClasses = nativeInterfaceConfiguration.getNativeClassPathReferenceClasses();
            if (nativeClassPathReferenceClasses != null) {
                referenceList.addAll(Arrays.asList(nativeClassPathReferenceClasses));
            }
            if ((nativeClassPathReferenceResources = nativeInterfaceConfiguration.getNativeClassPathReferenceResources()) != null) {
                referenceList.addAll(Arrays.asList(nativeClassPathReferenceResources));
            }
            ArrayList<String> optionalReferenceList = new ArrayList<String>();
            referenceList.add(NativeSwing.class);
            referenceList.add(NativeInterface.class);
            referenceList.add("org/eclipse/swt/widgets/Display.class");
            optionalReferenceList.add("org/mozilla/xpcom/Mozilla.class");
            optionalReferenceList.add("org/mozilla/interfaces/nsIWebBrowser.class");
            for (String optionalReference : optionalReferenceList) {
                if (NativeInterface.class.getClassLoader().getResource(optionalReference) == null) continue;
                referenceList.add(optionalReference);
            }
            boolean isProxyClassLoaderUsed = Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_FORCEPROXYCLASSLOADER.get());
            if (!isProxyClassLoaderUsed) {
                for (Object e : referenceList) {
                    File clazzClassPath;
                    if (e instanceof Class) {
                        clazzClassPath = Utils.getClassPathFile((Class)e);
                    } else {
                        clazzClassPath = Utils.getClassPathFile((String)e);
                        if (NativeInterface.class.getClassLoader().getResource((String)e) == null) {
                            throw new IllegalStateException("A resource that is needed in the classpath is missing: " + e);
                        }
                    }
                    File file = clazzClassPath = e instanceof Class ? Utils.getClassPathFile((Class)e) : Utils.getClassPathFile((String)e);
                    if (clazzClassPath != null) {
                        String path = clazzClassPath.getAbsolutePath();
                        if (classPathList.contains(path)) continue;
                        classPathList.add(path);
                        continue;
                    }
                    isProxyClassLoaderUsed = true;
                }
            }
            if (isProxyClassLoaderUsed) {
                classPathList.clear();
                File file = new File(SystemProperty.JAVA_IO_TMPDIR.get(), ".djnativeswing/classpath");
                Utils.deleteAll(file);
                String classPath = String.valueOf(NetworkURLClassLoader.class.getName().replace('.', '/')) + ".class";
                File mainClassFile = new File(file, classPath);
                mainClassFile.getParentFile().mkdirs();
                if (!mainClassFile.exists()) {
                    try {
                        int n2;
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(mainClassFile));
                        BufferedInputStream in = new BufferedInputStream(NativeInterface.class.getResourceAsStream("/" + classPath));
                        byte[] bytes = new byte[1024];
                        while ((n2 = in.read(bytes)) != -1) {
                            void n3;
                            out.write(bytes, 0, (int)n3);
                        }
                        in.close();
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    mainClassFile.deleteOnExit();
                }
                classPathList.add(file.getAbsolutePath());
            }
            StringBuilder stringBuilder = new StringBuilder();
            int i = 0;
            while (i < classPathList.size()) {
                if (i > 0) {
                    stringBuilder.append(pathSeparator);
                }
                stringBuilder.append((String)classPathList.get(i));
                ++i;
            }
            String javaHome = SystemProperty.JAVA_HOME.get();
            String[] candidateBinaries = new String[]{new File(javaHome, "bin/java").getAbsolutePath(), new File("/usr/lib/java").getAbsolutePath(), "java"};
            Process p = null;
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(null);
            String[] peerVMParams = nativeInterfaceConfiguration.getPeerVMParams();
            if (peerVMParams != null) {
                String[] stringArray = peerVMParams;
                n = peerVMParams.length;
                int n4 = 0;
                while (n4 < n) {
                    String param = stringArray[n4];
                    argList.add(param);
                    ++n4;
                }
            }
            String[] stringArray = flags = new String[]{NSSystemPropertySWT.INTERFACE_SYNCMESSAGES.getName(), NSSystemPropertySWT.INTERFACE_DEBUG_PRINTMESSAGES.getName(), NSSystemPropertySWT.PEERVM_DEBUG_PRINTSTARTMESSAGE.getName(), NSSystemPropertySWT.SWT_DEVICE_DEBUG.getName(), "nativeswing.swt.devicedata.debug", "nativeswing.swt.devicedata.tracking"};
            int n5 = flags.length;
            n = 0;
            while (n < n5) {
                String flag = stringArray[n];
                if (Boolean.parseBoolean(System.getProperty(flag))) {
                    argList.add("-D" + flag + "=true");
                }
                ++n;
            }
            argList.add("-Dnativeswing.localhostaddress=" + localHostAddress);
            argList.add("-classpath");
            argList.add(stringBuilder.toString());
            if (isProxyClassLoaderUsed) {
                argList.add(NetworkURLClassLoader.class.getName());
                argList.add(WebServer.getDefaultWebServer().getClassPathResourceURL("", ""));
            }
            argList.add(NativeInterface.class.getName());
            argList.add(String.valueOf(pid));
            argList.add(String.valueOf(port));
            String javaVersion = SystemProperty.JAVA_VERSION.get();
            if (javaVersion != null && javaVersion.compareTo("1.6.0_10") >= 0 && "Sun Microsystems Inc.".equals(SystemProperty.JAVA_VENDOR.get())) {
                boolean isTryingAppletCompatibility = true;
                if (peerVMParams != null) {
                    String[] stringArray2 = peerVMParams;
                    int n6 = peerVMParams.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        String peerVMParam = stringArray2[n7];
                        if (peerVMParam.startsWith("-Xbootclasspath/a:")) {
                            isTryingAppletCompatibility = false;
                            break;
                        }
                        ++n7;
                    }
                }
                if (isTryingAppletCompatibility) {
                    File[] deploymentFiles = new File[]{new File(javaHome, "lib/deploy.jar"), new File(javaHome, "lib/plugin.jar"), new File(javaHome, "lib/javaws.jar")};
                    ArrayList<String> argListX = new ArrayList<String>();
                    argListX.add(candidateBinaries[0]);
                    StringBuilder sbX = new StringBuilder();
                    int i2 = 0;
                    while (i2 < deploymentFiles.length) {
                        File deploymentFile;
                        if (i2 != 0) {
                            sbX.append(pathSeparator);
                        }
                        if ((deploymentFile = deploymentFiles[i2]).exists()) {
                            sbX.append(deploymentFile.getAbsolutePath());
                        }
                        ++i2;
                    }
                    if (sbX.indexOf(" ") != -1) {
                        argListX.add("\"-Xbootclasspath/a:" + sbX + "\"");
                    } else {
                        argListX.add("-Xbootclasspath/a:" + sbX);
                    }
                    argListX.addAll(argList.subList(1, argList.size()));
                    if (Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_DEBUG_PRINTCOMMANDLINE.get())) {
                        System.err.println("Native Command: " + Arrays.toString(argListX.toArray()));
                    }
                    try {
                        p = new ProcessBuilder(argListX).start();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (p == null) {
                String[] stringArray3 = candidateBinaries;
                int n8 = candidateBinaries.length;
                int n9 = 0;
                while (n9 < n8) {
                    String candidateBinary = stringArray3[n9];
                    argList.set(0, candidateBinary);
                    if (Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_DEBUG_PRINTCOMMANDLINE.get())) {
                        System.err.println("Native Command: " + Arrays.toString(argList.toArray()));
                    }
                    try {
                        p = new ProcessBuilder(argList).start();
                        break;
                    }
                    catch (IOException iOException) {
                        ++n9;
                    }
                }
            }
            if (p == null) {
                throw new IllegalStateException("Failed to spawn the VM!");
            }
            return p;
        }

        private static MessagingInterface createOutProcessMessagingInterface() {
            Process p;
            int port;
            boolean isProcessIOChannelMode;
            String localHostAddress = Utils.getLocalHostAddress();
            if (localHostAddress == null) {
                throw new IllegalStateException("Failed to find a suitable local host address to communicate with a spawned VM!");
            }
            boolean isCreatingProcess = Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_CREATE.get("true"));
            boolean bl = isProcessIOChannelMode = IS_PROCESS_IO_CHANNEL_MODE && isCreatingProcess;
            if (isProcessIOChannelMode) {
                port = 0;
            } else {
                port = Integer.parseInt(NSSystemPropertySWT.INTERFACE_PORT.get("-1"));
                if (port <= 0) {
                    ServerSocket serverSocket;
                    try {
                        serverSocket = new ServerSocket();
                        serverSocket.setReuseAddress(false);
                        serverSocket.bind(new InetSocketAddress(InetAddress.getByName(localHostAddress), 0));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    port = serverSocket.getLocalPort();
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            if (isCreatingProcess) {
                p = OutProcess.createProcess(localHostAddress, port, ++pid);
                if (!isProcessIOChannelMode) {
                    OutProcess.connectStream(System.out, p.getInputStream(), pid);
                }
                OutProcess.connectStream(System.err, p.getErrorStream(), pid);
            } else {
                p = null;
            }
            if (isProcessIOChannelMode) {
                return new OutProcessIOMessagingInterface.SwingOutProcessIOMessagingInterface(p.getInputStream(), p.getOutputStream(), false, p);
            }
            Exception exception = null;
            Socket socket = null;
            long startTime = System.currentTimeMillis();
            while (true) {
                if (p != null) {
                    try {
                        p.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
                try {
                    socket = new Socket(localHostAddress, port);
                    exception = null;
                }
                catch (Exception e) {
                    exception = e;
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - startTime < 10000L) continue;
                }
                break;
            }
            if (socket == null) {
                if (p != null) {
                    p.destroy();
                }
                if (exception == null) {
                    throw new IllegalStateException("Failed to connect to spawned VM! The native side process was already terminated.");
                }
                throw new IllegalStateException("Failed to connect to spawned VM!", exception);
            }
            return new OutProcessSocketsMessagingInterface.SwingOutProcessSocketsMessagingInterface(socket, false, p);
        }

        private static void connectStream(final PrintStream out, InputStream in, int pid) {
            final BufferedInputStream bin = new BufferedInputStream(in);
            Thread streamThread = new Thread("NativeSwing Stream Connector", pid){
                private IOStreamFormatter byteProcessor;
                {
                    super($anonymous0);
                    this.byteProcessor = new IOStreamFormatter(n);
                }

                public void run() {
                    try {
                        int i;
                        byte[] bytes = new byte[1024];
                        while ((i = bin.read(bytes)) != -1) {
                            byte[] result = this.byteProcessor.process(bytes, 0, i);
                            try {
                                out.write(result);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            streamThread.setDaemon(true);
            streamThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        static void runNativeSide(String[] args) throws IOException {
            block32: {
                pid = Integer.parseInt(args[0]);
                if (Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_DEBUG_PRINTSTARTMESSAGE.get())) {
                    System.err.println("Starting peer VM #" + pid);
                }
                var2_2 = NativeInterface.access$0();
                synchronized (var2_2) {
                    NativeInterface.access$2(true);
                }
                port = Integer.parseInt(args[1]);
                isProcessIOChannelMode = port <= 0;
                socket = null;
                if (!isProcessIOChannelMode) {
                    serverSocket = null;
                    startTime = System.currentTimeMillis();
                    while (true) {
                        try {
                            serverSocket = new ServerSocket();
                            serverSocket.setReuseAddress(true);
                            serverSocket.bind(new InetSocketAddress(Utils.getLocalHostAddress(), port));
                            exception = null;
                        }
                        catch (IOException e) {
                            exception = e;
                            if (serverSocket != null) {
                                try {
                                    serverSocket.close();
                                }
                                catch (Exception var10_14) {
                                    // empty catch block
                                }
                            }
                            serverSocket = null;
                            try {
                                Thread.sleep(200L);
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (System.currentTimeMillis() - startTime < 5000L) continue;
                        }
                        break;
                    }
                    if (serverSocket == null) {
                        if (exception == null) {
                            throw new IllegalStateException("Failed to create the server socket for native side communication!");
                        }
                        throw exception;
                    }
                    serverSocket_ = serverSocket;
                    if (!Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_KEEPALIVE.get())) {
                        shutdownThread = new Thread("NativeSwing Shutdown", (ServerSocket)serverSocket_){
                            private final /* synthetic */ ServerSocket val$serverSocket_;
                            {
                                this.val$serverSocket_ = serverSocket;
                                super($anonymous0);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                boolean isNull;
                                try {
                                    2.sleep(10000L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                Object object = OPEN_STATE_LOCK;
                                synchronized (object) {
                                    isNull = messagingInterface == null;
                                }
                                if (isNull) {
                                    try {
                                        this.val$serverSocket_.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        };
                        shutdownThread.setDaemon(true);
                        shutdownThread.start();
                    }
                    try {
                        socket = serverSocket.accept();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("The native side did not receive an incoming connection!");
                    }
                }
                Device.DEBUG = Boolean.parseBoolean(NSSystemPropertySWT.SWT_DEVICE_DEBUG.get());
                data = new DeviceData();
                data.debug = Boolean.parseBoolean(System.getProperty("nativeswing.swt.devicedata.debug"));
                data.tracking = Boolean.parseBoolean(System.getProperty("nativeswing.swt.devicedata.tracking"));
                NativeInterface.access$3(new Display(data));
                Display.setAppName("DJ Native Swing");
                if (!isProcessIOChannelMode) break block32;
                sysout = System.out;
                sysin = System.in;
                outInterface = new OutProcessIOMessagingInterface.SWTOutProcessIOMessagingInterface(sysin, sysout, true, NativeInterface.access$4());
                serverSocket_ = NativeInterface.access$0();
                synchronized (serverSocket_) {
                    NativeInterface.access$1(outInterface);
                }
                System.setIn(new InputStream(){

                    public int read() throws IOException {
                        while (true) {
                            try {
                                while (true) {
                                    Thread.sleep(Long.MAX_VALUE);
                                }
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            break;
                        }
                    }
                });
                System.setOut(new PrintStream(new OutputStream(pid){
                    private IOStreamFormatter byteProcessor;
                    {
                        this.byteProcessor = new IOStreamFormatter(n);
                    }

                    public void write(int b) throws IOException {
                        this.sendBytes(new byte[]{(byte)b}, 0, 1);
                    }

                    public void write(byte[] b) throws IOException {
                        this.sendBytes(b, 0, b.length);
                    }

                    public void write(byte[] b, int off, int len) throws IOException {
                        this.sendBytes(b, off, len);
                    }

                    private void sendBytes(byte[] bytes, int offset, int length) {
                        try {
                            new CMJ_systemOut().asyncExec(false, new Object[]{this.byteProcessor.process(bytes, offset, length)});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }));
                if (Utils.IS_WINDOWS) {
                    var10_15 = NativeInterface.access$0();
                    synchronized (var10_15) {
                        messagingInterface_ = NativeInterface.access$8();
                    }
                    new Thread("System.in unlocker"){

                        public void run() {
                            while (messagingInterface_.isAlive()) {
                                if (System.currentTimeMillis() - lastProcessTime > 100L) {
                                    new CMJ_unlockSystemIn().asyncExec(false, new Object[0]);
                                    lastProcessTime = System.currentTimeMillis();
                                }
                                try {
                                    5.sleep(100L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }.start();
                }
                ** GOTO lbl104
            }
            outInterface = new OutProcessSocketsMessagingInterface.SWTOutProcessSocketsMessagingInterface(socket, true, NativeInterface.access$4());
            var7_17 = NativeInterface.access$0();
            synchronized (var7_17) {
                NativeInterface.access$1(outInterface);
                // MONITOREXIT @DISABLED, blocks:[7, 10] lbl93 : MonitorExitStatement: MONITOREXIT : var7_17
                if (true) ** GOTO lbl104
            }
            do {
                try {
                    NativeInterface.access$10(System.currentTimeMillis());
                    if (!NativeInterface.access$4().readAndDispatch()) {
                        NativeInterface.access$10(0x7FFFFFFFFFFFFFFFL);
                        NativeInterface.access$4().sleep();
                    }
                    NativeInterface.access$10(0x7FFFFFFFFFFFFFFFL);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
lbl104:
                // 4 sources

            } while (NativeInterface.access$4() != null && !NativeInterface.access$4().isDisposed());
        }

        private static class CMJ_systemOut
        extends CommandMessage {
            private CMJ_systemOut() {
            }

            public Object run(Object[] args) {
                try {
                    System.out.write((byte[])args[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }

        private static class CMN_setProperties
        extends CommandMessage {
            private CMN_setProperties() {
            }

            public Object run(Object[] args) {
                Properties systemProperties = System.getProperties();
                Properties properties = (Properties)args[0];
                for (Object o : properties.keySet()) {
                    if (systemProperties.containsKey(o)) continue;
                    try {
                        System.setProperty((String)o, properties.getProperty((String)o));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }

        private static class IOStreamFormatter {
            private ByteArrayOutputStream baos = new ByteArrayOutputStream();
            private byte lastByte = (byte)Utils.LINE_SEPARATOR.charAt(Utils.LINE_SEPARATOR.length() - 1);
            private boolean isAddingMessage = true;
            private final byte[] prefixBytes;

            public IOStreamFormatter(int pid) {
                this.prefixBytes = ("NativeSwing[" + pid + "]: ").getBytes();
            }

            public byte[] process(byte[] bytes, int offset, int length) throws IOException {
                this.baos.reset();
                int i = offset;
                while (i < length) {
                    byte b = bytes[i];
                    if (this.isAddingMessage) {
                        this.baos.write(this.prefixBytes);
                    }
                    this.isAddingMessage = b == this.lastByte;
                    this.baos.write(b);
                    ++i;
                }
                return this.baos.toByteArray();
            }
        }
    }
}

