/*
 * Decompiled with CFR 0.152.
 */
package chrriis.common;

import chrriis.common.Filter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUtils {
    private UIUtils() {
    }

    public static Rectangle[] subtract(Rectangle[] rects, Rectangle rect) {
        return UIUtils.subtract(rects, new Rectangle[]{rect});
    }

    public static Rectangle[] subtract(Rectangle[] rects1, Rectangle[] rects2) {
        ArrayList<Rectangle> rectangleList = new ArrayList<Rectangle>(Arrays.asList(rects1));
        ArrayList<Rectangle> newRectangleList = new ArrayList<Rectangle>();
        int i = 0;
        while (i < rects2.length) {
            Rectangle r2 = rects2[i];
            for (Rectangle r1 : rectangleList) {
                if (r1.intersects(r2)) {
                    UIUtils.subtract(r1, r2, newRectangleList);
                    continue;
                }
                newRectangleList.add((Rectangle)r1.clone());
            }
            rectangleList.clear();
            if (newRectangleList.isEmpty()) break;
            rectangleList.addAll(newRectangleList);
            newRectangleList.clear();
            ++i;
        }
        return rectangleList.toArray(new Rectangle[0]);
    }

    private static void subtract(Rectangle r1, Rectangle r2, List<Rectangle> resultList) {
        boolean bottom;
        boolean left = r2.x <= r1.x && r2.x + r2.width > r1.x;
        boolean right = r2.x < r1.x + r1.width && r2.x + r2.width >= r1.x + r1.width;
        boolean top = r2.y <= r1.y && r2.y + r2.height > r1.y;
        boolean bl = bottom = r2.y < r1.y + r1.height && r2.y + r2.height >= r1.y + r1.height;
        if (!(left && right && top && bottom)) {
            if (left && right && top) {
                int y = r2.y + r2.height;
                int height = r1.y + r1.height - y;
                resultList.add(new Rectangle(r1.x, y, r1.width, height));
            } else if (left && right && bottom) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
            } else if (top && bottom && left) {
                int x = r2.x + r2.width;
                int width = r1.x + r1.width - x;
                resultList.add(new Rectangle(x, r1.y, width, r1.height));
            } else if (top && bottom && right) {
                resultList.add(new Rectangle(r1.x, r1.y, r2.x - r1.x, r1.height));
            } else if (left && top) {
                int x = r2.x + r2.width;
                int y = r2.y + r2.height;
                resultList.add(new Rectangle(x, r1.y, r1.x + r1.width - x, y - r1.y));
                resultList.add(new Rectangle(r1.x, y, r1.width, r1.y + r1.height - y));
            } else if (left && bottom) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int x = r2.x + r2.width;
                resultList.add(new Rectangle(x, r2.y, r1.x + r1.width - x, r1.y + r1.height - r2.y));
            } else if (right && top) {
                int y = r2.y + r2.height;
                resultList.add(new Rectangle(r1.x, r1.y, r2.x - r1.x, y - r1.y));
                resultList.add(new Rectangle(r1.x, y, r1.width, r1.y + r1.height - y));
            } else if (right && bottom) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                resultList.add(new Rectangle(r1.x, r2.y, r2.x - r1.x, r1.y + r1.height - r2.y));
            } else if (left && right) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int y = r2.y + r2.height;
                resultList.add(new Rectangle(r1.x, y, r1.width, r1.y + r1.height - y));
            } else if (top && bottom) {
                resultList.add(new Rectangle(r1.x, r1.y, r2.x - r1.x, r1.height));
                int x = r2.x + r2.width;
                resultList.add(new Rectangle(x, r1.y, r1.x + r1.width - x, r1.height));
            } else if (left) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int y = r2.y + r2.height;
                resultList.add(new Rectangle(r1.x, y, r1.width, r1.y + r1.height - y));
                int x = r2.x + r2.width;
                resultList.add(new Rectangle(x, r2.y, r1.x + r1.width - x, r2.height));
            } else if (right) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int y = r2.y + r2.height;
                resultList.add(new Rectangle(r1.x, y, r1.width, r1.y + r1.height - y));
                resultList.add(new Rectangle(r1.x, r2.y, r2.x - r1.x, r2.height));
            } else if (top) {
                resultList.add(new Rectangle(r1.x, r1.y, r2.x - r1.x, r1.height));
                int x = r2.x + r2.width;
                resultList.add(new Rectangle(x, r1.y, r1.x + r1.width - x, r1.height));
                int y = r2.y + r2.height;
                resultList.add(new Rectangle(r2.x, y, r2.width, r1.y + r1.height - y));
            } else if (bottom) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int height = r1.y + r1.height - r2.y;
                resultList.add(new Rectangle(r1.x, r2.y, r2.x - r1.x, height));
                int x = r2.x + r2.width;
                resultList.add(new Rectangle(x, r2.y, r1.x + r1.width - x, height));
            } else {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int y = r2.y + r2.height;
                resultList.add(new Rectangle(r1.x, y, r1.width, r1.y + r1.height - y));
                resultList.add(new Rectangle(r1.x, r2.y, r2.x - r1.x, r2.height));
                int x = r2.x + r2.width;
                resultList.add(new Rectangle(x, r2.y, r1.x + r1.width - x, r2.height));
            }
        }
    }

    public static Rectangle[] getComponentVisibleArea(Component component, Filter<Component> filter, boolean traverseChildren) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(component);
        int width = component.getWidth();
        int height = component.getHeight();
        if (windowAncestor == null || !component.isShowing() || width <= 0 || height <= 0) {
            return new Rectangle[0];
        }
        Rectangle tempRectangle = new Rectangle(0, 0, width, height);
        Rectangle[] shape = new Rectangle[]{new Rectangle(width, height)};
        if (component instanceof Container) {
            Container container = (Container)component;
            int i = container.getComponentCount() - 1;
            while (i >= 0) {
                Component c = container.getComponent(i);
                if (c == component) break;
                if (c.isVisible() && filter.accept(c)) {
                    tempRectangle.setBounds(c.getX(), c.getY(), c.getWidth(), c.getHeight());
                    shape = UIUtils.subtract(shape, tempRectangle);
                }
                --i;
            }
        }
        if (shape.length == 0) {
            return shape;
        }
        Component c = component;
        Container parent = c.getParent();
        while (parent != null && !(parent instanceof Window)) {
            tempRectangle.setBounds(0, 0, parent.getWidth(), parent.getHeight());
            Rectangle parentBounds = SwingUtilities.convertRectangle(parent, tempRectangle, component);
            ArrayList<Rectangle> newRectangleList = new ArrayList<Rectangle>();
            Rectangle[] rectangleArray = shape;
            int n = shape.length;
            int n2 = 0;
            while (n2 < n) {
                Rectangle rectangle = rectangleArray[n2];
                Rectangle r = rectangle.intersection(parentBounds);
                if (!r.isEmpty()) {
                    newRectangleList.add(r);
                }
                ++n2;
            }
            shape = newRectangleList.toArray(new Rectangle[0]);
            if (parent instanceof JComponent && !((JComponent)parent).isOptimizedDrawingEnabled()) {
                shape = UIUtils.getChildrenVisibleArea(component, filter, shape, parent, c, traverseChildren);
            }
            if (shape.length == 0) {
                return shape;
            }
            c = parent;
            parent = c.getParent();
        }
        return shape;
    }

    private static Rectangle[] getChildrenVisibleArea(Component component, Filter<Component> filter, Rectangle[] shape, Container parent, Component c, boolean traverseChildren) {
        Component[] children;
        if (parent instanceof JLayeredPane) {
            JLayeredPane layeredPane = (JLayeredPane)parent;
            ArrayList<Component> childList = new ArrayList<Component>(layeredPane.getComponentCount() - 1);
            int layer = c == null ? Integer.MIN_VALUE : layeredPane.getLayer(c);
            int i = layeredPane.highestLayer();
            while (i >= layer) {
                Component[] components;
                Component[] componentArray = components = layeredPane.getComponentsInLayer(i);
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    Component child = componentArray[n2];
                    if (child == c) break;
                    childList.add(child);
                    ++n2;
                }
                --i;
            }
            children = childList.toArray(new Component[0]);
        } else {
            children = parent.getComponents();
        }
        Rectangle tempRectangle = new Rectangle();
        int i = 0;
        while (i < children.length) {
            Component child = children[i];
            if (child == c) break;
            if (child.isVisible()) {
                if (parent instanceof JRootPane && ((JRootPane)parent).getGlassPane() == child) {
                    if (child instanceof JComponent) {
                        Component[] componentArray = ((JComponent)child).getComponents();
                        int n = componentArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Component child2 = componentArray[n3];
                            if (child2.isVisible()) {
                                if (filter.accept(child2)) {
                                    tempRectangle.setBounds(child2.getX(), child2.getY(), child2.getWidth(), child2.getHeight());
                                    shape = UIUtils.subtract(shape, SwingUtilities.convertRectangle(child, tempRectangle, component));
                                } else if (traverseChildren && child2 instanceof Container) {
                                    shape = UIUtils.getChildrenVisibleArea(component, filter, shape, (Container)child2, null, traverseChildren);
                                }
                            }
                            ++n3;
                        }
                    }
                } else if (filter.accept(child)) {
                    tempRectangle.setBounds(child.getX(), child.getY(), child.getWidth(), child.getHeight());
                    shape = UIUtils.subtract(shape, SwingUtilities.convertRectangle(parent, tempRectangle, component));
                } else if (traverseChildren && child instanceof Container) {
                    shape = UIUtils.getChildrenVisibleArea(component, filter, shape, (Container)child, null, traverseChildren);
                }
            }
            ++i;
        }
        return shape;
    }

    public static Rectangle getBounds(Rectangle[] rectangles) {
        Rectangle bounds = new Rectangle();
        if (rectangles.length > 0) {
            bounds.setBounds(rectangles[0]);
            int i = 1;
            while (i < rectangles.length) {
                Rectangle.union(bounds, rectangles[i], bounds);
                ++i;
            }
        }
        return bounds;
    }

    public static void setPreferredLookAndFeel() {
        try {
            String systemLookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
            if (!"com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(systemLookAndFeelClassName)) {
                UIManager.setLookAndFeel(systemLookAndFeelClassName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

